package org.jboss.errai.databinding.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.errai.databinding.client.api.Convert;
import org.jboss.errai.databinding.client.api.StateSync;
import org.jboss.errai.ui.shared.api.Locale;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.model.GenericSummary.LabeledCommand;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.jbpm.workbench.es.model.RequestParameterSummary;
import org.jbpm.workbench.es.model.RequestSummary;
import org.jbpm.workbench.es.util.ExecutionErrorType;
import org.jbpm.workbench.es.util.RequestStatus;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.model.TimerSummary;
import org.jbpm.workbench.pr.model.WorkItemParameterSummary;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement.ExtensionElements;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.background.BgColour;
import org.kie.workbench.common.dmn.api.property.background.BorderColour;
import org.kie.workbench.common.dmn.api.property.background.BorderSize;
import org.kie.workbench.common.dmn.api.property.dimensions.DecisionServiceRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Width;
import org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers;
import org.kie.workbench.common.dmn.api.property.dmn.ConstraintTypeProperty;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType;
import org.kie.workbench.common.dmn.api.property.dmn.QNameHolder;
import org.kie.workbench.common.dmn.api.property.dmn.Question;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.TextFormat;
import org.kie.workbench.common.dmn.api.property.font.FontColour;
import org.kie.workbench.common.dmn.api.property.font.FontSize;
import org.kie.workbench.common.dmn.client.property.dmn.DocumentationLinksFieldDefinition;
import org.kie.workbench.common.dmn.client.property.dmn.QNameFieldDefinition;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly.ReadOnly;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.checkBox.definition.CheckBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.checkBox.type.CheckBoxFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.datePicker.definition.DatePickerFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.datePicker.type.DatePickerFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.decimalBox.definition.DecimalBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.decimalBox.type.DecimalBoxFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.image.definition.PictureFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.image.definition.PictureSize;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.image.type.PictureFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.integerBox.definition.IntegerBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.integerBox.type.IntegerBoxFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.BooleanMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.CharacterMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.DateMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.DecimalMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.IntegerMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.StringMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.BooleanMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.CharacterMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.DateMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.DecimalMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.IntegerMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.selector.impl.StringMultipleSelectorFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.CharacterSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.DecimalSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.DefaultSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.EnumSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.IntegerSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.StringSelectorOption;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.definition.CharacterListBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.definition.DecimalListBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.definition.EnumListBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.definition.IntegerListBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.definition.StringListBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.type.ListBoxFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.radioGroup.definition.CharacterRadioGroupFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.radioGroup.definition.DecimalRadioGroupFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.radioGroup.definition.IntegerRadioGroupFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.radioGroup.definition.StringRadioGroupFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.radioGroup.type.RadioGroupFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.definition.DoubleSliderDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.definition.IntegerSliderDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.type.SliderFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.definition.TextAreaFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textBox.definition.CharacterBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textBox.definition.TextBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textBox.type.TextBoxFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.Container;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.TableColumnMeta;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.multipleSubform.definition.MultipleSubFormFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.multipleSubform.type.MultipleSubFormFieldType;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.subForm.definition.SubFormFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.subForm.type.SubFormFieldType;
import org.kie.workbench.common.forms.jbpm.model.authoring.document.definition.DocumentFieldDefinition;
import org.kie.workbench.common.forms.jbpm.model.authoring.document.type.DocumentFieldType;
import org.kie.workbench.common.forms.jbpm.model.authoring.documents.definition.DocumentCollectionFieldDefinition;
import org.kie.workbench.common.forms.jbpm.model.authoring.documents.type.DocumentCollectionFieldType;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentData;
import org.kie.workbench.common.forms.jbpm.model.document.DocumentStatus;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FieldType;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.AssigneeRow;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.Expiration;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.KeyValueRow;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.NotificationRow;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.NotificationType;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.ReassignmentRow;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.ReassignmentType;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.Variable.VariableType;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.model.VariableRow;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.notificationsEditor.converter.NotificationTypeDateConverter;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.reassignmentsEditor.converter.ReassignmentTypeDateConverter;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNBaseInfo;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask;
import org.kie.workbench.common.stunner.bpmn.definition.DirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EndCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EndTerminateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.EventGateway;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.GenericServiceTask;
import org.kie.workbench.common.stunner.bpmn.definition.InclusiveGateway;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventThrowing;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.Lane;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.NonDirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.NoneTask;
import org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.ScriptTask;
import org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.definition.StartCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartMessageEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartSignalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.StartTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.assignee.Actors;
import org.kie.workbench.common.stunner.bpmn.definition.property.assignee.Groupid;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BgColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseFileVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseIdPrefix;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseRoles;
import org.kie.workbench.common.stunner.bpmn.definition.property.common.ConditionExpression;
import org.kie.workbench.common.stunner.bpmn.definition.property.connectors.Priority;
import org.kie.workbench.common.stunner.bpmn.definition.property.connectors.SequenceFlowExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.AdHoc;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Executable;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.GlobalVariables;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Package;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.ProcessInstanceDescription;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Version;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.DefaultImport;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.Imports;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.ImportsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.imports.WSDLImport;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Height;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Radius;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseStartEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.CancelActivity;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.IsInterrupting;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.ActivityRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.compensation.CompensationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.InterruptingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.CancellingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.InterruptingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.InterruptingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.InterruptingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.InterruptingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.ScopedSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.SignalScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.InterruptingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettings;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.TimerSettingsValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontBorderColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontBorderSize;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontColor;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontFamily;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.DefaultRoute;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.GatewayExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.TaskGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.reassignment.ReassignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskInfo;
import org.kie.workbench.common.stunner.bpmn.definition.property.service.GenericServiceTaskValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.Currency;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.DistributionType;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.Max;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.Mean;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.Min;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.Quantity;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.StandardDeviation;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.TimeUnit;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.UnitCost;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.WorkingHours;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.IsCase;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EventSubprocessExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AbortParent;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocAutostart;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocOrdering;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BusinessRuleTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.CalledElement;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Content;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.CreatedBy;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.DecisionName;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Description;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.DmnModelName;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.EmptyTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Independent;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.IsMultipleInstance;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCollectionOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceCompletionCondition;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataInput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceDataOutput;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceExecutionMode;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Namespace;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.RuleFlowGroup;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.RuleLanguage;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Script;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Skippable;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.Subject;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskName;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskType;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskTypes;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.WaitForCompletion;
import org.kie.workbench.common.stunner.bpmn.forms.model.AssigneeEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.AssigneeEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.AssigneeType;
import org.kie.workbench.common.stunner.bpmn.forms.model.AssignmentsEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.AssignmentsEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.ComboBoxFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.ConditionalComboBoxFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.ConditionalComboBoxFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.GenericServiceTaskEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.GenericServiceTaskEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.ImportsFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.ImportsFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.MultipleInstanceVariableFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.NotificationsEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.NotificationsEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.ReassignmentsEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.ReassignmentsEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.ScriptTypeFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.ScriptTypeFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.ScriptTypeListFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.ScriptTypeListFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.ScriptTypeMode;
import org.kie.workbench.common.stunner.bpmn.forms.model.TimerSettingsFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.TimerSettingsFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.VariablesEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.VariablesEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.forms.model.cm.RolesEditorFieldDefinition;
import org.kie.workbench.common.stunner.bpmn.forms.model.cm.RolesEditorFieldType;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess;
import org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess;
import org.kie.workbench.common.stunner.cm.definition.UserTask;
import org.kie.workbench.common.stunner.cm.definition.property.task.AdHocActivationCondition;
import org.kie.workbench.common.stunner.cm.definition.property.task.AdHocCompletionCondition;
import org.kie.workbench.common.stunner.cm.definition.property.task.AdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.definition.property.task.UserTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.cm.definition.property.variables.ProcessVariables;
import org.kie.workbench.common.stunner.forms.model.ColorPickerFieldDefinition;
import org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType;
import org.uberfire.mvp.Command;
import org.uberfire.paging.AbstractPageRow;

public class BindableProxyLoaderImpl implements BindableProxyLoader { public void loadBindableProxies() {
    class org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy extends UserTaskExecutionSet implements BindableProxy {
      private BindableProxyAgent<UserTaskExecutionSet> agent;
      private UserTaskExecutionSet target;
      public org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy() {
        this(new UserTaskExecutionSet());
      }

      public org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy(UserTaskExecutionSet targetVal) {
        agent = new BindableProxyAgent<UserTaskExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("subject", new PropertyType(Subject.class, true, false));
        p.put("isAsync", new PropertyType(IsAsync.class, true, false));
        p.put("description", new PropertyType(Description.class, true, false));
        p.put("multipleInstanceDataOutput", new PropertyType(MultipleInstanceDataOutput.class, true, false));
        p.put("content", new PropertyType(Content.class, true, false));
        p.put("multipleInstanceDataInput", new PropertyType(MultipleInstanceDataInput.class, true, false));
        p.put("reassignmentsInfo", new PropertyType(ReassignmentsInfo.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("assignmentsinfo", new PropertyType(AssignmentsInfo.class, true, false));
        p.put("isMultipleInstance", new PropertyType(IsMultipleInstance.class, true, false));
        p.put("onExitAction", new PropertyType(OnExitAction.class, true, false));
        p.put("notificationsInfo", new PropertyType(NotificationsInfo.class, true, false));
        p.put("groupid", new PropertyType(Groupid.class, true, false));
        p.put("skippable", new PropertyType(Skippable.class, true, false));
        p.put("priority", new PropertyType(Priority.class, true, false));
        p.put("onEntryAction", new PropertyType(OnEntryAction.class, true, false));
        p.put("multipleInstanceCollectionInput", new PropertyType(MultipleInstanceCollectionInput.class, true, false));
        p.put("multipleInstanceCollectionOutput", new PropertyType(MultipleInstanceCollectionOutput.class, true, false));
        p.put("actors", new PropertyType(Actors.class, true, false));
        p.put("createdBy", new PropertyType(CreatedBy.class, true, false));
        p.put("adHocAutostart", new PropertyType(AdHocAutostart.class, true, false));
        p.put("taskName", new PropertyType(TaskName.class, true, false));
        p.put("multipleInstanceCompletionCondition", new PropertyType(MultipleInstanceCompletionCondition.class, true, false));
        p.put("multipleInstanceExecutionMode", new PropertyType(MultipleInstanceExecutionMode.class, true, false));
        p.put("this", new PropertyType(UserTaskExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public UserTaskExecutionSet unwrap() {
        return target;
      }

      public UserTaskExecutionSet deepUnwrap() {
        final UserTaskExecutionSet clone = new UserTaskExecutionSet();
        final UserTaskExecutionSet t = unwrap();
        if (t.getSubject() instanceof BindableProxy) {
          clone.setSubject((Subject) ((BindableProxy) getSubject()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSubject())) {
          clone.setSubject((Subject) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSubject())).deepUnwrap());
        } else {
          clone.setSubject(t.getSubject());
        }
        if (t.getIsAsync() instanceof BindableProxy) {
          clone.setIsAsync((IsAsync) ((BindableProxy) getIsAsync()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsAsync())) {
          clone.setIsAsync((IsAsync) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsAsync())).deepUnwrap());
        } else {
          clone.setIsAsync(t.getIsAsync());
        }
        if (t.getDescription() instanceof BindableProxy) {
          clone.setDescription((Description) ((BindableProxy) getDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDescription())) {
          clone.setDescription((Description) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDescription())).deepUnwrap());
        } else {
          clone.setDescription(t.getDescription());
        }
        if (t.getMultipleInstanceDataOutput() instanceof BindableProxy) {
          clone.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) ((BindableProxy) getMultipleInstanceDataOutput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceDataOutput())) {
          clone.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceDataOutput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceDataOutput(t.getMultipleInstanceDataOutput());
        }
        if (t.getContent() instanceof BindableProxy) {
          clone.setContent((Content) ((BindableProxy) getContent()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getContent())) {
          clone.setContent((Content) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getContent())).deepUnwrap());
        } else {
          clone.setContent(t.getContent());
        }
        if (t.getMultipleInstanceDataInput() instanceof BindableProxy) {
          clone.setMultipleInstanceDataInput((MultipleInstanceDataInput) ((BindableProxy) getMultipleInstanceDataInput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceDataInput())) {
          clone.setMultipleInstanceDataInput((MultipleInstanceDataInput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceDataInput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceDataInput(t.getMultipleInstanceDataInput());
        }
        if (t.getReassignmentsInfo() instanceof BindableProxy) {
          clone.setReassignmentsInfo((ReassignmentsInfo) ((BindableProxy) getReassignmentsInfo()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getReassignmentsInfo())) {
          clone.setReassignmentsInfo((ReassignmentsInfo) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getReassignmentsInfo())).deepUnwrap());
        } else {
          clone.setReassignmentsInfo(t.getReassignmentsInfo());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getAssignmentsinfo() instanceof BindableProxy) {
          clone.setAssignmentsinfo((AssignmentsInfo) ((BindableProxy) getAssignmentsinfo()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAssignmentsinfo())) {
          clone.setAssignmentsinfo((AssignmentsInfo) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAssignmentsinfo())).deepUnwrap());
        } else {
          clone.setAssignmentsinfo(t.getAssignmentsinfo());
        }
        if (t.getIsMultipleInstance() instanceof BindableProxy) {
          clone.setIsMultipleInstance((IsMultipleInstance) ((BindableProxy) getIsMultipleInstance()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsMultipleInstance())) {
          clone.setIsMultipleInstance((IsMultipleInstance) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsMultipleInstance())).deepUnwrap());
        } else {
          clone.setIsMultipleInstance(t.getIsMultipleInstance());
        }
        if (t.getOnExitAction() instanceof BindableProxy) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) getOnExitAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnExitAction())) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnExitAction())).deepUnwrap());
        } else {
          clone.setOnExitAction(t.getOnExitAction());
        }
        if (t.getNotificationsInfo() instanceof BindableProxy) {
          clone.setNotificationsInfo((NotificationsInfo) ((BindableProxy) getNotificationsInfo()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getNotificationsInfo())) {
          clone.setNotificationsInfo((NotificationsInfo) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getNotificationsInfo())).deepUnwrap());
        } else {
          clone.setNotificationsInfo(t.getNotificationsInfo());
        }
        if (t.getGroupid() instanceof BindableProxy) {
          clone.setGroupid((Groupid) ((BindableProxy) getGroupid()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGroupid())) {
          clone.setGroupid((Groupid) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGroupid())).deepUnwrap());
        } else {
          clone.setGroupid(t.getGroupid());
        }
        if (t.getSkippable() instanceof BindableProxy) {
          clone.setSkippable((Skippable) ((BindableProxy) getSkippable()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSkippable())) {
          clone.setSkippable((Skippable) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSkippable())).deepUnwrap());
        } else {
          clone.setSkippable(t.getSkippable());
        }
        if (t.getPriority() instanceof BindableProxy) {
          clone.setPriority((Priority) ((BindableProxy) getPriority()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getPriority())) {
          clone.setPriority((Priority) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getPriority())).deepUnwrap());
        } else {
          clone.setPriority(t.getPriority());
        }
        if (t.getOnEntryAction() instanceof BindableProxy) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) getOnEntryAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnEntryAction())) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnEntryAction())).deepUnwrap());
        } else {
          clone.setOnEntryAction(t.getOnEntryAction());
        }
        if (t.getMultipleInstanceCollectionInput() instanceof BindableProxy) {
          clone.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) ((BindableProxy) getMultipleInstanceCollectionInput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCollectionInput())) {
          clone.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCollectionInput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCollectionInput(t.getMultipleInstanceCollectionInput());
        }
        if (t.getMultipleInstanceCollectionOutput() instanceof BindableProxy) {
          clone.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) ((BindableProxy) getMultipleInstanceCollectionOutput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCollectionOutput())) {
          clone.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCollectionOutput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCollectionOutput(t.getMultipleInstanceCollectionOutput());
        }
        if (t.getActors() instanceof BindableProxy) {
          clone.setActors((Actors) ((BindableProxy) getActors()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getActors())) {
          clone.setActors((Actors) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getActors())).deepUnwrap());
        } else {
          clone.setActors(t.getActors());
        }
        if (t.getCreatedBy() instanceof BindableProxy) {
          clone.setCreatedBy((CreatedBy) ((BindableProxy) getCreatedBy()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCreatedBy())) {
          clone.setCreatedBy((CreatedBy) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCreatedBy())).deepUnwrap());
        } else {
          clone.setCreatedBy(t.getCreatedBy());
        }
        if (t.getAdHocAutostart() instanceof BindableProxy) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) getAdHocAutostart()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAdHocAutostart())) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAdHocAutostart())).deepUnwrap());
        } else {
          clone.setAdHocAutostart(t.getAdHocAutostart());
        }
        if (t.getTaskName() instanceof BindableProxy) {
          clone.setTaskName((TaskName) ((BindableProxy) getTaskName()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getTaskName())) {
          clone.setTaskName((TaskName) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getTaskName())).deepUnwrap());
        } else {
          clone.setTaskName(t.getTaskName());
        }
        if (t.getMultipleInstanceCompletionCondition() instanceof BindableProxy) {
          clone.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) ((BindableProxy) getMultipleInstanceCompletionCondition()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCompletionCondition())) {
          clone.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCompletionCondition())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCompletionCondition(t.getMultipleInstanceCompletionCondition());
        }
        if (t.getMultipleInstanceExecutionMode() instanceof BindableProxy) {
          clone.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) ((BindableProxy) getMultipleInstanceExecutionMode()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceExecutionMode())) {
          clone.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceExecutionMode())).deepUnwrap());
        } else {
          clone.setMultipleInstanceExecutionMode(t.getMultipleInstanceExecutionMode());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Subject getSubject() {
        return target.getSubject();
      }

      public void setSubject(Subject subject) {
        if (agent.binders.containsKey("subject")) {
          subject = (Subject) agent.binders.get("subject").setModel(subject, StateSync.FROM_MODEL, true);
        }
        changeAndFire("subject", subject);
      }

      public IsAsync getIsAsync() {
        return target.getIsAsync();
      }

      public void setIsAsync(IsAsync isAsync) {
        if (agent.binders.containsKey("isAsync")) {
          isAsync = (IsAsync) agent.binders.get("isAsync").setModel(isAsync, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isAsync", isAsync);
      }

      public Description getDescription() {
        return target.getDescription();
      }

      public void setDescription(Description description) {
        if (agent.binders.containsKey("description")) {
          description = (Description) agent.binders.get("description").setModel(description, StateSync.FROM_MODEL, true);
        }
        changeAndFire("description", description);
      }

      public MultipleInstanceDataOutput getMultipleInstanceDataOutput() {
        return target.getMultipleInstanceDataOutput();
      }

      public void setMultipleInstanceDataOutput(MultipleInstanceDataOutput multipleInstanceDataOutput) {
        if (agent.binders.containsKey("multipleInstanceDataOutput")) {
          multipleInstanceDataOutput = (MultipleInstanceDataOutput) agent.binders.get("multipleInstanceDataOutput").setModel(multipleInstanceDataOutput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceDataOutput", multipleInstanceDataOutput);
      }

      public Content getContent() {
        return target.getContent();
      }

      public void setContent(Content content) {
        if (agent.binders.containsKey("content")) {
          content = (Content) agent.binders.get("content").setModel(content, StateSync.FROM_MODEL, true);
        }
        changeAndFire("content", content);
      }

      public MultipleInstanceDataInput getMultipleInstanceDataInput() {
        return target.getMultipleInstanceDataInput();
      }

      public void setMultipleInstanceDataInput(MultipleInstanceDataInput multipleInstanceDataInput) {
        if (agent.binders.containsKey("multipleInstanceDataInput")) {
          multipleInstanceDataInput = (MultipleInstanceDataInput) agent.binders.get("multipleInstanceDataInput").setModel(multipleInstanceDataInput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceDataInput", multipleInstanceDataInput);
      }

      public ReassignmentsInfo getReassignmentsInfo() {
        return target.getReassignmentsInfo();
      }

      public void setReassignmentsInfo(ReassignmentsInfo reassignmentsInfo) {
        if (agent.binders.containsKey("reassignmentsInfo")) {
          reassignmentsInfo = (ReassignmentsInfo) agent.binders.get("reassignmentsInfo").setModel(reassignmentsInfo, StateSync.FROM_MODEL, true);
        }
        changeAndFire("reassignmentsInfo", reassignmentsInfo);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public AssignmentsInfo getAssignmentsinfo() {
        return target.getAssignmentsinfo();
      }

      public void setAssignmentsinfo(AssignmentsInfo assignmentsinfo) {
        if (agent.binders.containsKey("assignmentsinfo")) {
          assignmentsinfo = (AssignmentsInfo) agent.binders.get("assignmentsinfo").setModel(assignmentsinfo, StateSync.FROM_MODEL, true);
        }
        changeAndFire("assignmentsinfo", assignmentsinfo);
      }

      public IsMultipleInstance getIsMultipleInstance() {
        return target.getIsMultipleInstance();
      }

      public void setIsMultipleInstance(IsMultipleInstance isMultipleInstance) {
        if (agent.binders.containsKey("isMultipleInstance")) {
          isMultipleInstance = (IsMultipleInstance) agent.binders.get("isMultipleInstance").setModel(isMultipleInstance, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isMultipleInstance", isMultipleInstance);
      }

      public OnExitAction getOnExitAction() {
        return target.getOnExitAction();
      }

      public void setOnExitAction(OnExitAction onExitAction) {
        if (agent.binders.containsKey("onExitAction")) {
          onExitAction = (OnExitAction) agent.binders.get("onExitAction").setModel(onExitAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onExitAction", onExitAction);
      }

      public NotificationsInfo getNotificationsInfo() {
        return target.getNotificationsInfo();
      }

      public void setNotificationsInfo(NotificationsInfo notificationsInfo) {
        if (agent.binders.containsKey("notificationsInfo")) {
          notificationsInfo = (NotificationsInfo) agent.binders.get("notificationsInfo").setModel(notificationsInfo, StateSync.FROM_MODEL, true);
        }
        changeAndFire("notificationsInfo", notificationsInfo);
      }

      public Groupid getGroupid() {
        return target.getGroupid();
      }

      public void setGroupid(Groupid groupid) {
        if (agent.binders.containsKey("groupid")) {
          groupid = (Groupid) agent.binders.get("groupid").setModel(groupid, StateSync.FROM_MODEL, true);
        }
        changeAndFire("groupid", groupid);
      }

      public Skippable getSkippable() {
        return target.getSkippable();
      }

      public void setSkippable(Skippable skippable) {
        if (agent.binders.containsKey("skippable")) {
          skippable = (Skippable) agent.binders.get("skippable").setModel(skippable, StateSync.FROM_MODEL, true);
        }
        changeAndFire("skippable", skippable);
      }

      public Priority getPriority() {
        return target.getPriority();
      }

      public void setPriority(Priority priority) {
        if (agent.binders.containsKey("priority")) {
          priority = (Priority) agent.binders.get("priority").setModel(priority, StateSync.FROM_MODEL, true);
        }
        changeAndFire("priority", priority);
      }

      public OnEntryAction getOnEntryAction() {
        return target.getOnEntryAction();
      }

      public void setOnEntryAction(OnEntryAction onEntryAction) {
        if (agent.binders.containsKey("onEntryAction")) {
          onEntryAction = (OnEntryAction) agent.binders.get("onEntryAction").setModel(onEntryAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onEntryAction", onEntryAction);
      }

      public MultipleInstanceCollectionInput getMultipleInstanceCollectionInput() {
        return target.getMultipleInstanceCollectionInput();
      }

      public void setMultipleInstanceCollectionInput(MultipleInstanceCollectionInput multipleInstanceCollectionInput) {
        if (agent.binders.containsKey("multipleInstanceCollectionInput")) {
          multipleInstanceCollectionInput = (MultipleInstanceCollectionInput) agent.binders.get("multipleInstanceCollectionInput").setModel(multipleInstanceCollectionInput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCollectionInput", multipleInstanceCollectionInput);
      }

      public MultipleInstanceCollectionOutput getMultipleInstanceCollectionOutput() {
        return target.getMultipleInstanceCollectionOutput();
      }

      public void setMultipleInstanceCollectionOutput(MultipleInstanceCollectionOutput multipleInstanceCollectionOutput) {
        if (agent.binders.containsKey("multipleInstanceCollectionOutput")) {
          multipleInstanceCollectionOutput = (MultipleInstanceCollectionOutput) agent.binders.get("multipleInstanceCollectionOutput").setModel(multipleInstanceCollectionOutput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCollectionOutput", multipleInstanceCollectionOutput);
      }

      public Actors getActors() {
        return target.getActors();
      }

      public void setActors(Actors actors) {
        if (agent.binders.containsKey("actors")) {
          actors = (Actors) agent.binders.get("actors").setModel(actors, StateSync.FROM_MODEL, true);
        }
        changeAndFire("actors", actors);
      }

      public CreatedBy getCreatedBy() {
        return target.getCreatedBy();
      }

      public void setCreatedBy(CreatedBy createdBy) {
        if (agent.binders.containsKey("createdBy")) {
          createdBy = (CreatedBy) agent.binders.get("createdBy").setModel(createdBy, StateSync.FROM_MODEL, true);
        }
        changeAndFire("createdBy", createdBy);
      }

      public AdHocAutostart getAdHocAutostart() {
        return target.getAdHocAutostart();
      }

      public void setAdHocAutostart(AdHocAutostart adHocAutostart) {
        if (agent.binders.containsKey("adHocAutostart")) {
          adHocAutostart = (AdHocAutostart) agent.binders.get("adHocAutostart").setModel(adHocAutostart, StateSync.FROM_MODEL, true);
        }
        changeAndFire("adHocAutostart", adHocAutostart);
      }

      public TaskName getTaskName() {
        return target.getTaskName();
      }

      public void setTaskName(TaskName taskName) {
        if (agent.binders.containsKey("taskName")) {
          taskName = (TaskName) agent.binders.get("taskName").setModel(taskName, StateSync.FROM_MODEL, true);
        }
        changeAndFire("taskName", taskName);
      }

      public MultipleInstanceCompletionCondition getMultipleInstanceCompletionCondition() {
        return target.getMultipleInstanceCompletionCondition();
      }

      public void setMultipleInstanceCompletionCondition(MultipleInstanceCompletionCondition multipleInstanceCompletionCondition) {
        if (agent.binders.containsKey("multipleInstanceCompletionCondition")) {
          multipleInstanceCompletionCondition = (MultipleInstanceCompletionCondition) agent.binders.get("multipleInstanceCompletionCondition").setModel(multipleInstanceCompletionCondition, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCompletionCondition", multipleInstanceCompletionCondition);
      }

      public MultipleInstanceExecutionMode getMultipleInstanceExecutionMode() {
        return target.getMultipleInstanceExecutionMode();
      }

      public void setMultipleInstanceExecutionMode(MultipleInstanceExecutionMode multipleInstanceExecutionMode) {
        if (agent.binders.containsKey("multipleInstanceExecutionMode")) {
          multipleInstanceExecutionMode = (MultipleInstanceExecutionMode) agent.binders.get("multipleInstanceExecutionMode").setModel(multipleInstanceExecutionMode, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceExecutionMode", multipleInstanceExecutionMode);
      }

      public Object get(String property) {
        switch (property) {
          case "subject": return getSubject();
          case "isAsync": return getIsAsync();
          case "description": return getDescription();
          case "multipleInstanceDataOutput": return getMultipleInstanceDataOutput();
          case "content": return getContent();
          case "multipleInstanceDataInput": return getMultipleInstanceDataInput();
          case "reassignmentsInfo": return getReassignmentsInfo();
          case "slaDueDate": return getSlaDueDate();
          case "assignmentsinfo": return getAssignmentsinfo();
          case "isMultipleInstance": return getIsMultipleInstance();
          case "onExitAction": return getOnExitAction();
          case "notificationsInfo": return getNotificationsInfo();
          case "groupid": return getGroupid();
          case "skippable": return getSkippable();
          case "priority": return getPriority();
          case "onEntryAction": return getOnEntryAction();
          case "multipleInstanceCollectionInput": return getMultipleInstanceCollectionInput();
          case "multipleInstanceCollectionOutput": return getMultipleInstanceCollectionOutput();
          case "actors": return getActors();
          case "createdBy": return getCreatedBy();
          case "adHocAutostart": return getAdHocAutostart();
          case "taskName": return getTaskName();
          case "multipleInstanceCompletionCondition": return getMultipleInstanceCompletionCondition();
          case "multipleInstanceExecutionMode": return getMultipleInstanceExecutionMode();
          case "this": return target;
          default: throw new NonExistingPropertyException("UserTaskExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "subject": target.setSubject((Subject) value);
          break;
          case "isAsync": target.setIsAsync((IsAsync) value);
          break;
          case "description": target.setDescription((Description) value);
          break;
          case "multipleInstanceDataOutput": target.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) value);
          break;
          case "content": target.setContent((Content) value);
          break;
          case "multipleInstanceDataInput": target.setMultipleInstanceDataInput((MultipleInstanceDataInput) value);
          break;
          case "reassignmentsInfo": target.setReassignmentsInfo((ReassignmentsInfo) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "assignmentsinfo": target.setAssignmentsinfo((AssignmentsInfo) value);
          break;
          case "isMultipleInstance": target.setIsMultipleInstance((IsMultipleInstance) value);
          break;
          case "onExitAction": target.setOnExitAction((OnExitAction) value);
          break;
          case "notificationsInfo": target.setNotificationsInfo((NotificationsInfo) value);
          break;
          case "groupid": target.setGroupid((Groupid) value);
          break;
          case "skippable": target.setSkippable((Skippable) value);
          break;
          case "priority": target.setPriority((Priority) value);
          break;
          case "onEntryAction": target.setOnEntryAction((OnEntryAction) value);
          break;
          case "multipleInstanceCollectionInput": target.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) value);
          break;
          case "multipleInstanceCollectionOutput": target.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) value);
          break;
          case "actors": target.setActors((Actors) value);
          break;
          case "createdBy": target.setCreatedBy((CreatedBy) value);
          break;
          case "adHocAutostart": target.setAdHocAutostart((AdHocAutostart) value);
          break;
          case "taskName": target.setTaskName((TaskName) value);
          break;
          case "multipleInstanceCompletionCondition": target.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) value);
          break;
          case "multipleInstanceExecutionMode": target.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) value);
          break;
          case "this": target = (UserTaskExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("UserTaskExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(UserTaskExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy((UserTaskExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_cm_definition_property_task_UserTaskExecutionSetProxy();
      }
    });
    class org_jbpm_workbench_df_client_filter_SavedFilterProxy extends SavedFilter implements BindableProxy {
      private BindableProxyAgent<SavedFilter> agent;
      private SavedFilter target;
      public org_jbpm_workbench_df_client_filter_SavedFilterProxy() {
        this(new SavedFilter());
      }

      public org_jbpm_workbench_df_client_filter_SavedFilterProxy(SavedFilter targetVal) {
        agent = new BindableProxyAgent<SavedFilter>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("defaultFilter", new PropertyType(Boolean.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("key", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(SavedFilter.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public SavedFilter unwrap() {
        return target;
      }

      public SavedFilter deepUnwrap() {
        final SavedFilter clone = new SavedFilter();
        final SavedFilter t = unwrap();
        clone.setDefaultFilter(t.isDefaultFilter());
        clone.setName(t.getName());
        clone.setKey(t.getKey());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_df_client_filter_SavedFilterProxy) {
          obj = ((org_jbpm_workbench_df_client_filter_SavedFilterProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public boolean isDefaultFilter() {
        return target.isDefaultFilter();
      }

      public void setDefaultFilter(boolean defaultFilter) {
        changeAndFire("defaultFilter", defaultFilter);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getKey() {
        return target.getKey();
      }

      public void setKey(String key) {
        changeAndFire("key", key);
      }

      public Object get(String property) {
        switch (property) {
          case "defaultFilter": return isDefaultFilter();
          case "name": return getName();
          case "key": return getKey();
          case "this": return target;
          default: throw new NonExistingPropertyException("SavedFilter", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "defaultFilter": target.setDefaultFilter((Boolean) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "key": target.setKey((String) value);
          break;
          case "this": target = (SavedFilter) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("SavedFilter", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(SavedFilter.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_df_client_filter_SavedFilterProxy((SavedFilter) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_df_client_filter_SavedFilterProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy extends OutputClauseUnaryTests implements BindableProxy {
      private BindableProxyAgent<OutputClauseUnaryTests> agent;
      private OutputClauseUnaryTests target;
      public org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy() {
        this(new OutputClauseUnaryTests());
      }

      public org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy(OutputClauseUnaryTests targetVal) {
        agent = new BindableProxyAgent<OutputClauseUnaryTests>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("constraintType", new PropertyType(ConstraintType.class, false, false));
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("text", new PropertyType(Text.class, true, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(OutputClauseUnaryTests.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public OutputClauseUnaryTests unwrap() {
        return target;
      }

      public OutputClauseUnaryTests deepUnwrap() {
        final OutputClauseUnaryTests clone = new OutputClauseUnaryTests();
        final OutputClauseUnaryTests t = unwrap();
        clone.setParent(t.getParent());
        if (t.getText() instanceof BindableProxy) {
          clone.setText((Text) ((BindableProxy) getText()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getText())) {
          clone.setText((Text) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getText())).deepUnwrap());
        } else {
          clone.setText(t.getText());
        }
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public ConstraintType getConstraintType() {
        return target.getConstraintType();
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public Id getId() {
        return target.getId();
      }

      public Text getText() {
        return target.getText();
      }

      public void setText(Text text) {
        if (agent.binders.containsKey("text")) {
          text = (Text) agent.binders.get("text").setModel(text, StateSync.FROM_MODEL, true);
        }
        changeAndFire("text", text);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "constraintType": return getConstraintType();
          case "parent": return getParent();
          case "defaultNamespace": return getDefaultNamespace();
          case "nsContext": return getNsContext();
          case "id": return getId();
          case "text": return getText();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("OutputClauseUnaryTests", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "text": target.setText((Text) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (OutputClauseUnaryTests) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("OutputClauseUnaryTests", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void setConstraintTypeField(ConstraintType a0) {
        target.setConstraintTypeField(a0);
        agent.updateWidgetsAndFireEvents();
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(OutputClauseUnaryTests.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy((OutputClauseUnaryTests) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy extends FontFamily implements BindableProxy {
      private BindableProxyAgent<FontFamily> agent;
      private FontFamily target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy() {
        this(new FontFamily());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy(FontFamily targetVal) {
        agent = new BindableProxyAgent<FontFamily>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(FontFamily.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public FontFamily unwrap() {
        return target;
      }

      public FontFamily deepUnwrap() {
        final FontFamily clone = new FontFamily();
        final FontFamily t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("FontFamily", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (FontFamily) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("FontFamily", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(FontFamily.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy((FontFamily) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontFamilyProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy extends BusinessRuleTask implements BindableProxy {
      private BindableProxyAgent<BusinessRuleTask> agent;
      private BusinessRuleTask target;
      public org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy() {
        this(new BusinessRuleTask());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy(BusinessRuleTask targetVal) {
        agent = new BindableProxyAgent<BusinessRuleTask>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("dataIOSet", new PropertyType(DataIOSet.class, true, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("general", new PropertyType(TaskGeneralSet.class, true, false));
        p.put("taskType", new PropertyType(TaskType.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("executionSet", new PropertyType(BusinessRuleTaskExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("this", new PropertyType(BusinessRuleTask.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BusinessRuleTask unwrap() {
        return target;
      }

      public BusinessRuleTask deepUnwrap() {
        final BusinessRuleTask clone = new BusinessRuleTask();
        final BusinessRuleTask t = unwrap();
        if (t.getDataIOSet() instanceof BindableProxy) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) getDataIOSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDataIOSet())) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDataIOSet())).deepUnwrap());
        } else {
          clone.setDataIOSet(t.getDataIOSet());
        }
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((TaskGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((TaskGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getTaskType() instanceof BindableProxy) {
          clone.setTaskType((TaskType) ((BindableProxy) getTaskType()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getTaskType())) {
          clone.setTaskType((TaskType) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getTaskType())).deepUnwrap());
        } else {
          clone.setTaskType(t.getTaskType());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((BusinessRuleTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((BusinessRuleTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DataIOSet getDataIOSet() {
        return target.getDataIOSet();
      }

      public void setDataIOSet(DataIOSet dataIOSet) {
        if (agent.binders.containsKey("dataIOSet")) {
          dataIOSet = (DataIOSet) agent.binders.get("dataIOSet").setModel(dataIOSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dataIOSet", dataIOSet);
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public TaskGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(TaskGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (TaskGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public TaskType getTaskType() {
        return target.getTaskType();
      }

      public void setTaskType(TaskType taskType) {
        if (agent.binders.containsKey("taskType")) {
          taskType = (TaskType) agent.binders.get("taskType").setModel(taskType, StateSync.FROM_MODEL, true);
        }
        changeAndFire("taskType", taskType);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public BusinessRuleTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(BusinessRuleTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (BusinessRuleTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Object get(String property) {
        switch (property) {
          case "dataIOSet": return getDataIOSet();
          case "labels": return getLabels();
          case "general": return getGeneral();
          case "taskType": return getTaskType();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "singleInputVar": return isSingleInputVar();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "this": return target;
          default: throw new NonExistingPropertyException("BusinessRuleTask", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "dataIOSet": target.setDataIOSet((DataIOSet) value);
          break;
          case "general": target.setGeneral((TaskGeneralSet) value);
          break;
          case "taskType": target.setTaskType((TaskType) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((BusinessRuleTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (BusinessRuleTask) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BusinessRuleTask", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(BusinessRuleTask.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy((BusinessRuleTask) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_BusinessRuleTaskProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy extends org.kie.workbench.common.dmn.api.property.background.BackgroundSet implements BindableProxy {
      private BindableProxyAgent<org.kie.workbench.common.dmn.api.property.background.BackgroundSet> agent;
      private org.kie.workbench.common.dmn.api.property.background.BackgroundSet target;
      public org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy() {
        this(new org.kie.workbench.common.dmn.api.property.background.BackgroundSet());
      }

      public org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy(org.kie.workbench.common.dmn.api.property.background.BackgroundSet targetVal) {
        agent = new BindableProxyAgent<org.kie.workbench.common.dmn.api.property.background.BackgroundSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("borderColour", new PropertyType(BorderColour.class, true, false));
        p.put("borderSize", new PropertyType(BorderSize.class, true, false));
        p.put("bgColour", new PropertyType(BgColour.class, true, false));
        p.put("this", new PropertyType(org.kie.workbench.common.dmn.api.property.background.BackgroundSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public org.kie.workbench.common.dmn.api.property.background.BackgroundSet unwrap() {
        return target;
      }

      public org.kie.workbench.common.dmn.api.property.background.BackgroundSet deepUnwrap() {
        final org.kie.workbench.common.dmn.api.property.background.BackgroundSet clone = new org.kie.workbench.common.dmn.api.property.background.BackgroundSet();
        final org.kie.workbench.common.dmn.api.property.background.BackgroundSet t = unwrap();
        if (t.getBorderColour() instanceof BindableProxy) {
          clone.setBorderColour((BorderColour) ((BindableProxy) getBorderColour()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBorderColour())) {
          clone.setBorderColour((BorderColour) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBorderColour())).deepUnwrap());
        } else {
          clone.setBorderColour(t.getBorderColour());
        }
        if (t.getBorderSize() instanceof BindableProxy) {
          clone.setBorderSize((BorderSize) ((BindableProxy) getBorderSize()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBorderSize())) {
          clone.setBorderSize((BorderSize) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBorderSize())).deepUnwrap());
        } else {
          clone.setBorderSize(t.getBorderSize());
        }
        if (t.getBgColour() instanceof BindableProxy) {
          clone.setBgColour((BgColour) ((BindableProxy) getBgColour()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBgColour())) {
          clone.setBgColour((BgColour) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBgColour())).deepUnwrap());
        } else {
          clone.setBgColour(t.getBgColour());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BorderColour getBorderColour() {
        return target.getBorderColour();
      }

      public void setBorderColour(BorderColour borderColour) {
        if (agent.binders.containsKey("borderColour")) {
          borderColour = (BorderColour) agent.binders.get("borderColour").setModel(borderColour, StateSync.FROM_MODEL, true);
        }
        changeAndFire("borderColour", borderColour);
      }

      public BorderSize getBorderSize() {
        return target.getBorderSize();
      }

      public void setBorderSize(BorderSize borderSize) {
        if (agent.binders.containsKey("borderSize")) {
          borderSize = (BorderSize) agent.binders.get("borderSize").setModel(borderSize, StateSync.FROM_MODEL, true);
        }
        changeAndFire("borderSize", borderSize);
      }

      public BgColour getBgColour() {
        return target.getBgColour();
      }

      public void setBgColour(BgColour bgColour) {
        if (agent.binders.containsKey("bgColour")) {
          bgColour = (BgColour) agent.binders.get("bgColour").setModel(bgColour, StateSync.FROM_MODEL, true);
        }
        changeAndFire("bgColour", bgColour);
      }

      public Object get(String property) {
        switch (property) {
          case "borderColour": return getBorderColour();
          case "borderSize": return getBorderSize();
          case "bgColour": return getBgColour();
          case "this": return target;
          default: throw new NonExistingPropertyException("BackgroundSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "borderColour": target.setBorderColour((BorderColour) value);
          break;
          case "borderSize": target.setBorderSize((BorderSize) value);
          break;
          case "bgColour": target.setBgColour((BgColour) value);
          break;
          case "this": target = (org.kie.workbench.common.dmn.api.property.background.BackgroundSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BackgroundSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(org.kie.workbench.common.dmn.api.property.background.BackgroundSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy((org.kie.workbench.common.dmn.api.property.background.BackgroundSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_background_BackgroundSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy extends AdHocSubprocess implements BindableProxy {
      private BindableProxyAgent<AdHocSubprocess> agent;
      private AdHocSubprocess target;
      public org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy() {
        this(new AdHocSubprocess());
      }

      public org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy(AdHocSubprocess targetVal) {
        agent = new BindableProxyAgent<AdHocSubprocess>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("processData", new PropertyType(ProcessData.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(AdHocSubprocessTaskExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(AdHocSubprocess.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AdHocSubprocess unwrap() {
        return target;
      }

      public AdHocSubprocess deepUnwrap() {
        final AdHocSubprocess clone = new AdHocSubprocess();
        final AdHocSubprocess t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getProcessData() instanceof BindableProxy) {
          clone.setProcessData((ProcessData) ((BindableProxy) getProcessData()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getProcessData())) {
          clone.setProcessData((ProcessData) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getProcessData())).deepUnwrap());
        } else {
          clone.setProcessData(t.getProcessData());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((AdHocSubprocessTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((AdHocSubprocessTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy) {
          obj = ((org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public ProcessData getProcessData() {
        return target.getProcessData();
      }

      public void setProcessData(ProcessData processData) {
        if (agent.binders.containsKey("processData")) {
          processData = (ProcessData) agent.binders.get("processData").setModel(processData, StateSync.FROM_MODEL, true);
        }
        changeAndFire("processData", processData);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public AdHocSubprocessTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(AdHocSubprocessTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (AdHocSubprocessTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "simulationSet": return getSimulationSet();
          case "processData": return getProcessData();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("AdHocSubprocess", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "processData": target.setProcessData((ProcessData) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((AdHocSubprocessTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (AdHocSubprocess) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AdHocSubprocess", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(AdHocSubprocess.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy((AdHocSubprocess) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy extends BusinessRuleTaskExecutionSet implements BindableProxy {
      private BindableProxyAgent<BusinessRuleTaskExecutionSet> agent;
      private BusinessRuleTaskExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy() {
        this(new BusinessRuleTaskExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy(BusinessRuleTaskExecutionSet targetVal) {
        agent = new BindableProxyAgent<BusinessRuleTaskExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("ruleFlowGroup", new PropertyType(RuleFlowGroup.class, true, false));
        p.put("dmnModelName", new PropertyType(DmnModelName.class, true, false));
        p.put("adHocAutostart", new PropertyType(AdHocAutostart.class, true, false));
        p.put("isAsync", new PropertyType(IsAsync.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("namespace", new PropertyType(Namespace.class, true, false));
        p.put("ruleLanguage", new PropertyType(RuleLanguage.class, true, false));
        p.put("decisionName", new PropertyType(DecisionName.class, true, false));
        p.put("onExitAction", new PropertyType(OnExitAction.class, true, false));
        p.put("onEntryAction", new PropertyType(OnEntryAction.class, true, false));
        p.put("this", new PropertyType(BusinessRuleTaskExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BusinessRuleTaskExecutionSet unwrap() {
        return target;
      }

      public BusinessRuleTaskExecutionSet deepUnwrap() {
        final BusinessRuleTaskExecutionSet clone = new BusinessRuleTaskExecutionSet();
        final BusinessRuleTaskExecutionSet t = unwrap();
        if (t.getRuleFlowGroup() instanceof BindableProxy) {
          clone.setRuleFlowGroup((RuleFlowGroup) ((BindableProxy) getRuleFlowGroup()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getRuleFlowGroup())) {
          clone.setRuleFlowGroup((RuleFlowGroup) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getRuleFlowGroup())).deepUnwrap());
        } else {
          clone.setRuleFlowGroup(t.getRuleFlowGroup());
        }
        if (t.getDmnModelName() instanceof BindableProxy) {
          clone.setDmnModelName((DmnModelName) ((BindableProxy) getDmnModelName()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDmnModelName())) {
          clone.setDmnModelName((DmnModelName) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDmnModelName())).deepUnwrap());
        } else {
          clone.setDmnModelName(t.getDmnModelName());
        }
        if (t.getAdHocAutostart() instanceof BindableProxy) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) getAdHocAutostart()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAdHocAutostart())) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAdHocAutostart())).deepUnwrap());
        } else {
          clone.setAdHocAutostart(t.getAdHocAutostart());
        }
        if (t.getIsAsync() instanceof BindableProxy) {
          clone.setIsAsync((IsAsync) ((BindableProxy) getIsAsync()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsAsync())) {
          clone.setIsAsync((IsAsync) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsAsync())).deepUnwrap());
        } else {
          clone.setIsAsync(t.getIsAsync());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getNamespace() instanceof BindableProxy) {
          clone.setNamespace((Namespace) ((BindableProxy) getNamespace()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getNamespace())) {
          clone.setNamespace((Namespace) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getNamespace())).deepUnwrap());
        } else {
          clone.setNamespace(t.getNamespace());
        }
        if (t.getRuleLanguage() instanceof BindableProxy) {
          clone.setRuleLanguage((RuleLanguage) ((BindableProxy) getRuleLanguage()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getRuleLanguage())) {
          clone.setRuleLanguage((RuleLanguage) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getRuleLanguage())).deepUnwrap());
        } else {
          clone.setRuleLanguage(t.getRuleLanguage());
        }
        if (t.getDecisionName() instanceof BindableProxy) {
          clone.setDecisionName((DecisionName) ((BindableProxy) getDecisionName()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDecisionName())) {
          clone.setDecisionName((DecisionName) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDecisionName())).deepUnwrap());
        } else {
          clone.setDecisionName(t.getDecisionName());
        }
        if (t.getOnExitAction() instanceof BindableProxy) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) getOnExitAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnExitAction())) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnExitAction())).deepUnwrap());
        } else {
          clone.setOnExitAction(t.getOnExitAction());
        }
        if (t.getOnEntryAction() instanceof BindableProxy) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) getOnEntryAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnEntryAction())) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnEntryAction())).deepUnwrap());
        } else {
          clone.setOnEntryAction(t.getOnEntryAction());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public RuleFlowGroup getRuleFlowGroup() {
        return target.getRuleFlowGroup();
      }

      public void setRuleFlowGroup(RuleFlowGroup ruleFlowGroup) {
        if (agent.binders.containsKey("ruleFlowGroup")) {
          ruleFlowGroup = (RuleFlowGroup) agent.binders.get("ruleFlowGroup").setModel(ruleFlowGroup, StateSync.FROM_MODEL, true);
        }
        changeAndFire("ruleFlowGroup", ruleFlowGroup);
      }

      public DmnModelName getDmnModelName() {
        return target.getDmnModelName();
      }

      public void setDmnModelName(DmnModelName dmnModelName) {
        if (agent.binders.containsKey("dmnModelName")) {
          dmnModelName = (DmnModelName) agent.binders.get("dmnModelName").setModel(dmnModelName, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dmnModelName", dmnModelName);
      }

      public AdHocAutostart getAdHocAutostart() {
        return target.getAdHocAutostart();
      }

      public void setAdHocAutostart(AdHocAutostart adHocAutostart) {
        if (agent.binders.containsKey("adHocAutostart")) {
          adHocAutostart = (AdHocAutostart) agent.binders.get("adHocAutostart").setModel(adHocAutostart, StateSync.FROM_MODEL, true);
        }
        changeAndFire("adHocAutostart", adHocAutostart);
      }

      public IsAsync getIsAsync() {
        return target.getIsAsync();
      }

      public void setIsAsync(IsAsync isAsync) {
        if (agent.binders.containsKey("isAsync")) {
          isAsync = (IsAsync) agent.binders.get("isAsync").setModel(isAsync, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isAsync", isAsync);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public Namespace getNamespace() {
        return target.getNamespace();
      }

      public void setNamespace(Namespace namespace) {
        if (agent.binders.containsKey("namespace")) {
          namespace = (Namespace) agent.binders.get("namespace").setModel(namespace, StateSync.FROM_MODEL, true);
        }
        changeAndFire("namespace", namespace);
      }

      public RuleLanguage getRuleLanguage() {
        return target.getRuleLanguage();
      }

      public void setRuleLanguage(RuleLanguage ruleLanguage) {
        if (agent.binders.containsKey("ruleLanguage")) {
          ruleLanguage = (RuleLanguage) agent.binders.get("ruleLanguage").setModel(ruleLanguage, StateSync.FROM_MODEL, true);
        }
        changeAndFire("ruleLanguage", ruleLanguage);
      }

      public DecisionName getDecisionName() {
        return target.getDecisionName();
      }

      public void setDecisionName(DecisionName decisionName) {
        if (agent.binders.containsKey("decisionName")) {
          decisionName = (DecisionName) agent.binders.get("decisionName").setModel(decisionName, StateSync.FROM_MODEL, true);
        }
        changeAndFire("decisionName", decisionName);
      }

      public OnExitAction getOnExitAction() {
        return target.getOnExitAction();
      }

      public void setOnExitAction(OnExitAction onExitAction) {
        if (agent.binders.containsKey("onExitAction")) {
          onExitAction = (OnExitAction) agent.binders.get("onExitAction").setModel(onExitAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onExitAction", onExitAction);
      }

      public OnEntryAction getOnEntryAction() {
        return target.getOnEntryAction();
      }

      public void setOnEntryAction(OnEntryAction onEntryAction) {
        if (agent.binders.containsKey("onEntryAction")) {
          onEntryAction = (OnEntryAction) agent.binders.get("onEntryAction").setModel(onEntryAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onEntryAction", onEntryAction);
      }

      public Object get(String property) {
        switch (property) {
          case "ruleFlowGroup": return getRuleFlowGroup();
          case "dmnModelName": return getDmnModelName();
          case "adHocAutostart": return getAdHocAutostart();
          case "isAsync": return getIsAsync();
          case "slaDueDate": return getSlaDueDate();
          case "namespace": return getNamespace();
          case "ruleLanguage": return getRuleLanguage();
          case "decisionName": return getDecisionName();
          case "onExitAction": return getOnExitAction();
          case "onEntryAction": return getOnEntryAction();
          case "this": return target;
          default: throw new NonExistingPropertyException("BusinessRuleTaskExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "ruleFlowGroup": target.setRuleFlowGroup((RuleFlowGroup) value);
          break;
          case "dmnModelName": target.setDmnModelName((DmnModelName) value);
          break;
          case "adHocAutostart": target.setAdHocAutostart((AdHocAutostart) value);
          break;
          case "isAsync": target.setIsAsync((IsAsync) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "namespace": target.setNamespace((Namespace) value);
          break;
          case "ruleLanguage": target.setRuleLanguage((RuleLanguage) value);
          break;
          case "decisionName": target.setDecisionName((DecisionName) value);
          break;
          case "onExitAction": target.setOnExitAction((OnExitAction) value);
          break;
          case "onEntryAction": target.setOnEntryAction((OnEntryAction) value);
          break;
          case "this": target = (BusinessRuleTaskExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BusinessRuleTaskExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(BusinessRuleTaskExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy((BusinessRuleTaskExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_BusinessRuleTaskExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy extends ReusableSubprocess implements BindableProxy {
      private BindableProxyAgent<ReusableSubprocess> agent;
      private ReusableSubprocess target;
      public org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy() {
        this(new ReusableSubprocess());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy(ReusableSubprocess targetVal) {
        agent = new BindableProxyAgent<ReusableSubprocess>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("dataIOSet", new PropertyType(DataIOSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("executionSet", new PropertyType(ReusableSubprocessTaskExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(ReusableSubprocess.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ReusableSubprocess unwrap() {
        return target;
      }

      public ReusableSubprocess deepUnwrap() {
        final ReusableSubprocess clone = new ReusableSubprocess();
        final ReusableSubprocess t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getDataIOSet() instanceof BindableProxy) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) getDataIOSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDataIOSet())) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDataIOSet())).deepUnwrap());
        } else {
          clone.setDataIOSet(t.getDataIOSet());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((ReusableSubprocessTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((ReusableSubprocessTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public DataIOSet getDataIOSet() {
        return target.getDataIOSet();
      }

      public void setDataIOSet(DataIOSet dataIOSet) {
        if (agent.binders.containsKey("dataIOSet")) {
          dataIOSet = (DataIOSet) agent.binders.get("dataIOSet").setModel(dataIOSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dataIOSet", dataIOSet);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public ReusableSubprocessTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(ReusableSubprocessTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (ReusableSubprocessTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "dataIOSet": return getDataIOSet();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "singleInputVar": return isSingleInputVar();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("ReusableSubprocess", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "dataIOSet": target.setDataIOSet((DataIOSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((ReusableSubprocessTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (ReusableSubprocess) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ReusableSubprocess", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(ReusableSubprocess.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy((ReusableSubprocess) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_ReusableSubprocessProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy extends CaseFileVariables implements BindableProxy {
      private BindableProxyAgent<CaseFileVariables> agent;
      private CaseFileVariables target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy() {
        this(new CaseFileVariables());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy(CaseFileVariables targetVal) {
        agent = new BindableProxyAgent<CaseFileVariables>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("rawValue", new PropertyType(String.class, false, false));
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(CaseFileVariables.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CaseFileVariables unwrap() {
        return target;
      }

      public CaseFileVariables deepUnwrap() {
        final CaseFileVariables clone = new CaseFileVariables();
        final CaseFileVariables t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getRawValue() {
        return target.getRawValue();
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "rawValue": return getRawValue();
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("CaseFileVariables", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (CaseFileVariables) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CaseFileVariables", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CaseFileVariables.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy((CaseFileVariables) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseFileVariablesProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy extends CheckBoxFieldDefinition implements BindableProxy {
      private BindableProxyAgent<CheckBoxFieldDefinition> agent;
      private CheckBoxFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy() {
        this(new CheckBoxFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy(CheckBoxFieldDefinition targetVal) {
        agent = new BindableProxyAgent<CheckBoxFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(CheckBoxFieldType.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(CheckBoxFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CheckBoxFieldDefinition unwrap() {
        return target;
      }

      public CheckBoxFieldDefinition deepUnwrap() {
        final CheckBoxFieldDefinition clone = new CheckBoxFieldDefinition();
        final CheckBoxFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setName(t.getName());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setId(t.getId());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public CheckBoxFieldType getFieldType() {
        return target.getFieldType();
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "name": return getName();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "id": return getId();
          case "label": return getLabel();
          case "fieldType": return getFieldType();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "this": return target;
          default: throw new NonExistingPropertyException("CheckBoxFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "this": target = (CheckBoxFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CheckBoxFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(CheckBoxFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy((CheckBoxFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_checkBox_definition_CheckBoxFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy extends EndEscalationEvent implements BindableProxy {
      private BindableProxyAgent<EndEscalationEvent> agent;
      private EndEscalationEvent target;
      public org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy() {
        this(new EndEscalationEvent());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy(EndEscalationEvent targetVal) {
        agent = new BindableProxyAgent<EndEscalationEvent>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("dataIOSet", new PropertyType(DataIOSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("executionSet", new PropertyType(EscalationEventExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(EndEscalationEvent.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EndEscalationEvent unwrap() {
        return target;
      }

      public EndEscalationEvent deepUnwrap() {
        final EndEscalationEvent clone = new EndEscalationEvent();
        final EndEscalationEvent t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getDataIOSet() instanceof BindableProxy) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) getDataIOSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDataIOSet())) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDataIOSet())).deepUnwrap());
        } else {
          clone.setDataIOSet(t.getDataIOSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((EscalationEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((EscalationEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public DataIOSet getDataIOSet() {
        return target.getDataIOSet();
      }

      public void setDataIOSet(DataIOSet dataIOSet) {
        if (agent.binders.containsKey("dataIOSet")) {
          dataIOSet = (DataIOSet) agent.binders.get("dataIOSet").setModel(dataIOSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dataIOSet", dataIOSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public EscalationEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(EscalationEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (EscalationEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "dataIOSet": return getDataIOSet();
          case "backgroundSet": return getBackgroundSet();
          case "singleInputVar": return isSingleInputVar();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("EndEscalationEvent", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "dataIOSet": target.setDataIOSet((DataIOSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((EscalationEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (EndEscalationEvent) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EndEscalationEvent", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(EndEscalationEvent.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy((EndEscalationEvent) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_EndEscalationEventProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy extends SequenceFlowExecutionSet implements BindableProxy {
      private BindableProxyAgent<SequenceFlowExecutionSet> agent;
      private SequenceFlowExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy() {
        this(new SequenceFlowExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy(SequenceFlowExecutionSet targetVal) {
        agent = new BindableProxyAgent<SequenceFlowExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("conditionExpression", new PropertyType(ConditionExpression.class, true, false));
        p.put("priority", new PropertyType(Priority.class, true, false));
        p.put("this", new PropertyType(SequenceFlowExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public SequenceFlowExecutionSet unwrap() {
        return target;
      }

      public SequenceFlowExecutionSet deepUnwrap() {
        final SequenceFlowExecutionSet clone = new SequenceFlowExecutionSet();
        final SequenceFlowExecutionSet t = unwrap();
        if (t.getConditionExpression() instanceof BindableProxy) {
          clone.setConditionExpression((ConditionExpression) ((BindableProxy) getConditionExpression()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getConditionExpression())) {
          clone.setConditionExpression((ConditionExpression) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getConditionExpression())).deepUnwrap());
        } else {
          clone.setConditionExpression(t.getConditionExpression());
        }
        if (t.getPriority() instanceof BindableProxy) {
          clone.setPriority((Priority) ((BindableProxy) getPriority()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getPriority())) {
          clone.setPriority((Priority) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getPriority())).deepUnwrap());
        } else {
          clone.setPriority(t.getPriority());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public ConditionExpression getConditionExpression() {
        return target.getConditionExpression();
      }

      public void setConditionExpression(ConditionExpression conditionExpression) {
        if (agent.binders.containsKey("conditionExpression")) {
          conditionExpression = (ConditionExpression) agent.binders.get("conditionExpression").setModel(conditionExpression, StateSync.FROM_MODEL, true);
        }
        changeAndFire("conditionExpression", conditionExpression);
      }

      public Priority getPriority() {
        return target.getPriority();
      }

      public void setPriority(Priority priority) {
        if (agent.binders.containsKey("priority")) {
          priority = (Priority) agent.binders.get("priority").setModel(priority, StateSync.FROM_MODEL, true);
        }
        changeAndFire("priority", priority);
      }

      public Object get(String property) {
        switch (property) {
          case "conditionExpression": return getConditionExpression();
          case "priority": return getPriority();
          case "this": return target;
          default: throw new NonExistingPropertyException("SequenceFlowExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "conditionExpression": target.setConditionExpression((ConditionExpression) value);
          break;
          case "priority": target.setPriority((Priority) value);
          break;
          case "this": target = (SequenceFlowExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("SequenceFlowExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(SequenceFlowExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy((SequenceFlowExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_connectors_SequenceFlowExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy extends FontColor implements BindableProxy {
      private BindableProxyAgent<FontColor> agent;
      private FontColor target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy() {
        this(new FontColor());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy(FontColor targetVal) {
        agent = new BindableProxyAgent<FontColor>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(FontColor.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public FontColor unwrap() {
        return target;
      }

      public FontColor deepUnwrap() {
        final FontColor clone = new FontColor();
        final FontColor t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("FontColor", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (FontColor) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("FontColor", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(FontColor.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy((FontColor) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontColorProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy extends Version implements BindableProxy {
      private BindableProxyAgent<Version> agent;
      private Version target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy() {
        this(new Version());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy(Version targetVal) {
        agent = new BindableProxyAgent<Version>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(Version.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Version unwrap() {
        return target;
      }

      public Version deepUnwrap() {
        final Version clone = new Version();
        final Version t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Version", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (Version) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Version", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(Version.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy((Version) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_VersionProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy extends Width implements BindableProxy {
      private BindableProxyAgent<Width> agent;
      private Width target;
      public org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy() {
        this(new Width());
      }

      public org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy(Width targetVal) {
        agent = new BindableProxyAgent<Width>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(Width.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Width unwrap() {
        return target;
      }

      public Width deepUnwrap() {
        final Width clone = new Width();
        final Width t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Width", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (Width) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Width", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(Width.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy((Width) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_dimensions_WidthProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy extends DataIOSet implements BindableProxy {
      private BindableProxyAgent<DataIOSet> agent;
      private DataIOSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy() {
        this(new DataIOSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy(DataIOSet targetVal) {
        agent = new BindableProxyAgent<DataIOSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("assignmentsinfo", new PropertyType(AssignmentsInfo.class, true, false));
        p.put("this", new PropertyType(DataIOSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DataIOSet unwrap() {
        return target;
      }

      public DataIOSet deepUnwrap() {
        final DataIOSet clone = new DataIOSet();
        final DataIOSet t = unwrap();
        if (t.getAssignmentsinfo() instanceof BindableProxy) {
          clone.setAssignmentsinfo((AssignmentsInfo) ((BindableProxy) getAssignmentsinfo()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAssignmentsinfo())) {
          clone.setAssignmentsinfo((AssignmentsInfo) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAssignmentsinfo())).deepUnwrap());
        } else {
          clone.setAssignmentsinfo(t.getAssignmentsinfo());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public AssignmentsInfo getAssignmentsinfo() {
        return target.getAssignmentsinfo();
      }

      public void setAssignmentsinfo(AssignmentsInfo assignmentsinfo) {
        if (agent.binders.containsKey("assignmentsinfo")) {
          assignmentsinfo = (AssignmentsInfo) agent.binders.get("assignmentsinfo").setModel(assignmentsinfo, StateSync.FROM_MODEL, true);
        }
        changeAndFire("assignmentsinfo", assignmentsinfo);
      }

      public Object get(String property) {
        switch (property) {
          case "assignmentsinfo": return getAssignmentsinfo();
          case "this": return target;
          default: throw new NonExistingPropertyException("DataIOSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "assignmentsinfo": target.setAssignmentsinfo((AssignmentsInfo) value);
          break;
          case "this": target = (DataIOSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DataIOSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(DataIOSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy((DataIOSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dataio_DataIOSetProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_AssociationProxy extends Association implements BindableProxy {
      private BindableProxyAgent<Association> agent;
      private Association target;
      public org_kie_workbench_common_dmn_api_definition_model_AssociationProxy() {
        this(new Association());
      }

      public org_kie_workbench_common_dmn_api_definition_model_AssociationProxy(Association targetVal) {
        agent = new BindableProxyAgent<Association>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("extensionElements", new PropertyType(ExtensionElements.class, false, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("description", new PropertyType(org.kie.workbench.common.dmn.api.property.dmn.Description.class, true, false));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(Association.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Association unwrap() {
        return target;
      }

      public Association deepUnwrap() {
        final Association clone = new Association();
        final Association t = unwrap();
        clone.setParent(t.getParent());
        clone.setExtensionElements(t.getExtensionElements());
        if (t.getDescription() instanceof BindableProxy) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) getDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDescription())) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDescription())).deepUnwrap());
        } else {
          clone.setDescription(t.getDescription());
        }
        if (t.getId() instanceof BindableProxy) {
          clone.setId((Id) ((BindableProxy) getId()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getId())) {
          clone.setId((Id) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getId())).deepUnwrap());
        } else {
          clone.setId(t.getId());
        }
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_AssociationProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_AssociationProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public ExtensionElements getExtensionElements() {
        return target.getExtensionElements();
      }

      public void setExtensionElements(ExtensionElements extensionElements) {
        changeAndFire("extensionElements", extensionElements);
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Description getDescription() {
        return target.getDescription();
      }

      public void setDescription(org.kie.workbench.common.dmn.api.property.dmn.Description description) {
        if (agent.binders.containsKey("description")) {
          description = (org.kie.workbench.common.dmn.api.property.dmn.Description) agent.binders.get("description").setModel(description, StateSync.FROM_MODEL, true);
        }
        changeAndFire("description", description);
      }

      public Id getId() {
        return target.getId();
      }

      public void setId(Id id) {
        if (agent.binders.containsKey("id")) {
          id = (Id) agent.binders.get("id").setModel(id, StateSync.FROM_MODEL, true);
        }
        changeAndFire("id", id);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "nsContext": return getNsContext();
          case "extensionElements": return getExtensionElements();
          case "stunnerLabels": return getStunnerLabels();
          case "description": return getDescription();
          case "id": return getId();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("Association", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "extensionElements": target.setExtensionElements((ExtensionElements) value);
          break;
          case "description": target.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) value);
          break;
          case "id": target.setId((Id) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (Association) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Association", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(Association.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_AssociationProxy((Association) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_AssociationProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy extends InputClauseUnaryTests implements BindableProxy {
      private BindableProxyAgent<InputClauseUnaryTests> agent;
      private InputClauseUnaryTests target;
      public org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy() {
        this(new InputClauseUnaryTests());
      }

      public org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy(InputClauseUnaryTests targetVal) {
        agent = new BindableProxyAgent<InputClauseUnaryTests>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("constraintType", new PropertyType(ConstraintType.class, false, false));
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("constraintTypeProperty", new PropertyType(ConstraintTypeProperty.class, true, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("text", new PropertyType(Text.class, true, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(InputClauseUnaryTests.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public InputClauseUnaryTests unwrap() {
        return target;
      }

      public InputClauseUnaryTests deepUnwrap() {
        final InputClauseUnaryTests clone = new InputClauseUnaryTests();
        final InputClauseUnaryTests t = unwrap();
        clone.setParent(t.getParent());
        if (t.getConstraintTypeProperty() instanceof BindableProxy) {
          clone.setConstraintTypeProperty((ConstraintTypeProperty) ((BindableProxy) getConstraintTypeProperty()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getConstraintTypeProperty())) {
          clone.setConstraintTypeProperty((ConstraintTypeProperty) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getConstraintTypeProperty())).deepUnwrap());
        } else {
          clone.setConstraintTypeProperty(t.getConstraintTypeProperty());
        }
        if (t.getText() instanceof BindableProxy) {
          clone.setText((Text) ((BindableProxy) getText()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getText())) {
          clone.setText((Text) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getText())).deepUnwrap());
        } else {
          clone.setText(t.getText());
        }
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public ConstraintType getConstraintType() {
        return target.getConstraintType();
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public ConstraintTypeProperty getConstraintTypeProperty() {
        return target.getConstraintTypeProperty();
      }

      public void setConstraintTypeProperty(ConstraintTypeProperty constraintTypeProperty) {
        if (agent.binders.containsKey("constraintTypeProperty")) {
          constraintTypeProperty = (ConstraintTypeProperty) agent.binders.get("constraintTypeProperty").setModel(constraintTypeProperty, StateSync.FROM_MODEL, true);
        }
        changeAndFire("constraintTypeProperty", constraintTypeProperty);
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public Id getId() {
        return target.getId();
      }

      public Text getText() {
        return target.getText();
      }

      public void setText(Text text) {
        if (agent.binders.containsKey("text")) {
          text = (Text) agent.binders.get("text").setModel(text, StateSync.FROM_MODEL, true);
        }
        changeAndFire("text", text);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "constraintType": return getConstraintType();
          case "parent": return getParent();
          case "defaultNamespace": return getDefaultNamespace();
          case "constraintTypeProperty": return getConstraintTypeProperty();
          case "nsContext": return getNsContext();
          case "id": return getId();
          case "text": return getText();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("InputClauseUnaryTests", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "constraintTypeProperty": target.setConstraintTypeProperty((ConstraintTypeProperty) value);
          break;
          case "text": target.setText((Text) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (InputClauseUnaryTests) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("InputClauseUnaryTests", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(InputClauseUnaryTests.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy((InputClauseUnaryTests) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy extends GenericServiceTaskValue implements BindableProxy {
      private BindableProxyAgent<GenericServiceTaskValue> agent;
      private GenericServiceTaskValue target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy() {
        this(new GenericServiceTaskValue());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy(GenericServiceTaskValue targetVal) {
        agent = new BindableProxyAgent<GenericServiceTaskValue>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("outMessagetructure", new PropertyType(String.class, false, false));
        p.put("serviceOperation", new PropertyType(String.class, false, false));
        p.put("serviceImplementation", new PropertyType(String.class, false, false));
        p.put("serviceInterface", new PropertyType(String.class, false, false));
        p.put("inMessageStructure", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(GenericServiceTaskValue.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public GenericServiceTaskValue unwrap() {
        return target;
      }

      public GenericServiceTaskValue deepUnwrap() {
        final GenericServiceTaskValue clone = new GenericServiceTaskValue();
        final GenericServiceTaskValue t = unwrap();
        clone.setOutMessagetructure(t.getOutMessagetructure());
        clone.setServiceOperation(t.getServiceOperation());
        clone.setServiceImplementation(t.getServiceImplementation());
        clone.setServiceInterface(t.getServiceInterface());
        clone.setInMessageStructure(t.getInMessageStructure());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getOutMessagetructure() {
        return target.getOutMessagetructure();
      }

      public void setOutMessagetructure(String outMessagetructure) {
        changeAndFire("outMessagetructure", outMessagetructure);
      }

      public String getServiceOperation() {
        return target.getServiceOperation();
      }

      public void setServiceOperation(String serviceOperation) {
        changeAndFire("serviceOperation", serviceOperation);
      }

      public String getServiceImplementation() {
        return target.getServiceImplementation();
      }

      public void setServiceImplementation(String serviceImplementation) {
        changeAndFire("serviceImplementation", serviceImplementation);
      }

      public String getServiceInterface() {
        return target.getServiceInterface();
      }

      public void setServiceInterface(String serviceInterface) {
        changeAndFire("serviceInterface", serviceInterface);
      }

      public String getInMessageStructure() {
        return target.getInMessageStructure();
      }

      public void setInMessageStructure(String inMessageStructure) {
        changeAndFire("inMessageStructure", inMessageStructure);
      }

      public Object get(String property) {
        switch (property) {
          case "outMessagetructure": return getOutMessagetructure();
          case "serviceOperation": return getServiceOperation();
          case "serviceImplementation": return getServiceImplementation();
          case "serviceInterface": return getServiceInterface();
          case "inMessageStructure": return getInMessageStructure();
          case "this": return target;
          default: throw new NonExistingPropertyException("GenericServiceTaskValue", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "outMessagetructure": target.setOutMessagetructure((String) value);
          break;
          case "serviceOperation": target.setServiceOperation((String) value);
          break;
          case "serviceImplementation": target.setServiceImplementation((String) value);
          break;
          case "serviceInterface": target.setServiceInterface((String) value);
          break;
          case "inMessageStructure": target.setInMessageStructure((String) value);
          break;
          case "this": target = (GenericServiceTaskValue) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("GenericServiceTaskValue", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(GenericServiceTaskValue.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy((GenericServiceTaskValue) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskValueProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy extends BackgroundSet implements BindableProxy {
      private BindableProxyAgent<BackgroundSet> agent;
      private BackgroundSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy() {
        this(new BackgroundSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy(BackgroundSet targetVal) {
        agent = new BindableProxyAgent<BackgroundSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("borderColor", new PropertyType(BorderColor.class, true, false));
        p.put("bgColor", new PropertyType(BgColor.class, true, false));
        p.put("borderSize", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize.class, true, false));
        p.put("this", new PropertyType(BackgroundSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BackgroundSet unwrap() {
        return target;
      }

      public BackgroundSet deepUnwrap() {
        final BackgroundSet clone = new BackgroundSet();
        final BackgroundSet t = unwrap();
        if (t.getBorderColor() instanceof BindableProxy) {
          clone.setBorderColor((BorderColor) ((BindableProxy) getBorderColor()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBorderColor())) {
          clone.setBorderColor((BorderColor) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBorderColor())).deepUnwrap());
        } else {
          clone.setBorderColor(t.getBorderColor());
        }
        if (t.getBgColor() instanceof BindableProxy) {
          clone.setBgColor((BgColor) ((BindableProxy) getBgColor()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBgColor())) {
          clone.setBgColor((BgColor) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBgColor())).deepUnwrap());
        } else {
          clone.setBgColor(t.getBgColor());
        }
        if (t.getBorderSize() instanceof BindableProxy) {
          clone.setBorderSize((org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize) ((BindableProxy) getBorderSize()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBorderSize())) {
          clone.setBorderSize((org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBorderSize())).deepUnwrap());
        } else {
          clone.setBorderSize(t.getBorderSize());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BorderColor getBorderColor() {
        return target.getBorderColor();
      }

      public void setBorderColor(BorderColor borderColor) {
        if (agent.binders.containsKey("borderColor")) {
          borderColor = (BorderColor) agent.binders.get("borderColor").setModel(borderColor, StateSync.FROM_MODEL, true);
        }
        changeAndFire("borderColor", borderColor);
      }

      public BgColor getBgColor() {
        return target.getBgColor();
      }

      public void setBgColor(BgColor bgColor) {
        if (agent.binders.containsKey("bgColor")) {
          bgColor = (BgColor) agent.binders.get("bgColor").setModel(bgColor, StateSync.FROM_MODEL, true);
        }
        changeAndFire("bgColor", bgColor);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize getBorderSize() {
        return target.getBorderSize();
      }

      public void setBorderSize(org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize borderSize) {
        if (agent.binders.containsKey("borderSize")) {
          borderSize = (org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize) agent.binders.get("borderSize").setModel(borderSize, StateSync.FROM_MODEL, true);
        }
        changeAndFire("borderSize", borderSize);
      }

      public Object get(String property) {
        switch (property) {
          case "borderColor": return getBorderColor();
          case "bgColor": return getBgColor();
          case "borderSize": return getBorderSize();
          case "this": return target;
          default: throw new NonExistingPropertyException("BackgroundSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "borderColor": target.setBorderColor((BorderColor) value);
          break;
          case "bgColor": target.setBgColor((BgColor) value);
          break;
          case "borderSize": target.setBorderSize((org.kie.workbench.common.stunner.bpmn.definition.property.background.BorderSize) value);
          break;
          case "this": target = (BackgroundSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BackgroundSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(BackgroundSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy((BackgroundSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_background_BackgroundSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy extends AssigneeEditorFieldDefinition implements BindableProxy {
      private BindableProxyAgent<AssigneeEditorFieldDefinition> agent;
      private AssigneeEditorFieldDefinition target;
      public org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy() {
        this(new AssigneeEditorFieldDefinition());
      }

      public org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy(AssigneeEditorFieldDefinition targetVal) {
        agent = new BindableProxyAgent<AssigneeEditorFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("max", new PropertyType(Integer.class, false, false));
        p.put("defaultValue", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("type", new PropertyType(AssigneeType.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(AssigneeEditorFieldType.class, false, false));
        p.put("this", new PropertyType(AssigneeEditorFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AssigneeEditorFieldDefinition unwrap() {
        return target;
      }

      public AssigneeEditorFieldDefinition deepUnwrap() {
        final AssigneeEditorFieldDefinition clone = new AssigneeEditorFieldDefinition();
        final AssigneeEditorFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setMax(t.getMax());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setType(t.getType());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Integer getMax() {
        return target.getMax();
      }

      public void setMax(Integer max) {
        changeAndFire("max", max);
      }

      public String getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(String defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public AssigneeType getType() {
        return target.getType();
      }

      public void setType(AssigneeType type) {
        changeAndFire("type", type);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public AssigneeEditorFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "max": return getMax();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "type": return getType();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("AssigneeEditorFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "max": target.setMax((Integer) value);
          break;
          case "defaultValue": target.setDefaultValue((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "type": target.setType((AssigneeType) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (AssigneeEditorFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AssigneeEditorFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(AssigneeEditorFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy((AssigneeEditorFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_AssigneeEditorFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy extends CancellingEscalationEventExecutionSet implements BindableProxy {
      private BindableProxyAgent<CancellingEscalationEventExecutionSet> agent;
      private CancellingEscalationEventExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy() {
        this(new CancellingEscalationEventExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy(CancellingEscalationEventExecutionSet targetVal) {
        agent = new BindableProxyAgent<CancellingEscalationEventExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("cancelActivity", new PropertyType(CancelActivity.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("escalationRef", new PropertyType(EscalationRef.class, true, false));
        p.put("this", new PropertyType(CancellingEscalationEventExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CancellingEscalationEventExecutionSet unwrap() {
        return target;
      }

      public CancellingEscalationEventExecutionSet deepUnwrap() {
        final CancellingEscalationEventExecutionSet clone = new CancellingEscalationEventExecutionSet();
        final CancellingEscalationEventExecutionSet t = unwrap();
        if (t.getCancelActivity() instanceof BindableProxy) {
          clone.setCancelActivity((CancelActivity) ((BindableProxy) getCancelActivity()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCancelActivity())) {
          clone.setCancelActivity((CancelActivity) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCancelActivity())).deepUnwrap());
        } else {
          clone.setCancelActivity(t.getCancelActivity());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getEscalationRef() instanceof BindableProxy) {
          clone.setEscalationRef((EscalationRef) ((BindableProxy) getEscalationRef()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getEscalationRef())) {
          clone.setEscalationRef((EscalationRef) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getEscalationRef())).deepUnwrap());
        } else {
          clone.setEscalationRef(t.getEscalationRef());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public CancelActivity getCancelActivity() {
        return target.getCancelActivity();
      }

      public void setCancelActivity(CancelActivity cancelActivity) {
        if (agent.binders.containsKey("cancelActivity")) {
          cancelActivity = (CancelActivity) agent.binders.get("cancelActivity").setModel(cancelActivity, StateSync.FROM_MODEL, true);
        }
        changeAndFire("cancelActivity", cancelActivity);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public EscalationRef getEscalationRef() {
        return target.getEscalationRef();
      }

      public void setEscalationRef(EscalationRef escalationRef) {
        if (agent.binders.containsKey("escalationRef")) {
          escalationRef = (EscalationRef) agent.binders.get("escalationRef").setModel(escalationRef, StateSync.FROM_MODEL, true);
        }
        changeAndFire("escalationRef", escalationRef);
      }

      public Object get(String property) {
        switch (property) {
          case "cancelActivity": return getCancelActivity();
          case "slaDueDate": return getSlaDueDate();
          case "escalationRef": return getEscalationRef();
          case "this": return target;
          default: throw new NonExistingPropertyException("CancellingEscalationEventExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "cancelActivity": target.setCancelActivity((CancelActivity) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "escalationRef": target.setEscalationRef((EscalationRef) value);
          break;
          case "this": target = (CancellingEscalationEventExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CancellingEscalationEventExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CancellingEscalationEventExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy((CancellingEscalationEventExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_CancellingEscalationEventExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy extends IntermediateMessageEventCatching implements BindableProxy {
      private BindableProxyAgent<IntermediateMessageEventCatching> agent;
      private IntermediateMessageEventCatching target;
      public org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy() {
        this(new IntermediateMessageEventCatching());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy(IntermediateMessageEventCatching targetVal) {
        agent = new BindableProxyAgent<IntermediateMessageEventCatching>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("dataIOSet", new PropertyType(DataIOSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(CancellingMessageEventExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(IntermediateMessageEventCatching.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IntermediateMessageEventCatching unwrap() {
        return target;
      }

      public IntermediateMessageEventCatching deepUnwrap() {
        final IntermediateMessageEventCatching clone = new IntermediateMessageEventCatching();
        final IntermediateMessageEventCatching t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getDataIOSet() instanceof BindableProxy) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) getDataIOSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDataIOSet())) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDataIOSet())).deepUnwrap());
        } else {
          clone.setDataIOSet(t.getDataIOSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((CancellingMessageEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((CancellingMessageEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public DataIOSet getDataIOSet() {
        return target.getDataIOSet();
      }

      public void setDataIOSet(DataIOSet dataIOSet) {
        if (agent.binders.containsKey("dataIOSet")) {
          dataIOSet = (DataIOSet) agent.binders.get("dataIOSet").setModel(dataIOSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dataIOSet", dataIOSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public CancellingMessageEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(CancellingMessageEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (CancellingMessageEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "dataIOSet": return getDataIOSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("IntermediateMessageEventCatching", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "dataIOSet": target.setDataIOSet((DataIOSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((CancellingMessageEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (IntermediateMessageEventCatching) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IntermediateMessageEventCatching", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(IntermediateMessageEventCatching.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy((IntermediateMessageEventCatching) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_IntermediateMessageEventCatchingProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy extends BgColor implements BindableProxy {
      private BindableProxyAgent<BgColor> agent;
      private BgColor target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy() {
        this(new BgColor());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy(BgColor targetVal) {
        agent = new BindableProxyAgent<BgColor>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(BgColor.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BgColor unwrap() {
        return target;
      }

      public BgColor deepUnwrap() {
        final BgColor clone = new BgColor();
        final BgColor t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("BgColor", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (BgColor) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BgColor", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(BgColor.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy((BgColor) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_background_BgColorProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy extends KnowledgeRequirement implements BindableProxy {
      private BindableProxyAgent<KnowledgeRequirement> agent;
      private KnowledgeRequirement target;
      public org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy() {
        this(new KnowledgeRequirement());
      }

      public org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy(KnowledgeRequirement targetVal) {
        agent = new BindableProxyAgent<KnowledgeRequirement>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(KnowledgeRequirement.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public KnowledgeRequirement unwrap() {
        return target;
      }

      public KnowledgeRequirement deepUnwrap() {
        final KnowledgeRequirement clone = new KnowledgeRequirement();
        final KnowledgeRequirement t = unwrap();
        clone.setParent(t.getParent());
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "nsContext": return getNsContext();
          case "stunnerLabels": return getStunnerLabels();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("KnowledgeRequirement", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (KnowledgeRequirement) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("KnowledgeRequirement", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(KnowledgeRequirement.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy((KnowledgeRequirement) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementProxy();
      }
    });
    class org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy extends ProcessInstanceLogSummary implements BindableProxy {
      private BindableProxyAgent<ProcessInstanceLogSummary> agent;
      private ProcessInstanceLogSummary target;
      public org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy() {
        this(new ProcessInstanceLogSummary());
      }

      public org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy(ProcessInstanceLogSummary targetVal) {
        agent = new BindableProxyAgent<ProcessInstanceLogSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("date", new PropertyType(Date.class, false, false));
        p.put("logType", new PropertyType(Long.class, false, false));
        p.put("callbacks", new PropertyType(List.class, false, true));
        p.put("completed", new PropertyType(Boolean.class, false, false));
        p.put("workItemId", new PropertyType(Long.class, false, false));
        p.put("nodeType", new PropertyType(String.class, false, false));
        p.put("referenceId", new PropertyType(Long.class, false, false));
        p.put("logDeploymentId", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("nodeContainerId", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("nodeId", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ProcessInstanceLogSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ProcessInstanceLogSummary unwrap() {
        return target;
      }

      public ProcessInstanceLogSummary deepUnwrap() {
        final ProcessInstanceLogSummary clone = new ProcessInstanceLogSummary();
        final ProcessInstanceLogSummary t = unwrap();
        clone.setDate(t.getDate());
        clone.setLogType(t.getLogType());
        if (t.getCallbacks() != null) {
          final List callbacksClone = new ArrayList();
          for (Object callbacksElem : t.getCallbacks()) {
            if (callbacksElem instanceof BindableProxy) {
              callbacksClone.add(((BindableProxy) callbacksElem).deepUnwrap());
            } else {
              callbacksClone.add(callbacksElem);
            }
          }
          clone.setCallbacks(callbacksClone);
        }
        clone.setCompleted(t.isCompleted());
        clone.setWorkItemId(t.getWorkItemId());
        clone.setNodeType(t.getNodeType());
        clone.setReferenceId(t.getReferenceId());
        clone.setLogDeploymentId(t.getLogDeploymentId());
        clone.setName(t.getName());
        clone.setNodeContainerId(t.getNodeContainerId());
        clone.setId(t.getId());
        clone.setNodeId(t.getNodeId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy) {
          obj = ((org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Date getDate() {
        return target.getDate();
      }

      public void setDate(Date date) {
        changeAndFire("date", date);
      }

      public Long getLogType() {
        return target.getLogType();
      }

      public void setLogType(Long logType) {
        changeAndFire("logType", logType);
      }

      public List getCallbacks() {
        return target.getCallbacks();
      }

      public void setCallbacks(List<LabeledCommand> callbacks) {
        List<LabeledCommand> oldValue = target.getCallbacks();
        callbacks = agent.ensureBoundListIsProxied("callbacks", callbacks);
        target.setCallbacks(callbacks);
        agent.updateWidgetsAndFireEvent(true, "callbacks", oldValue, callbacks);
      }

      public boolean isCompleted() {
        return target.isCompleted();
      }

      public void setCompleted(boolean completed) {
        changeAndFire("completed", completed);
      }

      public Long getWorkItemId() {
        return target.getWorkItemId();
      }

      public void setWorkItemId(Long workItemId) {
        changeAndFire("workItemId", workItemId);
      }

      public String getNodeType() {
        return target.getNodeType();
      }

      public void setNodeType(String nodeType) {
        changeAndFire("nodeType", nodeType);
      }

      public Long getReferenceId() {
        return target.getReferenceId();
      }

      public void setReferenceId(Long referenceId) {
        changeAndFire("referenceId", referenceId);
      }

      public String getLogDeploymentId() {
        return target.getLogDeploymentId();
      }

      public void setLogDeploymentId(String logDeploymentId) {
        changeAndFire("logDeploymentId", logDeploymentId);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getNodeContainerId() {
        return target.getNodeContainerId();
      }

      public void setNodeContainerId(String nodeContainerId) {
        changeAndFire("nodeContainerId", nodeContainerId);
      }

      public Long getId() {
        return target.getId();
      }

      public void setId(Long id) {
        changeAndFire("id", id);
      }

      public String getNodeId() {
        return target.getNodeId();
      }

      public void setNodeId(String nodeId) {
        changeAndFire("nodeId", nodeId);
      }

      public Object get(String property) {
        switch (property) {
          case "date": return getDate();
          case "logType": return getLogType();
          case "callbacks": return getCallbacks();
          case "completed": return isCompleted();
          case "workItemId": return getWorkItemId();
          case "nodeType": return getNodeType();
          case "referenceId": return getReferenceId();
          case "logDeploymentId": return getLogDeploymentId();
          case "name": return getName();
          case "nodeContainerId": return getNodeContainerId();
          case "id": return getId();
          case "nodeId": return getNodeId();
          case "this": return target;
          default: throw new NonExistingPropertyException("ProcessInstanceLogSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "date": target.setDate((Date) value);
          break;
          case "logType": target.setLogType((Long) value);
          break;
          case "callbacks": target.setCallbacks((List<LabeledCommand>) value);
          break;
          case "completed": target.setCompleted((Boolean) value);
          break;
          case "workItemId": target.setWorkItemId((Long) value);
          break;
          case "nodeType": target.setNodeType((String) value);
          break;
          case "referenceId": target.setReferenceId((Long) value);
          break;
          case "logDeploymentId": target.setLogDeploymentId((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "nodeContainerId": target.setNodeContainerId((String) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "nodeId": target.setNodeId((String) value);
          break;
          case "this": target = (ProcessInstanceLogSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ProcessInstanceLogSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasCallbacks() {
        final boolean returnValue = target.hasCallbacks();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void addCallback(String a0, Command a1) {
        target.addCallback(a0, a1);
        agent.updateWidgetsAndFireEvents();
      }

      public int compareTo(AbstractPageRow a0) {
        final int returnValue = target.compareTo(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(ProcessInstanceLogSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy((ProcessInstanceLogSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_pr_model_ProcessInstanceLogSummaryProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy extends CancellingSignalEventExecutionSet implements BindableProxy {
      private BindableProxyAgent<CancellingSignalEventExecutionSet> agent;
      private CancellingSignalEventExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy() {
        this(new CancellingSignalEventExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy(CancellingSignalEventExecutionSet targetVal) {
        agent = new BindableProxyAgent<CancellingSignalEventExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("signalRef", new PropertyType(SignalRef.class, true, false));
        p.put("cancelActivity", new PropertyType(CancelActivity.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("this", new PropertyType(CancellingSignalEventExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CancellingSignalEventExecutionSet unwrap() {
        return target;
      }

      public CancellingSignalEventExecutionSet deepUnwrap() {
        final CancellingSignalEventExecutionSet clone = new CancellingSignalEventExecutionSet();
        final CancellingSignalEventExecutionSet t = unwrap();
        if (t.getSignalRef() instanceof BindableProxy) {
          clone.setSignalRef((SignalRef) ((BindableProxy) getSignalRef()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSignalRef())) {
          clone.setSignalRef((SignalRef) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSignalRef())).deepUnwrap());
        } else {
          clone.setSignalRef(t.getSignalRef());
        }
        if (t.getCancelActivity() instanceof BindableProxy) {
          clone.setCancelActivity((CancelActivity) ((BindableProxy) getCancelActivity()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCancelActivity())) {
          clone.setCancelActivity((CancelActivity) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCancelActivity())).deepUnwrap());
        } else {
          clone.setCancelActivity(t.getCancelActivity());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public SignalRef getSignalRef() {
        return target.getSignalRef();
      }

      public void setSignalRef(SignalRef signalRef) {
        if (agent.binders.containsKey("signalRef")) {
          signalRef = (SignalRef) agent.binders.get("signalRef").setModel(signalRef, StateSync.FROM_MODEL, true);
        }
        changeAndFire("signalRef", signalRef);
      }

      public CancelActivity getCancelActivity() {
        return target.getCancelActivity();
      }

      public void setCancelActivity(CancelActivity cancelActivity) {
        if (agent.binders.containsKey("cancelActivity")) {
          cancelActivity = (CancelActivity) agent.binders.get("cancelActivity").setModel(cancelActivity, StateSync.FROM_MODEL, true);
        }
        changeAndFire("cancelActivity", cancelActivity);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public Object get(String property) {
        switch (property) {
          case "signalRef": return getSignalRef();
          case "cancelActivity": return getCancelActivity();
          case "slaDueDate": return getSlaDueDate();
          case "this": return target;
          default: throw new NonExistingPropertyException("CancellingSignalEventExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "signalRef": target.setSignalRef((SignalRef) value);
          break;
          case "cancelActivity": target.setCancelActivity((CancelActivity) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "this": target = (CancellingSignalEventExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CancellingSignalEventExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CancellingSignalEventExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy((CancellingSignalEventExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_CancellingSignalEventExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy extends ScriptTypeFieldDefinition implements BindableProxy {
      private BindableProxyAgent<ScriptTypeFieldDefinition> agent;
      private ScriptTypeFieldDefinition target;
      public org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy() {
        this(new ScriptTypeFieldDefinition());
      }

      public org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy(ScriptTypeFieldDefinition targetVal) {
        agent = new BindableProxyAgent<ScriptTypeFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("mode", new PropertyType(ScriptTypeMode.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(ScriptTypeFieldType.class, false, false));
        p.put("this", new PropertyType(ScriptTypeFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ScriptTypeFieldDefinition unwrap() {
        return target;
      }

      public ScriptTypeFieldDefinition deepUnwrap() {
        final ScriptTypeFieldDefinition clone = new ScriptTypeFieldDefinition();
        final ScriptTypeFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setMode(t.getMode());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public ScriptTypeMode getMode() {
        return target.getMode();
      }

      public void setMode(ScriptTypeMode mode) {
        changeAndFire("mode", mode);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public ScriptTypeFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "mode": return getMode();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("ScriptTypeFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "mode": target.setMode((ScriptTypeMode) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (ScriptTypeFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ScriptTypeFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(ScriptTypeFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy((ScriptTypeFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy extends DecimalRadioGroupFieldDefinition implements BindableProxy {
      private BindableProxyAgent<DecimalRadioGroupFieldDefinition> agent;
      private DecimalRadioGroupFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy() {
        this(new DecimalRadioGroupFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy(DecimalRadioGroupFieldDefinition targetVal) {
        agent = new BindableProxyAgent<DecimalRadioGroupFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("relatedField", new PropertyType(String.class, false, false));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(Double.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("inline", new PropertyType(Boolean.class, false, false));
        p.put("options", new PropertyType(List.class, false, true));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("dataProvider", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(RadioGroupFieldType.class, false, false));
        p.put("this", new PropertyType(DecimalRadioGroupFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DecimalRadioGroupFieldDefinition unwrap() {
        return target;
      }

      public DecimalRadioGroupFieldDefinition deepUnwrap() {
        final DecimalRadioGroupFieldDefinition clone = new DecimalRadioGroupFieldDefinition();
        final DecimalRadioGroupFieldDefinition t = unwrap();
        clone.setRelatedField(t.getRelatedField());
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setInline(t.getInline());
        if (t.getOptions() != null) {
          final List optionsClone = new ArrayList();
          for (Object optionsElem : t.getOptions()) {
            if (optionsElem instanceof BindableProxy) {
              optionsClone.add(((BindableProxy) optionsElem).deepUnwrap());
            } else {
              optionsClone.add(optionsElem);
            }
          }
          clone.setOptions(optionsClone);
        }
        clone.setName(t.getName());
        clone.setDataProvider(t.getDataProvider());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getRelatedField() {
        return target.getRelatedField();
      }

      public void setRelatedField(String relatedField) {
        changeAndFire("relatedField", relatedField);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Double getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(Double defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Boolean getInline() {
        return target.getInline();
      }

      public void setInline(Boolean inline) {
        changeAndFire("inline", inline);
      }

      public List getOptions() {
        return target.getOptions();
      }

      public void setOptions(List<DecimalSelectorOption> options) {
        List<DecimalSelectorOption> oldValue = target.getOptions();
        options = agent.ensureBoundListIsProxied("options", options);
        target.setOptions(options);
        agent.updateWidgetsAndFireEvent(true, "options", oldValue, options);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getDataProvider() {
        return target.getDataProvider();
      }

      public void setDataProvider(String dataProvider) {
        changeAndFire("dataProvider", dataProvider);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public RadioGroupFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "relatedField": return getRelatedField();
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "inline": return getInline();
          case "options": return getOptions();
          case "name": return getName();
          case "dataProvider": return getDataProvider();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("DecimalRadioGroupFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "relatedField": target.setRelatedField((String) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((Double) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "inline": target.setInline((Boolean) value);
          break;
          case "options": target.setOptions((List<DecimalSelectorOption>) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "dataProvider": target.setDataProvider((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (DecimalRadioGroupFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DecimalRadioGroupFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(DecimalRadioGroupFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy((DecimalRadioGroupFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_DecimalRadioGroupFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy extends TimerSettings implements BindableProxy {
      private BindableProxyAgent<TimerSettings> agent;
      private TimerSettings target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy() {
        this(new TimerSettings());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy(TimerSettings targetVal) {
        agent = new BindableProxyAgent<TimerSettings>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(TimerSettingsValue.class, true, false));
        p.put("this", new PropertyType(TimerSettings.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public TimerSettings unwrap() {
        return target;
      }

      public TimerSettings deepUnwrap() {
        final TimerSettings clone = new TimerSettings();
        final TimerSettings t = unwrap();
        if (t.getValue() instanceof BindableProxy) {
          clone.setValue((TimerSettingsValue) ((BindableProxy) getValue()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getValue())) {
          clone.setValue((TimerSettingsValue) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getValue())).deepUnwrap());
        } else {
          clone.setValue(t.getValue());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public TimerSettingsValue getValue() {
        return target.getValue();
      }

      public void setValue(TimerSettingsValue value) {
        if (agent.binders.containsKey("value")) {
          value = (TimerSettingsValue) agent.binders.get("value").setModel(value, StateSync.FROM_MODEL, true);
        }
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("TimerSettings", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((TimerSettingsValue) value);
          break;
          case "this": target = (TimerSettings) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("TimerSettings", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(TimerSettings.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy((TimerSettings) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_timer_TimerSettingsProxy();
      }
    });
    class org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy extends QNameFieldDefinition implements BindableProxy {
      private BindableProxyAgent<QNameFieldDefinition> agent;
      private QNameFieldDefinition target;
      public org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy() {
        this(new QNameFieldDefinition());
      }

      public org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy(QNameFieldDefinition targetVal) {
        agent = new BindableProxyAgent<QNameFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(QNameFieldType.class, false, false));
        p.put("placeHolder", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(QNameFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public QNameFieldDefinition unwrap() {
        return target;
      }

      public QNameFieldDefinition deepUnwrap() {
        final QNameFieldDefinition clone = new QNameFieldDefinition();
        final QNameFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        clone.setPlaceHolder(t.getPlaceHolder());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public QNameFieldType getFieldType() {
        return target.getFieldType();
      }

      public String getPlaceHolder() {
        return target.getPlaceHolder();
      }

      public void setPlaceHolder(String placeHolder) {
        changeAndFire("placeHolder", placeHolder);
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "placeHolder": return getPlaceHolder();
          case "this": return target;
          default: throw new NonExistingPropertyException("QNameFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "placeHolder": target.setPlaceHolder((String) value);
          break;
          case "this": target = (QNameFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("QNameFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(QNameFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy((QNameFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_client_property_dmn_QNameFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy extends InterruptingSignalEventExecutionSet implements BindableProxy {
      private BindableProxyAgent<InterruptingSignalEventExecutionSet> agent;
      private InterruptingSignalEventExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy() {
        this(new InterruptingSignalEventExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy(InterruptingSignalEventExecutionSet targetVal) {
        agent = new BindableProxyAgent<InterruptingSignalEventExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("signalRef", new PropertyType(SignalRef.class, true, false));
        p.put("isInterrupting", new PropertyType(IsInterrupting.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("this", new PropertyType(InterruptingSignalEventExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public InterruptingSignalEventExecutionSet unwrap() {
        return target;
      }

      public InterruptingSignalEventExecutionSet deepUnwrap() {
        final InterruptingSignalEventExecutionSet clone = new InterruptingSignalEventExecutionSet();
        final InterruptingSignalEventExecutionSet t = unwrap();
        if (t.getSignalRef() instanceof BindableProxy) {
          clone.setSignalRef((SignalRef) ((BindableProxy) getSignalRef()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSignalRef())) {
          clone.setSignalRef((SignalRef) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSignalRef())).deepUnwrap());
        } else {
          clone.setSignalRef(t.getSignalRef());
        }
        if (t.getIsInterrupting() instanceof BindableProxy) {
          clone.setIsInterrupting((IsInterrupting) ((BindableProxy) getIsInterrupting()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsInterrupting())) {
          clone.setIsInterrupting((IsInterrupting) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsInterrupting())).deepUnwrap());
        } else {
          clone.setIsInterrupting(t.getIsInterrupting());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public SignalRef getSignalRef() {
        return target.getSignalRef();
      }

      public void setSignalRef(SignalRef signalRef) {
        if (agent.binders.containsKey("signalRef")) {
          signalRef = (SignalRef) agent.binders.get("signalRef").setModel(signalRef, StateSync.FROM_MODEL, true);
        }
        changeAndFire("signalRef", signalRef);
      }

      public IsInterrupting getIsInterrupting() {
        return target.getIsInterrupting();
      }

      public void setIsInterrupting(IsInterrupting isInterrupting) {
        if (agent.binders.containsKey("isInterrupting")) {
          isInterrupting = (IsInterrupting) agent.binders.get("isInterrupting").setModel(isInterrupting, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isInterrupting", isInterrupting);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public Object get(String property) {
        switch (property) {
          case "signalRef": return getSignalRef();
          case "isInterrupting": return getIsInterrupting();
          case "slaDueDate": return getSlaDueDate();
          case "this": return target;
          default: throw new NonExistingPropertyException("InterruptingSignalEventExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "signalRef": target.setSignalRef((SignalRef) value);
          break;
          case "isInterrupting": target.setIsInterrupting((IsInterrupting) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "this": target = (InterruptingSignalEventExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("InterruptingSignalEventExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(InterruptingSignalEventExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy((InterruptingSignalEventExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_signal_InterruptingSignalEventExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy extends CharacterRadioGroupFieldDefinition implements BindableProxy {
      private BindableProxyAgent<CharacterRadioGroupFieldDefinition> agent;
      private CharacterRadioGroupFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy() {
        this(new CharacterRadioGroupFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy(CharacterRadioGroupFieldDefinition targetVal) {
        agent = new BindableProxyAgent<CharacterRadioGroupFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("relatedField", new PropertyType(String.class, false, false));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(Character.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("inline", new PropertyType(Boolean.class, false, false));
        p.put("options", new PropertyType(List.class, false, true));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("dataProvider", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(RadioGroupFieldType.class, false, false));
        p.put("this", new PropertyType(CharacterRadioGroupFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CharacterRadioGroupFieldDefinition unwrap() {
        return target;
      }

      public CharacterRadioGroupFieldDefinition deepUnwrap() {
        final CharacterRadioGroupFieldDefinition clone = new CharacterRadioGroupFieldDefinition();
        final CharacterRadioGroupFieldDefinition t = unwrap();
        clone.setRelatedField(t.getRelatedField());
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setInline(t.getInline());
        if (t.getOptions() != null) {
          final List optionsClone = new ArrayList();
          for (Object optionsElem : t.getOptions()) {
            if (optionsElem instanceof BindableProxy) {
              optionsClone.add(((BindableProxy) optionsElem).deepUnwrap());
            } else {
              optionsClone.add(optionsElem);
            }
          }
          clone.setOptions(optionsClone);
        }
        clone.setName(t.getName());
        clone.setDataProvider(t.getDataProvider());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getRelatedField() {
        return target.getRelatedField();
      }

      public void setRelatedField(String relatedField) {
        changeAndFire("relatedField", relatedField);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Character getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(Character defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Boolean getInline() {
        return target.getInline();
      }

      public void setInline(Boolean inline) {
        changeAndFire("inline", inline);
      }

      public List getOptions() {
        return target.getOptions();
      }

      public void setOptions(List<CharacterSelectorOption> options) {
        List<CharacterSelectorOption> oldValue = target.getOptions();
        options = agent.ensureBoundListIsProxied("options", options);
        target.setOptions(options);
        agent.updateWidgetsAndFireEvent(true, "options", oldValue, options);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getDataProvider() {
        return target.getDataProvider();
      }

      public void setDataProvider(String dataProvider) {
        changeAndFire("dataProvider", dataProvider);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public RadioGroupFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "relatedField": return getRelatedField();
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "inline": return getInline();
          case "options": return getOptions();
          case "name": return getName();
          case "dataProvider": return getDataProvider();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("CharacterRadioGroupFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "relatedField": target.setRelatedField((String) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((Character) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "inline": target.setInline((Boolean) value);
          break;
          case "options": target.setOptions((List<CharacterSelectorOption>) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "dataProvider": target.setDataProvider((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (CharacterRadioGroupFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CharacterRadioGroupFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(CharacterRadioGroupFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy((CharacterRadioGroupFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_CharacterRadioGroupFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy extends ReusableSubprocessTaskExecutionSet implements BindableProxy {
      private BindableProxyAgent<ReusableSubprocessTaskExecutionSet> agent;
      private ReusableSubprocessTaskExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy() {
        this(new ReusableSubprocessTaskExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy(ReusableSubprocessTaskExecutionSet targetVal) {
        agent = new BindableProxyAgent<ReusableSubprocessTaskExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("abortParent", new PropertyType(AbortParent.class, true, false));
        p.put("independent", new PropertyType(Independent.class, true, false));
        p.put("isAsync", new PropertyType(IsAsync.class, true, false));
        p.put("multipleInstanceDataOutput", new PropertyType(MultipleInstanceDataOutput.class, true, false));
        p.put("waitForCompletion", new PropertyType(WaitForCompletion.class, true, false));
        p.put("onEntryAction", new PropertyType(OnEntryAction.class, true, false));
        p.put("multipleInstanceCollectionInput", new PropertyType(MultipleInstanceCollectionInput.class, true, false));
        p.put("multipleInstanceCollectionOutput", new PropertyType(MultipleInstanceCollectionOutput.class, true, false));
        p.put("multipleInstanceDataInput", new PropertyType(MultipleInstanceDataInput.class, true, false));
        p.put("adHocAutostart", new PropertyType(AdHocAutostart.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("isCase", new PropertyType(IsCase.class, true, false));
        p.put("calledElement", new PropertyType(CalledElement.class, true, false));
        p.put("isMultipleInstance", new PropertyType(IsMultipleInstance.class, true, false));
        p.put("multipleInstanceCompletionCondition", new PropertyType(MultipleInstanceCompletionCondition.class, true, false));
        p.put("onExitAction", new PropertyType(OnExitAction.class, true, false));
        p.put("multipleInstanceExecutionMode", new PropertyType(MultipleInstanceExecutionMode.class, true, false));
        p.put("this", new PropertyType(ReusableSubprocessTaskExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ReusableSubprocessTaskExecutionSet unwrap() {
        return target;
      }

      public ReusableSubprocessTaskExecutionSet deepUnwrap() {
        final ReusableSubprocessTaskExecutionSet clone = new ReusableSubprocessTaskExecutionSet();
        final ReusableSubprocessTaskExecutionSet t = unwrap();
        if (t.getAbortParent() instanceof BindableProxy) {
          clone.setAbortParent((AbortParent) ((BindableProxy) getAbortParent()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAbortParent())) {
          clone.setAbortParent((AbortParent) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAbortParent())).deepUnwrap());
        } else {
          clone.setAbortParent(t.getAbortParent());
        }
        if (t.getIndependent() instanceof BindableProxy) {
          clone.setIndependent((Independent) ((BindableProxy) getIndependent()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIndependent())) {
          clone.setIndependent((Independent) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIndependent())).deepUnwrap());
        } else {
          clone.setIndependent(t.getIndependent());
        }
        if (t.getIsAsync() instanceof BindableProxy) {
          clone.setIsAsync((IsAsync) ((BindableProxy) getIsAsync()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsAsync())) {
          clone.setIsAsync((IsAsync) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsAsync())).deepUnwrap());
        } else {
          clone.setIsAsync(t.getIsAsync());
        }
        if (t.getMultipleInstanceDataOutput() instanceof BindableProxy) {
          clone.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) ((BindableProxy) getMultipleInstanceDataOutput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceDataOutput())) {
          clone.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceDataOutput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceDataOutput(t.getMultipleInstanceDataOutput());
        }
        if (t.getWaitForCompletion() instanceof BindableProxy) {
          clone.setWaitForCompletion((WaitForCompletion) ((BindableProxy) getWaitForCompletion()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getWaitForCompletion())) {
          clone.setWaitForCompletion((WaitForCompletion) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getWaitForCompletion())).deepUnwrap());
        } else {
          clone.setWaitForCompletion(t.getWaitForCompletion());
        }
        if (t.getOnEntryAction() instanceof BindableProxy) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) getOnEntryAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnEntryAction())) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnEntryAction())).deepUnwrap());
        } else {
          clone.setOnEntryAction(t.getOnEntryAction());
        }
        if (t.getMultipleInstanceCollectionInput() instanceof BindableProxy) {
          clone.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) ((BindableProxy) getMultipleInstanceCollectionInput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCollectionInput())) {
          clone.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCollectionInput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCollectionInput(t.getMultipleInstanceCollectionInput());
        }
        if (t.getMultipleInstanceCollectionOutput() instanceof BindableProxy) {
          clone.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) ((BindableProxy) getMultipleInstanceCollectionOutput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCollectionOutput())) {
          clone.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCollectionOutput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCollectionOutput(t.getMultipleInstanceCollectionOutput());
        }
        if (t.getMultipleInstanceDataInput() instanceof BindableProxy) {
          clone.setMultipleInstanceDataInput((MultipleInstanceDataInput) ((BindableProxy) getMultipleInstanceDataInput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceDataInput())) {
          clone.setMultipleInstanceDataInput((MultipleInstanceDataInput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceDataInput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceDataInput(t.getMultipleInstanceDataInput());
        }
        if (t.getAdHocAutostart() instanceof BindableProxy) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) getAdHocAutostart()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAdHocAutostart())) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAdHocAutostart())).deepUnwrap());
        } else {
          clone.setAdHocAutostart(t.getAdHocAutostart());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getIsCase() instanceof BindableProxy) {
          clone.setIsCase((IsCase) ((BindableProxy) getIsCase()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsCase())) {
          clone.setIsCase((IsCase) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsCase())).deepUnwrap());
        } else {
          clone.setIsCase(t.getIsCase());
        }
        if (t.getCalledElement() instanceof BindableProxy) {
          clone.setCalledElement((CalledElement) ((BindableProxy) getCalledElement()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCalledElement())) {
          clone.setCalledElement((CalledElement) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCalledElement())).deepUnwrap());
        } else {
          clone.setCalledElement(t.getCalledElement());
        }
        if (t.getIsMultipleInstance() instanceof BindableProxy) {
          clone.setIsMultipleInstance((IsMultipleInstance) ((BindableProxy) getIsMultipleInstance()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsMultipleInstance())) {
          clone.setIsMultipleInstance((IsMultipleInstance) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsMultipleInstance())).deepUnwrap());
        } else {
          clone.setIsMultipleInstance(t.getIsMultipleInstance());
        }
        if (t.getMultipleInstanceCompletionCondition() instanceof BindableProxy) {
          clone.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) ((BindableProxy) getMultipleInstanceCompletionCondition()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCompletionCondition())) {
          clone.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCompletionCondition())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCompletionCondition(t.getMultipleInstanceCompletionCondition());
        }
        if (t.getOnExitAction() instanceof BindableProxy) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) getOnExitAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnExitAction())) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnExitAction())).deepUnwrap());
        } else {
          clone.setOnExitAction(t.getOnExitAction());
        }
        if (t.getMultipleInstanceExecutionMode() instanceof BindableProxy) {
          clone.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) ((BindableProxy) getMultipleInstanceExecutionMode()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceExecutionMode())) {
          clone.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceExecutionMode())).deepUnwrap());
        } else {
          clone.setMultipleInstanceExecutionMode(t.getMultipleInstanceExecutionMode());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public AbortParent getAbortParent() {
        return target.getAbortParent();
      }

      public void setAbortParent(AbortParent abortParent) {
        if (agent.binders.containsKey("abortParent")) {
          abortParent = (AbortParent) agent.binders.get("abortParent").setModel(abortParent, StateSync.FROM_MODEL, true);
        }
        changeAndFire("abortParent", abortParent);
      }

      public Independent getIndependent() {
        return target.getIndependent();
      }

      public void setIndependent(Independent independent) {
        if (agent.binders.containsKey("independent")) {
          independent = (Independent) agent.binders.get("independent").setModel(independent, StateSync.FROM_MODEL, true);
        }
        changeAndFire("independent", independent);
      }

      public IsAsync getIsAsync() {
        return target.getIsAsync();
      }

      public void setIsAsync(IsAsync isAsync) {
        if (agent.binders.containsKey("isAsync")) {
          isAsync = (IsAsync) agent.binders.get("isAsync").setModel(isAsync, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isAsync", isAsync);
      }

      public MultipleInstanceDataOutput getMultipleInstanceDataOutput() {
        return target.getMultipleInstanceDataOutput();
      }

      public void setMultipleInstanceDataOutput(MultipleInstanceDataOutput multipleInstanceDataOutput) {
        if (agent.binders.containsKey("multipleInstanceDataOutput")) {
          multipleInstanceDataOutput = (MultipleInstanceDataOutput) agent.binders.get("multipleInstanceDataOutput").setModel(multipleInstanceDataOutput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceDataOutput", multipleInstanceDataOutput);
      }

      public WaitForCompletion getWaitForCompletion() {
        return target.getWaitForCompletion();
      }

      public void setWaitForCompletion(WaitForCompletion waitForCompletion) {
        if (agent.binders.containsKey("waitForCompletion")) {
          waitForCompletion = (WaitForCompletion) agent.binders.get("waitForCompletion").setModel(waitForCompletion, StateSync.FROM_MODEL, true);
        }
        changeAndFire("waitForCompletion", waitForCompletion);
      }

      public OnEntryAction getOnEntryAction() {
        return target.getOnEntryAction();
      }

      public void setOnEntryAction(OnEntryAction onEntryAction) {
        if (agent.binders.containsKey("onEntryAction")) {
          onEntryAction = (OnEntryAction) agent.binders.get("onEntryAction").setModel(onEntryAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onEntryAction", onEntryAction);
      }

      public MultipleInstanceCollectionInput getMultipleInstanceCollectionInput() {
        return target.getMultipleInstanceCollectionInput();
      }

      public void setMultipleInstanceCollectionInput(MultipleInstanceCollectionInput multipleInstanceCollectionInput) {
        if (agent.binders.containsKey("multipleInstanceCollectionInput")) {
          multipleInstanceCollectionInput = (MultipleInstanceCollectionInput) agent.binders.get("multipleInstanceCollectionInput").setModel(multipleInstanceCollectionInput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCollectionInput", multipleInstanceCollectionInput);
      }

      public MultipleInstanceCollectionOutput getMultipleInstanceCollectionOutput() {
        return target.getMultipleInstanceCollectionOutput();
      }

      public void setMultipleInstanceCollectionOutput(MultipleInstanceCollectionOutput multipleInstanceCollectionOutput) {
        if (agent.binders.containsKey("multipleInstanceCollectionOutput")) {
          multipleInstanceCollectionOutput = (MultipleInstanceCollectionOutput) agent.binders.get("multipleInstanceCollectionOutput").setModel(multipleInstanceCollectionOutput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCollectionOutput", multipleInstanceCollectionOutput);
      }

      public MultipleInstanceDataInput getMultipleInstanceDataInput() {
        return target.getMultipleInstanceDataInput();
      }

      public void setMultipleInstanceDataInput(MultipleInstanceDataInput multipleInstanceDataInput) {
        if (agent.binders.containsKey("multipleInstanceDataInput")) {
          multipleInstanceDataInput = (MultipleInstanceDataInput) agent.binders.get("multipleInstanceDataInput").setModel(multipleInstanceDataInput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceDataInput", multipleInstanceDataInput);
      }

      public AdHocAutostart getAdHocAutostart() {
        return target.getAdHocAutostart();
      }

      public void setAdHocAutostart(AdHocAutostart adHocAutostart) {
        if (agent.binders.containsKey("adHocAutostart")) {
          adHocAutostart = (AdHocAutostart) agent.binders.get("adHocAutostart").setModel(adHocAutostart, StateSync.FROM_MODEL, true);
        }
        changeAndFire("adHocAutostart", adHocAutostart);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public IsCase getIsCase() {
        return target.getIsCase();
      }

      public void setIsCase(IsCase isCase) {
        if (agent.binders.containsKey("isCase")) {
          isCase = (IsCase) agent.binders.get("isCase").setModel(isCase, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isCase", isCase);
      }

      public CalledElement getCalledElement() {
        return target.getCalledElement();
      }

      public void setCalledElement(CalledElement calledElement) {
        if (agent.binders.containsKey("calledElement")) {
          calledElement = (CalledElement) agent.binders.get("calledElement").setModel(calledElement, StateSync.FROM_MODEL, true);
        }
        changeAndFire("calledElement", calledElement);
      }

      public IsMultipleInstance getIsMultipleInstance() {
        return target.getIsMultipleInstance();
      }

      public void setIsMultipleInstance(IsMultipleInstance isMultipleInstance) {
        if (agent.binders.containsKey("isMultipleInstance")) {
          isMultipleInstance = (IsMultipleInstance) agent.binders.get("isMultipleInstance").setModel(isMultipleInstance, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isMultipleInstance", isMultipleInstance);
      }

      public MultipleInstanceCompletionCondition getMultipleInstanceCompletionCondition() {
        return target.getMultipleInstanceCompletionCondition();
      }

      public void setMultipleInstanceCompletionCondition(MultipleInstanceCompletionCondition multipleInstanceCompletionCondition) {
        if (agent.binders.containsKey("multipleInstanceCompletionCondition")) {
          multipleInstanceCompletionCondition = (MultipleInstanceCompletionCondition) agent.binders.get("multipleInstanceCompletionCondition").setModel(multipleInstanceCompletionCondition, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCompletionCondition", multipleInstanceCompletionCondition);
      }

      public OnExitAction getOnExitAction() {
        return target.getOnExitAction();
      }

      public void setOnExitAction(OnExitAction onExitAction) {
        if (agent.binders.containsKey("onExitAction")) {
          onExitAction = (OnExitAction) agent.binders.get("onExitAction").setModel(onExitAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onExitAction", onExitAction);
      }

      public MultipleInstanceExecutionMode getMultipleInstanceExecutionMode() {
        return target.getMultipleInstanceExecutionMode();
      }

      public void setMultipleInstanceExecutionMode(MultipleInstanceExecutionMode multipleInstanceExecutionMode) {
        if (agent.binders.containsKey("multipleInstanceExecutionMode")) {
          multipleInstanceExecutionMode = (MultipleInstanceExecutionMode) agent.binders.get("multipleInstanceExecutionMode").setModel(multipleInstanceExecutionMode, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceExecutionMode", multipleInstanceExecutionMode);
      }

      public Object get(String property) {
        switch (property) {
          case "abortParent": return getAbortParent();
          case "independent": return getIndependent();
          case "isAsync": return getIsAsync();
          case "multipleInstanceDataOutput": return getMultipleInstanceDataOutput();
          case "waitForCompletion": return getWaitForCompletion();
          case "onEntryAction": return getOnEntryAction();
          case "multipleInstanceCollectionInput": return getMultipleInstanceCollectionInput();
          case "multipleInstanceCollectionOutput": return getMultipleInstanceCollectionOutput();
          case "multipleInstanceDataInput": return getMultipleInstanceDataInput();
          case "adHocAutostart": return getAdHocAutostart();
          case "slaDueDate": return getSlaDueDate();
          case "isCase": return getIsCase();
          case "calledElement": return getCalledElement();
          case "isMultipleInstance": return getIsMultipleInstance();
          case "multipleInstanceCompletionCondition": return getMultipleInstanceCompletionCondition();
          case "onExitAction": return getOnExitAction();
          case "multipleInstanceExecutionMode": return getMultipleInstanceExecutionMode();
          case "this": return target;
          default: throw new NonExistingPropertyException("ReusableSubprocessTaskExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "abortParent": target.setAbortParent((AbortParent) value);
          break;
          case "independent": target.setIndependent((Independent) value);
          break;
          case "isAsync": target.setIsAsync((IsAsync) value);
          break;
          case "multipleInstanceDataOutput": target.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) value);
          break;
          case "waitForCompletion": target.setWaitForCompletion((WaitForCompletion) value);
          break;
          case "onEntryAction": target.setOnEntryAction((OnEntryAction) value);
          break;
          case "multipleInstanceCollectionInput": target.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) value);
          break;
          case "multipleInstanceCollectionOutput": target.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) value);
          break;
          case "multipleInstanceDataInput": target.setMultipleInstanceDataInput((MultipleInstanceDataInput) value);
          break;
          case "adHocAutostart": target.setAdHocAutostart((AdHocAutostart) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "isCase": target.setIsCase((IsCase) value);
          break;
          case "calledElement": target.setCalledElement((CalledElement) value);
          break;
          case "isMultipleInstance": target.setIsMultipleInstance((IsMultipleInstance) value);
          break;
          case "multipleInstanceCompletionCondition": target.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) value);
          break;
          case "onExitAction": target.setOnExitAction((OnExitAction) value);
          break;
          case "multipleInstanceExecutionMode": target.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) value);
          break;
          case "this": target = (ReusableSubprocessTaskExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ReusableSubprocessTaskExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ReusableSubprocessTaskExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy((ReusableSubprocessTaskExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ReusableSubprocessTaskExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy extends InclusiveGateway implements BindableProxy {
      private BindableProxyAgent<InclusiveGateway> agent;
      private InclusiveGateway target;
      public org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy() {
        this(new InclusiveGateway());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy(InclusiveGateway targetVal) {
        agent = new BindableProxyAgent<InclusiveGateway>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(GatewayExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(InclusiveGateway.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public InclusiveGateway unwrap() {
        return target;
      }

      public InclusiveGateway deepUnwrap() {
        final InclusiveGateway clone = new InclusiveGateway();
        final InclusiveGateway t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((GatewayExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((GatewayExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public GatewayExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(GatewayExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (GatewayExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("InclusiveGateway", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((GatewayExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (InclusiveGateway) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("InclusiveGateway", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(InclusiveGateway.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy((InclusiveGateway) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_InclusiveGatewayProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy extends ReassignmentRow implements BindableProxy {
      private BindableProxyAgent<ReassignmentRow> agent;
      private ReassignmentRow target;
      public org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy() {
        this(new ReassignmentRow());
      }

      public org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy(ReassignmentRow targetVal) {
        agent = new BindableProxyAgent<ReassignmentRow>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("duration", new PropertyType(String.class, false, false));
        p.put("groups", new PropertyType(List.class, false, true));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("type", new PropertyType(ReassignmentType.class, false, false));
        p.put("users", new PropertyType(List.class, false, true));
        p.put("this", new PropertyType(ReassignmentRow.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ReassignmentRow unwrap() {
        return target;
      }

      public ReassignmentRow deepUnwrap() {
        final ReassignmentRow clone = new ReassignmentRow();
        final ReassignmentRow t = unwrap();
        clone.setDuration(t.getDuration());
        if (t.getGroups() != null) {
          final List groupsClone = new ArrayList();
          for (Object groupsElem : t.getGroups()) {
            if (groupsElem instanceof BindableProxy) {
              groupsClone.add(((BindableProxy) groupsElem).deepUnwrap());
            } else {
              groupsClone.add(groupsElem);
            }
          }
          clone.setGroups(groupsClone);
        }
        clone.setId(t.getId());
        clone.setType(t.getType());
        if (t.getUsers() != null) {
          final List usersClone = new ArrayList();
          for (Object usersElem : t.getUsers()) {
            if (usersElem instanceof BindableProxy) {
              usersClone.add(((BindableProxy) usersElem).deepUnwrap());
            } else {
              usersClone.add(usersElem);
            }
          }
          clone.setUsers(usersClone);
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getDuration() {
        return target.getDuration();
      }

      public void setDuration(String duration) {
        changeAndFire("duration", duration);
      }

      public List getGroups() {
        return target.getGroups();
      }

      public void setGroups(List<String> groups) {
        List<String> oldValue = target.getGroups();
        groups = agent.ensureBoundListIsProxied("groups", groups);
        target.setGroups(groups);
        agent.updateWidgetsAndFireEvent(true, "groups", oldValue, groups);
      }

      public long getId() {
        return target.getId();
      }

      public void setId(long id) {
        changeAndFire("id", id);
      }

      public ReassignmentType getType() {
        return target.getType();
      }

      public void setType(ReassignmentType type) {
        changeAndFire("type", type);
      }

      public List getUsers() {
        return target.getUsers();
      }

      public void setUsers(List<String> users) {
        List<String> oldValue = target.getUsers();
        users = agent.ensureBoundListIsProxied("users", users);
        target.setUsers(users);
        agent.updateWidgetsAndFireEvent(true, "users", oldValue, users);
      }

      public Object get(String property) {
        switch (property) {
          case "duration": return getDuration();
          case "groups": return getGroups();
          case "id": return getId();
          case "type": return getType();
          case "users": return getUsers();
          case "this": return target;
          default: throw new NonExistingPropertyException("ReassignmentRow", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "duration": target.setDuration((String) value);
          break;
          case "groups": target.setGroups((List<String>) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "type": target.setType((ReassignmentType) value);
          break;
          case "users": target.setUsers((List<String>) value);
          break;
          case "this": target = (ReassignmentRow) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ReassignmentRow", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public ReassignmentRow clone() {
        final ReassignmentRow returnValue = target.clone();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public ReassignmentValue toReassignmentValue() {
        final ReassignmentValue returnValue = target.toReassignmentValue();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(ReassignmentRow.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy((ReassignmentRow) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_ReassignmentRowProxy();
      }
    });
    class org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy extends NodeInstanceSummary implements BindableProxy {
      private BindableProxyAgent<NodeInstanceSummary> agent;
      private NodeInstanceSummary target;
      public org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy() {
        this(new NodeInstanceSummary());
      }

      public org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy(NodeInstanceSummary targetVal) {
        agent = new BindableProxyAgent<NodeInstanceSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("nodeUniqueName", new PropertyType(String.class, false, false));
        p.put("description", new PropertyType(String.class, false, false));
        p.put("callbacks", new PropertyType(List.class, false, true));
        p.put("completed", new PropertyType(Boolean.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("type", new PropertyType(String.class, false, false));
        p.put("referenceId", new PropertyType(Long.class, false, false));
        p.put("processId", new PropertyType(Long.class, false, false));
        p.put("slaCompliance", new PropertyType(Integer.class, false, false));
        p.put("slaDueDate", new PropertyType(Date.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("connection", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("timestamp", new PropertyType(Date.class, false, false));
        p.put("this", new PropertyType(NodeInstanceSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public NodeInstanceSummary unwrap() {
        return target;
      }

      public NodeInstanceSummary deepUnwrap() {
        final NodeInstanceSummary clone = new NodeInstanceSummary();
        final NodeInstanceSummary t = unwrap();
        clone.setNodeUniqueName(t.getNodeUniqueName());
        clone.setDescription(t.getDescription());
        if (t.getCallbacks() != null) {
          final List callbacksClone = new ArrayList();
          for (Object callbacksElem : t.getCallbacks()) {
            if (callbacksElem instanceof BindableProxy) {
              callbacksClone.add(((BindableProxy) callbacksElem).deepUnwrap());
            } else {
              callbacksClone.add(callbacksElem);
            }
          }
          clone.setCallbacks(callbacksClone);
        }
        clone.setCompleted(t.isCompleted());
        clone.setType(t.getType());
        clone.setReferenceId(t.getReferenceId());
        clone.setProcessId(t.getProcessId());
        clone.setSlaCompliance(t.getSlaCompliance());
        clone.setSlaDueDate(t.getSlaDueDate());
        clone.setName(t.getName());
        clone.setConnection(t.getConnection());
        clone.setId(t.getId());
        clone.setTimestamp(t.getTimestamp());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy) {
          obj = ((org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getNodeUniqueName() {
        return target.getNodeUniqueName();
      }

      public void setNodeUniqueName(String nodeUniqueName) {
        changeAndFire("nodeUniqueName", nodeUniqueName);
      }

      public String getDescription() {
        return target.getDescription();
      }

      public void setDescription(String description) {
        changeAndFire("description", description);
      }

      public List getCallbacks() {
        return target.getCallbacks();
      }

      public void setCallbacks(List<LabeledCommand> callbacks) {
        List<LabeledCommand> oldValue = target.getCallbacks();
        callbacks = agent.ensureBoundListIsProxied("callbacks", callbacks);
        target.setCallbacks(callbacks);
        agent.updateWidgetsAndFireEvent(true, "callbacks", oldValue, callbacks);
      }

      public Boolean isCompleted() {
        return target.isCompleted();
      }

      public void setCompleted(Boolean completed) {
        changeAndFire("completed", completed);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public String getType() {
        return target.getType();
      }

      public void setType(String type) {
        changeAndFire("type", type);
      }

      public Long getReferenceId() {
        return target.getReferenceId();
      }

      public void setReferenceId(Long referenceId) {
        changeAndFire("referenceId", referenceId);
      }

      public Long getProcessId() {
        return target.getProcessId();
      }

      public void setProcessId(Long processId) {
        changeAndFire("processId", processId);
      }

      public Integer getSlaCompliance() {
        return target.getSlaCompliance();
      }

      public void setSlaCompliance(Integer slaCompliance) {
        changeAndFire("slaCompliance", slaCompliance);
      }

      public Date getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(Date slaDueDate) {
        changeAndFire("slaDueDate", slaDueDate);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getConnection() {
        return target.getConnection();
      }

      public void setConnection(String connection) {
        changeAndFire("connection", connection);
      }

      public Long getId() {
        return target.getId();
      }

      public void setId(Long id) {
        changeAndFire("id", id);
      }

      public Date getTimestamp() {
        return target.getTimestamp();
      }

      public void setTimestamp(Date timestamp) {
        changeAndFire("timestamp", timestamp);
      }

      public Object get(String property) {
        switch (property) {
          case "nodeUniqueName": return getNodeUniqueName();
          case "description": return getDescription();
          case "callbacks": return getCallbacks();
          case "completed": return isCompleted();
          case "label": return getLabel();
          case "type": return getType();
          case "referenceId": return getReferenceId();
          case "processId": return getProcessId();
          case "slaCompliance": return getSlaCompliance();
          case "slaDueDate": return getSlaDueDate();
          case "name": return getName();
          case "connection": return getConnection();
          case "id": return getId();
          case "timestamp": return getTimestamp();
          case "this": return target;
          default: throw new NonExistingPropertyException("NodeInstanceSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "nodeUniqueName": target.setNodeUniqueName((String) value);
          break;
          case "description": target.setDescription((String) value);
          break;
          case "callbacks": target.setCallbacks((List<LabeledCommand>) value);
          break;
          case "completed": target.setCompleted((Boolean) value);
          break;
          case "type": target.setType((String) value);
          break;
          case "referenceId": target.setReferenceId((Long) value);
          break;
          case "processId": target.setProcessId((Long) value);
          break;
          case "slaCompliance": target.setSlaCompliance((Integer) value);
          break;
          case "slaDueDate": target.setSlaDueDate((Date) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "connection": target.setConnection((String) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "timestamp": target.setTimestamp((Date) value);
          break;
          case "this": target = (NodeInstanceSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("NodeInstanceSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasCallbacks() {
        final boolean returnValue = target.hasCallbacks();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void addCallback(String a0, Command a1) {
        target.addCallback(a0, a1);
        agent.updateWidgetsAndFireEvents();
      }

      public int compareTo(AbstractPageRow a0) {
        final int returnValue = target.compareTo(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(NodeInstanceSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy((NodeInstanceSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_pr_model_NodeInstanceSummaryProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy extends DecimalMultipleInputFieldDefinition implements BindableProxy {
      private BindableProxyAgent<DecimalMultipleInputFieldDefinition> agent;
      private DecimalMultipleInputFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy() {
        this(new DecimalMultipleInputFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy(DecimalMultipleInputFieldDefinition targetVal) {
        agent = new BindableProxyAgent<DecimalMultipleInputFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("pageSize", new PropertyType(Integer.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(FieldType.class, false, false));
        p.put("this", new PropertyType(DecimalMultipleInputFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DecimalMultipleInputFieldDefinition unwrap() {
        return target;
      }

      public DecimalMultipleInputFieldDefinition deepUnwrap() {
        final DecimalMultipleInputFieldDefinition clone = new DecimalMultipleInputFieldDefinition();
        final DecimalMultipleInputFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setPageSize(t.getPageSize());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Integer getPageSize() {
        return target.getPageSize();
      }

      public void setPageSize(Integer pageSize) {
        changeAndFire("pageSize", pageSize);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public FieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "pageSize": return getPageSize();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("DecimalMultipleInputFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "pageSize": target.setPageSize((Integer) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (DecimalMultipleInputFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DecimalMultipleInputFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(DecimalMultipleInputFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy((DecimalMultipleInputFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_DecimalMultipleInputFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy extends EmbeddedSubprocessExecutionSet implements BindableProxy {
      private BindableProxyAgent<EmbeddedSubprocessExecutionSet> agent;
      private EmbeddedSubprocessExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy() {
        this(new EmbeddedSubprocessExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy(EmbeddedSubprocessExecutionSet targetVal) {
        agent = new BindableProxyAgent<EmbeddedSubprocessExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("isAsync", new PropertyType(IsAsync.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("onExitAction", new PropertyType(OnExitAction.class, true, false));
        p.put("onEntryAction", new PropertyType(OnEntryAction.class, true, false));
        p.put("this", new PropertyType(EmbeddedSubprocessExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EmbeddedSubprocessExecutionSet unwrap() {
        return target;
      }

      public EmbeddedSubprocessExecutionSet deepUnwrap() {
        final EmbeddedSubprocessExecutionSet clone = new EmbeddedSubprocessExecutionSet();
        final EmbeddedSubprocessExecutionSet t = unwrap();
        if (t.getIsAsync() instanceof BindableProxy) {
          clone.setIsAsync((IsAsync) ((BindableProxy) getIsAsync()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsAsync())) {
          clone.setIsAsync((IsAsync) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsAsync())).deepUnwrap());
        } else {
          clone.setIsAsync(t.getIsAsync());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getOnExitAction() instanceof BindableProxy) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) getOnExitAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnExitAction())) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnExitAction())).deepUnwrap());
        } else {
          clone.setOnExitAction(t.getOnExitAction());
        }
        if (t.getOnEntryAction() instanceof BindableProxy) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) getOnEntryAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnEntryAction())) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnEntryAction())).deepUnwrap());
        } else {
          clone.setOnEntryAction(t.getOnEntryAction());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public IsAsync getIsAsync() {
        return target.getIsAsync();
      }

      public void setIsAsync(IsAsync isAsync) {
        if (agent.binders.containsKey("isAsync")) {
          isAsync = (IsAsync) agent.binders.get("isAsync").setModel(isAsync, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isAsync", isAsync);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public OnExitAction getOnExitAction() {
        return target.getOnExitAction();
      }

      public void setOnExitAction(OnExitAction onExitAction) {
        if (agent.binders.containsKey("onExitAction")) {
          onExitAction = (OnExitAction) agent.binders.get("onExitAction").setModel(onExitAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onExitAction", onExitAction);
      }

      public OnEntryAction getOnEntryAction() {
        return target.getOnEntryAction();
      }

      public void setOnEntryAction(OnEntryAction onEntryAction) {
        if (agent.binders.containsKey("onEntryAction")) {
          onEntryAction = (OnEntryAction) agent.binders.get("onEntryAction").setModel(onEntryAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onEntryAction", onEntryAction);
      }

      public Object get(String property) {
        switch (property) {
          case "isAsync": return getIsAsync();
          case "slaDueDate": return getSlaDueDate();
          case "onExitAction": return getOnExitAction();
          case "onEntryAction": return getOnEntryAction();
          case "this": return target;
          default: throw new NonExistingPropertyException("EmbeddedSubprocessExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "isAsync": target.setIsAsync((IsAsync) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "onExitAction": target.setOnExitAction((OnExitAction) value);
          break;
          case "onEntryAction": target.setOnEntryAction((OnEntryAction) value);
          break;
          case "this": target = (EmbeddedSubprocessExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EmbeddedSubprocessExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(EmbeddedSubprocessExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy((EmbeddedSubprocessExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_subProcess_execution_EmbeddedSubprocessExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy extends StringListBoxFieldDefinition implements BindableProxy {
      private BindableProxyAgent<StringListBoxFieldDefinition> agent;
      private StringListBoxFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy() {
        this(new StringListBoxFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy(StringListBoxFieldDefinition targetVal) {
        agent = new BindableProxyAgent<StringListBoxFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("addEmptyOption", new PropertyType(Boolean.class, false, false));
        p.put("relatedField", new PropertyType(String.class, false, false));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("options", new PropertyType(List.class, false, true));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("dataProvider", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(ListBoxFieldType.class, false, false));
        p.put("this", new PropertyType(StringListBoxFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public StringListBoxFieldDefinition unwrap() {
        return target;
      }

      public StringListBoxFieldDefinition deepUnwrap() {
        final StringListBoxFieldDefinition clone = new StringListBoxFieldDefinition();
        final StringListBoxFieldDefinition t = unwrap();
        clone.setAddEmptyOption(t.getAddEmptyOption());
        clone.setRelatedField(t.getRelatedField());
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        if (t.getOptions() != null) {
          final List optionsClone = new ArrayList();
          for (Object optionsElem : t.getOptions()) {
            if (optionsElem instanceof BindableProxy) {
              optionsClone.add(((BindableProxy) optionsElem).deepUnwrap());
            } else {
              optionsClone.add(optionsElem);
            }
          }
          clone.setOptions(optionsClone);
        }
        clone.setName(t.getName());
        clone.setDataProvider(t.getDataProvider());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getAddEmptyOption() {
        return target.getAddEmptyOption();
      }

      public void setAddEmptyOption(Boolean addEmptyOption) {
        changeAndFire("addEmptyOption", addEmptyOption);
      }

      public String getRelatedField() {
        return target.getRelatedField();
      }

      public void setRelatedField(String relatedField) {
        changeAndFire("relatedField", relatedField);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(String defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public List getOptions() {
        return target.getOptions();
      }

      public void setOptions(List<StringSelectorOption> options) {
        List<StringSelectorOption> oldValue = target.getOptions();
        options = agent.ensureBoundListIsProxied("options", options);
        target.setOptions(options);
        agent.updateWidgetsAndFireEvent(true, "options", oldValue, options);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getDataProvider() {
        return target.getDataProvider();
      }

      public void setDataProvider(String dataProvider) {
        changeAndFire("dataProvider", dataProvider);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public ListBoxFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "addEmptyOption": return getAddEmptyOption();
          case "relatedField": return getRelatedField();
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "options": return getOptions();
          case "name": return getName();
          case "dataProvider": return getDataProvider();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("StringListBoxFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "addEmptyOption": target.setAddEmptyOption((Boolean) value);
          break;
          case "relatedField": target.setRelatedField((String) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "options": target.setOptions((List<StringSelectorOption>) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "dataProvider": target.setDataProvider((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (StringListBoxFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("StringListBoxFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(StringListBoxFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy((StringListBoxFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_StringListBoxFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy extends DatePickerFieldDefinition implements BindableProxy {
      private BindableProxyAgent<DatePickerFieldDefinition> agent;
      private DatePickerFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy() {
        this(new DatePickerFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy(DatePickerFieldDefinition targetVal) {
        agent = new BindableProxyAgent<DatePickerFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("showTime", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(DatePickerFieldType.class, false, false));
        p.put("placeHolder", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(DatePickerFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DatePickerFieldDefinition unwrap() {
        return target;
      }

      public DatePickerFieldDefinition deepUnwrap() {
        final DatePickerFieldDefinition clone = new DatePickerFieldDefinition();
        final DatePickerFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setShowTime(t.getShowTime());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        clone.setPlaceHolder(t.getPlaceHolder());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Boolean getShowTime() {
        return target.getShowTime();
      }

      public void setShowTime(Boolean showTime) {
        changeAndFire("showTime", showTime);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public DatePickerFieldType getFieldType() {
        return target.getFieldType();
      }

      public String getPlaceHolder() {
        return target.getPlaceHolder();
      }

      public void setPlaceHolder(String placeHolder) {
        changeAndFire("placeHolder", placeHolder);
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "showTime": return getShowTime();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "placeHolder": return getPlaceHolder();
          case "this": return target;
          default: throw new NonExistingPropertyException("DatePickerFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "showTime": target.setShowTime((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "placeHolder": target.setPlaceHolder((String) value);
          break;
          case "this": target = (DatePickerFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DatePickerFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(DatePickerFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy((DatePickerFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_datePicker_definition_DatePickerFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy extends IntegerMultipleInputFieldDefinition implements BindableProxy {
      private BindableProxyAgent<IntegerMultipleInputFieldDefinition> agent;
      private IntegerMultipleInputFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy() {
        this(new IntegerMultipleInputFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy(IntegerMultipleInputFieldDefinition targetVal) {
        agent = new BindableProxyAgent<IntegerMultipleInputFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("pageSize", new PropertyType(Integer.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(FieldType.class, false, false));
        p.put("this", new PropertyType(IntegerMultipleInputFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IntegerMultipleInputFieldDefinition unwrap() {
        return target;
      }

      public IntegerMultipleInputFieldDefinition deepUnwrap() {
        final IntegerMultipleInputFieldDefinition clone = new IntegerMultipleInputFieldDefinition();
        final IntegerMultipleInputFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setPageSize(t.getPageSize());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Integer getPageSize() {
        return target.getPageSize();
      }

      public void setPageSize(Integer pageSize) {
        changeAndFire("pageSize", pageSize);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public FieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "pageSize": return getPageSize();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("IntegerMultipleInputFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "pageSize": target.setPageSize((Integer) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (IntegerMultipleInputFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IntegerMultipleInputFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(IntegerMultipleInputFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy((IntegerMultipleInputFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_IntegerMultipleInputFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy extends ReassignmentsInfo implements BindableProxy {
      private BindableProxyAgent<ReassignmentsInfo> agent;
      private ReassignmentsInfo target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy() {
        this(new ReassignmentsInfo());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy(ReassignmentsInfo targetVal) {
        agent = new BindableProxyAgent<ReassignmentsInfo>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(ReassignmentTypeListValue.class, true, false));
        p.put("this", new PropertyType(ReassignmentsInfo.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ReassignmentsInfo unwrap() {
        return target;
      }

      public ReassignmentsInfo deepUnwrap() {
        final ReassignmentsInfo clone = new ReassignmentsInfo();
        final ReassignmentsInfo t = unwrap();
        if (t.getValue() instanceof BindableProxy) {
          clone.setValue((ReassignmentTypeListValue) ((BindableProxy) getValue()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getValue())) {
          clone.setValue((ReassignmentTypeListValue) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getValue())).deepUnwrap());
        } else {
          clone.setValue(t.getValue());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public ReassignmentTypeListValue getValue() {
        return target.getValue();
      }

      public void setValue(ReassignmentTypeListValue value) {
        if (agent.binders.containsKey("value")) {
          value = (ReassignmentTypeListValue) agent.binders.get("value").setModel(value, StateSync.FROM_MODEL, true);
        }
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("ReassignmentsInfo", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((ReassignmentTypeListValue) value);
          break;
          case "this": target = (ReassignmentsInfo) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ReassignmentsInfo", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ReassignmentsInfo.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy((ReassignmentsInfo) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_reassignment_ReassignmentsInfoProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy extends EndCompensationEvent implements BindableProxy {
      private BindableProxyAgent<EndCompensationEvent> agent;
      private EndCompensationEvent target;
      public org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy() {
        this(new EndCompensationEvent());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy(EndCompensationEvent targetVal) {
        agent = new BindableProxyAgent<EndCompensationEvent>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(CompensationEventExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(EndCompensationEvent.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EndCompensationEvent unwrap() {
        return target;
      }

      public EndCompensationEvent deepUnwrap() {
        final EndCompensationEvent clone = new EndCompensationEvent();
        final EndCompensationEvent t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((CompensationEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((CompensationEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public CompensationEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(CompensationEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (CompensationEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("EndCompensationEvent", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((CompensationEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (EndCompensationEvent) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EndCompensationEvent", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(EndCompensationEvent.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy((EndCompensationEvent) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_EndCompensationEventProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy extends ScriptTypeListFieldDefinition implements BindableProxy {
      private BindableProxyAgent<ScriptTypeListFieldDefinition> agent;
      private ScriptTypeListFieldDefinition target;
      public org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy() {
        this(new ScriptTypeListFieldDefinition());
      }

      public org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy(ScriptTypeListFieldDefinition targetVal) {
        agent = new BindableProxyAgent<ScriptTypeListFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("mode", new PropertyType(ScriptTypeMode.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(ScriptTypeListFieldType.class, false, false));
        p.put("this", new PropertyType(ScriptTypeListFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ScriptTypeListFieldDefinition unwrap() {
        return target;
      }

      public ScriptTypeListFieldDefinition deepUnwrap() {
        final ScriptTypeListFieldDefinition clone = new ScriptTypeListFieldDefinition();
        final ScriptTypeListFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setMode(t.getMode());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public ScriptTypeMode getMode() {
        return target.getMode();
      }

      public void setMode(ScriptTypeMode mode) {
        changeAndFire("mode", mode);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public ScriptTypeListFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "mode": return getMode();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("ScriptTypeListFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "mode": target.setMode((ScriptTypeMode) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (ScriptTypeListFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ScriptTypeListFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(ScriptTypeListFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy((ScriptTypeListFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_ScriptTypeListFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy extends CharacterListBoxFieldDefinition implements BindableProxy {
      private BindableProxyAgent<CharacterListBoxFieldDefinition> agent;
      private CharacterListBoxFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy() {
        this(new CharacterListBoxFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy(CharacterListBoxFieldDefinition targetVal) {
        agent = new BindableProxyAgent<CharacterListBoxFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("addEmptyOption", new PropertyType(Boolean.class, false, false));
        p.put("relatedField", new PropertyType(String.class, false, false));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(Character.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("options", new PropertyType(List.class, false, true));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("dataProvider", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(ListBoxFieldType.class, false, false));
        p.put("this", new PropertyType(CharacterListBoxFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CharacterListBoxFieldDefinition unwrap() {
        return target;
      }

      public CharacterListBoxFieldDefinition deepUnwrap() {
        final CharacterListBoxFieldDefinition clone = new CharacterListBoxFieldDefinition();
        final CharacterListBoxFieldDefinition t = unwrap();
        clone.setAddEmptyOption(t.getAddEmptyOption());
        clone.setRelatedField(t.getRelatedField());
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        if (t.getOptions() != null) {
          final List optionsClone = new ArrayList();
          for (Object optionsElem : t.getOptions()) {
            if (optionsElem instanceof BindableProxy) {
              optionsClone.add(((BindableProxy) optionsElem).deepUnwrap());
            } else {
              optionsClone.add(optionsElem);
            }
          }
          clone.setOptions(optionsClone);
        }
        clone.setName(t.getName());
        clone.setDataProvider(t.getDataProvider());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getAddEmptyOption() {
        return target.getAddEmptyOption();
      }

      public void setAddEmptyOption(Boolean addEmptyOption) {
        changeAndFire("addEmptyOption", addEmptyOption);
      }

      public String getRelatedField() {
        return target.getRelatedField();
      }

      public void setRelatedField(String relatedField) {
        changeAndFire("relatedField", relatedField);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Character getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(Character defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public List getOptions() {
        return target.getOptions();
      }

      public void setOptions(List<CharacterSelectorOption> options) {
        List<CharacterSelectorOption> oldValue = target.getOptions();
        options = agent.ensureBoundListIsProxied("options", options);
        target.setOptions(options);
        agent.updateWidgetsAndFireEvent(true, "options", oldValue, options);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getDataProvider() {
        return target.getDataProvider();
      }

      public void setDataProvider(String dataProvider) {
        changeAndFire("dataProvider", dataProvider);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public ListBoxFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "addEmptyOption": return getAddEmptyOption();
          case "relatedField": return getRelatedField();
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "options": return getOptions();
          case "name": return getName();
          case "dataProvider": return getDataProvider();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("CharacterListBoxFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "addEmptyOption": target.setAddEmptyOption((Boolean) value);
          break;
          case "relatedField": target.setRelatedField((String) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((Character) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "options": target.setOptions((List<CharacterSelectorOption>) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "dataProvider": target.setDataProvider((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (CharacterListBoxFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CharacterListBoxFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(CharacterListBoxFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy((CharacterListBoxFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_listBox_definition_CharacterListBoxFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy extends Radius implements BindableProxy {
      private BindableProxyAgent<Radius> agent;
      private Radius target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy() {
        this(new Radius());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy(Radius targetVal) {
        agent = new BindableProxyAgent<Radius>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(Radius.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Radius unwrap() {
        return target;
      }

      public Radius deepUnwrap() {
        final Radius clone = new Radius();
        final Radius t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Radius", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (Radius) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Radius", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(Radius.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy((Radius) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RadiusProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy extends IsMultipleInstance implements BindableProxy {
      private BindableProxyAgent<IsMultipleInstance> agent;
      private IsMultipleInstance target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy() {
        this(new IsMultipleInstance());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy(IsMultipleInstance targetVal) {
        agent = new BindableProxyAgent<IsMultipleInstance>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Boolean.class, false, false));
        p.put("this", new PropertyType(IsMultipleInstance.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IsMultipleInstance unwrap() {
        return target;
      }

      public IsMultipleInstance deepUnwrap() {
        final IsMultipleInstance clone = new IsMultipleInstance();
        final IsMultipleInstance t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValue() {
        return target.getValue();
      }

      public void setValue(Boolean value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("IsMultipleInstance", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Boolean) value);
          break;
          case "this": target = (IsMultipleInstance) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IsMultipleInstance", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(IsMultipleInstance.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy((IsMultipleInstance) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_IsMultipleInstanceProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy extends NonDirectionalAssociation implements BindableProxy {
      private BindableProxyAgent<NonDirectionalAssociation> agent;
      private NonDirectionalAssociation target;
      public org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy() {
        this(new NonDirectionalAssociation());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy(NonDirectionalAssociation targetVal) {
        agent = new BindableProxyAgent<NonDirectionalAssociation>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(NonDirectionalAssociation.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public NonDirectionalAssociation unwrap() {
        return target;
      }

      public NonDirectionalAssociation deepUnwrap() {
        final NonDirectionalAssociation clone = new NonDirectionalAssociation();
        final NonDirectionalAssociation t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "backgroundSet": return getBackgroundSet();
          case "fontSet": return getFontSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("NonDirectionalAssociation", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "this": target = (NonDirectionalAssociation) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("NonDirectionalAssociation", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(NonDirectionalAssociation.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy((NonDirectionalAssociation) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_NonDirectionalAssociationProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy extends EventGateway implements BindableProxy {
      private BindableProxyAgent<EventGateway> agent;
      private EventGateway target;
      public org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy() {
        this(new EventGateway());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy(EventGateway targetVal) {
        agent = new BindableProxyAgent<EventGateway>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(EventGateway.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EventGateway unwrap() {
        return target;
      }

      public EventGateway deepUnwrap() {
        final EventGateway clone = new EventGateway();
        final EventGateway t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "backgroundSet": return getBackgroundSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("EventGateway", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (EventGateway) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EventGateway", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(EventGateway.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy((EventGateway) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_EventGatewayProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy extends RuleLanguage implements BindableProxy {
      private BindableProxyAgent<RuleLanguage> agent;
      private RuleLanguage target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy() {
        this(new RuleLanguage());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy(RuleLanguage targetVal) {
        agent = new BindableProxyAgent<RuleLanguage>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(RuleLanguage.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public RuleLanguage unwrap() {
        return target;
      }

      public RuleLanguage deepUnwrap() {
        final RuleLanguage clone = new RuleLanguage();
        final RuleLanguage t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("RuleLanguage", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (RuleLanguage) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("RuleLanguage", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(RuleLanguage.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy((RuleLanguage) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_RuleLanguageProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy extends BPMNDefinitionSet implements BindableProxy {
      private BindableProxyAgent<BPMNDefinitionSet> agent;
      private BPMNDefinitionSet target;
      public org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy() {
        this(new BPMNDefinitionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy(BPMNDefinitionSet targetVal) {
        agent = new BindableProxyAgent<BPMNDefinitionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("this", new PropertyType(BPMNDefinitionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BPMNDefinitionSet unwrap() {
        return target;
      }

      public BPMNDefinitionSet deepUnwrap() {
        final BPMNDefinitionSet clone = new BPMNDefinitionSet();
        final BPMNDefinitionSet t = unwrap();
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Object get(String property) {
        switch (property) {
          case "this": return target;
          default: throw new NonExistingPropertyException("BPMNDefinitionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "this": target = (BPMNDefinitionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BPMNDefinitionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(BPMNDefinitionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy((BPMNDefinitionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_BPMNDefinitionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy extends MultipleInstanceCompletionCondition implements BindableProxy {
      private BindableProxyAgent<MultipleInstanceCompletionCondition> agent;
      private MultipleInstanceCompletionCondition target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy() {
        this(new MultipleInstanceCompletionCondition());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy(MultipleInstanceCompletionCondition targetVal) {
        agent = new BindableProxyAgent<MultipleInstanceCompletionCondition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(MultipleInstanceCompletionCondition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public MultipleInstanceCompletionCondition unwrap() {
        return target;
      }

      public MultipleInstanceCompletionCondition deepUnwrap() {
        final MultipleInstanceCompletionCondition clone = new MultipleInstanceCompletionCondition();
        final MultipleInstanceCompletionCondition t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("MultipleInstanceCompletionCondition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (MultipleInstanceCompletionCondition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("MultipleInstanceCompletionCondition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(MultipleInstanceCompletionCondition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy((MultipleInstanceCompletionCondition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceCompletionConditionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy extends BaseSubprocessTaskExecutionSet implements BindableProxy {
      private BindableProxyAgent<BaseSubprocessTaskExecutionSet> agent;
      private BaseSubprocessTaskExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy() {
        this(new BaseSubprocessTaskExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy(BaseSubprocessTaskExecutionSet targetVal) {
        agent = new BindableProxyAgent<BaseSubprocessTaskExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("isAsync", new PropertyType(IsAsync.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("this", new PropertyType(BaseSubprocessTaskExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BaseSubprocessTaskExecutionSet unwrap() {
        return target;
      }

      public BaseSubprocessTaskExecutionSet deepUnwrap() {
        final BaseSubprocessTaskExecutionSet clone = new BaseSubprocessTaskExecutionSet();
        final BaseSubprocessTaskExecutionSet t = unwrap();
        if (t.getIsAsync() instanceof BindableProxy) {
          clone.setIsAsync((IsAsync) ((BindableProxy) getIsAsync()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsAsync())) {
          clone.setIsAsync((IsAsync) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsAsync())).deepUnwrap());
        } else {
          clone.setIsAsync(t.getIsAsync());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public IsAsync getIsAsync() {
        return target.getIsAsync();
      }

      public void setIsAsync(IsAsync isAsync) {
        if (agent.binders.containsKey("isAsync")) {
          isAsync = (IsAsync) agent.binders.get("isAsync").setModel(isAsync, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isAsync", isAsync);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public Object get(String property) {
        switch (property) {
          case "isAsync": return getIsAsync();
          case "slaDueDate": return getSlaDueDate();
          case "this": return target;
          default: throw new NonExistingPropertyException("BaseSubprocessTaskExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "isAsync": target.setIsAsync((IsAsync) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "this": target = (BaseSubprocessTaskExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BaseSubprocessTaskExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(BaseSubprocessTaskExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy((BaseSubprocessTaskExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_BaseSubprocessTaskExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy extends GenericServiceTask implements BindableProxy {
      private BindableProxyAgent<GenericServiceTask> agent;
      private GenericServiceTask target;
      public org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy() {
        this(new GenericServiceTask());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy(GenericServiceTask targetVal) {
        agent = new BindableProxyAgent<GenericServiceTask>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("general", new PropertyType(TaskGeneralSet.class, true, false));
        p.put("taskType", new PropertyType(TaskType.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(GenericServiceTaskExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("this", new PropertyType(GenericServiceTask.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public GenericServiceTask unwrap() {
        return target;
      }

      public GenericServiceTask deepUnwrap() {
        final GenericServiceTask clone = new GenericServiceTask();
        final GenericServiceTask t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((TaskGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((TaskGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getTaskType() instanceof BindableProxy) {
          clone.setTaskType((TaskType) ((BindableProxy) getTaskType()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getTaskType())) {
          clone.setTaskType((TaskType) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getTaskType())).deepUnwrap());
        } else {
          clone.setTaskType(t.getTaskType());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((GenericServiceTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((GenericServiceTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public TaskGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(TaskGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (TaskGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public TaskType getTaskType() {
        return target.getTaskType();
      }

      public void setTaskType(TaskType taskType) {
        if (agent.binders.containsKey("taskType")) {
          taskType = (TaskType) agent.binders.get("taskType").setModel(taskType, StateSync.FROM_MODEL, true);
        }
        changeAndFire("taskType", taskType);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public GenericServiceTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(GenericServiceTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (GenericServiceTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Object get(String property) {
        switch (property) {
          case "labels": return getLabels();
          case "general": return getGeneral();
          case "taskType": return getTaskType();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "this": return target;
          default: throw new NonExistingPropertyException("GenericServiceTask", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((TaskGeneralSet) value);
          break;
          case "taskType": target.setTaskType((TaskType) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((GenericServiceTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (GenericServiceTask) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("GenericServiceTask", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void setDataIOSet(DataIOSet a0) {
        target.setDataIOSet(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(GenericServiceTask.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy((GenericServiceTask) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_GenericServiceTaskProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy extends ConditionExpression implements BindableProxy {
      private BindableProxyAgent<ConditionExpression> agent;
      private ConditionExpression target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy() {
        this(new ConditionExpression());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy(ConditionExpression targetVal) {
        agent = new BindableProxyAgent<ConditionExpression>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(ScriptTypeValue.class, true, false));
        p.put("this", new PropertyType(ConditionExpression.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ConditionExpression unwrap() {
        return target;
      }

      public ConditionExpression deepUnwrap() {
        final ConditionExpression clone = new ConditionExpression();
        final ConditionExpression t = unwrap();
        if (t.getValue() instanceof BindableProxy) {
          clone.setValue((ScriptTypeValue) ((BindableProxy) getValue()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getValue())) {
          clone.setValue((ScriptTypeValue) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getValue())).deepUnwrap());
        } else {
          clone.setValue(t.getValue());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public ScriptTypeValue getValue() {
        return target.getValue();
      }

      public void setValue(ScriptTypeValue value) {
        if (agent.binders.containsKey("value")) {
          value = (ScriptTypeValue) agent.binders.get("value").setModel(value, StateSync.FROM_MODEL, true);
        }
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("ConditionExpression", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((ScriptTypeValue) value);
          break;
          case "this": target = (ConditionExpression) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ConditionExpression", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ConditionExpression.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy((ConditionExpression) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_common_ConditionExpressionProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy extends InputClauseLiteralExpression implements BindableProxy {
      private BindableProxyAgent<InputClauseLiteralExpression> agent;
      private InputClauseLiteralExpression target;
      public org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy() {
        this(new InputClauseLiteralExpression());
      }

      public org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy(InputClauseLiteralExpression targetVal) {
        agent = new BindableProxyAgent<InputClauseLiteralExpression>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("typeRefHolder", new PropertyType(QNameHolder.class, true, false));
        p.put("domainObjectUUID", new PropertyType(String.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("domainObjectNameTranslationKey", new PropertyType(String.class, false, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("description", new PropertyType(org.kie.workbench.common.dmn.api.property.dmn.Description.class, true, false));
        p.put("importedValues", new PropertyType(ImportedValues.class, true, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("hasTypeRefs", new PropertyType(List.class, false, true));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("text", new PropertyType(Text.class, true, false));
        p.put("typeRef", new PropertyType(QName.class, false, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(InputClauseLiteralExpression.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public InputClauseLiteralExpression unwrap() {
        return target;
      }

      public InputClauseLiteralExpression deepUnwrap() {
        final InputClauseLiteralExpression clone = new InputClauseLiteralExpression();
        final InputClauseLiteralExpression t = unwrap();
        clone.setParent(t.getParent());
        if (t.getTypeRefHolder() instanceof BindableProxy) {
          clone.setTypeRefHolder((QNameHolder) ((BindableProxy) getTypeRefHolder()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getTypeRefHolder())) {
          clone.setTypeRefHolder((QNameHolder) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getTypeRefHolder())).deepUnwrap());
        } else {
          clone.setTypeRefHolder(t.getTypeRefHolder());
        }
        if (t.getDescription() instanceof BindableProxy) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) getDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDescription())) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDescription())).deepUnwrap());
        } else {
          clone.setDescription(t.getDescription());
        }
        if (t.getImportedValues() instanceof BindableProxy) {
          clone.setImportedValues((ImportedValues) ((BindableProxy) getImportedValues()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getImportedValues())) {
          clone.setImportedValues((ImportedValues) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getImportedValues())).deepUnwrap());
        } else {
          clone.setImportedValues(t.getImportedValues());
        }
        if (t.getText() instanceof BindableProxy) {
          clone.setText((Text) ((BindableProxy) getText()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getText())) {
          clone.setText((Text) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getText())).deepUnwrap());
        } else {
          clone.setText(t.getText());
        }
        clone.setTypeRef(t.getTypeRef());
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public QNameHolder getTypeRefHolder() {
        return target.getTypeRefHolder();
      }

      public void setTypeRefHolder(QNameHolder typeRefHolder) {
        if (agent.binders.containsKey("typeRefHolder")) {
          typeRefHolder = (QNameHolder) agent.binders.get("typeRefHolder").setModel(typeRefHolder, StateSync.FROM_MODEL, true);
        }
        changeAndFire("typeRefHolder", typeRefHolder);
      }

      public String getDomainObjectUUID() {
        return target.getDomainObjectUUID();
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public String getDomainObjectNameTranslationKey() {
        return target.getDomainObjectNameTranslationKey();
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Description getDescription() {
        return target.getDescription();
      }

      public void setDescription(org.kie.workbench.common.dmn.api.property.dmn.Description description) {
        if (agent.binders.containsKey("description")) {
          description = (org.kie.workbench.common.dmn.api.property.dmn.Description) agent.binders.get("description").setModel(description, StateSync.FROM_MODEL, true);
        }
        changeAndFire("description", description);
      }

      public ImportedValues getImportedValues() {
        return target.getImportedValues();
      }

      public void setImportedValues(ImportedValues importedValues) {
        if (agent.binders.containsKey("importedValues")) {
          importedValues = (ImportedValues) agent.binders.get("importedValues").setModel(importedValues, StateSync.FROM_MODEL, true);
        }
        changeAndFire("importedValues", importedValues);
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public List getHasTypeRefs() {
        return target.getHasTypeRefs();
      }

      public Id getId() {
        return target.getId();
      }

      public Text getText() {
        return target.getText();
      }

      public void setText(Text text) {
        if (agent.binders.containsKey("text")) {
          text = (Text) agent.binders.get("text").setModel(text, StateSync.FROM_MODEL, true);
        }
        changeAndFire("text", text);
      }

      public QName getTypeRef() {
        return target.getTypeRef();
      }

      public void setTypeRef(QName typeRef) {
        changeAndFire("typeRef", typeRef);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "typeRefHolder": return getTypeRefHolder();
          case "domainObjectUUID": return getDomainObjectUUID();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "domainObjectNameTranslationKey": return getDomainObjectNameTranslationKey();
          case "stunnerLabels": return getStunnerLabels();
          case "description": return getDescription();
          case "importedValues": return getImportedValues();
          case "nsContext": return getNsContext();
          case "hasTypeRefs": return getHasTypeRefs();
          case "id": return getId();
          case "text": return getText();
          case "typeRef": return getTypeRef();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("InputClauseLiteralExpression", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "typeRefHolder": target.setTypeRefHolder((QNameHolder) value);
          break;
          case "description": target.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) value);
          break;
          case "importedValues": target.setImportedValues((ImportedValues) value);
          break;
          case "text": target.setText((Text) value);
          break;
          case "typeRef": target.setTypeRef((QName) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (InputClauseLiteralExpression) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("InputClauseLiteralExpression", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        final DMNModelInstrumentedBase returnValue = target.asDMNModelInstrumentedBase();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(InputClauseLiteralExpression.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy((InputClauseLiteralExpression) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy extends MultipleInstanceSubprocess implements BindableProxy {
      private BindableProxyAgent<MultipleInstanceSubprocess> agent;
      private MultipleInstanceSubprocess target;
      public org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy() {
        this(new MultipleInstanceSubprocess());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy(MultipleInstanceSubprocess targetVal) {
        agent = new BindableProxyAgent<MultipleInstanceSubprocess>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("processData", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(MultipleInstanceSubprocessTaskExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(MultipleInstanceSubprocess.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public MultipleInstanceSubprocess unwrap() {
        return target;
      }

      public MultipleInstanceSubprocess deepUnwrap() {
        final MultipleInstanceSubprocess clone = new MultipleInstanceSubprocess();
        final MultipleInstanceSubprocess t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getProcessData() instanceof BindableProxy) {
          clone.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) ((BindableProxy) getProcessData()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getProcessData())) {
          clone.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getProcessData())).deepUnwrap());
        } else {
          clone.setProcessData(t.getProcessData());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((MultipleInstanceSubprocessTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((MultipleInstanceSubprocessTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData getProcessData() {
        return target.getProcessData();
      }

      public void setProcessData(org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData processData) {
        if (agent.binders.containsKey("processData")) {
          processData = (org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) agent.binders.get("processData").setModel(processData, StateSync.FROM_MODEL, true);
        }
        changeAndFire("processData", processData);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public MultipleInstanceSubprocessTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(MultipleInstanceSubprocessTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (MultipleInstanceSubprocessTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "simulationSet": return getSimulationSet();
          case "processData": return getProcessData();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("MultipleInstanceSubprocess", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "processData": target.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((MultipleInstanceSubprocessTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (MultipleInstanceSubprocess) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("MultipleInstanceSubprocess", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(MultipleInstanceSubprocess.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy((MultipleInstanceSubprocess) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_MultipleInstanceSubprocessProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy extends InputClause implements BindableProxy {
      private BindableProxyAgent<InputClause> agent;
      private InputClause target;
      public org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy() {
        this(new InputClause());
      }

      public org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy(InputClause targetVal) {
        agent = new BindableProxyAgent<InputClause>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("domainObjectUUID", new PropertyType(String.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("extensionElements", new PropertyType(ExtensionElements.class, false, false));
        p.put("domainObjectNameTranslationKey", new PropertyType(String.class, false, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("description", new PropertyType(org.kie.workbench.common.dmn.api.property.dmn.Description.class, true, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("hasTypeRefs", new PropertyType(List.class, false, true));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("inputExpression", new PropertyType(InputClauseLiteralExpression.class, true, false));
        p.put("inputValues", new PropertyType(InputClauseUnaryTests.class, true, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(InputClause.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public InputClause unwrap() {
        return target;
      }

      public InputClause deepUnwrap() {
        final InputClause clone = new InputClause();
        final InputClause t = unwrap();
        clone.setParent(t.getParent());
        clone.setExtensionElements(t.getExtensionElements());
        if (t.getDescription() instanceof BindableProxy) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) getDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDescription())) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDescription())).deepUnwrap());
        } else {
          clone.setDescription(t.getDescription());
        }
        if (t.getId() instanceof BindableProxy) {
          clone.setId((Id) ((BindableProxy) getId()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getId())) {
          clone.setId((Id) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getId())).deepUnwrap());
        } else {
          clone.setId(t.getId());
        }
        if (t.getInputExpression() instanceof BindableProxy) {
          clone.setInputExpression((InputClauseLiteralExpression) ((BindableProxy) getInputExpression()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getInputExpression())) {
          clone.setInputExpression((InputClauseLiteralExpression) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getInputExpression())).deepUnwrap());
        } else {
          clone.setInputExpression(t.getInputExpression());
        }
        if (t.getInputValues() instanceof BindableProxy) {
          clone.setInputValues((InputClauseUnaryTests) ((BindableProxy) getInputValues()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getInputValues())) {
          clone.setInputValues((InputClauseUnaryTests) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getInputValues())).deepUnwrap());
        } else {
          clone.setInputValues(t.getInputValues());
        }
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDomainObjectUUID() {
        return target.getDomainObjectUUID();
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public ExtensionElements getExtensionElements() {
        return target.getExtensionElements();
      }

      public void setExtensionElements(ExtensionElements extensionElements) {
        changeAndFire("extensionElements", extensionElements);
      }

      public String getDomainObjectNameTranslationKey() {
        return target.getDomainObjectNameTranslationKey();
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Description getDescription() {
        return target.getDescription();
      }

      public void setDescription(org.kie.workbench.common.dmn.api.property.dmn.Description description) {
        if (agent.binders.containsKey("description")) {
          description = (org.kie.workbench.common.dmn.api.property.dmn.Description) agent.binders.get("description").setModel(description, StateSync.FROM_MODEL, true);
        }
        changeAndFire("description", description);
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public List getHasTypeRefs() {
        return target.getHasTypeRefs();
      }

      public Id getId() {
        return target.getId();
      }

      public void setId(Id id) {
        if (agent.binders.containsKey("id")) {
          id = (Id) agent.binders.get("id").setModel(id, StateSync.FROM_MODEL, true);
        }
        changeAndFire("id", id);
      }

      public InputClauseLiteralExpression getInputExpression() {
        return target.getInputExpression();
      }

      public void setInputExpression(InputClauseLiteralExpression inputExpression) {
        if (agent.binders.containsKey("inputExpression")) {
          inputExpression = (InputClauseLiteralExpression) agent.binders.get("inputExpression").setModel(inputExpression, StateSync.FROM_MODEL, true);
        }
        changeAndFire("inputExpression", inputExpression);
      }

      public InputClauseUnaryTests getInputValues() {
        return target.getInputValues();
      }

      public void setInputValues(InputClauseUnaryTests inputValues) {
        if (agent.binders.containsKey("inputValues")) {
          inputValues = (InputClauseUnaryTests) agent.binders.get("inputValues").setModel(inputValues, StateSync.FROM_MODEL, true);
        }
        changeAndFire("inputValues", inputValues);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "domainObjectUUID": return getDomainObjectUUID();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "extensionElements": return getExtensionElements();
          case "domainObjectNameTranslationKey": return getDomainObjectNameTranslationKey();
          case "stunnerLabels": return getStunnerLabels();
          case "description": return getDescription();
          case "nsContext": return getNsContext();
          case "hasTypeRefs": return getHasTypeRefs();
          case "id": return getId();
          case "inputExpression": return getInputExpression();
          case "inputValues": return getInputValues();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("InputClause", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "extensionElements": target.setExtensionElements((ExtensionElements) value);
          break;
          case "description": target.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) value);
          break;
          case "id": target.setId((Id) value);
          break;
          case "inputExpression": target.setInputExpression((InputClauseLiteralExpression) value);
          break;
          case "inputValues": target.setInputValues((InputClauseUnaryTests) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (InputClause) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("InputClause", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(InputClause.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy((InputClause) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_InputClauseProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy extends TimeUnit implements BindableProxy {
      private BindableProxyAgent<TimeUnit> agent;
      private TimeUnit target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy() {
        this(new TimeUnit());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy(TimeUnit targetVal) {
        agent = new BindableProxyAgent<TimeUnit>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(TimeUnit.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public TimeUnit unwrap() {
        return target;
      }

      public TimeUnit deepUnwrap() {
        final TimeUnit clone = new TimeUnit();
        final TimeUnit t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("TimeUnit", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (TimeUnit) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("TimeUnit", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(TimeUnit.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy((TimeUnit) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_TimeUnitProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy extends IntermediateEscalationEvent implements BindableProxy {
      private BindableProxyAgent<IntermediateEscalationEvent> agent;
      private IntermediateEscalationEvent target;
      public org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy() {
        this(new IntermediateEscalationEvent());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy(IntermediateEscalationEvent targetVal) {
        agent = new BindableProxyAgent<IntermediateEscalationEvent>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("dataIOSet", new PropertyType(DataIOSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(CancellingEscalationEventExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(IntermediateEscalationEvent.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IntermediateEscalationEvent unwrap() {
        return target;
      }

      public IntermediateEscalationEvent deepUnwrap() {
        final IntermediateEscalationEvent clone = new IntermediateEscalationEvent();
        final IntermediateEscalationEvent t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getDataIOSet() instanceof BindableProxy) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) getDataIOSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDataIOSet())) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDataIOSet())).deepUnwrap());
        } else {
          clone.setDataIOSet(t.getDataIOSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((CancellingEscalationEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((CancellingEscalationEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public DataIOSet getDataIOSet() {
        return target.getDataIOSet();
      }

      public void setDataIOSet(DataIOSet dataIOSet) {
        if (agent.binders.containsKey("dataIOSet")) {
          dataIOSet = (DataIOSet) agent.binders.get("dataIOSet").setModel(dataIOSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dataIOSet", dataIOSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public CancellingEscalationEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(CancellingEscalationEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (CancellingEscalationEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "dataIOSet": return getDataIOSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("IntermediateEscalationEvent", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "dataIOSet": target.setDataIOSet((DataIOSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((CancellingEscalationEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (IntermediateEscalationEvent) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IntermediateEscalationEvent", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(IntermediateEscalationEvent.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy((IntermediateEscalationEvent) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_IntermediateEscalationEventProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy extends ScriptTypeValue implements BindableProxy {
      private BindableProxyAgent<ScriptTypeValue> agent;
      private ScriptTypeValue target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy() {
        this(new ScriptTypeValue());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy(ScriptTypeValue targetVal) {
        agent = new BindableProxyAgent<ScriptTypeValue>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("language", new PropertyType(String.class, false, false));
        p.put("script", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ScriptTypeValue.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ScriptTypeValue unwrap() {
        return target;
      }

      public ScriptTypeValue deepUnwrap() {
        final ScriptTypeValue clone = new ScriptTypeValue();
        final ScriptTypeValue t = unwrap();
        clone.setLanguage(t.getLanguage());
        clone.setScript(t.getScript());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getLanguage() {
        return target.getLanguage();
      }

      public void setLanguage(String language) {
        changeAndFire("language", language);
      }

      public String getScript() {
        return target.getScript();
      }

      public void setScript(String script) {
        changeAndFire("script", script);
      }

      public Object get(String property) {
        switch (property) {
          case "language": return getLanguage();
          case "script": return getScript();
          case "this": return target;
          default: throw new NonExistingPropertyException("ScriptTypeValue", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "language": target.setLanguage((String) value);
          break;
          case "script": target.setScript((String) value);
          break;
          case "this": target = (ScriptTypeValue) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ScriptTypeValue", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ScriptTypeValue.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy((ScriptTypeValue) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptTypeValueProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy extends CharacterMultipleInputFieldDefinition implements BindableProxy {
      private BindableProxyAgent<CharacterMultipleInputFieldDefinition> agent;
      private CharacterMultipleInputFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy() {
        this(new CharacterMultipleInputFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy(CharacterMultipleInputFieldDefinition targetVal) {
        agent = new BindableProxyAgent<CharacterMultipleInputFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("pageSize", new PropertyType(Integer.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(FieldType.class, false, false));
        p.put("this", new PropertyType(CharacterMultipleInputFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CharacterMultipleInputFieldDefinition unwrap() {
        return target;
      }

      public CharacterMultipleInputFieldDefinition deepUnwrap() {
        final CharacterMultipleInputFieldDefinition clone = new CharacterMultipleInputFieldDefinition();
        final CharacterMultipleInputFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setPageSize(t.getPageSize());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Integer getPageSize() {
        return target.getPageSize();
      }

      public void setPageSize(Integer pageSize) {
        changeAndFire("pageSize", pageSize);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public FieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "pageSize": return getPageSize();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("CharacterMultipleInputFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "pageSize": target.setPageSize((Integer) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (CharacterMultipleInputFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CharacterMultipleInputFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(CharacterMultipleInputFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy((CharacterMultipleInputFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_input_impl_CharacterMultipleInputFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy extends DMNDiagram implements BindableProxy {
      private BindableProxyAgent<DMNDiagram> agent;
      private DMNDiagram target;
      public org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy() {
        this(new DMNDiagram());
      }

      public org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy(DMNDiagram targetVal) {
        agent = new BindableProxyAgent<DMNDiagram>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("definitions", new PropertyType(Definitions.class, true, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(DMNDiagram.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DMNDiagram unwrap() {
        return target;
      }

      public DMNDiagram deepUnwrap() {
        final DMNDiagram clone = new DMNDiagram();
        final DMNDiagram t = unwrap();
        clone.setParent(t.getParent());
        if (t.getId() instanceof BindableProxy) {
          clone.setId((Id) ((BindableProxy) getId()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getId())) {
          clone.setId((Id) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getId())).deepUnwrap());
        } else {
          clone.setId(t.getId());
        }
        if (t.getDefinitions() instanceof BindableProxy) {
          clone.setDefinitions((Definitions) ((BindableProxy) getDefinitions()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDefinitions())) {
          clone.setDefinitions((Definitions) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDefinitions())).deepUnwrap());
        } else {
          clone.setDefinitions(t.getDefinitions());
        }
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public Id getId() {
        return target.getId();
      }

      public void setId(Id id) {
        if (agent.binders.containsKey("id")) {
          id = (Id) agent.binders.get("id").setModel(id, StateSync.FROM_MODEL, true);
        }
        changeAndFire("id", id);
      }

      public Definitions getDefinitions() {
        return target.getDefinitions();
      }

      public void setDefinitions(Definitions definitions) {
        if (agent.binders.containsKey("definitions")) {
          definitions = (Definitions) agent.binders.get("definitions").setModel(definitions, StateSync.FROM_MODEL, true);
        }
        changeAndFire("definitions", definitions);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "nsContext": return getNsContext();
          case "stunnerLabels": return getStunnerLabels();
          case "id": return getId();
          case "definitions": return getDefinitions();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("DMNDiagram", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "id": target.setId((Id) value);
          break;
          case "definitions": target.setDefinitions((Definitions) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (DMNDiagram) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DMNDiagram", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(DMNDiagram.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy((DMNDiagram) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_DMNDiagramProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy extends NoneTask implements BindableProxy {
      private BindableProxyAgent<NoneTask> agent;
      private NoneTask target;
      public org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy() {
        this(new NoneTask());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy(NoneTask targetVal) {
        agent = new BindableProxyAgent<NoneTask>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(TaskGeneralSet.class, true, false));
        p.put("taskType", new PropertyType(TaskType.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(EmptyTaskExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(NoneTask.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public NoneTask unwrap() {
        return target;
      }

      public NoneTask deepUnwrap() {
        final NoneTask clone = new NoneTask();
        final NoneTask t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((TaskGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((TaskGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getTaskType() instanceof BindableProxy) {
          clone.setTaskType((TaskType) ((BindableProxy) getTaskType()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getTaskType())) {
          clone.setTaskType((TaskType) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getTaskType())).deepUnwrap());
        } else {
          clone.setTaskType(t.getTaskType());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((EmptyTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((EmptyTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public TaskGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(TaskGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (TaskGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public TaskType getTaskType() {
        return target.getTaskType();
      }

      public void setTaskType(TaskType taskType) {
        if (agent.binders.containsKey("taskType")) {
          taskType = (TaskType) agent.binders.get("taskType").setModel(taskType, StateSync.FROM_MODEL, true);
        }
        changeAndFire("taskType", taskType);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public EmptyTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(EmptyTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (EmptyTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "taskType": return getTaskType();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("NoneTask", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((TaskGeneralSet) value);
          break;
          case "taskType": target.setTaskType((TaskType) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((EmptyTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (NoneTask) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("NoneTask", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(NoneTask.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy((NoneTask) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_NoneTaskProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy extends DiagramSet implements BindableProxy {
      private BindableProxyAgent<DiagramSet> agent;
      private DiagramSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy() {
        this(new DiagramSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy(DiagramSet targetVal) {
        agent = new BindableProxyAgent<DiagramSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("globalVariables", new PropertyType(GlobalVariables.class, true, false));
        p.put("processInstanceDescription", new PropertyType(ProcessInstanceDescription.class, true, false));
        p.put("imports", new PropertyType(Imports.class, true, false));
        p.put("packageProperty", new PropertyType(Package.class, true, false));
        p.put("documentation", new PropertyType(Documentation.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("name", new PropertyType(Name.class, true, false));
        p.put("id", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id.class, true, false));
        p.put("adHoc", new PropertyType(AdHoc.class, true, false));
        p.put("version", new PropertyType(Version.class, true, false));
        p.put("executable", new PropertyType(Executable.class, true, false));
        p.put("this", new PropertyType(DiagramSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DiagramSet unwrap() {
        return target;
      }

      public DiagramSet deepUnwrap() {
        final DiagramSet clone = new DiagramSet();
        final DiagramSet t = unwrap();
        if (t.getGlobalVariables() instanceof BindableProxy) {
          clone.setGlobalVariables((GlobalVariables) ((BindableProxy) getGlobalVariables()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGlobalVariables())) {
          clone.setGlobalVariables((GlobalVariables) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGlobalVariables())).deepUnwrap());
        } else {
          clone.setGlobalVariables(t.getGlobalVariables());
        }
        if (t.getProcessInstanceDescription() instanceof BindableProxy) {
          clone.setProcessInstanceDescription((ProcessInstanceDescription) ((BindableProxy) getProcessInstanceDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getProcessInstanceDescription())) {
          clone.setProcessInstanceDescription((ProcessInstanceDescription) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getProcessInstanceDescription())).deepUnwrap());
        } else {
          clone.setProcessInstanceDescription(t.getProcessInstanceDescription());
        }
        if (t.getImports() instanceof BindableProxy) {
          clone.setImports((Imports) ((BindableProxy) getImports()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getImports())) {
          clone.setImports((Imports) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getImports())).deepUnwrap());
        } else {
          clone.setImports(t.getImports());
        }
        if (t.getPackageProperty() instanceof BindableProxy) {
          clone.setPackageProperty((Package) ((BindableProxy) getPackageProperty()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getPackageProperty())) {
          clone.setPackageProperty((Package) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getPackageProperty())).deepUnwrap());
        } else {
          clone.setPackageProperty(t.getPackageProperty());
        }
        if (t.getDocumentation() instanceof BindableProxy) {
          clone.setDocumentation((Documentation) ((BindableProxy) getDocumentation()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDocumentation())) {
          clone.setDocumentation((Documentation) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDocumentation())).deepUnwrap());
        } else {
          clone.setDocumentation(t.getDocumentation());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getName() instanceof BindableProxy) {
          clone.setName((Name) ((BindableProxy) getName()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getName())) {
          clone.setName((Name) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getName())).deepUnwrap());
        } else {
          clone.setName(t.getName());
        }
        if (t.getId() instanceof BindableProxy) {
          clone.setId((org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id) ((BindableProxy) getId()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getId())) {
          clone.setId((org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getId())).deepUnwrap());
        } else {
          clone.setId(t.getId());
        }
        if (t.getAdHoc() instanceof BindableProxy) {
          clone.setAdHoc((AdHoc) ((BindableProxy) getAdHoc()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAdHoc())) {
          clone.setAdHoc((AdHoc) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAdHoc())).deepUnwrap());
        } else {
          clone.setAdHoc(t.getAdHoc());
        }
        if (t.getVersion() instanceof BindableProxy) {
          clone.setVersion((Version) ((BindableProxy) getVersion()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getVersion())) {
          clone.setVersion((Version) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getVersion())).deepUnwrap());
        } else {
          clone.setVersion(t.getVersion());
        }
        if (t.getExecutable() instanceof BindableProxy) {
          clone.setExecutable((Executable) ((BindableProxy) getExecutable()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutable())) {
          clone.setExecutable((Executable) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutable())).deepUnwrap());
        } else {
          clone.setExecutable(t.getExecutable());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public GlobalVariables getGlobalVariables() {
        return target.getGlobalVariables();
      }

      public void setGlobalVariables(GlobalVariables globalVariables) {
        if (agent.binders.containsKey("globalVariables")) {
          globalVariables = (GlobalVariables) agent.binders.get("globalVariables").setModel(globalVariables, StateSync.FROM_MODEL, true);
        }
        changeAndFire("globalVariables", globalVariables);
      }

      public ProcessInstanceDescription getProcessInstanceDescription() {
        return target.getProcessInstanceDescription();
      }

      public void setProcessInstanceDescription(ProcessInstanceDescription processInstanceDescription) {
        if (agent.binders.containsKey("processInstanceDescription")) {
          processInstanceDescription = (ProcessInstanceDescription) agent.binders.get("processInstanceDescription").setModel(processInstanceDescription, StateSync.FROM_MODEL, true);
        }
        changeAndFire("processInstanceDescription", processInstanceDescription);
      }

      public Imports getImports() {
        return target.getImports();
      }

      public void setImports(Imports imports) {
        if (agent.binders.containsKey("imports")) {
          imports = (Imports) agent.binders.get("imports").setModel(imports, StateSync.FROM_MODEL, true);
        }
        changeAndFire("imports", imports);
      }

      public Package getPackageProperty() {
        return target.getPackageProperty();
      }

      public void setPackageProperty(Package packageProperty) {
        if (agent.binders.containsKey("packageProperty")) {
          packageProperty = (Package) agent.binders.get("packageProperty").setModel(packageProperty, StateSync.FROM_MODEL, true);
        }
        changeAndFire("packageProperty", packageProperty);
      }

      public Documentation getDocumentation() {
        return target.getDocumentation();
      }

      public void setDocumentation(Documentation documentation) {
        if (agent.binders.containsKey("documentation")) {
          documentation = (Documentation) agent.binders.get("documentation").setModel(documentation, StateSync.FROM_MODEL, true);
        }
        changeAndFire("documentation", documentation);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public Name getName() {
        return target.getName();
      }

      public void setName(Name name) {
        if (agent.binders.containsKey("name")) {
          name = (Name) agent.binders.get("name").setModel(name, StateSync.FROM_MODEL, true);
        }
        changeAndFire("name", name);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id getId() {
        return target.getId();
      }

      public void setId(org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id id) {
        if (agent.binders.containsKey("id")) {
          id = (org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id) agent.binders.get("id").setModel(id, StateSync.FROM_MODEL, true);
        }
        changeAndFire("id", id);
      }

      public AdHoc getAdHoc() {
        return target.getAdHoc();
      }

      public void setAdHoc(AdHoc adHoc) {
        if (agent.binders.containsKey("adHoc")) {
          adHoc = (AdHoc) agent.binders.get("adHoc").setModel(adHoc, StateSync.FROM_MODEL, true);
        }
        changeAndFire("adHoc", adHoc);
      }

      public Version getVersion() {
        return target.getVersion();
      }

      public void setVersion(Version version) {
        if (agent.binders.containsKey("version")) {
          version = (Version) agent.binders.get("version").setModel(version, StateSync.FROM_MODEL, true);
        }
        changeAndFire("version", version);
      }

      public Executable getExecutable() {
        return target.getExecutable();
      }

      public void setExecutable(Executable executable) {
        if (agent.binders.containsKey("executable")) {
          executable = (Executable) agent.binders.get("executable").setModel(executable, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executable", executable);
      }

      public Object get(String property) {
        switch (property) {
          case "globalVariables": return getGlobalVariables();
          case "processInstanceDescription": return getProcessInstanceDescription();
          case "imports": return getImports();
          case "packageProperty": return getPackageProperty();
          case "documentation": return getDocumentation();
          case "slaDueDate": return getSlaDueDate();
          case "name": return getName();
          case "id": return getId();
          case "adHoc": return getAdHoc();
          case "version": return getVersion();
          case "executable": return getExecutable();
          case "this": return target;
          default: throw new NonExistingPropertyException("DiagramSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "globalVariables": target.setGlobalVariables((GlobalVariables) value);
          break;
          case "processInstanceDescription": target.setProcessInstanceDescription((ProcessInstanceDescription) value);
          break;
          case "imports": target.setImports((Imports) value);
          break;
          case "packageProperty": target.setPackageProperty((Package) value);
          break;
          case "documentation": target.setDocumentation((Documentation) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "name": target.setName((Name) value);
          break;
          case "id": target.setId((org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id) value);
          break;
          case "adHoc": target.setAdHoc((AdHoc) value);
          break;
          case "version": target.setVersion((Version) value);
          break;
          case "executable": target.setExecutable((Executable) value);
          break;
          case "this": target = (DiagramSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DiagramSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(DiagramSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy((DiagramSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_DiagramSetProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy extends LiteralExpressionPMMLDocumentModel implements BindableProxy {
      private BindableProxyAgent<LiteralExpressionPMMLDocumentModel> agent;
      private LiteralExpressionPMMLDocumentModel target;
      public org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy() {
        this(new LiteralExpressionPMMLDocumentModel());
      }

      public org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy(LiteralExpressionPMMLDocumentModel targetVal) {
        agent = new BindableProxyAgent<LiteralExpressionPMMLDocumentModel>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("domainObjectUUID", new PropertyType(String.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("extensionElements", new PropertyType(ExtensionElements.class, false, false));
        p.put("domainObjectNameTranslationKey", new PropertyType(String.class, false, false));
        p.put("expressionLanguage", new PropertyType(ExpressionLanguage.class, true, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("description", new PropertyType(org.kie.workbench.common.dmn.api.property.dmn.Description.class, true, false));
        p.put("importedValues", new PropertyType(ImportedValues.class, true, false));
        p.put("requiredComponentWidthCount", new PropertyType(Integer.class, false, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("componentWidths", new PropertyType(List.class, false, true));
        p.put("hasTypeRefs", new PropertyType(List.class, false, true));
        p.put("text", new PropertyType(Text.class, true, false));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("typeRef", new PropertyType(QName.class, false, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(LiteralExpressionPMMLDocumentModel.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public LiteralExpressionPMMLDocumentModel unwrap() {
        return target;
      }

      public LiteralExpressionPMMLDocumentModel deepUnwrap() {
        final LiteralExpressionPMMLDocumentModel clone = new LiteralExpressionPMMLDocumentModel();
        final LiteralExpressionPMMLDocumentModel t = unwrap();
        clone.setParent(t.getParent());
        clone.setExtensionElements(t.getExtensionElements());
        if (t.getExpressionLanguage() instanceof BindableProxy) {
          clone.setExpressionLanguage((ExpressionLanguage) ((BindableProxy) getExpressionLanguage()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExpressionLanguage())) {
          clone.setExpressionLanguage((ExpressionLanguage) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExpressionLanguage())).deepUnwrap());
        } else {
          clone.setExpressionLanguage(t.getExpressionLanguage());
        }
        if (t.getDescription() instanceof BindableProxy) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) getDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDescription())) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDescription())).deepUnwrap());
        } else {
          clone.setDescription(t.getDescription());
        }
        if (t.getImportedValues() instanceof BindableProxy) {
          clone.setImportedValues((ImportedValues) ((BindableProxy) getImportedValues()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getImportedValues())) {
          clone.setImportedValues((ImportedValues) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getImportedValues())).deepUnwrap());
        } else {
          clone.setImportedValues(t.getImportedValues());
        }
        if (t.getText() instanceof BindableProxy) {
          clone.setText((Text) ((BindableProxy) getText()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getText())) {
          clone.setText((Text) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getText())).deepUnwrap());
        } else {
          clone.setText(t.getText());
        }
        if (t.getId() instanceof BindableProxy) {
          clone.setId((Id) ((BindableProxy) getId()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getId())) {
          clone.setId((Id) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getId())).deepUnwrap());
        } else {
          clone.setId(t.getId());
        }
        clone.setTypeRef(t.getTypeRef());
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDomainObjectUUID() {
        return target.getDomainObjectUUID();
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public ExtensionElements getExtensionElements() {
        return target.getExtensionElements();
      }

      public void setExtensionElements(ExtensionElements extensionElements) {
        changeAndFire("extensionElements", extensionElements);
      }

      public String getDomainObjectNameTranslationKey() {
        return target.getDomainObjectNameTranslationKey();
      }

      public ExpressionLanguage getExpressionLanguage() {
        return target.getExpressionLanguage();
      }

      public void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        if (agent.binders.containsKey("expressionLanguage")) {
          expressionLanguage = (ExpressionLanguage) agent.binders.get("expressionLanguage").setModel(expressionLanguage, StateSync.FROM_MODEL, true);
        }
        changeAndFire("expressionLanguage", expressionLanguage);
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Description getDescription() {
        return target.getDescription();
      }

      public void setDescription(org.kie.workbench.common.dmn.api.property.dmn.Description description) {
        if (agent.binders.containsKey("description")) {
          description = (org.kie.workbench.common.dmn.api.property.dmn.Description) agent.binders.get("description").setModel(description, StateSync.FROM_MODEL, true);
        }
        changeAndFire("description", description);
      }

      public ImportedValues getImportedValues() {
        return target.getImportedValues();
      }

      public void setImportedValues(ImportedValues importedValues) {
        if (agent.binders.containsKey("importedValues")) {
          importedValues = (ImportedValues) agent.binders.get("importedValues").setModel(importedValues, StateSync.FROM_MODEL, true);
        }
        changeAndFire("importedValues", importedValues);
      }

      public int getRequiredComponentWidthCount() {
        return target.getRequiredComponentWidthCount();
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public List getComponentWidths() {
        return target.getComponentWidths();
      }

      public List getHasTypeRefs() {
        return target.getHasTypeRefs();
      }

      public Text getText() {
        return target.getText();
      }

      public void setText(Text text) {
        if (agent.binders.containsKey("text")) {
          text = (Text) agent.binders.get("text").setModel(text, StateSync.FROM_MODEL, true);
        }
        changeAndFire("text", text);
      }

      public Id getId() {
        return target.getId();
      }

      public void setId(Id id) {
        if (agent.binders.containsKey("id")) {
          id = (Id) agent.binders.get("id").setModel(id, StateSync.FROM_MODEL, true);
        }
        changeAndFire("id", id);
      }

      public QName getTypeRef() {
        return target.getTypeRef();
      }

      public void setTypeRef(QName typeRef) {
        changeAndFire("typeRef", typeRef);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "domainObjectUUID": return getDomainObjectUUID();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "extensionElements": return getExtensionElements();
          case "domainObjectNameTranslationKey": return getDomainObjectNameTranslationKey();
          case "expressionLanguage": return getExpressionLanguage();
          case "stunnerLabels": return getStunnerLabels();
          case "description": return getDescription();
          case "importedValues": return getImportedValues();
          case "requiredComponentWidthCount": return getRequiredComponentWidthCount();
          case "nsContext": return getNsContext();
          case "componentWidths": return getComponentWidths();
          case "hasTypeRefs": return getHasTypeRefs();
          case "text": return getText();
          case "id": return getId();
          case "typeRef": return getTypeRef();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("LiteralExpressionPMMLDocumentModel", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "extensionElements": target.setExtensionElements((ExtensionElements) value);
          break;
          case "expressionLanguage": target.setExpressionLanguage((ExpressionLanguage) value);
          break;
          case "description": target.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) value);
          break;
          case "importedValues": target.setImportedValues((ImportedValues) value);
          break;
          case "text": target.setText((Text) value);
          break;
          case "id": target.setId((Id) value);
          break;
          case "typeRef": target.setTypeRef((QName) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (LiteralExpressionPMMLDocumentModel) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("LiteralExpressionPMMLDocumentModel", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        final DMNModelInstrumentedBase returnValue = target.asDMNModelInstrumentedBase();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(LiteralExpressionPMMLDocumentModel.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy((LiteralExpressionPMMLDocumentModel) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy extends MultipleSubFormFieldDefinition implements BindableProxy {
      private BindableProxyAgent<MultipleSubFormFieldDefinition> agent;
      private MultipleSubFormFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy() {
        this(new MultipleSubFormFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy(MultipleSubFormFieldDefinition targetVal) {
        agent = new BindableProxyAgent<MultipleSubFormFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("container", new PropertyType(Container.class, false, false));
        p.put("creationForm", new PropertyType(String.class, false, false));
        p.put("columnMetas", new PropertyType(List.class, false, true));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("editionForm", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(MultipleSubFormFieldType.class, false, false));
        p.put("this", new PropertyType(MultipleSubFormFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public MultipleSubFormFieldDefinition unwrap() {
        return target;
      }

      public MultipleSubFormFieldDefinition deepUnwrap() {
        final MultipleSubFormFieldDefinition clone = new MultipleSubFormFieldDefinition();
        final MultipleSubFormFieldDefinition t = unwrap();
        clone.setContainer(t.getContainer());
        clone.setCreationForm(t.getCreationForm());
        if (t.getColumnMetas() != null) {
          final List columnMetasClone = new ArrayList();
          for (Object columnMetasElem : t.getColumnMetas()) {
            if (columnMetasElem instanceof BindableProxy) {
              columnMetasClone.add(((BindableProxy) columnMetasElem).deepUnwrap());
            } else {
              columnMetasClone.add(columnMetasElem);
            }
          }
          clone.setColumnMetas(columnMetasClone);
        }
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setEditionForm(t.getEditionForm());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Container getContainer() {
        return target.getContainer();
      }

      public void setContainer(Container container) {
        changeAndFire("container", container);
      }

      public String getCreationForm() {
        return target.getCreationForm();
      }

      public void setCreationForm(String creationForm) {
        changeAndFire("creationForm", creationForm);
      }

      public List getColumnMetas() {
        return target.getColumnMetas();
      }

      public void setColumnMetas(List<TableColumnMeta> columnMetas) {
        List<TableColumnMeta> oldValue = target.getColumnMetas();
        columnMetas = agent.ensureBoundListIsProxied("columnMetas", columnMetas);
        target.setColumnMetas(columnMetas);
        agent.updateWidgetsAndFireEvent(true, "columnMetas", oldValue, columnMetas);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public String getEditionForm() {
        return target.getEditionForm();
      }

      public void setEditionForm(String editionForm) {
        changeAndFire("editionForm", editionForm);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public MultipleSubFormFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "container": return getContainer();
          case "creationForm": return getCreationForm();
          case "columnMetas": return getColumnMetas();
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "editionForm": return getEditionForm();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("MultipleSubFormFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "container": target.setContainer((Container) value);
          break;
          case "creationForm": target.setCreationForm((String) value);
          break;
          case "columnMetas": target.setColumnMetas((List<TableColumnMeta>) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "editionForm": target.setEditionForm((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (MultipleSubFormFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("MultipleSubFormFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(MultipleSubFormFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy((MultipleSubFormFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_multipleSubform_definition_MultipleSubFormFieldDefinitionProxy();
      }
    });
    class org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy extends TimerInstanceSummary implements BindableProxy {
      private BindableProxyAgent<TimerInstanceSummary> agent;
      private TimerInstanceSummary target;
      public org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy() {
        this(new TimerInstanceSummary());
      }

      public org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy(TimerInstanceSummary targetVal) {
        agent = new BindableProxyAgent<TimerInstanceSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("lastFireTime", new PropertyType(Date.class, false, false));
        p.put("processInstanceId", new PropertyType(Long.class, false, false));
        p.put("period", new PropertyType(Long.class, false, false));
        p.put("repeatLimit", new PropertyType(Integer.class, false, false));
        p.put("nextFireTime", new PropertyType(Date.class, false, false));
        p.put("description", new PropertyType(String.class, false, false));
        p.put("callbacks", new PropertyType(List.class, false, true));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("timerId", new PropertyType(Long.class, false, false));
        p.put("delay", new PropertyType(Long.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("activationTime", new PropertyType(Date.class, false, false));
        p.put("relative", new PropertyType(Boolean.class, false, false));
        p.put("this", new PropertyType(TimerInstanceSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public TimerInstanceSummary unwrap() {
        return target;
      }

      public TimerInstanceSummary deepUnwrap() {
        final TimerInstanceSummary clone = new TimerInstanceSummary();
        final TimerInstanceSummary t = unwrap();
        clone.setLastFireTime(t.getLastFireTime());
        clone.setProcessInstanceId(t.getProcessInstanceId());
        clone.setPeriod(t.getPeriod());
        clone.setRepeatLimit(t.getRepeatLimit());
        clone.setNextFireTime(t.getNextFireTime());
        clone.setDescription(t.getDescription());
        if (t.getCallbacks() != null) {
          final List callbacksClone = new ArrayList();
          for (Object callbacksElem : t.getCallbacks()) {
            if (callbacksElem instanceof BindableProxy) {
              callbacksClone.add(((BindableProxy) callbacksElem).deepUnwrap());
            } else {
              callbacksClone.add(callbacksElem);
            }
          }
          clone.setCallbacks(callbacksClone);
        }
        clone.setTimerId(t.getTimerId());
        clone.setDelay(t.getDelay());
        clone.setName(t.getName());
        clone.setId(t.getId());
        clone.setActivationTime(t.getActivationTime());
        clone.setRelative(t.isRelative());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy) {
          obj = ((org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Date getLastFireTime() {
        return target.getLastFireTime();
      }

      public void setLastFireTime(Date lastFireTime) {
        changeAndFire("lastFireTime", lastFireTime);
      }

      public Long getProcessInstanceId() {
        return target.getProcessInstanceId();
      }

      public void setProcessInstanceId(Long processInstanceId) {
        changeAndFire("processInstanceId", processInstanceId);
      }

      public Long getPeriod() {
        return target.getPeriod();
      }

      public void setPeriod(Long period) {
        changeAndFire("period", period);
      }

      public Integer getRepeatLimit() {
        return target.getRepeatLimit();
      }

      public void setRepeatLimit(Integer repeatLimit) {
        changeAndFire("repeatLimit", repeatLimit);
      }

      public Date getNextFireTime() {
        return target.getNextFireTime();
      }

      public void setNextFireTime(Date nextFireTime) {
        changeAndFire("nextFireTime", nextFireTime);
      }

      public String getDescription() {
        return target.getDescription();
      }

      public void setDescription(String description) {
        changeAndFire("description", description);
      }

      public List getCallbacks() {
        return target.getCallbacks();
      }

      public void setCallbacks(List<LabeledCommand> callbacks) {
        List<LabeledCommand> oldValue = target.getCallbacks();
        callbacks = agent.ensureBoundListIsProxied("callbacks", callbacks);
        target.setCallbacks(callbacks);
        agent.updateWidgetsAndFireEvent(true, "callbacks", oldValue, callbacks);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public Long getTimerId() {
        return target.getTimerId();
      }

      public void setTimerId(Long timerId) {
        changeAndFire("timerId", timerId);
      }

      public Long getDelay() {
        return target.getDelay();
      }

      public void setDelay(Long delay) {
        changeAndFire("delay", delay);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public Long getId() {
        return target.getId();
      }

      public void setId(Long id) {
        changeAndFire("id", id);
      }

      public Date getActivationTime() {
        return target.getActivationTime();
      }

      public void setActivationTime(Date activationTime) {
        changeAndFire("activationTime", activationTime);
      }

      public Boolean isRelative() {
        return target.isRelative();
      }

      public void setRelative(Boolean relative) {
        changeAndFire("relative", relative);
      }

      public Object get(String property) {
        switch (property) {
          case "lastFireTime": return getLastFireTime();
          case "processInstanceId": return getProcessInstanceId();
          case "period": return getPeriod();
          case "repeatLimit": return getRepeatLimit();
          case "nextFireTime": return getNextFireTime();
          case "description": return getDescription();
          case "callbacks": return getCallbacks();
          case "label": return getLabel();
          case "timerId": return getTimerId();
          case "delay": return getDelay();
          case "name": return getName();
          case "id": return getId();
          case "activationTime": return getActivationTime();
          case "relative": return isRelative();
          case "this": return target;
          default: throw new NonExistingPropertyException("TimerInstanceSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "lastFireTime": target.setLastFireTime((Date) value);
          break;
          case "processInstanceId": target.setProcessInstanceId((Long) value);
          break;
          case "period": target.setPeriod((Long) value);
          break;
          case "repeatLimit": target.setRepeatLimit((Integer) value);
          break;
          case "nextFireTime": target.setNextFireTime((Date) value);
          break;
          case "description": target.setDescription((String) value);
          break;
          case "callbacks": target.setCallbacks((List<LabeledCommand>) value);
          break;
          case "timerId": target.setTimerId((Long) value);
          break;
          case "delay": target.setDelay((Long) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "activationTime": target.setActivationTime((Date) value);
          break;
          case "relative": target.setRelative((Boolean) value);
          break;
          case "this": target = (TimerInstanceSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("TimerInstanceSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasCallbacks() {
        final boolean returnValue = target.hasCallbacks();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void addCallback(String a0, Command a1) {
        target.addCallback(a0, a1);
        agent.updateWidgetsAndFireEvents();
      }

      public int compareTo(AbstractPageRow a0) {
        final int returnValue = target.compareTo(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(TimerInstanceSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy((TimerInstanceSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_pr_model_TimerInstanceSummaryProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy extends IntegerRadioGroupFieldDefinition implements BindableProxy {
      private BindableProxyAgent<IntegerRadioGroupFieldDefinition> agent;
      private IntegerRadioGroupFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy() {
        this(new IntegerRadioGroupFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy(IntegerRadioGroupFieldDefinition targetVal) {
        agent = new BindableProxyAgent<IntegerRadioGroupFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("relatedField", new PropertyType(String.class, false, false));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(Long.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("inline", new PropertyType(Boolean.class, false, false));
        p.put("options", new PropertyType(List.class, false, true));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("dataProvider", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(RadioGroupFieldType.class, false, false));
        p.put("this", new PropertyType(IntegerRadioGroupFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IntegerRadioGroupFieldDefinition unwrap() {
        return target;
      }

      public IntegerRadioGroupFieldDefinition deepUnwrap() {
        final IntegerRadioGroupFieldDefinition clone = new IntegerRadioGroupFieldDefinition();
        final IntegerRadioGroupFieldDefinition t = unwrap();
        clone.setRelatedField(t.getRelatedField());
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setInline(t.getInline());
        if (t.getOptions() != null) {
          final List optionsClone = new ArrayList();
          for (Object optionsElem : t.getOptions()) {
            if (optionsElem instanceof BindableProxy) {
              optionsClone.add(((BindableProxy) optionsElem).deepUnwrap());
            } else {
              optionsClone.add(optionsElem);
            }
          }
          clone.setOptions(optionsClone);
        }
        clone.setName(t.getName());
        clone.setDataProvider(t.getDataProvider());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getRelatedField() {
        return target.getRelatedField();
      }

      public void setRelatedField(String relatedField) {
        changeAndFire("relatedField", relatedField);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Long getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(Long defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Boolean getInline() {
        return target.getInline();
      }

      public void setInline(Boolean inline) {
        changeAndFire("inline", inline);
      }

      public List getOptions() {
        return target.getOptions();
      }

      public void setOptions(List<IntegerSelectorOption> options) {
        List<IntegerSelectorOption> oldValue = target.getOptions();
        options = agent.ensureBoundListIsProxied("options", options);
        target.setOptions(options);
        agent.updateWidgetsAndFireEvent(true, "options", oldValue, options);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getDataProvider() {
        return target.getDataProvider();
      }

      public void setDataProvider(String dataProvider) {
        changeAndFire("dataProvider", dataProvider);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public RadioGroupFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "relatedField": return getRelatedField();
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "inline": return getInline();
          case "options": return getOptions();
          case "name": return getName();
          case "dataProvider": return getDataProvider();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("IntegerRadioGroupFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "relatedField": target.setRelatedField((String) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((Long) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "inline": target.setInline((Boolean) value);
          break;
          case "options": target.setOptions((List<IntegerSelectorOption>) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "dataProvider": target.setDataProvider((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (IntegerRadioGroupFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IntegerRadioGroupFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(IntegerRadioGroupFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy((IntegerRadioGroupFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_radioGroup_definition_IntegerRadioGroupFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy extends AdHocAutostart implements BindableProxy {
      private BindableProxyAgent<AdHocAutostart> agent;
      private AdHocAutostart target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy() {
        this(new AdHocAutostart());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy(AdHocAutostart targetVal) {
        agent = new BindableProxyAgent<AdHocAutostart>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Boolean.class, false, false));
        p.put("this", new PropertyType(AdHocAutostart.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AdHocAutostart unwrap() {
        return target;
      }

      public AdHocAutostart deepUnwrap() {
        final AdHocAutostart clone = new AdHocAutostart();
        final AdHocAutostart t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValue() {
        return target.getValue();
      }

      public void setValue(Boolean value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("AdHocAutostart", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Boolean) value);
          break;
          case "this": target = (AdHocAutostart) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AdHocAutostart", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(AdHocAutostart.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy((AdHocAutostart) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_AdHocAutostartProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy extends ErrorRef implements BindableProxy {
      private BindableProxyAgent<ErrorRef> agent;
      private ErrorRef target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy() {
        this(new ErrorRef());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy(ErrorRef targetVal) {
        agent = new BindableProxyAgent<ErrorRef>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ErrorRef.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ErrorRef unwrap() {
        return target;
      }

      public ErrorRef deepUnwrap() {
        final ErrorRef clone = new ErrorRef();
        final ErrorRef t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("ErrorRef", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (ErrorRef) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ErrorRef", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ErrorRef.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy((ErrorRef) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_error_ErrorRefProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy extends WorkingHours implements BindableProxy {
      private BindableProxyAgent<WorkingHours> agent;
      private WorkingHours target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy() {
        this(new WorkingHours());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy(WorkingHours targetVal) {
        agent = new BindableProxyAgent<WorkingHours>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(WorkingHours.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public WorkingHours unwrap() {
        return target;
      }

      public WorkingHours deepUnwrap() {
        final WorkingHours clone = new WorkingHours();
        final WorkingHours t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("WorkingHours", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (WorkingHours) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("WorkingHours", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(WorkingHours.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy((WorkingHours) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_WorkingHoursProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy extends VariableRow implements BindableProxy {
      private BindableProxyAgent<VariableRow> agent;
      private VariableRow target;
      public org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy() {
        this(new VariableRow());
      }

      public org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy(VariableRow targetVal) {
        agent = new BindableProxyAgent<VariableRow>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("variableType", new PropertyType(VariableType.class, false, false));
        p.put("kpi", new PropertyType(Boolean.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("customDataType", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("dataTypeDisplayName", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(VariableRow.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public VariableRow unwrap() {
        return target;
      }

      public VariableRow deepUnwrap() {
        final VariableRow clone = new VariableRow();
        final VariableRow t = unwrap();
        clone.setVariableType(t.getVariableType());
        clone.setKpi(t.getKpi());
        clone.setName(t.getName());
        clone.setCustomDataType(t.getCustomDataType());
        clone.setId(t.getId());
        clone.setDataTypeDisplayName(t.getDataTypeDisplayName());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public VariableType getVariableType() {
        return target.getVariableType();
      }

      public void setVariableType(VariableType variableType) {
        changeAndFire("variableType", variableType);
      }

      public boolean getKpi() {
        return target.getKpi();
      }

      public void setKpi(boolean kpi) {
        changeAndFire("kpi", kpi);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getCustomDataType() {
        return target.getCustomDataType();
      }

      public void setCustomDataType(String customDataType) {
        changeAndFire("customDataType", customDataType);
      }

      public long getId() {
        return target.getId();
      }

      public void setId(long id) {
        changeAndFire("id", id);
      }

      public String getDataTypeDisplayName() {
        return target.getDataTypeDisplayName();
      }

      public void setDataTypeDisplayName(String dataTypeDisplayName) {
        changeAndFire("dataTypeDisplayName", dataTypeDisplayName);
      }

      public Object get(String property) {
        switch (property) {
          case "variableType": return getVariableType();
          case "kpi": return getKpi();
          case "name": return getName();
          case "customDataType": return getCustomDataType();
          case "id": return getId();
          case "dataTypeDisplayName": return getDataTypeDisplayName();
          case "this": return target;
          default: throw new NonExistingPropertyException("VariableRow", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "variableType": target.setVariableType((VariableType) value);
          break;
          case "kpi": target.setKpi((Boolean) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "customDataType": target.setCustomDataType((String) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "dataTypeDisplayName": target.setDataTypeDisplayName((String) value);
          break;
          case "this": target = (VariableRow) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("VariableRow", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(VariableRow.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy((VariableRow) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_VariableRowProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy extends AssignmentsEditorFieldDefinition implements BindableProxy {
      private BindableProxyAgent<AssignmentsEditorFieldDefinition> agent;
      private AssignmentsEditorFieldDefinition target;
      public org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy() {
        this(new AssignmentsEditorFieldDefinition());
      }

      public org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy(AssignmentsEditorFieldDefinition targetVal) {
        agent = new BindableProxyAgent<AssignmentsEditorFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(AssignmentsEditorFieldType.class, false, false));
        p.put("this", new PropertyType(AssignmentsEditorFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AssignmentsEditorFieldDefinition unwrap() {
        return target;
      }

      public AssignmentsEditorFieldDefinition deepUnwrap() {
        final AssignmentsEditorFieldDefinition clone = new AssignmentsEditorFieldDefinition();
        final AssignmentsEditorFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(String defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public AssignmentsEditorFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("AssignmentsEditorFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (AssignmentsEditorFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AssignmentsEditorFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(AssignmentsEditorFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy((AssignmentsEditorFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_AssignmentsEditorFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_font_FontColourProxy extends FontColour implements BindableProxy {
      private BindableProxyAgent<FontColour> agent;
      private FontColour target;
      public org_kie_workbench_common_dmn_api_property_font_FontColourProxy() {
        this(new FontColour());
      }

      public org_kie_workbench_common_dmn_api_property_font_FontColourProxy(FontColour targetVal) {
        agent = new BindableProxyAgent<FontColour>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(FontColour.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public FontColour unwrap() {
        return target;
      }

      public FontColour deepUnwrap() {
        final FontColour clone = new FontColour();
        final FontColour t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_font_FontColourProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_font_FontColourProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("FontColour", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (FontColour) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("FontColour", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(FontColour.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_font_FontColourProxy((FontColour) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_font_FontColourProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy extends FontBorderSize implements BindableProxy {
      private BindableProxyAgent<FontBorderSize> agent;
      private FontBorderSize target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy() {
        this(new FontBorderSize());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy(FontBorderSize targetVal) {
        agent = new BindableProxyAgent<FontBorderSize>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(FontBorderSize.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public FontBorderSize unwrap() {
        return target;
      }

      public FontBorderSize deepUnwrap() {
        final FontBorderSize clone = new FontBorderSize();
        final FontBorderSize t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("FontBorderSize", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (FontBorderSize) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("FontBorderSize", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(FontBorderSize.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy((FontBorderSize) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontBorderSizeProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy extends StandardDeviation implements BindableProxy {
      private BindableProxyAgent<StandardDeviation> agent;
      private StandardDeviation target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy() {
        this(new StandardDeviation());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy(StandardDeviation targetVal) {
        agent = new BindableProxyAgent<StandardDeviation>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(StandardDeviation.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public StandardDeviation unwrap() {
        return target;
      }

      public StandardDeviation deepUnwrap() {
        final StandardDeviation clone = new StandardDeviation();
        final StandardDeviation t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("StandardDeviation", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (StandardDeviation) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("StandardDeviation", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(StandardDeviation.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy((StandardDeviation) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_StandardDeviationProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_background_BorderColourProxy extends BorderColour implements BindableProxy {
      private BindableProxyAgent<BorderColour> agent;
      private BorderColour target;
      public org_kie_workbench_common_dmn_api_property_background_BorderColourProxy() {
        this(new BorderColour());
      }

      public org_kie_workbench_common_dmn_api_property_background_BorderColourProxy(BorderColour targetVal) {
        agent = new BindableProxyAgent<BorderColour>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(BorderColour.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public BorderColour unwrap() {
        return target;
      }

      public BorderColour deepUnwrap() {
        final BorderColour clone = new BorderColour();
        final BorderColour t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_background_BorderColourProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_background_BorderColourProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("BorderColour", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (BorderColour) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("BorderColour", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(BorderColour.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_background_BorderColourProxy((BorderColour) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_background_BorderColourProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy extends ImportsValue implements BindableProxy {
      private BindableProxyAgent<ImportsValue> agent;
      private ImportsValue target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy() {
        this(new ImportsValue());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy(ImportsValue targetVal) {
        agent = new BindableProxyAgent<ImportsValue>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("wSDLImports", new PropertyType(List.class, false, true));
        p.put("defaultImports", new PropertyType(List.class, false, true));
        p.put("this", new PropertyType(ImportsValue.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ImportsValue unwrap() {
        return target;
      }

      public ImportsValue deepUnwrap() {
        final ImportsValue clone = new ImportsValue();
        final ImportsValue t = unwrap();
        if (t.getWSDLImports() != null) {
          final List wSDLImportsClone = new ArrayList();
          for (Object wSDLImportsElem : t.getWSDLImports()) {
            if (wSDLImportsElem instanceof BindableProxy) {
              wSDLImportsClone.add(((BindableProxy) wSDLImportsElem).deepUnwrap());
            } else {
              wSDLImportsClone.add(wSDLImportsElem);
            }
          }
          clone.setWSDLImports(wSDLImportsClone);
        }
        if (t.getDefaultImports() != null) {
          final List defaultImportsClone = new ArrayList();
          for (Object defaultImportsElem : t.getDefaultImports()) {
            if (defaultImportsElem instanceof BindableProxy) {
              defaultImportsClone.add(((BindableProxy) defaultImportsElem).deepUnwrap());
            } else {
              defaultImportsClone.add(defaultImportsElem);
            }
          }
          clone.setDefaultImports(defaultImportsClone);
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public List getWSDLImports() {
        return target.getWSDLImports();
      }

      public void setWSDLImports(List<WSDLImport> wSDLImports) {
        List<WSDLImport> oldValue = target.getWSDLImports();
        wSDLImports = agent.ensureBoundListIsProxied("wSDLImports", wSDLImports);
        target.setWSDLImports(wSDLImports);
        agent.updateWidgetsAndFireEvent(true, "wSDLImports", oldValue, wSDLImports);
      }

      public List getDefaultImports() {
        return target.getDefaultImports();
      }

      public void setDefaultImports(List<DefaultImport> defaultImports) {
        List<DefaultImport> oldValue = target.getDefaultImports();
        defaultImports = agent.ensureBoundListIsProxied("defaultImports", defaultImports);
        target.setDefaultImports(defaultImports);
        agent.updateWidgetsAndFireEvent(true, "defaultImports", oldValue, defaultImports);
      }

      public Object get(String property) {
        switch (property) {
          case "wSDLImports": return getWSDLImports();
          case "defaultImports": return getDefaultImports();
          case "this": return target;
          default: throw new NonExistingPropertyException("ImportsValue", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "wSDLImports": target.setWSDLImports((List<WSDLImport>) value);
          break;
          case "defaultImports": target.setDefaultImports((List<DefaultImport>) value);
          break;
          case "this": target = (ImportsValue) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ImportsValue", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void addImport(DefaultImport a0) {
        target.addImport(a0);
        agent.updateWidgetsAndFireEvents();
      }

      public void addImport(WSDLImport a0) {
        target.addImport(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(ImportsValue.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy((ImportsValue) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_ImportsValueProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_font_FontSetProxy extends org.kie.workbench.common.dmn.api.property.font.FontSet implements BindableProxy {
      private BindableProxyAgent<org.kie.workbench.common.dmn.api.property.font.FontSet> agent;
      private org.kie.workbench.common.dmn.api.property.font.FontSet target;
      public org_kie_workbench_common_dmn_api_property_font_FontSetProxy() {
        this(new org.kie.workbench.common.dmn.api.property.font.FontSet());
      }

      public org_kie_workbench_common_dmn_api_property_font_FontSetProxy(org.kie.workbench.common.dmn.api.property.font.FontSet targetVal) {
        agent = new BindableProxyAgent<org.kie.workbench.common.dmn.api.property.font.FontSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("fontFamily", new PropertyType(org.kie.workbench.common.dmn.api.property.font.FontFamily.class, true, false));
        p.put("fontSize", new PropertyType(FontSize.class, true, false));
        p.put("fontColour", new PropertyType(FontColour.class, true, false));
        p.put("this", new PropertyType(org.kie.workbench.common.dmn.api.property.font.FontSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public org.kie.workbench.common.dmn.api.property.font.FontSet unwrap() {
        return target;
      }

      public org.kie.workbench.common.dmn.api.property.font.FontSet deepUnwrap() {
        final org.kie.workbench.common.dmn.api.property.font.FontSet clone = new org.kie.workbench.common.dmn.api.property.font.FontSet();
        final org.kie.workbench.common.dmn.api.property.font.FontSet t = unwrap();
        if (t.getFontFamily() instanceof BindableProxy) {
          clone.setFontFamily((org.kie.workbench.common.dmn.api.property.font.FontFamily) ((BindableProxy) getFontFamily()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontFamily())) {
          clone.setFontFamily((org.kie.workbench.common.dmn.api.property.font.FontFamily) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontFamily())).deepUnwrap());
        } else {
          clone.setFontFamily(t.getFontFamily());
        }
        if (t.getFontSize() instanceof BindableProxy) {
          clone.setFontSize((FontSize) ((BindableProxy) getFontSize()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSize())) {
          clone.setFontSize((FontSize) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSize())).deepUnwrap());
        } else {
          clone.setFontSize(t.getFontSize());
        }
        if (t.getFontColour() instanceof BindableProxy) {
          clone.setFontColour((FontColour) ((BindableProxy) getFontColour()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontColour())) {
          clone.setFontColour((FontColour) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontColour())).deepUnwrap());
        } else {
          clone.setFontColour(t.getFontColour());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_font_FontSetProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_font_FontSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.dmn.api.property.font.FontFamily getFontFamily() {
        return target.getFontFamily();
      }

      public void setFontFamily(org.kie.workbench.common.dmn.api.property.font.FontFamily fontFamily) {
        if (agent.binders.containsKey("fontFamily")) {
          fontFamily = (org.kie.workbench.common.dmn.api.property.font.FontFamily) agent.binders.get("fontFamily").setModel(fontFamily, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontFamily", fontFamily);
      }

      public FontSize getFontSize() {
        return target.getFontSize();
      }

      public void setFontSize(FontSize fontSize) {
        if (agent.binders.containsKey("fontSize")) {
          fontSize = (FontSize) agent.binders.get("fontSize").setModel(fontSize, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSize", fontSize);
      }

      public FontColour getFontColour() {
        return target.getFontColour();
      }

      public void setFontColour(FontColour fontColour) {
        if (agent.binders.containsKey("fontColour")) {
          fontColour = (FontColour) agent.binders.get("fontColour").setModel(fontColour, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontColour", fontColour);
      }

      public Object get(String property) {
        switch (property) {
          case "fontFamily": return getFontFamily();
          case "fontSize": return getFontSize();
          case "fontColour": return getFontColour();
          case "this": return target;
          default: throw new NonExistingPropertyException("FontSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "fontFamily": target.setFontFamily((org.kie.workbench.common.dmn.api.property.font.FontFamily) value);
          break;
          case "fontSize": target.setFontSize((FontSize) value);
          break;
          case "fontColour": target.setFontColour((FontColour) value);
          break;
          case "this": target = (org.kie.workbench.common.dmn.api.property.font.FontSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("FontSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(org.kie.workbench.common.dmn.api.property.font.FontSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_font_FontSetProxy((org.kie.workbench.common.dmn.api.property.font.FontSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_font_FontSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy extends MultipleInstanceExecutionMode implements BindableProxy {
      private BindableProxyAgent<MultipleInstanceExecutionMode> agent;
      private MultipleInstanceExecutionMode target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy() {
        this(new MultipleInstanceExecutionMode());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy(MultipleInstanceExecutionMode targetVal) {
        agent = new BindableProxyAgent<MultipleInstanceExecutionMode>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("sequential", new PropertyType(Boolean.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(MultipleInstanceExecutionMode.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public MultipleInstanceExecutionMode unwrap() {
        return target;
      }

      public MultipleInstanceExecutionMode deepUnwrap() {
        final MultipleInstanceExecutionMode clone = new MultipleInstanceExecutionMode();
        final MultipleInstanceExecutionMode t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public boolean isSequential() {
        return target.isSequential();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "sequential": return isSequential();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("MultipleInstanceExecutionMode", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (MultipleInstanceExecutionMode) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("MultipleInstanceExecutionMode", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(MultipleInstanceExecutionMode.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy((MultipleInstanceExecutionMode) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_MultipleInstanceExecutionModeProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy extends CharacterMultipleSelectorFieldDefinition implements BindableProxy {
      private BindableProxyAgent<CharacterMultipleSelectorFieldDefinition> agent;
      private CharacterMultipleSelectorFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy() {
        this(new CharacterMultipleSelectorFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy(CharacterMultipleSelectorFieldDefinition targetVal) {
        agent = new BindableProxyAgent<CharacterMultipleSelectorFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("maxDropdownElements", new PropertyType(Integer.class, false, false));
        p.put("listOfValues", new PropertyType(List.class, false, true));
        p.put("maxElementsOnTitle", new PropertyType(Integer.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("allowFilter", new PropertyType(Boolean.class, false, false));
        p.put("allowClearSelection", new PropertyType(Boolean.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(FieldType.class, false, false));
        p.put("this", new PropertyType(CharacterMultipleSelectorFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CharacterMultipleSelectorFieldDefinition unwrap() {
        return target;
      }

      public CharacterMultipleSelectorFieldDefinition deepUnwrap() {
        final CharacterMultipleSelectorFieldDefinition clone = new CharacterMultipleSelectorFieldDefinition();
        final CharacterMultipleSelectorFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setMaxDropdownElements(t.getMaxDropdownElements());
        if (t.getListOfValues() != null) {
          final List listOfValuesClone = new ArrayList();
          for (Object listOfValuesElem : t.getListOfValues()) {
            if (listOfValuesElem instanceof BindableProxy) {
              listOfValuesClone.add(((BindableProxy) listOfValuesElem).deepUnwrap());
            } else {
              listOfValuesClone.add(listOfValuesElem);
            }
          }
          clone.setListOfValues(listOfValuesClone);
        }
        clone.setMaxElementsOnTitle(t.getMaxElementsOnTitle());
        clone.setName(t.getName());
        clone.setAllowFilter(t.getAllowFilter());
        clone.setAllowClearSelection(t.getAllowClearSelection());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Integer getMaxDropdownElements() {
        return target.getMaxDropdownElements();
      }

      public void setMaxDropdownElements(Integer maxDropdownElements) {
        changeAndFire("maxDropdownElements", maxDropdownElements);
      }

      public List getListOfValues() {
        return target.getListOfValues();
      }

      public void setListOfValues(List<Character> listOfValues) {
        List<Character> oldValue = target.getListOfValues();
        listOfValues = agent.ensureBoundListIsProxied("listOfValues", listOfValues);
        target.setListOfValues(listOfValues);
        agent.updateWidgetsAndFireEvent(true, "listOfValues", oldValue, listOfValues);
      }

      public Integer getMaxElementsOnTitle() {
        return target.getMaxElementsOnTitle();
      }

      public void setMaxElementsOnTitle(Integer maxElementsOnTitle) {
        changeAndFire("maxElementsOnTitle", maxElementsOnTitle);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public Boolean getAllowFilter() {
        return target.getAllowFilter();
      }

      public void setAllowFilter(Boolean allowFilter) {
        changeAndFire("allowFilter", allowFilter);
      }

      public Boolean getAllowClearSelection() {
        return target.getAllowClearSelection();
      }

      public void setAllowClearSelection(Boolean allowClearSelection) {
        changeAndFire("allowClearSelection", allowClearSelection);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public FieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "maxDropdownElements": return getMaxDropdownElements();
          case "listOfValues": return getListOfValues();
          case "maxElementsOnTitle": return getMaxElementsOnTitle();
          case "name": return getName();
          case "allowFilter": return getAllowFilter();
          case "allowClearSelection": return getAllowClearSelection();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("CharacterMultipleSelectorFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "maxDropdownElements": target.setMaxDropdownElements((Integer) value);
          break;
          case "listOfValues": target.setListOfValues((List<Character>) value);
          break;
          case "maxElementsOnTitle": target.setMaxElementsOnTitle((Integer) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "allowFilter": target.setAllowFilter((Boolean) value);
          break;
          case "allowClearSelection": target.setAllowClearSelection((Boolean) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (CharacterMultipleSelectorFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CharacterMultipleSelectorFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(CharacterMultipleSelectorFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy((CharacterMultipleSelectorFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_CharacterMultipleSelectorFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy extends ProcessData implements BindableProxy {
      private BindableProxyAgent<ProcessData> agent;
      private ProcessData target;
      public org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy() {
        this(new ProcessData());
      }

      public org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy(ProcessData targetVal) {
        agent = new BindableProxyAgent<ProcessData>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("processVariables", new PropertyType(ProcessVariables.class, true, false));
        p.put("this", new PropertyType(ProcessData.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ProcessData unwrap() {
        return target;
      }

      public ProcessData deepUnwrap() {
        final ProcessData clone = new ProcessData();
        final ProcessData t = unwrap();
        if (t.getProcessVariables() instanceof BindableProxy) {
          clone.setProcessVariables((ProcessVariables) ((BindableProxy) getProcessVariables()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getProcessVariables())) {
          clone.setProcessVariables((ProcessVariables) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getProcessVariables())).deepUnwrap());
        } else {
          clone.setProcessVariables(t.getProcessVariables());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy) {
          obj = ((org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public ProcessVariables getProcessVariables() {
        return target.getProcessVariables();
      }

      public void setProcessVariables(ProcessVariables processVariables) {
        if (agent.binders.containsKey("processVariables")) {
          processVariables = (ProcessVariables) agent.binders.get("processVariables").setModel(processVariables, StateSync.FROM_MODEL, true);
        }
        changeAndFire("processVariables", processVariables);
      }

      public Object get(String property) {
        switch (property) {
          case "processVariables": return getProcessVariables();
          case "this": return target;
          default: throw new NonExistingPropertyException("ProcessData", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "processVariables": target.setProcessVariables((ProcessVariables) value);
          break;
          case "this": target = (ProcessData) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ProcessData", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ProcessData.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy((ProcessData) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessDataProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy extends RectangleDimensionsSet implements BindableProxy {
      private BindableProxyAgent<RectangleDimensionsSet> agent;
      private RectangleDimensionsSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy() {
        this(new RectangleDimensionsSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy(RectangleDimensionsSet targetVal) {
        agent = new BindableProxyAgent<RectangleDimensionsSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("width", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width.class, true, false));
        p.put("height", new PropertyType(Height.class, true, false));
        p.put("this", new PropertyType(RectangleDimensionsSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public RectangleDimensionsSet unwrap() {
        return target;
      }

      public RectangleDimensionsSet deepUnwrap() {
        final RectangleDimensionsSet clone = new RectangleDimensionsSet();
        final RectangleDimensionsSet t = unwrap();
        if (t.getWidth() instanceof BindableProxy) {
          clone.setWidth((org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width) ((BindableProxy) getWidth()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getWidth())) {
          clone.setWidth((org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getWidth())).deepUnwrap());
        } else {
          clone.setWidth(t.getWidth());
        }
        if (t.getHeight() instanceof BindableProxy) {
          clone.setHeight((Height) ((BindableProxy) getHeight()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getHeight())) {
          clone.setHeight((Height) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getHeight())).deepUnwrap());
        } else {
          clone.setHeight(t.getHeight());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width getWidth() {
        return target.getWidth();
      }

      public void setWidth(org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width width) {
        if (agent.binders.containsKey("width")) {
          width = (org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width) agent.binders.get("width").setModel(width, StateSync.FROM_MODEL, true);
        }
        changeAndFire("width", width);
      }

      public Height getHeight() {
        return target.getHeight();
      }

      public void setHeight(Height height) {
        if (agent.binders.containsKey("height")) {
          height = (Height) agent.binders.get("height").setModel(height, StateSync.FROM_MODEL, true);
        }
        changeAndFire("height", height);
      }

      public Object get(String property) {
        switch (property) {
          case "width": return getWidth();
          case "height": return getHeight();
          case "this": return target;
          default: throw new NonExistingPropertyException("RectangleDimensionsSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "width": target.setWidth((org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.Width) value);
          break;
          case "height": target.setHeight((Height) value);
          break;
          case "this": target = (RectangleDimensionsSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("RectangleDimensionsSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(RectangleDimensionsSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy((RectangleDimensionsSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_RectangleDimensionsSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy extends ImportsFieldDefinition implements BindableProxy {
      private BindableProxyAgent<ImportsFieldDefinition> agent;
      private ImportsFieldDefinition target;
      public org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy() {
        this(new ImportsFieldDefinition());
      }

      public org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy(ImportsFieldDefinition targetVal) {
        agent = new BindableProxyAgent<ImportsFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(ImportsFieldType.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ImportsFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ImportsFieldDefinition unwrap() {
        return target;
      }

      public ImportsFieldDefinition deepUnwrap() {
        final ImportsFieldDefinition clone = new ImportsFieldDefinition();
        final ImportsFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setName(t.getName());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setId(t.getId());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public ImportsFieldType getFieldType() {
        return target.getFieldType();
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "name": return getName();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "id": return getId();
          case "label": return getLabel();
          case "fieldType": return getFieldType();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "this": return target;
          default: throw new NonExistingPropertyException("ImportsFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "this": target = (ImportsFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ImportsFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(ImportsFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy((ImportsFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_ImportsFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy extends GenericServiceTaskExecutionSet implements BindableProxy {
      private BindableProxyAgent<GenericServiceTaskExecutionSet> agent;
      private GenericServiceTaskExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy() {
        this(new GenericServiceTaskExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy(GenericServiceTaskExecutionSet targetVal) {
        agent = new BindableProxyAgent<GenericServiceTaskExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("isAsync", new PropertyType(IsAsync.class, true, false));
        p.put("multipleInstanceDataOutput", new PropertyType(MultipleInstanceDataOutput.class, true, false));
        p.put("onEntryAction", new PropertyType(OnEntryAction.class, true, false));
        p.put("multipleInstanceCollectionInput", new PropertyType(MultipleInstanceCollectionInput.class, true, false));
        p.put("multipleInstanceCollectionOutput", new PropertyType(MultipleInstanceCollectionOutput.class, true, false));
        p.put("multipleInstanceDataInput", new PropertyType(MultipleInstanceDataInput.class, true, false));
        p.put("adHocAutostart", new PropertyType(AdHocAutostart.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("genericServiceTaskInfo", new PropertyType(GenericServiceTaskInfo.class, true, false));
        p.put("assignmentsinfo", new PropertyType(AssignmentsInfo.class, true, false));
        p.put("isMultipleInstance", new PropertyType(IsMultipleInstance.class, true, false));
        p.put("multipleInstanceCompletionCondition", new PropertyType(MultipleInstanceCompletionCondition.class, true, false));
        p.put("onExitAction", new PropertyType(OnExitAction.class, true, false));
        p.put("multipleInstanceExecutionMode", new PropertyType(MultipleInstanceExecutionMode.class, true, false));
        p.put("this", new PropertyType(GenericServiceTaskExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public GenericServiceTaskExecutionSet unwrap() {
        return target;
      }

      public GenericServiceTaskExecutionSet deepUnwrap() {
        final GenericServiceTaskExecutionSet clone = new GenericServiceTaskExecutionSet();
        final GenericServiceTaskExecutionSet t = unwrap();
        if (t.getIsAsync() instanceof BindableProxy) {
          clone.setIsAsync((IsAsync) ((BindableProxy) getIsAsync()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsAsync())) {
          clone.setIsAsync((IsAsync) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsAsync())).deepUnwrap());
        } else {
          clone.setIsAsync(t.getIsAsync());
        }
        if (t.getMultipleInstanceDataOutput() instanceof BindableProxy) {
          clone.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) ((BindableProxy) getMultipleInstanceDataOutput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceDataOutput())) {
          clone.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceDataOutput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceDataOutput(t.getMultipleInstanceDataOutput());
        }
        if (t.getOnEntryAction() instanceof BindableProxy) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) getOnEntryAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnEntryAction())) {
          clone.setOnEntryAction((OnEntryAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnEntryAction())).deepUnwrap());
        } else {
          clone.setOnEntryAction(t.getOnEntryAction());
        }
        if (t.getMultipleInstanceCollectionInput() instanceof BindableProxy) {
          clone.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) ((BindableProxy) getMultipleInstanceCollectionInput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCollectionInput())) {
          clone.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCollectionInput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCollectionInput(t.getMultipleInstanceCollectionInput());
        }
        if (t.getMultipleInstanceCollectionOutput() instanceof BindableProxy) {
          clone.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) ((BindableProxy) getMultipleInstanceCollectionOutput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCollectionOutput())) {
          clone.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCollectionOutput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCollectionOutput(t.getMultipleInstanceCollectionOutput());
        }
        if (t.getMultipleInstanceDataInput() instanceof BindableProxy) {
          clone.setMultipleInstanceDataInput((MultipleInstanceDataInput) ((BindableProxy) getMultipleInstanceDataInput()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceDataInput())) {
          clone.setMultipleInstanceDataInput((MultipleInstanceDataInput) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceDataInput())).deepUnwrap());
        } else {
          clone.setMultipleInstanceDataInput(t.getMultipleInstanceDataInput());
        }
        if (t.getAdHocAutostart() instanceof BindableProxy) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) getAdHocAutostart()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAdHocAutostart())) {
          clone.setAdHocAutostart((AdHocAutostart) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAdHocAutostart())).deepUnwrap());
        } else {
          clone.setAdHocAutostart(t.getAdHocAutostart());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        if (t.getGenericServiceTaskInfo() instanceof BindableProxy) {
          clone.setGenericServiceTaskInfo((GenericServiceTaskInfo) ((BindableProxy) getGenericServiceTaskInfo()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGenericServiceTaskInfo())) {
          clone.setGenericServiceTaskInfo((GenericServiceTaskInfo) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGenericServiceTaskInfo())).deepUnwrap());
        } else {
          clone.setGenericServiceTaskInfo(t.getGenericServiceTaskInfo());
        }
        if (t.getAssignmentsinfo() instanceof BindableProxy) {
          clone.setAssignmentsinfo((AssignmentsInfo) ((BindableProxy) getAssignmentsinfo()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getAssignmentsinfo())) {
          clone.setAssignmentsinfo((AssignmentsInfo) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getAssignmentsinfo())).deepUnwrap());
        } else {
          clone.setAssignmentsinfo(t.getAssignmentsinfo());
        }
        if (t.getIsMultipleInstance() instanceof BindableProxy) {
          clone.setIsMultipleInstance((IsMultipleInstance) ((BindableProxy) getIsMultipleInstance()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsMultipleInstance())) {
          clone.setIsMultipleInstance((IsMultipleInstance) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsMultipleInstance())).deepUnwrap());
        } else {
          clone.setIsMultipleInstance(t.getIsMultipleInstance());
        }
        if (t.getMultipleInstanceCompletionCondition() instanceof BindableProxy) {
          clone.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) ((BindableProxy) getMultipleInstanceCompletionCondition()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceCompletionCondition())) {
          clone.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceCompletionCondition())).deepUnwrap());
        } else {
          clone.setMultipleInstanceCompletionCondition(t.getMultipleInstanceCompletionCondition());
        }
        if (t.getOnExitAction() instanceof BindableProxy) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) getOnExitAction()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getOnExitAction())) {
          clone.setOnExitAction((OnExitAction) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getOnExitAction())).deepUnwrap());
        } else {
          clone.setOnExitAction(t.getOnExitAction());
        }
        if (t.getMultipleInstanceExecutionMode() instanceof BindableProxy) {
          clone.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) ((BindableProxy) getMultipleInstanceExecutionMode()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMultipleInstanceExecutionMode())) {
          clone.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMultipleInstanceExecutionMode())).deepUnwrap());
        } else {
          clone.setMultipleInstanceExecutionMode(t.getMultipleInstanceExecutionMode());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public IsAsync getIsAsync() {
        return target.getIsAsync();
      }

      public void setIsAsync(IsAsync isAsync) {
        if (agent.binders.containsKey("isAsync")) {
          isAsync = (IsAsync) agent.binders.get("isAsync").setModel(isAsync, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isAsync", isAsync);
      }

      public MultipleInstanceDataOutput getMultipleInstanceDataOutput() {
        return target.getMultipleInstanceDataOutput();
      }

      public void setMultipleInstanceDataOutput(MultipleInstanceDataOutput multipleInstanceDataOutput) {
        if (agent.binders.containsKey("multipleInstanceDataOutput")) {
          multipleInstanceDataOutput = (MultipleInstanceDataOutput) agent.binders.get("multipleInstanceDataOutput").setModel(multipleInstanceDataOutput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceDataOutput", multipleInstanceDataOutput);
      }

      public OnEntryAction getOnEntryAction() {
        return target.getOnEntryAction();
      }

      public void setOnEntryAction(OnEntryAction onEntryAction) {
        if (agent.binders.containsKey("onEntryAction")) {
          onEntryAction = (OnEntryAction) agent.binders.get("onEntryAction").setModel(onEntryAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onEntryAction", onEntryAction);
      }

      public MultipleInstanceCollectionInput getMultipleInstanceCollectionInput() {
        return target.getMultipleInstanceCollectionInput();
      }

      public void setMultipleInstanceCollectionInput(MultipleInstanceCollectionInput multipleInstanceCollectionInput) {
        if (agent.binders.containsKey("multipleInstanceCollectionInput")) {
          multipleInstanceCollectionInput = (MultipleInstanceCollectionInput) agent.binders.get("multipleInstanceCollectionInput").setModel(multipleInstanceCollectionInput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCollectionInput", multipleInstanceCollectionInput);
      }

      public MultipleInstanceCollectionOutput getMultipleInstanceCollectionOutput() {
        return target.getMultipleInstanceCollectionOutput();
      }

      public void setMultipleInstanceCollectionOutput(MultipleInstanceCollectionOutput multipleInstanceCollectionOutput) {
        if (agent.binders.containsKey("multipleInstanceCollectionOutput")) {
          multipleInstanceCollectionOutput = (MultipleInstanceCollectionOutput) agent.binders.get("multipleInstanceCollectionOutput").setModel(multipleInstanceCollectionOutput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCollectionOutput", multipleInstanceCollectionOutput);
      }

      public MultipleInstanceDataInput getMultipleInstanceDataInput() {
        return target.getMultipleInstanceDataInput();
      }

      public void setMultipleInstanceDataInput(MultipleInstanceDataInput multipleInstanceDataInput) {
        if (agent.binders.containsKey("multipleInstanceDataInput")) {
          multipleInstanceDataInput = (MultipleInstanceDataInput) agent.binders.get("multipleInstanceDataInput").setModel(multipleInstanceDataInput, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceDataInput", multipleInstanceDataInput);
      }

      public AdHocAutostart getAdHocAutostart() {
        return target.getAdHocAutostart();
      }

      public void setAdHocAutostart(AdHocAutostart adHocAutostart) {
        if (agent.binders.containsKey("adHocAutostart")) {
          adHocAutostart = (AdHocAutostart) agent.binders.get("adHocAutostart").setModel(adHocAutostart, StateSync.FROM_MODEL, true);
        }
        changeAndFire("adHocAutostart", adHocAutostart);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public GenericServiceTaskInfo getGenericServiceTaskInfo() {
        return target.getGenericServiceTaskInfo();
      }

      public void setGenericServiceTaskInfo(GenericServiceTaskInfo genericServiceTaskInfo) {
        if (agent.binders.containsKey("genericServiceTaskInfo")) {
          genericServiceTaskInfo = (GenericServiceTaskInfo) agent.binders.get("genericServiceTaskInfo").setModel(genericServiceTaskInfo, StateSync.FROM_MODEL, true);
        }
        changeAndFire("genericServiceTaskInfo", genericServiceTaskInfo);
      }

      public AssignmentsInfo getAssignmentsinfo() {
        return target.getAssignmentsinfo();
      }

      public void setAssignmentsinfo(AssignmentsInfo assignmentsinfo) {
        if (agent.binders.containsKey("assignmentsinfo")) {
          assignmentsinfo = (AssignmentsInfo) agent.binders.get("assignmentsinfo").setModel(assignmentsinfo, StateSync.FROM_MODEL, true);
        }
        changeAndFire("assignmentsinfo", assignmentsinfo);
      }

      public IsMultipleInstance getIsMultipleInstance() {
        return target.getIsMultipleInstance();
      }

      public void setIsMultipleInstance(IsMultipleInstance isMultipleInstance) {
        if (agent.binders.containsKey("isMultipleInstance")) {
          isMultipleInstance = (IsMultipleInstance) agent.binders.get("isMultipleInstance").setModel(isMultipleInstance, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isMultipleInstance", isMultipleInstance);
      }

      public MultipleInstanceCompletionCondition getMultipleInstanceCompletionCondition() {
        return target.getMultipleInstanceCompletionCondition();
      }

      public void setMultipleInstanceCompletionCondition(MultipleInstanceCompletionCondition multipleInstanceCompletionCondition) {
        if (agent.binders.containsKey("multipleInstanceCompletionCondition")) {
          multipleInstanceCompletionCondition = (MultipleInstanceCompletionCondition) agent.binders.get("multipleInstanceCompletionCondition").setModel(multipleInstanceCompletionCondition, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceCompletionCondition", multipleInstanceCompletionCondition);
      }

      public OnExitAction getOnExitAction() {
        return target.getOnExitAction();
      }

      public void setOnExitAction(OnExitAction onExitAction) {
        if (agent.binders.containsKey("onExitAction")) {
          onExitAction = (OnExitAction) agent.binders.get("onExitAction").setModel(onExitAction, StateSync.FROM_MODEL, true);
        }
        changeAndFire("onExitAction", onExitAction);
      }

      public MultipleInstanceExecutionMode getMultipleInstanceExecutionMode() {
        return target.getMultipleInstanceExecutionMode();
      }

      public void setMultipleInstanceExecutionMode(MultipleInstanceExecutionMode multipleInstanceExecutionMode) {
        if (agent.binders.containsKey("multipleInstanceExecutionMode")) {
          multipleInstanceExecutionMode = (MultipleInstanceExecutionMode) agent.binders.get("multipleInstanceExecutionMode").setModel(multipleInstanceExecutionMode, StateSync.FROM_MODEL, true);
        }
        changeAndFire("multipleInstanceExecutionMode", multipleInstanceExecutionMode);
      }

      public Object get(String property) {
        switch (property) {
          case "isAsync": return getIsAsync();
          case "multipleInstanceDataOutput": return getMultipleInstanceDataOutput();
          case "onEntryAction": return getOnEntryAction();
          case "multipleInstanceCollectionInput": return getMultipleInstanceCollectionInput();
          case "multipleInstanceCollectionOutput": return getMultipleInstanceCollectionOutput();
          case "multipleInstanceDataInput": return getMultipleInstanceDataInput();
          case "adHocAutostart": return getAdHocAutostart();
          case "slaDueDate": return getSlaDueDate();
          case "genericServiceTaskInfo": return getGenericServiceTaskInfo();
          case "assignmentsinfo": return getAssignmentsinfo();
          case "isMultipleInstance": return getIsMultipleInstance();
          case "multipleInstanceCompletionCondition": return getMultipleInstanceCompletionCondition();
          case "onExitAction": return getOnExitAction();
          case "multipleInstanceExecutionMode": return getMultipleInstanceExecutionMode();
          case "this": return target;
          default: throw new NonExistingPropertyException("GenericServiceTaskExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "isAsync": target.setIsAsync((IsAsync) value);
          break;
          case "multipleInstanceDataOutput": target.setMultipleInstanceDataOutput((MultipleInstanceDataOutput) value);
          break;
          case "onEntryAction": target.setOnEntryAction((OnEntryAction) value);
          break;
          case "multipleInstanceCollectionInput": target.setMultipleInstanceCollectionInput((MultipleInstanceCollectionInput) value);
          break;
          case "multipleInstanceCollectionOutput": target.setMultipleInstanceCollectionOutput((MultipleInstanceCollectionOutput) value);
          break;
          case "multipleInstanceDataInput": target.setMultipleInstanceDataInput((MultipleInstanceDataInput) value);
          break;
          case "adHocAutostart": target.setAdHocAutostart((AdHocAutostart) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "genericServiceTaskInfo": target.setGenericServiceTaskInfo((GenericServiceTaskInfo) value);
          break;
          case "assignmentsinfo": target.setAssignmentsinfo((AssignmentsInfo) value);
          break;
          case "isMultipleInstance": target.setIsMultipleInstance((IsMultipleInstance) value);
          break;
          case "multipleInstanceCompletionCondition": target.setMultipleInstanceCompletionCondition((MultipleInstanceCompletionCondition) value);
          break;
          case "onExitAction": target.setOnExitAction((OnExitAction) value);
          break;
          case "multipleInstanceExecutionMode": target.setMultipleInstanceExecutionMode((MultipleInstanceExecutionMode) value);
          break;
          case "this": target = (GenericServiceTaskExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("GenericServiceTaskExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(GenericServiceTaskExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy((GenericServiceTaskExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_service_GenericServiceTaskExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy extends StringMultipleSelectorFieldDefinition implements BindableProxy {
      private BindableProxyAgent<StringMultipleSelectorFieldDefinition> agent;
      private StringMultipleSelectorFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy() {
        this(new StringMultipleSelectorFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy(StringMultipleSelectorFieldDefinition targetVal) {
        agent = new BindableProxyAgent<StringMultipleSelectorFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("maxDropdownElements", new PropertyType(Integer.class, false, false));
        p.put("listOfValues", new PropertyType(List.class, false, true));
        p.put("maxElementsOnTitle", new PropertyType(Integer.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("allowFilter", new PropertyType(Boolean.class, false, false));
        p.put("allowClearSelection", new PropertyType(Boolean.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(FieldType.class, false, false));
        p.put("this", new PropertyType(StringMultipleSelectorFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public StringMultipleSelectorFieldDefinition unwrap() {
        return target;
      }

      public StringMultipleSelectorFieldDefinition deepUnwrap() {
        final StringMultipleSelectorFieldDefinition clone = new StringMultipleSelectorFieldDefinition();
        final StringMultipleSelectorFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setMaxDropdownElements(t.getMaxDropdownElements());
        if (t.getListOfValues() != null) {
          final List listOfValuesClone = new ArrayList();
          for (Object listOfValuesElem : t.getListOfValues()) {
            if (listOfValuesElem instanceof BindableProxy) {
              listOfValuesClone.add(((BindableProxy) listOfValuesElem).deepUnwrap());
            } else {
              listOfValuesClone.add(listOfValuesElem);
            }
          }
          clone.setListOfValues(listOfValuesClone);
        }
        clone.setMaxElementsOnTitle(t.getMaxElementsOnTitle());
        clone.setName(t.getName());
        clone.setAllowFilter(t.getAllowFilter());
        clone.setAllowClearSelection(t.getAllowClearSelection());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Integer getMaxDropdownElements() {
        return target.getMaxDropdownElements();
      }

      public void setMaxDropdownElements(Integer maxDropdownElements) {
        changeAndFire("maxDropdownElements", maxDropdownElements);
      }

      public List getListOfValues() {
        return target.getListOfValues();
      }

      public void setListOfValues(List<String> listOfValues) {
        List<String> oldValue = target.getListOfValues();
        listOfValues = agent.ensureBoundListIsProxied("listOfValues", listOfValues);
        target.setListOfValues(listOfValues);
        agent.updateWidgetsAndFireEvent(true, "listOfValues", oldValue, listOfValues);
      }

      public Integer getMaxElementsOnTitle() {
        return target.getMaxElementsOnTitle();
      }

      public void setMaxElementsOnTitle(Integer maxElementsOnTitle) {
        changeAndFire("maxElementsOnTitle", maxElementsOnTitle);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public Boolean getAllowFilter() {
        return target.getAllowFilter();
      }

      public void setAllowFilter(Boolean allowFilter) {
        changeAndFire("allowFilter", allowFilter);
      }

      public Boolean getAllowClearSelection() {
        return target.getAllowClearSelection();
      }

      public void setAllowClearSelection(Boolean allowClearSelection) {
        changeAndFire("allowClearSelection", allowClearSelection);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public FieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "maxDropdownElements": return getMaxDropdownElements();
          case "listOfValues": return getListOfValues();
          case "maxElementsOnTitle": return getMaxElementsOnTitle();
          case "name": return getName();
          case "allowFilter": return getAllowFilter();
          case "allowClearSelection": return getAllowClearSelection();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("StringMultipleSelectorFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "maxDropdownElements": target.setMaxDropdownElements((Integer) value);
          break;
          case "listOfValues": target.setListOfValues((List<String>) value);
          break;
          case "maxElementsOnTitle": target.setMaxElementsOnTitle((Integer) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "allowFilter": target.setAllowFilter((Boolean) value);
          break;
          case "allowClearSelection": target.setAllowClearSelection((Boolean) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (StringMultipleSelectorFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("StringMultipleSelectorFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(StringMultipleSelectorFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy((StringMultipleSelectorFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_lists_selector_impl_StringMultipleSelectorFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy extends ColorPickerFieldDefinition implements BindableProxy {
      private BindableProxyAgent<ColorPickerFieldDefinition> agent;
      private ColorPickerFieldDefinition target;
      public org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy() {
        this(new ColorPickerFieldDefinition());
      }

      public org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy(ColorPickerFieldDefinition targetVal) {
        agent = new BindableProxyAgent<ColorPickerFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("defaultValue", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(ColorPickerFieldType.class, false, false));
        p.put("this", new PropertyType(ColorPickerFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ColorPickerFieldDefinition unwrap() {
        return target;
      }

      public ColorPickerFieldDefinition deepUnwrap() {
        final ColorPickerFieldDefinition clone = new ColorPickerFieldDefinition();
        final ColorPickerFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setDefaultValue(t.getDefaultValue());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getDefaultValue() {
        return target.getDefaultValue();
      }

      public void setDefaultValue(String defaultValue) {
        changeAndFire("defaultValue", defaultValue);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public ColorPickerFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "defaultValue": return getDefaultValue();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("ColorPickerFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "defaultValue": target.setDefaultValue((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (ColorPickerFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ColorPickerFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(ColorPickerFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy((ColorPickerFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_forms_model_ColorPickerFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy extends FontSet implements BindableProxy {
      private BindableProxyAgent<FontSet> agent;
      private FontSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy() {
        this(new FontSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy(FontSet targetVal) {
        agent = new BindableProxyAgent<FontSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("fontFamily", new PropertyType(FontFamily.class, true, false));
        p.put("fontBorderSize", new PropertyType(FontBorderSize.class, true, false));
        p.put("fontBorderColor", new PropertyType(FontBorderColor.class, true, false));
        p.put("fontSize", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize.class, true, false));
        p.put("fontColor", new PropertyType(FontColor.class, true, false));
        p.put("this", new PropertyType(FontSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public FontSet unwrap() {
        return target;
      }

      public FontSet deepUnwrap() {
        final FontSet clone = new FontSet();
        final FontSet t = unwrap();
        if (t.getFontFamily() instanceof BindableProxy) {
          clone.setFontFamily((FontFamily) ((BindableProxy) getFontFamily()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontFamily())) {
          clone.setFontFamily((FontFamily) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontFamily())).deepUnwrap());
        } else {
          clone.setFontFamily(t.getFontFamily());
        }
        if (t.getFontBorderSize() instanceof BindableProxy) {
          clone.setFontBorderSize((FontBorderSize) ((BindableProxy) getFontBorderSize()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontBorderSize())) {
          clone.setFontBorderSize((FontBorderSize) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontBorderSize())).deepUnwrap());
        } else {
          clone.setFontBorderSize(t.getFontBorderSize());
        }
        if (t.getFontBorderColor() instanceof BindableProxy) {
          clone.setFontBorderColor((FontBorderColor) ((BindableProxy) getFontBorderColor()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontBorderColor())) {
          clone.setFontBorderColor((FontBorderColor) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontBorderColor())).deepUnwrap());
        } else {
          clone.setFontBorderColor(t.getFontBorderColor());
        }
        if (t.getFontSize() instanceof BindableProxy) {
          clone.setFontSize((org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize) ((BindableProxy) getFontSize()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSize())) {
          clone.setFontSize((org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSize())).deepUnwrap());
        } else {
          clone.setFontSize(t.getFontSize());
        }
        if (t.getFontColor() instanceof BindableProxy) {
          clone.setFontColor((FontColor) ((BindableProxy) getFontColor()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontColor())) {
          clone.setFontColor((FontColor) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontColor())).deepUnwrap());
        } else {
          clone.setFontColor(t.getFontColor());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public FontFamily getFontFamily() {
        return target.getFontFamily();
      }

      public void setFontFamily(FontFamily fontFamily) {
        if (agent.binders.containsKey("fontFamily")) {
          fontFamily = (FontFamily) agent.binders.get("fontFamily").setModel(fontFamily, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontFamily", fontFamily);
      }

      public FontBorderSize getFontBorderSize() {
        return target.getFontBorderSize();
      }

      public void setFontBorderSize(FontBorderSize fontBorderSize) {
        if (agent.binders.containsKey("fontBorderSize")) {
          fontBorderSize = (FontBorderSize) agent.binders.get("fontBorderSize").setModel(fontBorderSize, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontBorderSize", fontBorderSize);
      }

      public FontBorderColor getFontBorderColor() {
        return target.getFontBorderColor();
      }

      public void setFontBorderColor(FontBorderColor fontBorderColor) {
        if (agent.binders.containsKey("fontBorderColor")) {
          fontBorderColor = (FontBorderColor) agent.binders.get("fontBorderColor").setModel(fontBorderColor, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontBorderColor", fontBorderColor);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize getFontSize() {
        return target.getFontSize();
      }

      public void setFontSize(org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize fontSize) {
        if (agent.binders.containsKey("fontSize")) {
          fontSize = (org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize) agent.binders.get("fontSize").setModel(fontSize, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSize", fontSize);
      }

      public FontColor getFontColor() {
        return target.getFontColor();
      }

      public void setFontColor(FontColor fontColor) {
        if (agent.binders.containsKey("fontColor")) {
          fontColor = (FontColor) agent.binders.get("fontColor").setModel(fontColor, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontColor", fontColor);
      }

      public Object get(String property) {
        switch (property) {
          case "fontFamily": return getFontFamily();
          case "fontBorderSize": return getFontBorderSize();
          case "fontBorderColor": return getFontBorderColor();
          case "fontSize": return getFontSize();
          case "fontColor": return getFontColor();
          case "this": return target;
          default: throw new NonExistingPropertyException("FontSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "fontFamily": target.setFontFamily((FontFamily) value);
          break;
          case "fontBorderSize": target.setFontBorderSize((FontBorderSize) value);
          break;
          case "fontBorderColor": target.setFontBorderColor((FontBorderColor) value);
          break;
          case "fontSize": target.setFontSize((org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSize) value);
          break;
          case "fontColor": target.setFontColor((FontColor) value);
          break;
          case "this": target = (FontSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("FontSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(FontSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy((FontSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_font_FontSetProxy();
      }
    });
    class org_jbpm_workbench_es_model_RequestParameterSummaryProxy extends RequestParameterSummary implements BindableProxy {
      private BindableProxyAgent<RequestParameterSummary> agent;
      private RequestParameterSummary target;
      public org_jbpm_workbench_es_model_RequestParameterSummaryProxy() {
        this(new RequestParameterSummary());
      }

      public org_jbpm_workbench_es_model_RequestParameterSummaryProxy(RequestParameterSummary targetVal) {
        agent = new BindableProxyAgent<RequestParameterSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("name", new PropertyType(String.class, false, false));
        p.put("callbacks", new PropertyType(List.class, false, true));
        p.put("id", new PropertyType(Object.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("key", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(RequestParameterSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public RequestParameterSummary unwrap() {
        return target;
      }

      public RequestParameterSummary deepUnwrap() {
        final RequestParameterSummary clone = new RequestParameterSummary();
        final RequestParameterSummary t = unwrap();
        clone.setName(t.getName());
        if (t.getCallbacks() != null) {
          final List callbacksClone = new ArrayList();
          for (Object callbacksElem : t.getCallbacks()) {
            if (callbacksElem instanceof BindableProxy) {
              callbacksClone.add(((BindableProxy) callbacksElem).deepUnwrap());
            } else {
              callbacksClone.add(callbacksElem);
            }
          }
          clone.setCallbacks(callbacksClone);
        }
        clone.setId(t.getId());
        clone.setValue(t.getValue());
        clone.setKey(t.getKey());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_es_model_RequestParameterSummaryProxy) {
          obj = ((org_jbpm_workbench_es_model_RequestParameterSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public List getCallbacks() {
        return target.getCallbacks();
      }

      public void setCallbacks(List callbacks) {
        List oldValue = target.getCallbacks();
        callbacks = agent.ensureBoundListIsProxied("callbacks", callbacks);
        target.setCallbacks(callbacks);
        agent.updateWidgetsAndFireEvent(true, "callbacks", oldValue, callbacks);
      }

      public Object getId() {
        return target.getId();
      }

      public void setId(Object id) {
        changeAndFire("id", id);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public String getKey() {
        return target.getKey();
      }

      public void setKey(String key) {
        changeAndFire("key", key);
      }

      public Object get(String property) {
        switch (property) {
          case "name": return getName();
          case "callbacks": return getCallbacks();
          case "id": return getId();
          case "value": return getValue();
          case "key": return getKey();
          case "this": return target;
          default: throw new NonExistingPropertyException("RequestParameterSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "name": target.setName((String) value);
          break;
          case "callbacks": target.setCallbacks((List) value);
          break;
          case "id": target.setId(value);
          break;
          case "value": target.setValue((String) value);
          break;
          case "key": target.setKey((String) value);
          break;
          case "this": target = (RequestParameterSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("RequestParameterSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasCallbacks() {
        final boolean returnValue = target.hasCallbacks();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void addCallback(String a0, Command a1) {
        target.addCallback(a0, a1);
        agent.updateWidgetsAndFireEvents();
      }

      public int compareTo(AbstractPageRow a0) {
        final int returnValue = target.compareTo(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(RequestParameterSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_es_model_RequestParameterSummaryProxy((RequestParameterSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_es_model_RequestParameterSummaryProxy();
      }
    });
    class org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy extends ProcessVariables implements BindableProxy {
      private BindableProxyAgent<ProcessVariables> agent;
      private ProcessVariables target;
      public org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy() {
        this(new ProcessVariables());
      }

      public org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy(ProcessVariables targetVal) {
        agent = new BindableProxyAgent<ProcessVariables>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ProcessVariables.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ProcessVariables unwrap() {
        return target;
      }

      public ProcessVariables deepUnwrap() {
        final ProcessVariables clone = new ProcessVariables();
        final ProcessVariables t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy) {
          obj = ((org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("ProcessVariables", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (ProcessVariables) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ProcessVariables", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ProcessVariables.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy((ProcessVariables) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_cm_definition_property_variables_ProcessVariablesProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy extends DefaultImport implements BindableProxy {
      private BindableProxyAgent<DefaultImport> agent;
      private DefaultImport target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy() {
        this(new DefaultImport());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy(DefaultImport targetVal) {
        agent = new BindableProxyAgent<DefaultImport>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("className", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(DefaultImport.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DefaultImport unwrap() {
        return target;
      }

      public DefaultImport deepUnwrap() {
        final DefaultImport clone = new DefaultImport();
        final DefaultImport t = unwrap();
        clone.setClassName(t.getClassName());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getClassName() {
        return target.getClassName();
      }

      public void setClassName(String className) {
        changeAndFire("className", className);
      }

      public Object get(String property) {
        switch (property) {
          case "className": return getClassName();
          case "this": return target;
          default: throw new NonExistingPropertyException("DefaultImport", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "className": target.setClassName((String) value);
          break;
          case "this": target = (DefaultImport) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DefaultImport", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(DefaultImport.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy((DefaultImport) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_diagram_imports_DefaultImportProxy();
      }
    });
    class org_jbpm_workbench_ht_model_CommentSummaryProxy extends CommentSummary implements BindableProxy {
      private BindableProxyAgent<CommentSummary> agent;
      private CommentSummary target;
      public org_jbpm_workbench_ht_model_CommentSummaryProxy() {
        this(new CommentSummary());
      }

      public org_jbpm_workbench_ht_model_CommentSummaryProxy(CommentSummary targetVal) {
        agent = new BindableProxyAgent<CommentSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("addedAt", new PropertyType(Date.class, false, false));
        p.put("addedBy", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("text", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(CommentSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CommentSummary unwrap() {
        return target;
      }

      public CommentSummary deepUnwrap() {
        final CommentSummary clone = new CommentSummary();
        final CommentSummary t = unwrap();
        clone.setAddedAt(t.getAddedAt());
        clone.setAddedBy(t.getAddedBy());
        clone.setId(t.getId());
        clone.setText(t.getText());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_ht_model_CommentSummaryProxy) {
          obj = ((org_jbpm_workbench_ht_model_CommentSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Date getAddedAt() {
        return target.getAddedAt();
      }

      public void setAddedAt(Date addedAt) {
        changeAndFire("addedAt", addedAt);
      }

      public String getAddedBy() {
        return target.getAddedBy();
      }

      public void setAddedBy(String addedBy) {
        changeAndFire("addedBy", addedBy);
      }

      public Long getId() {
        return target.getId();
      }

      public void setId(Long id) {
        changeAndFire("id", id);
      }

      public String getText() {
        return target.getText();
      }

      public void setText(String text) {
        changeAndFire("text", text);
      }

      public Object get(String property) {
        switch (property) {
          case "addedAt": return getAddedAt();
          case "addedBy": return getAddedBy();
          case "id": return getId();
          case "text": return getText();
          case "this": return target;
          default: throw new NonExistingPropertyException("CommentSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "addedAt": target.setAddedAt((Date) value);
          break;
          case "addedBy": target.setAddedBy((String) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "text": target.setText((String) value);
          break;
          case "this": target = (CommentSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CommentSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CommentSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_ht_model_CommentSummaryProxy((CommentSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_ht_model_CommentSummaryProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy extends EventSubprocess implements BindableProxy {
      private BindableProxyAgent<EventSubprocess> agent;
      private EventSubprocess target;
      public org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy() {
        this(new EventSubprocess());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy(EventSubprocess targetVal) {
        agent = new BindableProxyAgent<EventSubprocess>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("processData", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(EventSubprocessExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(EventSubprocess.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EventSubprocess unwrap() {
        return target;
      }

      public EventSubprocess deepUnwrap() {
        final EventSubprocess clone = new EventSubprocess();
        final EventSubprocess t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getProcessData() instanceof BindableProxy) {
          clone.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) ((BindableProxy) getProcessData()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getProcessData())) {
          clone.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getProcessData())).deepUnwrap());
        } else {
          clone.setProcessData(t.getProcessData());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((EventSubprocessExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((EventSubprocessExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData getProcessData() {
        return target.getProcessData();
      }

      public void setProcessData(org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData processData) {
        if (agent.binders.containsKey("processData")) {
          processData = (org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) agent.binders.get("processData").setModel(processData, StateSync.FROM_MODEL, true);
        }
        changeAndFire("processData", processData);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public EventSubprocessExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(EventSubprocessExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (EventSubprocessExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "simulationSet": return getSimulationSet();
          case "processData": return getProcessData();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("EventSubprocess", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "processData": target.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((EventSubprocessExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (EventSubprocess) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EventSubprocess", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(EventSubprocess.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy((EventSubprocess) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_EventSubprocessProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy extends AssignmentsInfo implements BindableProxy {
      private BindableProxyAgent<AssignmentsInfo> agent;
      private AssignmentsInfo target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy() {
        this(new AssignmentsInfo());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy(AssignmentsInfo targetVal) {
        agent = new BindableProxyAgent<AssignmentsInfo>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(AssignmentsInfo.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AssignmentsInfo unwrap() {
        return target;
      }

      public AssignmentsInfo deepUnwrap() {
        final AssignmentsInfo clone = new AssignmentsInfo();
        final AssignmentsInfo t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("AssignmentsInfo", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (AssignmentsInfo) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AssignmentsInfo", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(AssignmentsInfo.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy((AssignmentsInfo) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dataio_AssignmentsInfoProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy extends MessageRef implements BindableProxy {
      private BindableProxyAgent<MessageRef> agent;
      private MessageRef target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy() {
        this(new MessageRef());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy(MessageRef targetVal) {
        agent = new BindableProxyAgent<MessageRef>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("structure", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(MessageRef.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public MessageRef unwrap() {
        return target;
      }

      public MessageRef deepUnwrap() {
        final MessageRef clone = new MessageRef();
        final MessageRef t = unwrap();
        clone.setValue(t.getValue());
        clone.setStructure(t.getStructure());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public String getStructure() {
        return target.getStructure();
      }

      public void setStructure(String structure) {
        changeAndFire("structure", structure);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "structure": return getStructure();
          case "this": return target;
          default: throw new NonExistingPropertyException("MessageRef", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "structure": target.setStructure((String) value);
          break;
          case "this": target = (MessageRef) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("MessageRef", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(MessageRef.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy((MessageRef) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_message_MessageRefProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy extends ParallelGateway implements BindableProxy {
      private BindableProxyAgent<ParallelGateway> agent;
      private ParallelGateway target;
      public org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy() {
        this(new ParallelGateway());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy(ParallelGateway targetVal) {
        agent = new BindableProxyAgent<ParallelGateway>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(ParallelGateway.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ParallelGateway unwrap() {
        return target;
      }

      public ParallelGateway deepUnwrap() {
        final ParallelGateway clone = new ParallelGateway();
        final ParallelGateway t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "backgroundSet": return getBackgroundSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("ParallelGateway", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (ParallelGateway) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ParallelGateway", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ParallelGateway.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy((ParallelGateway) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_ParallelGatewayProxy();
      }
    });
    class org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy extends ProcessNodeSummary implements BindableProxy {
      private BindableProxyAgent<ProcessNodeSummary> agent;
      private ProcessNodeSummary target;
      public org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy() {
        this(new ProcessNodeSummary());
      }

      public org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy(ProcessNodeSummary targetVal) {
        agent = new BindableProxyAgent<ProcessNodeSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("name", new PropertyType(String.class, false, false));
        p.put("callbacks", new PropertyType(List.class, false, true));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("type", new PropertyType(String.class, false, false));
        p.put("uniqueId", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ProcessNodeSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ProcessNodeSummary unwrap() {
        return target;
      }

      public ProcessNodeSummary deepUnwrap() {
        final ProcessNodeSummary clone = new ProcessNodeSummary();
        final ProcessNodeSummary t = unwrap();
        clone.setName(t.getName());
        if (t.getCallbacks() != null) {
          final List callbacksClone = new ArrayList();
          for (Object callbacksElem : t.getCallbacks()) {
            if (callbacksElem instanceof BindableProxy) {
              callbacksClone.add(((BindableProxy) callbacksElem).deepUnwrap());
            } else {
              callbacksClone.add(callbacksElem);
            }
          }
          clone.setCallbacks(callbacksClone);
        }
        clone.setId(t.getId());
        clone.setType(t.getType());
        clone.setUniqueId(t.getUniqueId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy) {
          obj = ((org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public List getCallbacks() {
        return target.getCallbacks();
      }

      public void setCallbacks(List<LabeledCommand> callbacks) {
        List<LabeledCommand> oldValue = target.getCallbacks();
        callbacks = agent.ensureBoundListIsProxied("callbacks", callbacks);
        target.setCallbacks(callbacks);
        agent.updateWidgetsAndFireEvent(true, "callbacks", oldValue, callbacks);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public Long getId() {
        return target.getId();
      }

      public void setId(Long id) {
        changeAndFire("id", id);
      }

      public String getType() {
        return target.getType();
      }

      public void setType(String type) {
        changeAndFire("type", type);
      }

      public String getUniqueId() {
        return target.getUniqueId();
      }

      public void setUniqueId(String uniqueId) {
        changeAndFire("uniqueId", uniqueId);
      }

      public Object get(String property) {
        switch (property) {
          case "name": return getName();
          case "callbacks": return getCallbacks();
          case "label": return getLabel();
          case "id": return getId();
          case "type": return getType();
          case "uniqueId": return getUniqueId();
          case "this": return target;
          default: throw new NonExistingPropertyException("ProcessNodeSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "name": target.setName((String) value);
          break;
          case "callbacks": target.setCallbacks((List<LabeledCommand>) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "type": target.setType((String) value);
          break;
          case "uniqueId": target.setUniqueId((String) value);
          break;
          case "this": target = (ProcessNodeSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ProcessNodeSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasCallbacks() {
        final boolean returnValue = target.hasCallbacks();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void addCallback(String a0, Command a1) {
        target.addCallback(a0, a1);
        agent.updateWidgetsAndFireEvents();
      }

      public int compareTo(AbstractPageRow a0) {
        final int returnValue = target.compareTo(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(ProcessNodeSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy((ProcessNodeSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_pr_model_ProcessNodeSummaryProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy extends TaskGeneralSet implements BindableProxy {
      private BindableProxyAgent<TaskGeneralSet> agent;
      private TaskGeneralSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy() {
        this(new TaskGeneralSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy(TaskGeneralSet targetVal) {
        agent = new BindableProxyAgent<TaskGeneralSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("documentation", new PropertyType(Documentation.class, true, false));
        p.put("name", new PropertyType(Name.class, true, false));
        p.put("this", new PropertyType(TaskGeneralSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public TaskGeneralSet unwrap() {
        return target;
      }

      public TaskGeneralSet deepUnwrap() {
        final TaskGeneralSet clone = new TaskGeneralSet();
        final TaskGeneralSet t = unwrap();
        if (t.getDocumentation() instanceof BindableProxy) {
          clone.setDocumentation((Documentation) ((BindableProxy) getDocumentation()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDocumentation())) {
          clone.setDocumentation((Documentation) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDocumentation())).deepUnwrap());
        } else {
          clone.setDocumentation(t.getDocumentation());
        }
        if (t.getName() instanceof BindableProxy) {
          clone.setName((Name) ((BindableProxy) getName()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getName())) {
          clone.setName((Name) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getName())).deepUnwrap());
        } else {
          clone.setName(t.getName());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Documentation getDocumentation() {
        return target.getDocumentation();
      }

      public void setDocumentation(Documentation documentation) {
        if (agent.binders.containsKey("documentation")) {
          documentation = (Documentation) agent.binders.get("documentation").setModel(documentation, StateSync.FROM_MODEL, true);
        }
        changeAndFire("documentation", documentation);
      }

      public Name getName() {
        return target.getName();
      }

      public void setName(Name name) {
        if (agent.binders.containsKey("name")) {
          name = (Name) agent.binders.get("name").setModel(name, StateSync.FROM_MODEL, true);
        }
        changeAndFire("name", name);
      }

      public Object get(String property) {
        switch (property) {
          case "documentation": return getDocumentation();
          case "name": return getName();
          case "this": return target;
          default: throw new NonExistingPropertyException("TaskGeneralSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "documentation": target.setDocumentation((Documentation) value);
          break;
          case "name": target.setName((Name) value);
          break;
          case "this": target = (TaskGeneralSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("TaskGeneralSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(TaskGeneralSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy((TaskGeneralSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_general_TaskGeneralSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy extends DistributionType implements BindableProxy {
      private BindableProxyAgent<DistributionType> agent;
      private DistributionType target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy() {
        this(new DistributionType());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy(DistributionType targetVal) {
        agent = new BindableProxyAgent<DistributionType>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(DistributionType.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public DistributionType unwrap() {
        return target;
      }

      public DistributionType deepUnwrap() {
        final DistributionType clone = new DistributionType();
        final DistributionType t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("DistributionType", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (DistributionType) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("DistributionType", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(DistributionType.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy((DistributionType) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_DistributionTypeProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_dmn_NameProxy extends org.kie.workbench.common.dmn.api.property.dmn.Name implements BindableProxy {
      private BindableProxyAgent<org.kie.workbench.common.dmn.api.property.dmn.Name> agent;
      private org.kie.workbench.common.dmn.api.property.dmn.Name target;
      public org_kie_workbench_common_dmn_api_property_dmn_NameProxy() {
        this(new org.kie.workbench.common.dmn.api.property.dmn.Name());
      }

      public org_kie_workbench_common_dmn_api_property_dmn_NameProxy(org.kie.workbench.common.dmn.api.property.dmn.Name targetVal) {
        agent = new BindableProxyAgent<org.kie.workbench.common.dmn.api.property.dmn.Name>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(org.kie.workbench.common.dmn.api.property.dmn.Name.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Name unwrap() {
        return target;
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Name deepUnwrap() {
        final org.kie.workbench.common.dmn.api.property.dmn.Name clone = new org.kie.workbench.common.dmn.api.property.dmn.Name();
        final org.kie.workbench.common.dmn.api.property.dmn.Name t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_dmn_NameProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_dmn_NameProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Name", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (org.kie.workbench.common.dmn.api.property.dmn.Name) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Name", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(org.kie.workbench.common.dmn.api.property.dmn.Name.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_dmn_NameProxy((org.kie.workbench.common.dmn.api.property.dmn.Name) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_dmn_NameProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy extends EmptyTaskExecutionSet implements BindableProxy {
      private BindableProxyAgent<EmptyTaskExecutionSet> agent;
      private EmptyTaskExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy() {
        this(new EmptyTaskExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy(EmptyTaskExecutionSet targetVal) {
        agent = new BindableProxyAgent<EmptyTaskExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("this", new PropertyType(EmptyTaskExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EmptyTaskExecutionSet unwrap() {
        return target;
      }

      public EmptyTaskExecutionSet deepUnwrap() {
        final EmptyTaskExecutionSet clone = new EmptyTaskExecutionSet();
        final EmptyTaskExecutionSet t = unwrap();
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Object get(String property) {
        switch (property) {
          case "this": return target;
          default: throw new NonExistingPropertyException("EmptyTaskExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "this": target = (EmptyTaskExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EmptyTaskExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(EmptyTaskExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy((EmptyTaskExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_EmptyTaskExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy extends StartCompensationEvent implements BindableProxy {
      private BindableProxyAgent<StartCompensationEvent> agent;
      private StartCompensationEvent target;
      public org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy() {
        this(new StartCompensationEvent());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy(StartCompensationEvent targetVal) {
        agent = new BindableProxyAgent<StartCompensationEvent>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationAttributeSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(BaseStartEventExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(StartCompensationEvent.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public StartCompensationEvent unwrap() {
        return target;
      }

      public StartCompensationEvent deepUnwrap() {
        final StartCompensationEvent clone = new StartCompensationEvent();
        final StartCompensationEvent t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationAttributeSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationAttributeSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((BaseStartEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((BaseStartEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public SimulationAttributeSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationAttributeSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationAttributeSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public BaseStartEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(BaseStartEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (BaseStartEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("StartCompensationEvent", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationAttributeSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((BaseStartEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (StartCompensationEvent) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("StartCompensationEvent", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(StartCompensationEvent.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy((StartCompensationEvent) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_StartCompensationEventProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy extends CharacterSelectorOption implements BindableProxy {
      private BindableProxyAgent<CharacterSelectorOption> agent;
      private CharacterSelectorOption target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy() {
        this(new CharacterSelectorOption());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy(CharacterSelectorOption targetVal) {
        agent = new BindableProxyAgent<CharacterSelectorOption>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("text", new PropertyType(String.class, false, false));
        p.put("value", new PropertyType(Character.class, false, false));
        p.put("this", new PropertyType(CharacterSelectorOption.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CharacterSelectorOption unwrap() {
        return target;
      }

      public CharacterSelectorOption deepUnwrap() {
        final CharacterSelectorOption clone = new CharacterSelectorOption();
        final CharacterSelectorOption t = unwrap();
        clone.setText(t.getText());
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getText() {
        return target.getText();
      }

      public void setText(String text) {
        changeAndFire("text", text);
      }

      public Character getValue() {
        return target.getValue();
      }

      public void setValue(Character value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "text": return getText();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("CharacterSelectorOption", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "text": target.setText((String) value);
          break;
          case "value": target.setValue((Character) value);
          break;
          case "this": target = (CharacterSelectorOption) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CharacterSelectorOption", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CharacterSelectorOption.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy((CharacterSelectorOption) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_selectors_CharacterSelectorOptionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy extends Script implements BindableProxy {
      private BindableProxyAgent<Script> agent;
      private Script target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy() {
        this(new Script());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy(Script targetVal) {
        agent = new BindableProxyAgent<Script>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(ScriptTypeValue.class, true, false));
        p.put("this", new PropertyType(Script.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Script unwrap() {
        return target;
      }

      public Script deepUnwrap() {
        final Script clone = new Script();
        final Script t = unwrap();
        if (t.getValue() instanceof BindableProxy) {
          clone.setValue((ScriptTypeValue) ((BindableProxy) getValue()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getValue())) {
          clone.setValue((ScriptTypeValue) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getValue())).deepUnwrap());
        } else {
          clone.setValue(t.getValue());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public ScriptTypeValue getValue() {
        return target.getValue();
      }

      public void setValue(ScriptTypeValue value) {
        if (agent.binders.containsKey("value")) {
          value = (ScriptTypeValue) agent.binders.get("value").setModel(value, StateSync.FROM_MODEL, true);
        }
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Script", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((ScriptTypeValue) value);
          break;
          case "this": target = (Script) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Script", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(Script.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy((Script) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ScriptProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy extends IntegerSliderDefinition implements BindableProxy {
      private BindableProxyAgent<IntegerSliderDefinition> agent;
      private IntegerSliderDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy() {
        this(new IntegerSliderDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy(IntegerSliderDefinition targetVal) {
        agent = new BindableProxyAgent<IntegerSliderDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("max", new PropertyType(Integer.class, false, false));
        p.put("precision", new PropertyType(Integer.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("min", new PropertyType(Integer.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("step", new PropertyType(Integer.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(SliderFieldType.class, false, false));
        p.put("this", new PropertyType(IntegerSliderDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IntegerSliderDefinition unwrap() {
        return target;
      }

      public IntegerSliderDefinition deepUnwrap() {
        final IntegerSliderDefinition clone = new IntegerSliderDefinition();
        final IntegerSliderDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setMax(t.getMax());
        clone.setPrecision(t.getPrecision());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setMin(t.getMin());
        clone.setName(t.getName());
        clone.setStep(t.getStep());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public Integer getMax() {
        return target.getMax();
      }

      public void setMax(Integer max) {
        changeAndFire("max", max);
      }

      public Integer getPrecision() {
        return target.getPrecision();
      }

      public void setPrecision(Integer precision) {
        changeAndFire("precision", precision);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Integer getMin() {
        return target.getMin();
      }

      public void setMin(Integer min) {
        changeAndFire("min", min);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public Integer getStep() {
        return target.getStep();
      }

      public void setStep(Integer step) {
        changeAndFire("step", step);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public SliderFieldType getFieldType() {
        return target.getFieldType();
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "max": return getMax();
          case "precision": return getPrecision();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "min": return getMin();
          case "name": return getName();
          case "step": return getStep();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "this": return target;
          default: throw new NonExistingPropertyException("IntegerSliderDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "max": target.setMax((Integer) value);
          break;
          case "precision": target.setPrecision((Integer) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "min": target.setMin((Integer) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "step": target.setStep((Integer) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "this": target = (IntegerSliderDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IntegerSliderDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(IntegerSliderDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy((IntegerSliderDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_slider_definition_IntegerSliderDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy extends StartErrorEvent implements BindableProxy {
      private BindableProxyAgent<StartErrorEvent> agent;
      private StartErrorEvent target;
      public org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy() {
        this(new StartErrorEvent());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy(StartErrorEvent targetVal) {
        agent = new BindableProxyAgent<StartErrorEvent>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("dataIOSet", new PropertyType(DataIOSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationAttributeSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(InterruptingErrorEventExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(StartErrorEvent.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public StartErrorEvent unwrap() {
        return target;
      }

      public StartErrorEvent deepUnwrap() {
        final StartErrorEvent clone = new StartErrorEvent();
        final StartErrorEvent t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getDataIOSet() instanceof BindableProxy) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) getDataIOSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDataIOSet())) {
          clone.setDataIOSet((DataIOSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDataIOSet())).deepUnwrap());
        } else {
          clone.setDataIOSet(t.getDataIOSet());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationAttributeSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationAttributeSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((InterruptingErrorEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((InterruptingErrorEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public DataIOSet getDataIOSet() {
        return target.getDataIOSet();
      }

      public void setDataIOSet(DataIOSet dataIOSet) {
        if (agent.binders.containsKey("dataIOSet")) {
          dataIOSet = (DataIOSet) agent.binders.get("dataIOSet").setModel(dataIOSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dataIOSet", dataIOSet);
      }

      public SimulationAttributeSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationAttributeSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationAttributeSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public InterruptingErrorEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(InterruptingErrorEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (InterruptingErrorEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "dataIOSet": return getDataIOSet();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("StartErrorEvent", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "dataIOSet": target.setDataIOSet((DataIOSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationAttributeSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((InterruptingErrorEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (StartErrorEvent) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("StartErrorEvent", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(StartErrorEvent.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy((StartErrorEvent) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_StartErrorEventProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy extends AssigneeRow implements BindableProxy {
      private BindableProxyAgent<AssigneeRow> agent;
      private AssigneeRow target;
      public org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy() {
        this(new AssigneeRow());
      }

      public org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy(AssigneeRow targetVal) {
        agent = new BindableProxyAgent<AssigneeRow>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("name", new PropertyType(String.class, false, false));
        p.put("customName", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("empty", new PropertyType(Boolean.class, false, false));
        p.put("this", new PropertyType(AssigneeRow.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AssigneeRow unwrap() {
        return target;
      }

      public AssigneeRow deepUnwrap() {
        final AssigneeRow clone = new AssigneeRow();
        final AssigneeRow t = unwrap();
        clone.setName(t.getName());
        clone.setCustomName(t.getCustomName());
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getCustomName() {
        return target.getCustomName();
      }

      public void setCustomName(String customName) {
        changeAndFire("customName", customName);
      }

      public long getId() {
        return target.getId();
      }

      public void setId(long id) {
        changeAndFire("id", id);
      }

      public boolean isEmpty() {
        return target.isEmpty();
      }

      public Object get(String property) {
        switch (property) {
          case "name": return getName();
          case "customName": return getCustomName();
          case "id": return getId();
          case "empty": return isEmpty();
          case "this": return target;
          default: throw new NonExistingPropertyException("AssigneeRow", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "name": target.setName((String) value);
          break;
          case "customName": target.setCustomName((String) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "this": target = (AssigneeRow) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AssigneeRow", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(AssigneeRow.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy((AssigneeRow) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_client_forms_fields_model_AssigneeRowProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy extends org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess implements BindableProxy {
      private BindableProxyAgent<org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess> agent;
      private org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess target;
      public org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy() {
        this(new org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy(org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess targetVal) {
        agent = new BindableProxyAgent<org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationSet.class, true, false));
        p.put("processData", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet.class, true, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(RectangleDimensionsSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess unwrap() {
        return target;
      }

      public org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess deepUnwrap() {
        final org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess clone = new org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess();
        final org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getProcessData() instanceof BindableProxy) {
          clone.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) ((BindableProxy) getProcessData()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getProcessData())) {
          clone.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getProcessData())).deepUnwrap());
        } else {
          clone.setProcessData(t.getProcessData());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((RectangleDimensionsSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public SimulationSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData getProcessData() {
        return target.getProcessData();
      }

      public void setProcessData(org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData processData) {
        if (agent.binders.containsKey("processData")) {
          processData = (org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) agent.binders.get("processData").setModel(processData, StateSync.FROM_MODEL, true);
        }
        changeAndFire("processData", processData);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public RectangleDimensionsSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (RectangleDimensionsSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "simulationSet": return getSimulationSet();
          case "processData": return getProcessData();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("AdHocSubprocess", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationSet) value);
          break;
          case "processData": target.setProcessData((org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((RectangleDimensionsSet) value);
          break;
          case "this": target = (org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AdHocSubprocess", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy((org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_AdHocSubprocessProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy extends IntegerBoxFieldDefinition implements BindableProxy {
      private BindableProxyAgent<IntegerBoxFieldDefinition> agent;
      private IntegerBoxFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy() {
        this(new IntegerBoxFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy(IntegerBoxFieldDefinition targetVal) {
        agent = new BindableProxyAgent<IntegerBoxFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(IntegerBoxFieldType.class, false, false));
        p.put("placeHolder", new PropertyType(String.class, false, false));
        p.put("maxLength", new PropertyType(Integer.class, false, false));
        p.put("this", new PropertyType(IntegerBoxFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public IntegerBoxFieldDefinition unwrap() {
        return target;
      }

      public IntegerBoxFieldDefinition deepUnwrap() {
        final IntegerBoxFieldDefinition clone = new IntegerBoxFieldDefinition();
        final IntegerBoxFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        clone.setPlaceHolder(t.getPlaceHolder());
        clone.setMaxLength(t.getMaxLength());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public IntegerBoxFieldType getFieldType() {
        return target.getFieldType();
      }

      public String getPlaceHolder() {
        return target.getPlaceHolder();
      }

      public void setPlaceHolder(String placeHolder) {
        changeAndFire("placeHolder", placeHolder);
      }

      public Integer getMaxLength() {
        return target.getMaxLength();
      }

      public void setMaxLength(Integer maxLength) {
        changeAndFire("maxLength", maxLength);
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "placeHolder": return getPlaceHolder();
          case "maxLength": return getMaxLength();
          case "this": return target;
          default: throw new NonExistingPropertyException("IntegerBoxFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "placeHolder": target.setPlaceHolder((String) value);
          break;
          case "maxLength": target.setMaxLength((Integer) value);
          break;
          case "this": target = (IntegerBoxFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("IntegerBoxFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(IntegerBoxFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy((IntegerBoxFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_basic_integerBox_definition_IntegerBoxFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy extends CaseManagementSet implements BindableProxy {
      private BindableProxyAgent<CaseManagementSet> agent;
      private CaseManagementSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy() {
        this(new CaseManagementSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy(CaseManagementSet targetVal) {
        agent = new BindableProxyAgent<CaseManagementSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("caseIdPrefix", new PropertyType(CaseIdPrefix.class, true, false));
        p.put("caseRoles", new PropertyType(CaseRoles.class, true, false));
        p.put("caseFileVariables", new PropertyType(CaseFileVariables.class, true, false));
        p.put("this", new PropertyType(CaseManagementSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CaseManagementSet unwrap() {
        return target;
      }

      public CaseManagementSet deepUnwrap() {
        final CaseManagementSet clone = new CaseManagementSet();
        final CaseManagementSet t = unwrap();
        if (t.getCaseIdPrefix() instanceof BindableProxy) {
          clone.setCaseIdPrefix((CaseIdPrefix) ((BindableProxy) getCaseIdPrefix()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCaseIdPrefix())) {
          clone.setCaseIdPrefix((CaseIdPrefix) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCaseIdPrefix())).deepUnwrap());
        } else {
          clone.setCaseIdPrefix(t.getCaseIdPrefix());
        }
        if (t.getCaseRoles() instanceof BindableProxy) {
          clone.setCaseRoles((CaseRoles) ((BindableProxy) getCaseRoles()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCaseRoles())) {
          clone.setCaseRoles((CaseRoles) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCaseRoles())).deepUnwrap());
        } else {
          clone.setCaseRoles(t.getCaseRoles());
        }
        if (t.getCaseFileVariables() instanceof BindableProxy) {
          clone.setCaseFileVariables((CaseFileVariables) ((BindableProxy) getCaseFileVariables()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getCaseFileVariables())) {
          clone.setCaseFileVariables((CaseFileVariables) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getCaseFileVariables())).deepUnwrap());
        } else {
          clone.setCaseFileVariables(t.getCaseFileVariables());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public CaseIdPrefix getCaseIdPrefix() {
        return target.getCaseIdPrefix();
      }

      public void setCaseIdPrefix(CaseIdPrefix caseIdPrefix) {
        if (agent.binders.containsKey("caseIdPrefix")) {
          caseIdPrefix = (CaseIdPrefix) agent.binders.get("caseIdPrefix").setModel(caseIdPrefix, StateSync.FROM_MODEL, true);
        }
        changeAndFire("caseIdPrefix", caseIdPrefix);
      }

      public CaseRoles getCaseRoles() {
        return target.getCaseRoles();
      }

      public void setCaseRoles(CaseRoles caseRoles) {
        if (agent.binders.containsKey("caseRoles")) {
          caseRoles = (CaseRoles) agent.binders.get("caseRoles").setModel(caseRoles, StateSync.FROM_MODEL, true);
        }
        changeAndFire("caseRoles", caseRoles);
      }

      public CaseFileVariables getCaseFileVariables() {
        return target.getCaseFileVariables();
      }

      public void setCaseFileVariables(CaseFileVariables caseFileVariables) {
        if (agent.binders.containsKey("caseFileVariables")) {
          caseFileVariables = (CaseFileVariables) agent.binders.get("caseFileVariables").setModel(caseFileVariables, StateSync.FROM_MODEL, true);
        }
        changeAndFire("caseFileVariables", caseFileVariables);
      }

      public Object get(String property) {
        switch (property) {
          case "caseIdPrefix": return getCaseIdPrefix();
          case "caseRoles": return getCaseRoles();
          case "caseFileVariables": return getCaseFileVariables();
          case "this": return target;
          default: throw new NonExistingPropertyException("CaseManagementSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "caseIdPrefix": target.setCaseIdPrefix((CaseIdPrefix) value);
          break;
          case "caseRoles": target.setCaseRoles((CaseRoles) value);
          break;
          case "caseFileVariables": target.setCaseFileVariables((CaseFileVariables) value);
          break;
          case "this": target = (CaseManagementSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CaseManagementSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CaseManagementSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy((CaseManagementSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseManagementSetProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy extends AllowedAnswers implements BindableProxy {
      private BindableProxyAgent<AllowedAnswers> agent;
      private AllowedAnswers target;
      public org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy() {
        this(new AllowedAnswers());
      }

      public org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy(AllowedAnswers targetVal) {
        agent = new BindableProxyAgent<AllowedAnswers>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(AllowedAnswers.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public AllowedAnswers unwrap() {
        return target;
      }

      public AllowedAnswers deepUnwrap() {
        final AllowedAnswers clone = new AllowedAnswers();
        final AllowedAnswers t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("AllowedAnswers", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (AllowedAnswers) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("AllowedAnswers", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(AllowedAnswers.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy((AllowedAnswers) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswersProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy extends CaseIdPrefix implements BindableProxy {
      private BindableProxyAgent<CaseIdPrefix> agent;
      private CaseIdPrefix target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy() {
        this(new CaseIdPrefix());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy(CaseIdPrefix targetVal) {
        agent = new BindableProxyAgent<CaseIdPrefix>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(CaseIdPrefix.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CaseIdPrefix unwrap() {
        return target;
      }

      public CaseIdPrefix deepUnwrap() {
        final CaseIdPrefix clone = new CaseIdPrefix();
        final CaseIdPrefix t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("CaseIdPrefix", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (CaseIdPrefix) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CaseIdPrefix", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CaseIdPrefix.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy((CaseIdPrefix) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseIdPrefixProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy extends Mean implements BindableProxy {
      private BindableProxyAgent<Mean> agent;
      private Mean target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy() {
        this(new Mean());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy(Mean targetVal) {
        agent = new BindableProxyAgent<Mean>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(Mean.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Mean unwrap() {
        return target;
      }

      public Mean deepUnwrap() {
        final Mean clone = new Mean();
        final Mean t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Mean", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (Mean) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Mean", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(Mean.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy((Mean) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_simulation_MeanProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy extends EscalationEventExecutionSet implements BindableProxy {
      private BindableProxyAgent<EscalationEventExecutionSet> agent;
      private EscalationEventExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy() {
        this(new EscalationEventExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy(EscalationEventExecutionSet targetVal) {
        agent = new BindableProxyAgent<EscalationEventExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("escalationRef", new PropertyType(EscalationRef.class, true, false));
        p.put("this", new PropertyType(EscalationEventExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public EscalationEventExecutionSet unwrap() {
        return target;
      }

      public EscalationEventExecutionSet deepUnwrap() {
        final EscalationEventExecutionSet clone = new EscalationEventExecutionSet();
        final EscalationEventExecutionSet t = unwrap();
        if (t.getEscalationRef() instanceof BindableProxy) {
          clone.setEscalationRef((EscalationRef) ((BindableProxy) getEscalationRef()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getEscalationRef())) {
          clone.setEscalationRef((EscalationRef) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getEscalationRef())).deepUnwrap());
        } else {
          clone.setEscalationRef(t.getEscalationRef());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public EscalationRef getEscalationRef() {
        return target.getEscalationRef();
      }

      public void setEscalationRef(EscalationRef escalationRef) {
        if (agent.binders.containsKey("escalationRef")) {
          escalationRef = (EscalationRef) agent.binders.get("escalationRef").setModel(escalationRef, StateSync.FROM_MODEL, true);
        }
        changeAndFire("escalationRef", escalationRef);
      }

      public Object get(String property) {
        switch (property) {
          case "escalationRef": return getEscalationRef();
          case "this": return target;
          default: throw new NonExistingPropertyException("EscalationEventExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "escalationRef": target.setEscalationRef((EscalationRef) value);
          break;
          case "this": target = (EscalationEventExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("EscalationEventExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(EscalationEventExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy((EscalationEventExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_escalation_EscalationEventExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy extends Content implements BindableProxy {
      private BindableProxyAgent<Content> agent;
      private Content target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy() {
        this(new Content());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy(Content targetVal) {
        agent = new BindableProxyAgent<Content>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(Content.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public Content unwrap() {
        return target;
      }

      public Content deepUnwrap() {
        final Content clone = new Content();
        final Content t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Content", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (Content) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Content", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(Content.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy((Content) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_task_ContentProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy extends NotificationsEditorFieldDefinition implements BindableProxy {
      private BindableProxyAgent<NotificationsEditorFieldDefinition> agent;
      private NotificationsEditorFieldDefinition target;
      public org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy() {
        this(new NotificationsEditorFieldDefinition());
      }

      public org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy(NotificationsEditorFieldDefinition targetVal) {
        agent = new BindableProxyAgent<NotificationsEditorFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(NotificationsEditorFieldType.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(NotificationsEditorFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public NotificationsEditorFieldDefinition unwrap() {
        return target;
      }

      public NotificationsEditorFieldDefinition deepUnwrap() {
        final NotificationsEditorFieldDefinition clone = new NotificationsEditorFieldDefinition();
        final NotificationsEditorFieldDefinition t = unwrap();
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setName(t.getName());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setId(t.getId());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public NotificationsEditorFieldType getFieldType() {
        return target.getFieldType();
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public Object get(String property) {
        switch (property) {
          case "validateOnChange": return getValidateOnChange();
          case "name": return getName();
          case "binding": return getBinding();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "id": return getId();
          case "label": return getLabel();
          case "fieldType": return getFieldType();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "this": return target;
          default: throw new NonExistingPropertyException("NotificationsEditorFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "this": target = (NotificationsEditorFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("NotificationsEditorFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(NotificationsEditorFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy((NotificationsEditorFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_forms_model_NotificationsEditorFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy extends CaseRoles implements BindableProxy {
      private BindableProxyAgent<CaseRoles> agent;
      private CaseRoles target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy() {
        this(new CaseRoles());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy(CaseRoles targetVal) {
        agent = new BindableProxyAgent<CaseRoles>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("type", new PropertyType(org.kie.workbench.common.stunner.core.definition.property.PropertyType.class, false, false));
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(CaseRoles.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CaseRoles unwrap() {
        return target;
      }

      public CaseRoles deepUnwrap() {
        final CaseRoles clone = new CaseRoles();
        final CaseRoles t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public org.kie.workbench.common.stunner.core.definition.property.PropertyType getType() {
        return target.getType();
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "type": return getType();
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("CaseRoles", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (CaseRoles) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CaseRoles", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CaseRoles.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy((CaseRoles) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_cm_CaseRolesProxy();
      }
    });
    class org_jbpm_workbench_ht_model_TaskEventSummaryProxy extends TaskEventSummary implements BindableProxy {
      private BindableProxyAgent<TaskEventSummary> agent;
      private TaskEventSummary target;
      public org_jbpm_workbench_ht_model_TaskEventSummaryProxy() {
        this(new TaskEventSummary());
      }

      public org_jbpm_workbench_ht_model_TaskEventSummaryProxy(TaskEventSummary targetVal) {
        agent = new BindableProxyAgent<TaskEventSummary>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("eventId", new PropertyType(Long.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("callbacks", new PropertyType(List.class, false, true));
        p.put("workItemId", new PropertyType(Long.class, false, false));
        p.put("id", new PropertyType(Long.class, false, false));
        p.put("type", new PropertyType(String.class, false, false));
        p.put("message", new PropertyType(String.class, false, false));
        p.put("userId", new PropertyType(String.class, false, false));
        p.put("taskId", new PropertyType(Long.class, false, false));
        p.put("logTime", new PropertyType(Date.class, false, false));
        p.put("this", new PropertyType(TaskEventSummary.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public TaskEventSummary unwrap() {
        return target;
      }

      public TaskEventSummary deepUnwrap() {
        final TaskEventSummary clone = new TaskEventSummary();
        final TaskEventSummary t = unwrap();
        clone.setName(t.getName());
        if (t.getCallbacks() != null) {
          final List callbacksClone = new ArrayList();
          for (Object callbacksElem : t.getCallbacks()) {
            if (callbacksElem instanceof BindableProxy) {
              callbacksClone.add(((BindableProxy) callbacksElem).deepUnwrap());
            } else {
              callbacksClone.add(callbacksElem);
            }
          }
          clone.setCallbacks(callbacksClone);
        }
        clone.setId(t.getId());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_jbpm_workbench_ht_model_TaskEventSummaryProxy) {
          obj = ((org_jbpm_workbench_ht_model_TaskEventSummaryProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Long getEventId() {
        return target.getEventId();
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public List getCallbacks() {
        return target.getCallbacks();
      }

      public void setCallbacks(List<LabeledCommand> callbacks) {
        List<LabeledCommand> oldValue = target.getCallbacks();
        callbacks = agent.ensureBoundListIsProxied("callbacks", callbacks);
        target.setCallbacks(callbacks);
        agent.updateWidgetsAndFireEvent(true, "callbacks", oldValue, callbacks);
      }

      public Long getWorkItemId() {
        return target.getWorkItemId();
      }

      public Long getId() {
        return target.getId();
      }

      public void setId(Long id) {
        changeAndFire("id", id);
      }

      public String getType() {
        return target.getType();
      }

      public String getMessage() {
        return target.getMessage();
      }

      public String getUserId() {
        return target.getUserId();
      }

      public Long getTaskId() {
        return target.getTaskId();
      }

      public Date getLogTime() {
        return target.getLogTime();
      }

      public Object get(String property) {
        switch (property) {
          case "eventId": return getEventId();
          case "name": return getName();
          case "callbacks": return getCallbacks();
          case "workItemId": return getWorkItemId();
          case "id": return getId();
          case "type": return getType();
          case "message": return getMessage();
          case "userId": return getUserId();
          case "taskId": return getTaskId();
          case "logTime": return getLogTime();
          case "this": return target;
          default: throw new NonExistingPropertyException("TaskEventSummary", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "name": target.setName((String) value);
          break;
          case "callbacks": target.setCallbacks((List<LabeledCommand>) value);
          break;
          case "id": target.setId((Long) value);
          break;
          case "this": target = (TaskEventSummary) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("TaskEventSummary", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasCallbacks() {
        final boolean returnValue = target.hasCallbacks();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public void addCallback(String a0, Command a1) {
        target.addCallback(a0, a1);
        agent.updateWidgetsAndFireEvents();
      }

      public int compareTo(AbstractPageRow a0) {
        final int returnValue = target.compareTo(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(TaskEventSummary.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_jbpm_workbench_ht_model_TaskEventSummaryProxy((TaskEventSummary) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_jbpm_workbench_ht_model_TaskEventSummaryProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy extends StartNoneEvent implements BindableProxy {
      private BindableProxyAgent<StartNoneEvent> agent;
      private StartNoneEvent target;
      public org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy() {
        this(new StartNoneEvent());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy(StartNoneEvent targetVal) {
        agent = new BindableProxyAgent<StartNoneEvent>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("general", new PropertyType(BPMNGeneralSet.class, true, false));
        p.put("simulationSet", new PropertyType(SimulationAttributeSet.class, true, false));
        p.put("backgroundSet", new PropertyType(BackgroundSet.class, true, false));
        p.put("executionSet", new PropertyType(BaseStartEventExecutionSet.class, true, false));
        p.put("singleInputVar", new PropertyType(Boolean.class, false, false));
        p.put("fontSet", new PropertyType(FontSet.class, true, false));
        p.put("dimensionsSet", new PropertyType(CircleDimensionSet.class, true, false));
        p.put("category", new PropertyType(String.class, false, false));
        p.put("singleOutputVar", new PropertyType(Boolean.class, false, false));
        p.put("labels", new PropertyType(Set.class, false, false));
        p.put("this", new PropertyType(StartNoneEvent.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public StartNoneEvent unwrap() {
        return target;
      }

      public StartNoneEvent deepUnwrap() {
        final StartNoneEvent clone = new StartNoneEvent();
        final StartNoneEvent t = unwrap();
        if (t.getGeneral() instanceof BindableProxy) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) getGeneral()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getGeneral())) {
          clone.setGeneral((BPMNGeneralSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getGeneral())).deepUnwrap());
        } else {
          clone.setGeneral(t.getGeneral());
        }
        if (t.getSimulationSet() instanceof BindableProxy) {
          clone.setSimulationSet((SimulationAttributeSet) ((BindableProxy) getSimulationSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSimulationSet())) {
          clone.setSimulationSet((SimulationAttributeSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSimulationSet())).deepUnwrap());
        } else {
          clone.setSimulationSet(t.getSimulationSet());
        }
        if (t.getBackgroundSet() instanceof BindableProxy) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) getBackgroundSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getBackgroundSet())) {
          clone.setBackgroundSet((BackgroundSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getBackgroundSet())).deepUnwrap());
        } else {
          clone.setBackgroundSet(t.getBackgroundSet());
        }
        if (t.getExecutionSet() instanceof BindableProxy) {
          clone.setExecutionSet((BaseStartEventExecutionSet) ((BindableProxy) getExecutionSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExecutionSet())) {
          clone.setExecutionSet((BaseStartEventExecutionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExecutionSet())).deepUnwrap());
        } else {
          clone.setExecutionSet(t.getExecutionSet());
        }
        if (t.getFontSet() instanceof BindableProxy) {
          clone.setFontSet((FontSet) ((BindableProxy) getFontSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getFontSet())) {
          clone.setFontSet((FontSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getFontSet())).deepUnwrap());
        } else {
          clone.setFontSet(t.getFontSet());
        }
        if (t.getDimensionsSet() instanceof BindableProxy) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) getDimensionsSet()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDimensionsSet())) {
          clone.setDimensionsSet((CircleDimensionSet) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDimensionsSet())).deepUnwrap());
        } else {
          clone.setDimensionsSet(t.getDimensionsSet());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public BPMNGeneralSet getGeneral() {
        return target.getGeneral();
      }

      public void setGeneral(BPMNGeneralSet general) {
        if (agent.binders.containsKey("general")) {
          general = (BPMNGeneralSet) agent.binders.get("general").setModel(general, StateSync.FROM_MODEL, true);
        }
        changeAndFire("general", general);
      }

      public SimulationAttributeSet getSimulationSet() {
        return target.getSimulationSet();
      }

      public void setSimulationSet(SimulationAttributeSet simulationSet) {
        if (agent.binders.containsKey("simulationSet")) {
          simulationSet = (SimulationAttributeSet) agent.binders.get("simulationSet").setModel(simulationSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("simulationSet", simulationSet);
      }

      public BackgroundSet getBackgroundSet() {
        return target.getBackgroundSet();
      }

      public void setBackgroundSet(BackgroundSet backgroundSet) {
        if (agent.binders.containsKey("backgroundSet")) {
          backgroundSet = (BackgroundSet) agent.binders.get("backgroundSet").setModel(backgroundSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("backgroundSet", backgroundSet);
      }

      public BaseStartEventExecutionSet getExecutionSet() {
        return target.getExecutionSet();
      }

      public void setExecutionSet(BaseStartEventExecutionSet executionSet) {
        if (agent.binders.containsKey("executionSet")) {
          executionSet = (BaseStartEventExecutionSet) agent.binders.get("executionSet").setModel(executionSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("executionSet", executionSet);
      }

      public boolean isSingleInputVar() {
        return target.isSingleInputVar();
      }

      public FontSet getFontSet() {
        return target.getFontSet();
      }

      public void setFontSet(FontSet fontSet) {
        if (agent.binders.containsKey("fontSet")) {
          fontSet = (FontSet) agent.binders.get("fontSet").setModel(fontSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("fontSet", fontSet);
      }

      public CircleDimensionSet getDimensionsSet() {
        return target.getDimensionsSet();
      }

      public void setDimensionsSet(CircleDimensionSet dimensionsSet) {
        if (agent.binders.containsKey("dimensionsSet")) {
          dimensionsSet = (CircleDimensionSet) agent.binders.get("dimensionsSet").setModel(dimensionsSet, StateSync.FROM_MODEL, true);
        }
        changeAndFire("dimensionsSet", dimensionsSet);
      }

      public String getCategory() {
        return target.getCategory();
      }

      public boolean isSingleOutputVar() {
        return target.isSingleOutputVar();
      }

      public Set getLabels() {
        return target.getLabels();
      }

      public Object get(String property) {
        switch (property) {
          case "general": return getGeneral();
          case "simulationSet": return getSimulationSet();
          case "backgroundSet": return getBackgroundSet();
          case "executionSet": return getExecutionSet();
          case "singleInputVar": return isSingleInputVar();
          case "fontSet": return getFontSet();
          case "dimensionsSet": return getDimensionsSet();
          case "category": return getCategory();
          case "singleOutputVar": return isSingleOutputVar();
          case "labels": return getLabels();
          case "this": return target;
          default: throw new NonExistingPropertyException("StartNoneEvent", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "general": target.setGeneral((BPMNGeneralSet) value);
          break;
          case "simulationSet": target.setSimulationSet((SimulationAttributeSet) value);
          break;
          case "backgroundSet": target.setBackgroundSet((BackgroundSet) value);
          break;
          case "executionSet": target.setExecutionSet((BaseStartEventExecutionSet) value);
          break;
          case "fontSet": target.setFontSet((FontSet) value);
          break;
          case "dimensionsSet": target.setDimensionsSet((CircleDimensionSet) value);
          break;
          case "this": target = (StartNoneEvent) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("StartNoneEvent", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public boolean hasInputVars() {
        final boolean returnValue = target.hasInputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public boolean hasOutputVars() {
        final boolean returnValue = target.hasOutputVars();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(StartNoneEvent.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy((StartNoneEvent) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_StartNoneEventProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy extends org.kie.workbench.common.dmn.api.property.dimensions.Height implements BindableProxy {
      private BindableProxyAgent<org.kie.workbench.common.dmn.api.property.dimensions.Height> agent;
      private org.kie.workbench.common.dmn.api.property.dimensions.Height target;
      public org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy() {
        this(new org.kie.workbench.common.dmn.api.property.dimensions.Height());
      }

      public org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy(org.kie.workbench.common.dmn.api.property.dimensions.Height targetVal) {
        agent = new BindableProxyAgent<org.kie.workbench.common.dmn.api.property.dimensions.Height>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(Double.class, false, false));
        p.put("this", new PropertyType(org.kie.workbench.common.dmn.api.property.dimensions.Height.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public org.kie.workbench.common.dmn.api.property.dimensions.Height unwrap() {
        return target;
      }

      public org.kie.workbench.common.dmn.api.property.dimensions.Height deepUnwrap() {
        final org.kie.workbench.common.dmn.api.property.dimensions.Height clone = new org.kie.workbench.common.dmn.api.property.dimensions.Height();
        final org.kie.workbench.common.dmn.api.property.dimensions.Height t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Double getValue() {
        return target.getValue();
      }

      public void setValue(Double value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("Height", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((Double) value);
          break;
          case "this": target = (org.kie.workbench.common.dmn.api.property.dimensions.Height) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("Height", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(org.kie.workbench.common.dmn.api.property.dimensions.Height.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy((org.kie.workbench.common.dmn.api.property.dimensions.Height) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_dimensions_HeightProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy extends InterruptingMessageEventExecutionSet implements BindableProxy {
      private BindableProxyAgent<InterruptingMessageEventExecutionSet> agent;
      private InterruptingMessageEventExecutionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy() {
        this(new InterruptingMessageEventExecutionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy(InterruptingMessageEventExecutionSet targetVal) {
        agent = new BindableProxyAgent<InterruptingMessageEventExecutionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("isInterrupting", new PropertyType(IsInterrupting.class, true, false));
        p.put("messageRef", new PropertyType(MessageRef.class, true, false));
        p.put("slaDueDate", new PropertyType(SLADueDate.class, true, false));
        p.put("this", new PropertyType(InterruptingMessageEventExecutionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public InterruptingMessageEventExecutionSet unwrap() {
        return target;
      }

      public InterruptingMessageEventExecutionSet deepUnwrap() {
        final InterruptingMessageEventExecutionSet clone = new InterruptingMessageEventExecutionSet();
        final InterruptingMessageEventExecutionSet t = unwrap();
        if (t.getIsInterrupting() instanceof BindableProxy) {
          clone.setIsInterrupting((IsInterrupting) ((BindableProxy) getIsInterrupting()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getIsInterrupting())) {
          clone.setIsInterrupting((IsInterrupting) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getIsInterrupting())).deepUnwrap());
        } else {
          clone.setIsInterrupting(t.getIsInterrupting());
        }
        if (t.getMessageRef() instanceof BindableProxy) {
          clone.setMessageRef((MessageRef) ((BindableProxy) getMessageRef()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getMessageRef())) {
          clone.setMessageRef((MessageRef) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getMessageRef())).deepUnwrap());
        } else {
          clone.setMessageRef(t.getMessageRef());
        }
        if (t.getSlaDueDate() instanceof BindableProxy) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) getSlaDueDate()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getSlaDueDate())) {
          clone.setSlaDueDate((SLADueDate) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getSlaDueDate())).deepUnwrap());
        } else {
          clone.setSlaDueDate(t.getSlaDueDate());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public IsInterrupting getIsInterrupting() {
        return target.getIsInterrupting();
      }

      public void setIsInterrupting(IsInterrupting isInterrupting) {
        if (agent.binders.containsKey("isInterrupting")) {
          isInterrupting = (IsInterrupting) agent.binders.get("isInterrupting").setModel(isInterrupting, StateSync.FROM_MODEL, true);
        }
        changeAndFire("isInterrupting", isInterrupting);
      }

      public MessageRef getMessageRef() {
        return target.getMessageRef();
      }

      public void setMessageRef(MessageRef messageRef) {
        if (agent.binders.containsKey("messageRef")) {
          messageRef = (MessageRef) agent.binders.get("messageRef").setModel(messageRef, StateSync.FROM_MODEL, true);
        }
        changeAndFire("messageRef", messageRef);
      }

      public SLADueDate getSlaDueDate() {
        return target.getSlaDueDate();
      }

      public void setSlaDueDate(SLADueDate slaDueDate) {
        if (agent.binders.containsKey("slaDueDate")) {
          slaDueDate = (SLADueDate) agent.binders.get("slaDueDate").setModel(slaDueDate, StateSync.FROM_MODEL, true);
        }
        changeAndFire("slaDueDate", slaDueDate);
      }

      public Object get(String property) {
        switch (property) {
          case "isInterrupting": return getIsInterrupting();
          case "messageRef": return getMessageRef();
          case "slaDueDate": return getSlaDueDate();
          case "this": return target;
          default: throw new NonExistingPropertyException("InterruptingMessageEventExecutionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "isInterrupting": target.setIsInterrupting((IsInterrupting) value);
          break;
          case "messageRef": target.setMessageRef((MessageRef) value);
          break;
          case "slaDueDate": target.setSlaDueDate((SLADueDate) value);
          break;
          case "this": target = (InterruptingMessageEventExecutionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("InterruptingMessageEventExecutionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(InterruptingMessageEventExecutionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy((InterruptingMessageEventExecutionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_event_message_InterruptingMessageEventExecutionSetProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy extends CircleDimensionSet implements BindableProxy {
      private BindableProxyAgent<CircleDimensionSet> agent;
      private CircleDimensionSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy() {
        this(new CircleDimensionSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy(CircleDimensionSet targetVal) {
        agent = new BindableProxyAgent<CircleDimensionSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("radius", new PropertyType(Radius.class, true, false));
        p.put("this", new PropertyType(CircleDimensionSet.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public CircleDimensionSet unwrap() {
        return target;
      }

      public CircleDimensionSet deepUnwrap() {
        final CircleDimensionSet clone = new CircleDimensionSet();
        final CircleDimensionSet t = unwrap();
        if (t.getRadius() instanceof BindableProxy) {
          clone.setRadius((Radius) ((BindableProxy) getRadius()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getRadius())) {
          clone.setRadius((Radius) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getRadius())).deepUnwrap());
        } else {
          clone.setRadius(t.getRadius());
        }
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy) {
          obj = ((org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Radius getRadius() {
        return target.getRadius();
      }

      public void setRadius(Radius radius) {
        if (agent.binders.containsKey("radius")) {
          radius = (Radius) agent.binders.get("radius").setModel(radius, StateSync.FROM_MODEL, true);
        }
        changeAndFire("radius", radius);
      }

      public Object get(String property) {
        switch (property) {
          case "radius": return getRadius();
          case "this": return target;
          default: throw new NonExistingPropertyException("CircleDimensionSet", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "radius": target.setRadius((Radius) value);
          break;
          case "this": target = (CircleDimensionSet) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("CircleDimensionSet", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(CircleDimensionSet.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy((CircleDimensionSet) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_stunner_bpmn_definition_property_dimensions_CircleDimensionSetProxy();
      }
    });
    class org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy extends SubFormFieldDefinition implements BindableProxy {
      private BindableProxyAgent<SubFormFieldDefinition> agent;
      private SubFormFieldDefinition target;
      public org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy() {
        this(new SubFormFieldDefinition());
      }

      public org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy(SubFormFieldDefinition targetVal) {
        agent = new BindableProxyAgent<SubFormFieldDefinition>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("container", new PropertyType(Container.class, false, false));
        p.put("validateOnChange", new PropertyType(Boolean.class, false, false));
        p.put("binding", new PropertyType(String.class, false, false));
        p.put("fieldTypeInfo", new PropertyType(TypeInfo.class, false, false));
        p.put("readOnly", new PropertyType(Boolean.class, false, false));
        p.put("standaloneClassName", new PropertyType(String.class, false, false));
        p.put("label", new PropertyType(String.class, false, false));
        p.put("required", new PropertyType(Boolean.class, false, false));
        p.put("helpMessage", new PropertyType(String.class, false, false));
        p.put("name", new PropertyType(String.class, false, false));
        p.put("id", new PropertyType(String.class, false, false));
        p.put("fieldType", new PropertyType(SubFormFieldType.class, false, false));
        p.put("nestedForm", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(SubFormFieldDefinition.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public SubFormFieldDefinition unwrap() {
        return target;
      }

      public SubFormFieldDefinition deepUnwrap() {
        final SubFormFieldDefinition clone = new SubFormFieldDefinition();
        final SubFormFieldDefinition t = unwrap();
        clone.setContainer(t.getContainer());
        clone.setValidateOnChange(t.getValidateOnChange());
        clone.setBinding(t.getBinding());
        clone.setReadOnly(t.getReadOnly());
        clone.setStandaloneClassName(t.getStandaloneClassName());
        clone.setLabel(t.getLabel());
        clone.setRequired(t.getRequired());
        clone.setHelpMessage(t.getHelpMessage());
        clone.setName(t.getName());
        clone.setId(t.getId());
        clone.setNestedForm(t.getNestedForm());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy) {
          obj = ((org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public Container getContainer() {
        return target.getContainer();
      }

      public void setContainer(Container container) {
        changeAndFire("container", container);
      }

      public Boolean getValidateOnChange() {
        return target.getValidateOnChange();
      }

      public void setValidateOnChange(Boolean validateOnChange) {
        changeAndFire("validateOnChange", validateOnChange);
      }

      public String getBinding() {
        return target.getBinding();
      }

      public void setBinding(String binding) {
        changeAndFire("binding", binding);
      }

      public TypeInfo getFieldTypeInfo() {
        return target.getFieldTypeInfo();
      }

      public Boolean getReadOnly() {
        return target.getReadOnly();
      }

      public void setReadOnly(Boolean readOnly) {
        changeAndFire("readOnly", readOnly);
      }

      public String getStandaloneClassName() {
        return target.getStandaloneClassName();
      }

      public void setStandaloneClassName(String standaloneClassName) {
        changeAndFire("standaloneClassName", standaloneClassName);
      }

      public String getLabel() {
        return target.getLabel();
      }

      public void setLabel(String label) {
        changeAndFire("label", label);
      }

      public Boolean getRequired() {
        return target.getRequired();
      }

      public void setRequired(Boolean required) {
        changeAndFire("required", required);
      }

      public String getHelpMessage() {
        return target.getHelpMessage();
      }

      public void setHelpMessage(String helpMessage) {
        changeAndFire("helpMessage", helpMessage);
      }

      public String getName() {
        return target.getName();
      }

      public void setName(String name) {
        changeAndFire("name", name);
      }

      public String getId() {
        return target.getId();
      }

      public void setId(String id) {
        changeAndFire("id", id);
      }

      public SubFormFieldType getFieldType() {
        return target.getFieldType();
      }

      public String getNestedForm() {
        return target.getNestedForm();
      }

      public void setNestedForm(String nestedForm) {
        changeAndFire("nestedForm", nestedForm);
      }

      public Object get(String property) {
        switch (property) {
          case "container": return getContainer();
          case "validateOnChange": return getValidateOnChange();
          case "binding": return getBinding();
          case "fieldTypeInfo": return getFieldTypeInfo();
          case "readOnly": return getReadOnly();
          case "standaloneClassName": return getStandaloneClassName();
          case "label": return getLabel();
          case "required": return getRequired();
          case "helpMessage": return getHelpMessage();
          case "name": return getName();
          case "id": return getId();
          case "fieldType": return getFieldType();
          case "nestedForm": return getNestedForm();
          case "this": return target;
          default: throw new NonExistingPropertyException("SubFormFieldDefinition", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "container": target.setContainer((Container) value);
          break;
          case "validateOnChange": target.setValidateOnChange((Boolean) value);
          break;
          case "binding": target.setBinding((String) value);
          break;
          case "readOnly": target.setReadOnly((Boolean) value);
          break;
          case "standaloneClassName": target.setStandaloneClassName((String) value);
          break;
          case "label": target.setLabel((String) value);
          break;
          case "required": target.setRequired((Boolean) value);
          break;
          case "helpMessage": target.setHelpMessage((String) value);
          break;
          case "name": target.setName((String) value);
          break;
          case "id": target.setId((String) value);
          break;
          case "nestedForm": target.setNestedForm((String) value);
          break;
          case "this": target = (SubFormFieldDefinition) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("SubFormFieldDefinition", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public void copyFrom(FieldDefinition a0) {
        target.copyFrom(a0);
        agent.updateWidgetsAndFireEvents();
      }
    }
    BindableProxyFactory.addBindableProxy(SubFormFieldDefinition.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy((SubFormFieldDefinition) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_forms_fields_shared_fieldTypes_relations_subForm_definition_SubFormFieldDefinitionProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy extends LiteralExpression implements BindableProxy {
      private BindableProxyAgent<LiteralExpression> agent;
      private LiteralExpression target;
      public org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy() {
        this(new LiteralExpression());
      }

      public org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy(LiteralExpression targetVal) {
        agent = new BindableProxyAgent<LiteralExpression>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("parent", new PropertyType(DMNModelInstrumentedBase.class, false, false));
        p.put("domainObjectUUID", new PropertyType(String.class, false, false));
        p.put("defaultNamespace", new PropertyType(String.class, false, false));
        p.put("stunnerCategory", new PropertyType(String.class, false, false));
        p.put("extensionElements", new PropertyType(ExtensionElements.class, false, false));
        p.put("domainObjectNameTranslationKey", new PropertyType(String.class, false, false));
        p.put("expressionLanguage", new PropertyType(ExpressionLanguage.class, true, false));
        p.put("stunnerLabels", new PropertyType(Set.class, false, false));
        p.put("description", new PropertyType(org.kie.workbench.common.dmn.api.property.dmn.Description.class, true, false));
        p.put("importedValues", new PropertyType(ImportedValues.class, true, false));
        p.put("requiredComponentWidthCount", new PropertyType(Integer.class, false, false));
        p.put("nsContext", new PropertyType(Map.class, false, false));
        p.put("componentWidths", new PropertyType(List.class, false, true));
        p.put("hasTypeRefs", new PropertyType(List.class, false, true));
        p.put("text", new PropertyType(Text.class, true, false));
        p.put("id", new PropertyType(Id.class, true, false));
        p.put("typeRef", new PropertyType(QName.class, false, false));
        p.put("additionalAttributes", new PropertyType(Map.class, false, false));
        p.put("this", new PropertyType(LiteralExpression.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public LiteralExpression unwrap() {
        return target;
      }

      public LiteralExpression deepUnwrap() {
        final LiteralExpression clone = new LiteralExpression();
        final LiteralExpression t = unwrap();
        clone.setParent(t.getParent());
        clone.setExtensionElements(t.getExtensionElements());
        if (t.getExpressionLanguage() instanceof BindableProxy) {
          clone.setExpressionLanguage((ExpressionLanguage) ((BindableProxy) getExpressionLanguage()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getExpressionLanguage())) {
          clone.setExpressionLanguage((ExpressionLanguage) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getExpressionLanguage())).deepUnwrap());
        } else {
          clone.setExpressionLanguage(t.getExpressionLanguage());
        }
        if (t.getDescription() instanceof BindableProxy) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) getDescription()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getDescription())) {
          clone.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getDescription())).deepUnwrap());
        } else {
          clone.setDescription(t.getDescription());
        }
        if (t.getImportedValues() instanceof BindableProxy) {
          clone.setImportedValues((ImportedValues) ((BindableProxy) getImportedValues()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getImportedValues())) {
          clone.setImportedValues((ImportedValues) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getImportedValues())).deepUnwrap());
        } else {
          clone.setImportedValues(t.getImportedValues());
        }
        if (t.getText() instanceof BindableProxy) {
          clone.setText((Text) ((BindableProxy) getText()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getText())) {
          clone.setText((Text) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getText())).deepUnwrap());
        } else {
          clone.setText(t.getText());
        }
        if (t.getId() instanceof BindableProxy) {
          clone.setId((Id) ((BindableProxy) getId()).deepUnwrap());
        } else if (BindableProxyFactory.isBindableType(t.getId())) {
          clone.setId((Id) ((BindableProxy) BindableProxyFactory.getBindableProxy(t.getId())).deepUnwrap());
        } else {
          clone.setId(t.getId());
        }
        clone.setTypeRef(t.getTypeRef());
        clone.setAdditionalAttributes(t.getAdditionalAttributes());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy) {
          obj = ((org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public DMNModelInstrumentedBase getParent() {
        return target.getParent();
      }

      public void setParent(DMNModelInstrumentedBase parent) {
        changeAndFire("parent", parent);
      }

      public String getDomainObjectUUID() {
        return target.getDomainObjectUUID();
      }

      public String getDefaultNamespace() {
        return target.getDefaultNamespace();
      }

      public String getStunnerCategory() {
        return target.getStunnerCategory();
      }

      public ExtensionElements getExtensionElements() {
        return target.getExtensionElements();
      }

      public void setExtensionElements(ExtensionElements extensionElements) {
        changeAndFire("extensionElements", extensionElements);
      }

      public String getDomainObjectNameTranslationKey() {
        return target.getDomainObjectNameTranslationKey();
      }

      public ExpressionLanguage getExpressionLanguage() {
        return target.getExpressionLanguage();
      }

      public void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        if (agent.binders.containsKey("expressionLanguage")) {
          expressionLanguage = (ExpressionLanguage) agent.binders.get("expressionLanguage").setModel(expressionLanguage, StateSync.FROM_MODEL, true);
        }
        changeAndFire("expressionLanguage", expressionLanguage);
      }

      public Set getStunnerLabels() {
        return target.getStunnerLabels();
      }

      public org.kie.workbench.common.dmn.api.property.dmn.Description getDescription() {
        return target.getDescription();
      }

      public void setDescription(org.kie.workbench.common.dmn.api.property.dmn.Description description) {
        if (agent.binders.containsKey("description")) {
          description = (org.kie.workbench.common.dmn.api.property.dmn.Description) agent.binders.get("description").setModel(description, StateSync.FROM_MODEL, true);
        }
        changeAndFire("description", description);
      }

      public ImportedValues getImportedValues() {
        return target.getImportedValues();
      }

      public void setImportedValues(ImportedValues importedValues) {
        if (agent.binders.containsKey("importedValues")) {
          importedValues = (ImportedValues) agent.binders.get("importedValues").setModel(importedValues, StateSync.FROM_MODEL, true);
        }
        changeAndFire("importedValues", importedValues);
      }

      public int getRequiredComponentWidthCount() {
        return target.getRequiredComponentWidthCount();
      }

      public Map getNsContext() {
        return target.getNsContext();
      }

      public List getComponentWidths() {
        return target.getComponentWidths();
      }

      public List getHasTypeRefs() {
        return target.getHasTypeRefs();
      }

      public Text getText() {
        return target.getText();
      }

      public void setText(Text text) {
        if (agent.binders.containsKey("text")) {
          text = (Text) agent.binders.get("text").setModel(text, StateSync.FROM_MODEL, true);
        }
        changeAndFire("text", text);
      }

      public Id getId() {
        return target.getId();
      }

      public void setId(Id id) {
        if (agent.binders.containsKey("id")) {
          id = (Id) agent.binders.get("id").setModel(id, StateSync.FROM_MODEL, true);
        }
        changeAndFire("id", id);
      }

      public QName getTypeRef() {
        return target.getTypeRef();
      }

      public void setTypeRef(QName typeRef) {
        changeAndFire("typeRef", typeRef);
      }

      public Map getAdditionalAttributes() {
        return target.getAdditionalAttributes();
      }

      public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        changeAndFire("additionalAttributes", additionalAttributes);
      }

      public Object get(String property) {
        switch (property) {
          case "parent": return getParent();
          case "domainObjectUUID": return getDomainObjectUUID();
          case "defaultNamespace": return getDefaultNamespace();
          case "stunnerCategory": return getStunnerCategory();
          case "extensionElements": return getExtensionElements();
          case "domainObjectNameTranslationKey": return getDomainObjectNameTranslationKey();
          case "expressionLanguage": return getExpressionLanguage();
          case "stunnerLabels": return getStunnerLabels();
          case "description": return getDescription();
          case "importedValues": return getImportedValues();
          case "requiredComponentWidthCount": return getRequiredComponentWidthCount();
          case "nsContext": return getNsContext();
          case "componentWidths": return getComponentWidths();
          case "hasTypeRefs": return getHasTypeRefs();
          case "text": return getText();
          case "id": return getId();
          case "typeRef": return getTypeRef();
          case "additionalAttributes": return getAdditionalAttributes();
          case "this": return target;
          default: throw new NonExistingPropertyException("LiteralExpression", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "parent": target.setParent((DMNModelInstrumentedBase) value);
          break;
          case "extensionElements": target.setExtensionElements((ExtensionElements) value);
          break;
          case "expressionLanguage": target.setExpressionLanguage((ExpressionLanguage) value);
          break;
          case "description": target.setDescription((org.kie.workbench.common.dmn.api.property.dmn.Description) value);
          break;
          case "importedValues": target.setImportedValues((ImportedValues) value);
          break;
          case "text": target.setText((Text) value);
          break;
          case "id": target.setId((Id) value);
          break;
          case "typeRef": target.setTypeRef((QName) value);
          break;
          case "additionalAttributes": target.setAdditionalAttributes((Map<QName, String>) value);
          break;
          case "this": target = (LiteralExpression) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("LiteralExpression", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }

      public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        final DMNModelInstrumentedBase returnValue = target.asDMNModelInstrumentedBase();
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }

      public Optional getPrefixForNamespaceURI(String a0) {
        final Optional returnValue = target.getPrefixForNamespaceURI(a0);
        agent.updateWidgetsAndFireEvents();
        return returnValue;
      }
    }
    BindableProxyFactory.addBindableProxy(LiteralExpression.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy((LiteralExpression) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionProxy();
      }
    });
    class org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy extends ExpressionLanguage implements BindableProxy {
      private BindableProxyAgent<ExpressionLanguage> agent;
      private ExpressionLanguage target;
      public org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy() {
        this(new ExpressionLanguage());
      }

      public org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy(ExpressionLanguage targetVal) {
        agent = new BindableProxyAgent<ExpressionLanguage>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("value", new PropertyType(String.class, false, false));
        p.put("this", new PropertyType(ExpressionLanguage.class, true, false));
        agent.copyValues();
      }

      public BindableProxyAgent getBindableProxyAgent() {
        return agent;
      }

      public void updateWidgets() {
        agent.updateWidgetsAndFireEvents();
      }

      public ExpressionLanguage unwrap() {
        return target;
      }

      public ExpressionLanguage deepUnwrap() {
        final ExpressionLanguage clone = new ExpressionLanguage();
        final ExpressionLanguage t = unwrap();
        clone.setValue(t.getValue());
        return clone;
      }

      public boolean equals(Object obj) {
        if (obj instanceof org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy) {
          obj = ((org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy) obj).unwrap();
        }
        return target.equals(obj);
      }

      public int hashCode() {
        return target.hashCode();
      }

      public String toString() {
        return target.toString();
      }

      private void changeAndFire(String property, Object value) {
        final Object oldValue = get(property);
        set(property, value);
        agent.updateWidgetsAndFireEvent(false, property, oldValue, value);
      }

      public String getValue() {
        return target.getValue();
      }

      public void setValue(String value) {
        changeAndFire("value", value);
      }

      public Object get(String property) {
        switch (property) {
          case "value": return getValue();
          case "this": return target;
          default: throw new NonExistingPropertyException("ExpressionLanguage", property);
        }
      }

      public void set(String property, Object value) {
        switch (property) {
          case "value": target.setValue((String) value);
          break;
          case "this": target = (ExpressionLanguage) value;
          agent.target = target;
          break;
          default: throw new NonExistingPropertyException("ExpressionLanguage", property);
        }
      }

      public Map getBeanProperties() {
        final Map props = new HashMap(agent.propertyTypes);
        props.remove("this");
        return Collections.unmodifiableMap(props);
      }
    }
    BindableProxyFactory.addBindableProxy(ExpressionLanguage.class, new BindableProxyProvider() {
      public BindableProxy getBindableProxy(Object model) {
        return new org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy((ExpressionLanguage) model);
      }
      public BindableProxy getBindableProxy() {
        return new org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguageProxy();
      }
    });
    class org_kie_workbench_common_stunner_bpmn_definition_property_simulation_SimulationAttributeSetProxy extends SimulationAttributeSet implements BindableProxy {
      private BindableProxyAgent<SimulationAttributeSet> agent;
      private SimulationAttributeSet target;
      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_SimulationAttributeSetProxy() {
        this(new SimulationAttributeSet());
      }

      public org_kie_workbench_common_stunner_bpmn_definition_property_simulation_SimulationAttributeSetProxy(SimulationAttributeSet targetVal) {
        agent = new BindableProxyAgent<SimulationAttributeSet>(this, targetVal);
        target = targetVal;
        final Map<String, PropertyType> p = agent.propertyTypes;
        p.put("min", new PropertyType(Min.class, true, false));
        p.put("distributionType", new PropertyType(DistributionType.class, true, false));
        p.put("max", new PropertyType(Max.class, true, false));
        p.put("mean", new PropertyType(Mean.class, true, false));
        p.put("standardDevi