package org.jboss.errai.enterprise.client.jaxrs;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import java.util.Collection;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.framework.ProxyProvider;
import org.jboss.errai.common.client.framework.RemoteServiceProxyFactory;
import org.jboss.errai.security.client.local.interceptors.SecurityExceptionMapper;
import org.kie.workbench.common.screens.library.api.SpacesScreenService;
import org.kie.workbench.common.screens.library.api.SpacesScreenService.NewSpace;

public class JaxrsProxyLoaderImpl implements JaxrsProxyLoader { public void loadProxies() {
    class org_kie_workbench_common_screens_library_api_SpacesScreenServiceImpl extends AbstractJaxrsProxy implements SpacesScreenService {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public org_kie_workbench_common_screens_library_api_SpacesScreenServiceImpl() {
        setExceptionMapper(new SecurityExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public Collection getSpaces() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("spacesScreen/spaces");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        sendRequest(requestBuilder, null, new ResponseDemarshallingCallback() {
          public Object demarshallResponse(Response response) {
            if (response.getStatusCode() == 204) {
              return null;
            } else {
              return MarshallingWrapper.fromJSON(response.getText(), Collection.class, OrganizationalUnit.class);
            }
          }
        });
        return null;
      }

      public OrganizationalUnit getSpace(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("spacesScreen/spaces/{name}".replace("{name}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        sendRequest(requestBuilder, null, new ResponseDemarshallingCallback() {
          public Object demarshallResponse(Response response) {
            if (response.getStatusCode() == 204) {
              return null;
            } else {
              return MarshallingWrapper.fromJSON(response.getText(), OrganizationalUnit.class, null);
            }
          }
        });
        return null;
      }

      public boolean isValidGroupId(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("spacesScreen/spaces/validGroupId").append("?").append("groupId").append("=").append(URL.encodeQueryString(a0 == null ? "" : a0));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        sendRequest(requestBuilder, null, new ResponseDemarshallingCallback() {
          public Object demarshallResponse(Response response) {
            if (response.getStatusCode() == 204) {
              return null;
            } else {
              return MarshallingWrapper.fromJSON(response.getText(), Boolean.class, null);
            }
          }
        });
        return false;
      }

      public javax.ws.rs.core.Response postSpace(final NewSpace a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("spacesScreen/spaces");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        sendRequest(requestBuilder, MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
          public Object demarshallResponse(Response response) {
            return response;
          }
        });
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(SpacesScreenService.class, new ProxyProvider() {
      public Object getProxy() {
        return new org_kie_workbench_common_screens_library_api_SpacesScreenServiceImpl();
      }
    });
  }
}