package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_s_a_m_ExpressionIdentifier_1_Impl implements GeneratedMarshaller<ExpressionIdentifier> {
  private ExpressionIdentifier[] EMPTY_ARRAY = new ExpressionIdentifier[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<FactMappingType> org_drools_scenariosimulation_api_model_FactMappingType = null;
  public ExpressionIdentifier[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String ExpressionIdentifier_String_name(ExpressionIdentifier instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.ExpressionIdentifier::name;
  }-*/;

  native static void ExpressionIdentifier_String_name(ExpressionIdentifier instance, String value) /*-{
    instance.@org.drools.scenariosimulation.api.model.ExpressionIdentifier::name = value;
  }-*/;

  native static FactMappingType ExpressionIdentifier_FactMappingType_type(ExpressionIdentifier instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.ExpressionIdentifier::type;
  }-*/;

  native static void ExpressionIdentifier_FactMappingType_type(ExpressionIdentifier instance, FactMappingType value) /*-{
    instance.@org.drools.scenariosimulation.api.model.ExpressionIdentifier::type = value;
  }-*/;

  public ExpressionIdentifier demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ExpressionIdentifier.class, objId);
    }
    ExpressionIdentifier entity = new ExpressionIdentifier();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": ExpressionIdentifier_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "type": ExpressionIdentifier_FactMappingType_type(entity, objVal.isObject() != null ? Enum.valueOf(FactMappingType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(FactMappingType.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(ExpressionIdentifier a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.ExpressionIdentifier") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "type") + "\":") + (a0.getType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.FactMappingType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getType().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_drools_scenariosimulation_api_model_FactMappingType == null) {
      org_drools_scenariosimulation_api_model_FactMappingType = Marshalling.getMarshaller(FactMappingType.class);
    }
  }
}