package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_s_a_m_FactIdentifier_1_Impl implements GeneratedMarshaller<FactIdentifier> {
  private FactIdentifier[] EMPTY_ARRAY = new FactIdentifier[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public FactIdentifier[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String FactIdentifier_String_name(FactIdentifier instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactIdentifier::name;
  }-*/;

  native static void FactIdentifier_String_name(FactIdentifier instance, String value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactIdentifier::name = value;
  }-*/;

  native static String FactIdentifier_String_className(FactIdentifier instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactIdentifier::className;
  }-*/;

  native static void FactIdentifier_String_className(FactIdentifier instance, String value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactIdentifier::className = value;
  }-*/;

  public FactIdentifier demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactIdentifier.class, objId);
    }
    FactIdentifier entity = new FactIdentifier();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": FactIdentifier_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "className": FactIdentifier_String_className(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactIdentifier a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.FactIdentifier") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}