package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_d_s_a_m_FactMappingValue_1_Impl implements GeneratedMarshaller<FactMappingValue> {
  private FactMappingValue[] EMPTY_ARRAY = new FactMappingValue[0];
  private Marshaller<FactIdentifier> org_drools_scenariosimulation_api_model_FactIdentifier = null;
  private Marshaller<ExpressionIdentifier> org_drools_scenariosimulation_api_model_ExpressionIdentifier = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<FactMappingValueStatus> org_drools_scenariosimulation_api_model_FactMappingValueStatus = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public FactMappingValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static FactIdentifier FactMappingValue_FactIdentifier_factIdentifier(FactMappingValue instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMappingValue::factIdentifier;
  }-*/;

  native static void FactMappingValue_FactIdentifier_factIdentifier(FactMappingValue instance, FactIdentifier value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMappingValue::factIdentifier = value;
  }-*/;

  native static ExpressionIdentifier FactMappingValue_ExpressionIdentifier_expressionIdentifier(FactMappingValue instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMappingValue::expressionIdentifier;
  }-*/;

  native static void FactMappingValue_ExpressionIdentifier_expressionIdentifier(FactMappingValue instance, ExpressionIdentifier value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMappingValue::expressionIdentifier = value;
  }-*/;

  native static FactMappingValueStatus FactMappingValue_FactMappingValueStatus_status(FactMappingValue instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMappingValue::status;
  }-*/;

  native static void FactMappingValue_FactMappingValueStatus_status(FactMappingValue instance, FactMappingValueStatus value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMappingValue::status = value;
  }-*/;

  public FactMappingValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactMappingValue.class, objId);
    }
    FactMappingValue entity = new FactMappingValue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "factIdentifier": FactMappingValue_FactIdentifier_factIdentifier(entity, org_drools_scenariosimulation_api_model_FactIdentifier.demarshall(objVal, a1));
        break;
        case "expressionIdentifier": FactMappingValue_ExpressionIdentifier_expressionIdentifier(entity, org_drools_scenariosimulation_api_model_ExpressionIdentifier.demarshall(objVal, a1));
        break;
        case "rawValue": entity.setRawValue(((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
        case "status": FactMappingValue_FactMappingValueStatus_status(entity, objVal.isObject() != null ? Enum.valueOf(FactMappingValueStatus.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(FactMappingValueStatus.class, objVal.isString().stringValue()) : null);
        break;
        case "errorValue": entity.setErrorValue(((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
        case "exceptionMessage": entity.setExceptionMessage(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactMappingValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.FactMappingValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "factIdentifier") + "\":") + org_drools_scenariosimulation_api_model_FactIdentifier.marshall(a0.getFactIdentifier(), a1)) + ",\"") + "expressionIdentifier") + "\":") + org_drools_scenariosimulation_api_model_ExpressionIdentifier.marshall(a0.getExpressionIdentifier(), a1)) + ",\"") + "rawValue") + "\":") + java_lang_Object.marshall(a0.getRawValue(), a1)) + ",\"") + "status") + "\":") + (a0.getStatus() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.FactMappingValueStatus") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getStatus().name()) + "\"}" : "null")) + ",\"") + "errorValue") + "\":") + java_lang_Object.marshall(a0.getErrorValue(), a1)) + ",\"") + "exceptionMessage") + "\":") + java_lang_String.marshall(a0.getExceptionMessage(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_drools_scenariosimulation_api_model_FactIdentifier == null) {
      org_drools_scenariosimulation_api_model_FactIdentifier = Marshalling.getMarshaller(FactIdentifier.class);
    }
    if (org_drools_scenariosimulation_api_model_ExpressionIdentifier == null) {
      org_drools_scenariosimulation_api_model_ExpressionIdentifier = Marshalling.getMarshaller(ExpressionIdentifier.class);
    }
    if (org_drools_scenariosimulation_api_model_FactMappingValueStatus == null) {
      org_drools_scenariosimulation_api_model_FactMappingValueStatus = Marshalling.getMarshaller(FactMappingValueStatus.class);
    }
  }
}