package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_s_a_m_FactMapping_1_Impl implements GeneratedMarshaller<FactMapping> {
  private FactMapping[] EMPTY_ARRAY = new FactMapping[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<ExpressionIdentifier> org_drools_scenariosimulation_api_model_ExpressionIdentifier = null;
  private Marshaller<FactIdentifier> org_drools_scenariosimulation_api_model_FactIdentifier = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  public FactMapping[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List FactMapping_List_expressionElements(FactMapping instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMapping::expressionElements;
  }-*/;

  native static void FactMapping_List_expressionElements(FactMapping instance, List<ExpressionElement> value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMapping::expressionElements = value;
  }-*/;

  native static ExpressionIdentifier FactMapping_ExpressionIdentifier_expressionIdentifier(FactMapping instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMapping::expressionIdentifier;
  }-*/;

  native static void FactMapping_ExpressionIdentifier_expressionIdentifier(FactMapping instance, ExpressionIdentifier value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMapping::expressionIdentifier = value;
  }-*/;

  native static FactIdentifier FactMapping_FactIdentifier_factIdentifier(FactMapping instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMapping::factIdentifier;
  }-*/;

  native static void FactMapping_FactIdentifier_factIdentifier(FactMapping instance, FactIdentifier value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMapping::factIdentifier = value;
  }-*/;

  native static String FactMapping_String_className(FactMapping instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.FactMapping::className;
  }-*/;

  native static void FactMapping_String_className(FactMapping instance, String value) /*-{
    instance.@org.drools.scenariosimulation.api.model.FactMapping::className = value;
  }-*/;

  public FactMapping demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactMapping.class, objId);
    }
    FactMapping entity = new FactMapping();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "expressionElements": a1.setAssumedElementType("org.drools.scenariosimulation.api.model.ExpressionElement");
        FactMapping_List_expressionElements(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "expressionIdentifier": FactMapping_ExpressionIdentifier_expressionIdentifier(entity, org_drools_scenariosimulation_api_model_ExpressionIdentifier.demarshall(objVal, a1));
        break;
        case "factIdentifier": FactMapping_FactIdentifier_factIdentifier(entity, org_drools_scenariosimulation_api_model_FactIdentifier.demarshall(objVal, a1));
        break;
        case "className": FactMapping_String_className(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "factAlias": entity.setFactAlias(java_lang_String.demarshall(objVal, a1));
        break;
        case "expressionAlias": entity.setExpressionAlias(java_lang_String.demarshall(objVal, a1));
        break;
        case "genericTypes": a1.setAssumedElementType("java.lang.String");
        entity.setGenericTypes(java_util_List.demarshall(objVal, a1));
        break;
        case "columnWidth": entity.setColumnWidth(java_lang_Double.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactMapping a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.FactMapping") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "expressionElements") + "\":") + java_util_List.marshall(a0.getExpressionElements(), a1)) + ",\"") + "expressionIdentifier") + "\":") + org_drools_scenariosimulation_api_model_ExpressionIdentifier.marshall(a0.getExpressionIdentifier(), a1)) + ",\"") + "factIdentifier") + "\":") + org_drools_scenariosimulation_api_model_FactIdentifier.marshall(a0.getFactIdentifier(), a1)) + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + ",\"") + "factAlias") + "\":") + java_lang_String.marshall(a0.getFactAlias(), a1)) + ",\"") + "expressionAlias") + "\":") + java_lang_String.marshall(a0.getExpressionAlias(), a1)) + ",\"") + "genericTypes") + "\":") + java_util_List.marshall(a0.getGenericTypes(), a1)) + ",\"") + "columnWidth") + "\":") + java_lang_Double.marshall(a0.getColumnWidth(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_drools_scenariosimulation_api_model_ExpressionIdentifier == null) {
      org_drools_scenariosimulation_api_model_ExpressionIdentifier = Marshalling.getMarshaller(ExpressionIdentifier.class);
    }
    if (org_drools_scenariosimulation_api_model_FactIdentifier == null) {
      org_drools_scenariosimulation_api_model_FactIdentifier = Marshalling.getMarshaller(FactIdentifier.class);
    }
  }
}