package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.imports.Imports;

public class Marshaller_o_d_s_a_m_ScenarioSimulationModel_1_Impl implements GeneratedMarshaller<ScenarioSimulationModel> {
  private ScenarioSimulationModel[] EMPTY_ARRAY = new ScenarioSimulationModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Simulation> org_drools_scenariosimulation_api_model_Simulation = null;
  private Marshaller<Imports> org_kie_soup_project_datamodel_imports_Imports = null;
  public ScenarioSimulationModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String ScenarioSimulationModel_String_version(ScenarioSimulationModel instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.ScenarioSimulationModel::version;
  }-*/;

  native static void ScenarioSimulationModel_String_version(ScenarioSimulationModel instance, String value) /*-{
    instance.@org.drools.scenariosimulation.api.model.ScenarioSimulationModel::version = value;
  }-*/;

  public ScenarioSimulationModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ScenarioSimulationModel.class, objId);
    }
    ScenarioSimulationModel entity = new ScenarioSimulationModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "version": ScenarioSimulationModel_String_version(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "simulation": entity.setSimulation(org_drools_scenariosimulation_api_model_Simulation.demarshall(objVal, a1));
        break;
        case "imports": entity.setImports(org_kie_soup_project_datamodel_imports_Imports.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ScenarioSimulationModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.ScenarioSimulationModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "version") + "\":") + java_lang_String.marshall(a0.getVersion(), a1)) + ",\"") + "simulation") + "\":") + org_drools_scenariosimulation_api_model_Simulation.marshall(a0.getSimulation(), a1)) + ",\"") + "imports") + "\":") + org_kie_soup_project_datamodel_imports_Imports.marshall(a0.getImports(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_drools_scenariosimulation_api_model_Simulation == null) {
      org_drools_scenariosimulation_api_model_Simulation = Marshalling.getMarshaller(Simulation.class);
    }
    if (org_kie_soup_project_datamodel_imports_Imports == null) {
      org_kie_soup_project_datamodel_imports_Imports = Marshalling.getMarshaller(Imports.class);
    }
  }
}