package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_s_a_m_SimulationRunMetadata_1_Impl implements GeneratedMarshaller<SimulationRunMetadata> {
  private SimulationRunMetadata[] EMPTY_ARRAY = new SimulationRunMetadata[0];
  private Marshaller<AuditLog> org_drools_scenariosimulation_api_model_AuditLog = null;
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public SimulationRunMetadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static AuditLog SimulationRunMetadata_AuditLog_auditLog(SimulationRunMetadata instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::auditLog;
  }-*/;

  native static void SimulationRunMetadata_AuditLog_auditLog(SimulationRunMetadata instance, AuditLog value) /*-{
    instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::auditLog = value;
  }-*/;

  native static int SimulationRunMetadata_int_available(SimulationRunMetadata instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::available;
  }-*/;

  native static void SimulationRunMetadata_int_available(SimulationRunMetadata instance, int value) /*-{
    instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::available = value;
  }-*/;

  native static int SimulationRunMetadata_int_executed(SimulationRunMetadata instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::executed;
  }-*/;

  native static void SimulationRunMetadata_int_executed(SimulationRunMetadata instance, int value) /*-{
    instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::executed = value;
  }-*/;

  native static double SimulationRunMetadata_double_coveragePercentage(SimulationRunMetadata instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::coveragePercentage;
  }-*/;

  native static void SimulationRunMetadata_double_coveragePercentage(SimulationRunMetadata instance, double value) /*-{
    instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::coveragePercentage = value;
  }-*/;

  native static Map SimulationRunMetadata_Map_outputCounter(SimulationRunMetadata instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::outputCounter;
  }-*/;

  native static void SimulationRunMetadata_Map_outputCounter(SimulationRunMetadata instance, Map<String, Integer> value) /*-{
    instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::outputCounter = value;
  }-*/;

  native static Map SimulationRunMetadata_Map_scenarioCounter(SimulationRunMetadata instance) /*-{
    return instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::scenarioCounter;
  }-*/;

  native static void SimulationRunMetadata_Map_scenarioCounter(SimulationRunMetadata instance, Map<ScenarioWithIndex, Map<String, Integer>> value) /*-{
    instance.@org.drools.scenariosimulation.api.model.SimulationRunMetadata::scenarioCounter = value;
  }-*/;

  public SimulationRunMetadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SimulationRunMetadata.class, objId);
    }
    SimulationRunMetadata entity = new SimulationRunMetadata();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "auditLog": SimulationRunMetadata_AuditLog_auditLog(entity, org_drools_scenariosimulation_api_model_AuditLog.demarshall(objVal, a1));
        break;
        case "available": SimulationRunMetadata_int_available(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "executed": SimulationRunMetadata_int_executed(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "coveragePercentage": SimulationRunMetadata_double_coveragePercentage(entity, java_lang_Double.demarshall(objVal, a1));
        break;
        case "outputCounter": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.Integer");
        SimulationRunMetadata_Map_outputCounter(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "scenarioCounter": a1.setAssumedMapKeyType("org.drools.scenariosimulation.api.model.ScenarioWithIndex");
        a1.setAssumedMapValueType("java.util.Map");
        SimulationRunMetadata_Map_scenarioCounter(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(SimulationRunMetadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.scenariosimulation.api.model.SimulationRunMetadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "auditLog") + "\":") + org_drools_scenariosimulation_api_model_AuditLog.marshall(a0.getAuditLog(), a1)) + ",\"") + "available") + "\":") + java_lang_Integer.marshall(a0.getAvailable(), a1)) + ",\"") + "executed") + "\":") + java_lang_Integer.marshall(a0.getExecuted(), a1)) + ",\"") + "coveragePercentage") + "\":") + java_lang_Double.marshall(a0.getCoveragePercentage(), a1)) + ",\"") + "outputCounter") + "\":") + java_util_Map.marshall(a0.getOutputCounter(), a1)) + ",\"") + "scenarioCounter") + "\":") + java_util_Map.marshall(a0.getScenarioCounter(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_drools_scenariosimulation_api_model_AuditLog == null) {
      org_drools_scenariosimulation_api_model_AuditLog = Marshalling.getMarshaller(AuditLog.class);
    }
  }
}