package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.verifier.api.Status;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_v_a_Status_1_Impl implements GeneratedMarshaller<Status> {
  private Status[] EMPTY_ARRAY = new Status[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public Status[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Status demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Status.class, objId);
    }
    Status entity = new Status();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "webWorkerUUID": entity.setWebWorkerUUID(java_lang_String.demarshall(objVal, a1));
        break;
        case "startCheckIndex": entity.setStartCheckIndex(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "endCheckIndex": entity.setEndCheckIndex(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "totalCheckCount": entity.setTotalCheckCount(java_lang_Integer.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static int Status_int_startCheckIndex(Status instance) /*-{
    return instance.@org.drools.verifier.api.Status::startCheckIndex;
  }-*/;

  native static void Status_int_startCheckIndex(Status instance, int value) /*-{
    instance.@org.drools.verifier.api.Status::startCheckIndex = value;
  }-*/;

  native static int Status_int_endCheckIndex(Status instance) /*-{
    return instance.@org.drools.verifier.api.Status::endCheckIndex;
  }-*/;

  native static void Status_int_endCheckIndex(Status instance, int value) /*-{
    instance.@org.drools.verifier.api.Status::endCheckIndex = value;
  }-*/;

  public String marshall(Status a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.verifier.api.Status") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "webWorkerUUID") + "\":") + java_lang_String.marshall(a0.getWebWorkerUUID(), a1)) + ",\"") + "startCheckIndex") + "\":") + java_lang_Integer.marshall(Status_int_startCheckIndex(a0), a1)) + ",\"") + "endCheckIndex") + "\":") + java_lang_Integer.marshall(Status_int_endCheckIndex(a0), a1)) + ",\"") + "totalCheckCount") + "\":") + java_lang_Integer.marshall(a0.getTotalCheckCount(), a1)) + "}");
  }

  private void lazyInit() {

  }
}