package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_v_a_r_Issue_1_Impl implements GeneratedMarshaller<Issue> {
  private Issue[] EMPTY_ARRAY = new Issue[0];
  private Marshaller<Severity> org_drools_verifier_api_reporting_Severity = null;
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  private Marshaller<CheckType> org_drools_verifier_api_reporting_CheckType = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public Issue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Issue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Issue.class, objId);
    }
    Issue entity = new Issue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "severity": entity.setSeverity(objVal.isObject() != null ? Enum.valueOf(Severity.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Severity.class, objVal.isString().stringValue()) : null);
        break;
        case "rowNumbers": a1.setAssumedElementType("java.lang.Integer");
        entity.setRowNumbers(java_util_Set.demarshall(objVal, a1));
        break;
        case "checkType": entity.setCheckType(objVal.isObject() != null ? Enum.valueOf(CheckType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(CheckType.class, objVal.isString().stringValue()) : null);
        break;
        case "debugMessage": entity.setDebugMessage(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Issue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.Issue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "severity") + "\":") + (a0.getSeverity() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.Severity") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getSeverity().name()) + "\"}" : "null")) + ",\"") + "rowNumbers") + "\":") + java_util_Set.marshall(a0.getRowNumbers(), a1)) + ",\"") + "checkType") + "\":") + (a0.getCheckType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.CheckType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getCheckType().name()) + "\"}" : "null")) + ",\"") + "debugMessage") + "\":") + java_lang_String.marshall(a0.getDebugMessage(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_drools_verifier_api_reporting_Severity == null) {
      org_drools_verifier_api_reporting_Severity = Marshalling.getMarshaller(Severity.class);
    }
    if (org_drools_verifier_api_reporting_CheckType == null) {
      org_drools_verifier_api_reporting_CheckType = Marshalling.getMarshaller(CheckType.class);
    }
  }
}