package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.verifier.api.reporting.Issues;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_v_a_r_Issues_1_Impl implements GeneratedMarshaller<Issues> {
  private Issues[] EMPTY_ARRAY = new Issues[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public Issues[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Issues demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Issues.class, objId);
    }
    Issues entity = new Issues();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "webWorkerUUID": entity.setWebWorkerUUID(java_lang_String.demarshall(objVal, a1));
        break;
        case "set": a1.setAssumedElementType("org.drools.verifier.api.reporting.Issue");
        entity.setSet(java_util_Set.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Issues a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.Issues") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "webWorkerUUID") + "\":") + java_lang_String.marshall(a0.getWebWorkerUUID(), a1)) + ",\"") + "set") + "\":") + java_util_Set.marshall(a0.getSet(), a1)) + "}");
  }

  private void lazyInit() {

  }
}