package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.api.reporting.SingleHitLostIssue;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_v_a_r_SingleHitLostIssue_1_Impl implements GeneratedMarshaller<SingleHitLostIssue> {
  private SingleHitLostIssue[] EMPTY_ARRAY = new SingleHitLostIssue[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Severity> org_drools_verifier_api_reporting_Severity = null;
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  private Marshaller<CheckType> org_drools_verifier_api_reporting_CheckType = null;
  public SingleHitLostIssue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public SingleHitLostIssue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SingleHitLostIssue.class, objId);
    }
    SingleHitLostIssue entity = new SingleHitLostIssue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "firstItem": entity.setFirstItem(java_lang_String.demarshall(objVal, a1));
        break;
        case "secondItem": entity.setSecondItem(java_lang_String.demarshall(objVal, a1));
        break;
        case "severity": entity.setSeverity(objVal.isObject() != null ? Enum.valueOf(Severity.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Severity.class, objVal.isString().stringValue()) : null);
        break;
        case "rowNumbers": a1.setAssumedElementType("java.lang.Integer");
        entity.setRowNumbers(java_util_Set.demarshall(objVal, a1));
        break;
        case "checkType": entity.setCheckType(objVal.isObject() != null ? Enum.valueOf(CheckType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(CheckType.class, objVal.isString().stringValue()) : null);
        break;
        case "debugMessage": entity.setDebugMessage(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(SingleHitLostIssue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.SingleHitLostIssue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "firstItem") + "\":") + java_lang_String.marshall(a0.getFirstItem(), a1)) + ",\"") + "secondItem") + "\":") + java_lang_String.marshall(a0.getSecondItem(), a1)) + ",\"") + "severity") + "\":") + (a0.getSeverity() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.Severity") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getSeverity().name()) + "\"}" : "null")) + ",\"") + "rowNumbers") + "\":") + java_util_Set.marshall(a0.getRowNumbers(), a1)) + ",\"") + "checkType") + "\":") + (a0.getCheckType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.drools.verifier.api.reporting.CheckType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getCheckType().name()) + "\"}" : "null")) + ",\"") + "debugMessage") + "\":") + java_lang_String.marshall(a0.getDebugMessage(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_drools_verifier_api_reporting_Severity == null) {
      org_drools_verifier_api_reporting_Severity = Marshalling.getMarshaller(Severity.class);
    }
    if (org_drools_verifier_api_reporting_CheckType == null) {
      org_drools_verifier_api_reporting_CheckType = Marshalling.getMarshaller(CheckType.class);
    }
  }
}