package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.datamodel.rule.ActionFieldFunction;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_d_r_ActionFieldFunction_1_Impl implements GeneratedMarshaller<ActionFieldFunction> {
  private ActionFieldFunction[] EMPTY_ARRAY = new ActionFieldFunction[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public ActionFieldFunction[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ActionFieldFunction demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ActionFieldFunction.class, objId);
    }
    ActionFieldFunction entity = new ActionFieldFunction();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "method": entity.setMethod(java_lang_String.demarshall(objVal, a1));
        break;
        case "field": entity.setField(java_lang_String.demarshall(objVal, a1));
        break;
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "nature": entity.setNature(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ActionFieldFunction a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.datamodel.rule.ActionFieldFunction") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "method") + "\":") + java_lang_String.marshall(a0.getMethod(), a1)) + ",\"") + "field") + "\":") + java_lang_String.marshall(a0.getField(), a1)) + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + ",\"") + "nature") + "\":") + java_lang_Integer.marshall(a0.getNature(), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + "}");
  }

  private void lazyInit() {

  }
}