package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.models.datamodel.rule.DSLSentence;
import org.drools.workbench.models.datamodel.rule.DSLVariableValue;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_d_r_DSLSentence_1_Impl implements GeneratedMarshaller<DSLSentence> {
  private DSLSentence[] EMPTY_ARRAY = new DSLSentence[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public DSLSentence[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String DSLSentence_String_sentence(DSLSentence instance) /*-{
    return instance.@org.drools.workbench.models.datamodel.rule.DSLSentence::sentence;
  }-*/;

  native static void DSLSentence_String_sentence(DSLSentence instance, String value) /*-{
    instance.@org.drools.workbench.models.datamodel.rule.DSLSentence::sentence = value;
  }-*/;

  native static List DSLSentence_List_values(DSLSentence instance) /*-{
    return instance.@org.drools.workbench.models.datamodel.rule.DSLSentence::values;
  }-*/;

  native static void DSLSentence_List_values(DSLSentence instance, List<DSLVariableValue> value) /*-{
    instance.@org.drools.workbench.models.datamodel.rule.DSLSentence::values = value;
  }-*/;

  public DSLSentence demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DSLSentence.class, objId);
    }
    DSLSentence entity = new DSLSentence();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "drl": entity.setDrl(java_lang_String.demarshall(objVal, a1));
        break;
        case "sentence": DSLSentence_String_sentence(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "definition": entity.setDefinition(java_lang_String.demarshall(objVal, a1));
        break;
        case "values": a1.setAssumedElementType("org.drools.workbench.models.datamodel.rule.DSLVariableValue");
        DSLSentence_List_values(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DSLSentence a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.datamodel.rule.DSLSentence") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "drl") + "\":") + java_lang_String.marshall(a0.getDrl(), a1)) + ",\"") + "sentence") + "\":") + java_lang_String.marshall(DSLSentence_String_sentence(a0), a1)) + ",\"") + "definition") + "\":") + java_lang_String.marshall(a0.getDefinition(), a1)) + ",\"") + "values") + "\":") + java_util_List.marshall(a0.getValues(), a1)) + "}");
  }

  private void lazyInit() {

  }
}