package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_d_r_InterpolationVariable_1_Impl implements GeneratedMarshaller<InterpolationVariable> {
  private InterpolationVariable[] EMPTY_ARRAY = new InterpolationVariable[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public InterpolationVariable[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public InterpolationVariable demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(InterpolationVariable.class, objId);
    }
    InterpolationVariable entity = new InterpolationVariable();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "varName": entity.setVarName(java_lang_String.demarshall(objVal, a1));
        break;
        case "dataType": entity.setDataType(java_lang_String.demarshall(objVal, a1));
        break;
        case "factType": entity.setFactType(java_lang_String.demarshall(objVal, a1));
        break;
        case "factField": entity.setFactField(java_lang_String.demarshall(objVal, a1));
        break;
        case "operator": entity.setOperator(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(InterpolationVariable a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.datamodel.rule.InterpolationVariable") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "varName") + "\":") + java_lang_String.marshall(a0.getVarName(), a1)) + ",\"") + "dataType") + "\":") + java_lang_String.marshall(a0.getDataType(), a1)) + ",\"") + "factType") + "\":") + java_lang_String.marshall(a0.getFactType(), a1)) + ",\"") + "factField") + "\":") + java_lang_String.marshall(a0.getFactField(), a1)) + ",\"") + "operator") + "\":") + java_lang_String.marshall(a0.getOperator(), a1)) + "}");
  }

  private void lazyInit() {

  }
}