package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.Node;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.BaseNodeImpl;
import org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.TypeNodeImpl;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_d_w_m_g_d_s_m_n_i_TypeNodeImpl_1_Impl implements GeneratedMarshaller<TypeNodeImpl> {
  private TypeNodeImpl[] EMPTY_ARRAY = new TypeNodeImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public TypeNodeImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List BaseNodeImpl_List_children(BaseNodeImpl instance) /*-{
    return instance.@org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.BaseNodeImpl::children;
  }-*/;

  native static void BaseNodeImpl_List_children(BaseNodeImpl instance, List<Node> value) /*-{
    instance.@org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.BaseNodeImpl::children = value;
  }-*/;

  public TypeNodeImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TypeNodeImpl.class, objId);
    }
    TypeNodeImpl entity = new TypeNodeImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "className": entity.setClassName(java_lang_String.demarshall(objVal, a1));
        break;
        case "binding": entity.setBinding(java_lang_String.demarshall(objVal, a1));
        break;
        case "parent": entity.setParent((Node) ((ObjectMarshaller) java_lang_Object).demarshall(Node.class, objVal, a1));
        break;
        case "children": a1.setAssumedElementType("org.drools.workbench.models.guided.dtree.shared.model.nodes.Node");
        BaseNodeImpl_List_children(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(TypeNodeImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.dtree.shared.model.nodes.impl.TypeNodeImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + ",\"") + "binding") + "\":") + java_lang_String.marshall(a0.getBinding(), a1)) + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + ",\"") + "children") + "\":") + java_util_List.marshall(a0.getChildren(), a1)) + "}");
  }

  private void lazyInit() {

  }
}