package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.ByteValue;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_g_d_s_m_v_i_ByteValue_1_Impl implements GeneratedMarshaller<ByteValue> {
  private ByteValue[] EMPTY_ARRAY = new ByteValue[0];
  private Marshaller<Byte> java_lang_Byte = Marshalling.getMarshaller(Byte.class);
  public ByteValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ByteValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ByteValue.class, objId);
    }
    ByteValue entity = new ByteValue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_lang_Byte.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ByteValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.dtree.shared.model.values.impl.ByteValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_lang_Byte.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}