package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import java.util.Set;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.DateValue;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_g_d_s_m_v_i_DateValue_1_Impl implements GeneratedMarshaller<DateValue> {
  private DateValue[] EMPTY_ARRAY = new DateValue[0];
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public DateValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DateValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DateValue.class, objId);
    }
    DateValue entity = new DateValue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_util_Date.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DateValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.dtree.shared.model.values.impl.DateValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_util_Date.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}