package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.EnumValue;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_g_d_s_m_v_i_EnumValue_1_Impl implements GeneratedMarshaller<EnumValue> {
  private EnumValue[] EMPTY_ARRAY = new EnumValue[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public EnumValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public EnumValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EnumValue.class, objId);
    }
    EnumValue entity = new EnumValue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(EnumValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.dtree.shared.model.values.impl.EnumValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}