package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.guided.dtree.shared.model.values.impl.LongValue;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_g_d_s_m_v_i_LongValue_1_Impl implements GeneratedMarshaller<LongValue> {
  private LongValue[] EMPTY_ARRAY = new LongValue[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public LongValue[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public LongValue demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(LongValue.class, objId);
    }
    LongValue entity = new LongValue();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_lang_Long.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(LongValue a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.dtree.shared.model.values.impl.LongValue") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "value") + "\":") + java_lang_Long.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}