package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.guided.scorecard.shared.Attribute;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_g_s_s_Attribute_1_Impl implements GeneratedMarshaller<Attribute> {
  private Attribute[] EMPTY_ARRAY = new Attribute[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  public Attribute[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Attribute demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Attribute.class, objId);
    }
    Attribute entity = new Attribute();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "value": entity.setValue(java_lang_String.demarshall(objVal, a1));
        break;
        case "partialScore": entity.setPartialScore(java_lang_Double.demarshall(objVal, a1));
        break;
        case "reasonCode": entity.setReasonCode(java_lang_String.demarshall(objVal, a1));
        break;
        case "operator": entity.setOperator(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Attribute a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.scorecard.shared.Attribute") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + ",\"") + "partialScore") + "\":") + java_lang_Double.marshall(a0.getPartialScore(), a1)) + ",\"") + "reasonCode") + "\":") + java_lang_String.marshall(a0.getReasonCode(), a1)) + ",\"") + "operator") + "\":") + java_lang_String.marshall(a0.getOperator(), a1)) + "}");
  }

  private void lazyInit() {

  }
}