package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.scorecard.shared.Characteristic;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_g_s_s_Characteristic_1_Impl implements GeneratedMarshaller<Characteristic> {
  private Characteristic[] EMPTY_ARRAY = new Characteristic[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public Characteristic[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Characteristic demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Characteristic.class, objId);
    }
    Characteristic entity = new Characteristic();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "fact": entity.setFact(java_lang_String.demarshall(objVal, a1));
        break;
        case "field": entity.setField(java_lang_String.demarshall(objVal, a1));
        break;
        case "baselineScore": entity.setBaselineScore(java_lang_Double.demarshall(objVal, a1));
        break;
        case "reasonCode": entity.setReasonCode(java_lang_String.demarshall(objVal, a1));
        break;
        case "attributes": a1.setAssumedElementType("org.drools.workbench.models.guided.scorecard.shared.Attribute");
        entity.setAttributes(java_util_List.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "dataType": entity.setDataType(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Characteristic a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.scorecard.shared.Characteristic") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "fact") + "\":") + java_lang_String.marshall(a0.getFact(), a1)) + ",\"") + "field") + "\":") + java_lang_String.marshall(a0.getField(), a1)) + ",\"") + "baselineScore") + "\":") + java_lang_Double.marshall(a0.getBaselineScore(), a1)) + ",\"") + "reasonCode") + "\":") + java_lang_String.marshall(a0.getReasonCode(), a1)) + ",\"") + "attributes") + "\":") + java_util_List.marshall(a0.getAttributes(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "dataType") + "\":") + java_lang_String.marshall(a0.getDataType(), a1)) + "}");
  }

  private void lazyInit() {

  }
}