package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.imports.Imports;

public class Marshaller_o_d_w_m_g_s_s_ScoreCardModel_1_Impl implements GeneratedMarshaller<ScoreCardModel> {
  private ScoreCardModel[] EMPTY_ARRAY = new ScoreCardModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Double> java_lang_Double = Marshalling.getMarshaller(Double.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Imports> org_kie_soup_project_datamodel_imports_Imports = null;
  public ScoreCardModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ScoreCardModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ScoreCardModel.class, objId);
    }
    ScoreCardModel entity = new ScoreCardModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "baselineScore": entity.setBaselineScore(java_lang_Double.demarshall(objVal, a1));
        break;
        case "initialScore": entity.setInitialScore(java_lang_Double.demarshall(objVal, a1));
        break;
        case "useReasonCodes": entity.setUseReasonCodes(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "factName": entity.setFactName(java_lang_String.demarshall(objVal, a1));
        break;
        case "fieldName": entity.setFieldName(java_lang_String.demarshall(objVal, a1));
        break;
        case "reasonCodesAlgorithm": entity.setReasonCodesAlgorithm(java_lang_String.demarshall(objVal, a1));
        break;
        case "reasonCodeField": entity.setReasonCodeField(java_lang_String.demarshall(objVal, a1));
        break;
        case "characteristics": a1.setAssumedElementType("org.drools.workbench.models.guided.scorecard.shared.Characteristic");
        entity.setCharacteristics(java_util_List.demarshall(objVal, a1));
        break;
        case "packageName": entity.setPackageName(java_lang_String.demarshall(objVal, a1));
        break;
        case "imports": entity.setImports(org_kie_soup_project_datamodel_imports_Imports.demarshall(objVal, a1));
        break;
        case "agendaGroup": entity.setAgendaGroup(java_lang_String.demarshall(objVal, a1));
        break;
        case "ruleFlowGroup": entity.setRuleFlowGroup(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean ScoreCardModel_boolean_useReasonCodes(ScoreCardModel instance) /*-{
    return instance.@org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel::useReasonCodes;
  }-*/;

  native static void ScoreCardModel_boolean_useReasonCodes(ScoreCardModel instance, boolean value) /*-{
    instance.@org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel::useReasonCodes = value;
  }-*/;

  public String marshall(ScoreCardModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "baselineScore") + "\":") + java_lang_Double.marshall(a0.getBaselineScore(), a1)) + ",\"") + "initialScore") + "\":") + java_lang_Double.marshall(a0.getInitialScore(), a1)) + ",\"") + "useReasonCodes") + "\":") + java_lang_Boolean.marshall(ScoreCardModel_boolean_useReasonCodes(a0), a1)) + ",\"") + "factName") + "\":") + java_lang_String.marshall(a0.getFactName(), a1)) + ",\"") + "fieldName") + "\":") + java_lang_String.marshall(a0.getFieldName(), a1)) + ",\"") + "reasonCodesAlgorithm") + "\":") + java_lang_String.marshall(a0.getReasonCodesAlgorithm(), a1)) + ",\"") + "reasonCodeField") + "\":") + java_lang_String.marshall(a0.getReasonCodeField(), a1)) + ",\"") + "characteristics") + "\":") + java_util_List.marshall(a0.getCharacteristics(), a1)) + ",\"") + "packageName") + "\":") + java_lang_String.marshall(a0.getPackageName(), a1)) + ",\"") + "imports") + "\":") + org_kie_soup_project_datamodel_imports_Imports.marshall(a0.getImports(), a1)) + ",\"") + "agendaGroup") + "\":") + java_lang_String.marshall(a0.getAgendaGroup(), a1)) + ",\"") + "ruleFlowGroup") + "\":") + java_lang_String.marshall(a0.getRuleFlowGroup(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_soup_project_datamodel_imports_Imports == null) {
      org_kie_soup_project_datamodel_imports_Imports = Marshalling.getMarshaller(Imports.class);
    }
  }
}