package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.testscenarios.shared.BuilderResultLine;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_t_s_BuilderResultLine_1_Impl implements GeneratedMarshaller<BuilderResultLine> {
  private BuilderResultLine[] EMPTY_ARRAY = new BuilderResultLine[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public BuilderResultLine[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public BuilderResultLine demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(BuilderResultLine.class, objId);
    }
    BuilderResultLine entity = new BuilderResultLine();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "assetFormat": entity.setAssetFormat(java_lang_String.demarshall(objVal, a1));
        break;
        case "assetName": entity.setAssetName(java_lang_String.demarshall(objVal, a1));
        break;
        case "uuid": entity.setUuid(java_lang_String.demarshall(objVal, a1));
        break;
        case "message": entity.setMessage(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(BuilderResultLine a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.testscenarios.shared.BuilderResultLine") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "assetFormat") + "\":") + java_lang_String.marshall(a0.getAssetFormat(), a1)) + ",\"") + "assetName") + "\":") + java_lang_String.marshall(a0.getAssetName(), a1)) + ",\"") + "uuid") + "\":") + java_lang_String.marshall(a0.getUuid(), a1)) + ",\"") + "message") + "\":") + java_lang_String.marshall(a0.getMessage(), a1)) + "}");
  }

  private void lazyInit() {

  }
}