package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_t_s_FactData_1_Impl implements GeneratedMarshaller<FactData> {
  private FactData[] EMPTY_ARRAY = new FactData[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public FactData[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean FactData_boolean_isModify(FactData instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.FactData::isModify;
  }-*/;

  native static void FactData_boolean_isModify(FactData instance, boolean value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.FactData::isModify = value;
  }-*/;

  public FactData demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactData.class, objId);
    }
    FactData entity = new FactData();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "isModify": FactData_boolean_isModify(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "type": entity.setType(java_lang_String.demarshall(objVal, a1));
        break;
        case "fieldData": a1.setAssumedElementType("org.drools.workbench.models.testscenarios.shared.Field");
        entity.setFieldData(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactData a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.testscenarios.shared.FactData") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "isModify") + "\":") + java_lang_Boolean.marshall(FactData_boolean_isModify(a0), a1)) + ",\"") + "type") + "\":") + java_lang_String.marshall(a0.getType(), a1)) + ",\"") + "fieldData") + "\":") + java_util_List.marshall(a0.getFieldData(), a1)) + "}");
  }

  private void lazyInit() {

  }
}