package org.jboss.errai.marshalling.client.api;

import java.util.ArrayList;
import java.util.Set;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.FixtureList;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_t_s_FixtureList_1_Impl implements GeneratedMarshaller<FixtureList> {
  private FixtureList[] EMPTY_ARRAY = new FixtureList[0];
  private Marshaller<ArrayList> java_util_ArrayList = null;
  public FixtureList[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static ArrayList FixtureList_ArrayList_list(FixtureList instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.FixtureList::list;
  }-*/;

  native static void FixtureList_ArrayList_list(FixtureList instance, ArrayList<Fixture> value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.FixtureList::list = value;
  }-*/;

  public FixtureList demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FixtureList.class, objId);
    }
    FixtureList entity = new FixtureList();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "list": a1.setAssumedElementType("org.drools.workbench.models.testscenarios.shared.Fixture");
        FixtureList_ArrayList_list(entity, java_util_ArrayList.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FixtureList a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.testscenarios.shared.FixtureList") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "list") + "\":") + java_util_ArrayList.marshall(FixtureList_ArrayList_list(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (java_util_ArrayList == null) {
      java_util_ArrayList = Marshalling.getMarshaller(ArrayList.class);
    }
  }
}