package org.jboss.errai.marshalling.client.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.imports.Imports;

public class Marshaller_o_d_w_m_t_s_Scenario_1_Impl implements GeneratedMarshaller<Scenario> {
  private Scenario[] EMPTY_ARRAY = new Scenario[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Imports> org_kie_soup_project_datamodel_imports_Imports = null;
  private Marshaller<ArrayList> java_util_ArrayList = null;
  public Scenario[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static int Scenario_int_maxRuleFirings(Scenario instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.Scenario::maxRuleFirings;
  }-*/;

  native static void Scenario_int_maxRuleFirings(Scenario instance, int value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.Scenario::maxRuleFirings = value;
  }-*/;

  native static List Scenario_List_globals(Scenario instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.Scenario::globals;
  }-*/;

  native static void Scenario_List_globals(Scenario instance, List<FactData> value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.Scenario::globals = value;
  }-*/;

  native static List Scenario_List_fixtures(Scenario instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.Scenario::fixtures;
  }-*/;

  native static void Scenario_List_fixtures(Scenario instance, List<Fixture> value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.Scenario::fixtures = value;
  }-*/;

  native static List Scenario_List_rules(Scenario instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.Scenario::rules;
  }-*/;

  native static void Scenario_List_rules(Scenario instance, List<String> value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.Scenario::rules = value;
  }-*/;

  native static ArrayList Scenario_ArrayList_ksessions(Scenario instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.Scenario::ksessions;
  }-*/;

  native static void Scenario_ArrayList_ksessions(Scenario instance, ArrayList<String> value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.Scenario::ksessions = value;
  }-*/;

  public Scenario demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Scenario.class, objId);
    }
    Scenario entity = new Scenario();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "maxRuleFirings": Scenario_int_maxRuleFirings(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "globals": a1.setAssumedElementType("org.drools.workbench.models.testscenarios.shared.FactData");
        Scenario_List_globals(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "fixtures": a1.setAssumedElementType("org.drools.workbench.models.testscenarios.shared.Fixture");
        Scenario_List_fixtures(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "lastRunResult": entity.setLastRunResult(java_util_Date.demarshall(objVal, a1));
        break;
        case "rules": a1.setAssumedElementType("java.lang.String");
        Scenario_List_rules(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "inclusive": entity.setInclusive(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "packageName": entity.setPackageName(java_lang_String.demarshall(objVal, a1));
        break;
        case "imports": entity.setImports(org_kie_soup_project_datamodel_imports_Imports.demarshall(objVal, a1));
        break;
        case "ksessions": a1.setAssumedElementType("java.lang.String");
        Scenario_ArrayList_ksessions(entity, java_util_ArrayList.demarshall(objVal, a1));
        break;
        case "modelName": entity.setModelName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean Scenario_boolean_inclusive(Scenario instance) /*-{
    return instance.@org.drools.workbench.models.testscenarios.shared.Scenario::inclusive;
  }-*/;

  native static void Scenario_boolean_inclusive(Scenario instance, boolean value) /*-{
    instance.@org.drools.workbench.models.testscenarios.shared.Scenario::inclusive = value;
  }-*/;

  public String marshall(Scenario a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.testscenarios.shared.Scenario") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "maxRuleFirings") + "\":") + java_lang_Integer.marshall(a0.getMaxRuleFirings(), a1)) + ",\"") + "globals") + "\":") + java_util_List.marshall(a0.getGlobals(), a1)) + ",\"") + "fixtures") + "\":") + java_util_List.marshall(a0.getFixtures(), a1)) + ",\"") + "lastRunResult") + "\":") + java_util_Date.marshall(a0.getLastRunResult(), a1)) + ",\"") + "rules") + "\":") + java_util_List.marshall(a0.getRules(), a1)) + ",\"") + "inclusive") + "\":") + java_lang_Boolean.marshall(Scenario_boolean_inclusive(a0), a1)) + ",\"") + "packageName") + "\":") + java_lang_String.marshall(a0.getPackageName(), a1)) + ",\"") + "imports") + "\":") + org_kie_soup_project_datamodel_imports_Imports.marshall(a0.getImports(), a1)) + ",\"") + "ksessions") + "\":") + java_util_ArrayList.marshall(Scenario_ArrayList_ksessions(a0), a1)) + ",\"") + "modelName") + "\":") + java_lang_String.marshall(a0.getModelName(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_soup_project_datamodel_imports_Imports == null) {
      org_kie_soup_project_datamodel_imports_Imports = Marshalling.getMarshaller(Imports.class);
    }
    if (java_util_ArrayList == null) {
      java_util_ArrayList = Marshalling.getMarshaller(ArrayList.class);
    }
  }
}