package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_m_t_s_VerifyField_1_Impl implements GeneratedMarshaller<VerifyField> {
  private VerifyField[] EMPTY_ARRAY = new VerifyField[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  public VerifyField[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public VerifyField demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(VerifyField.class, objId);
    }
    VerifyField entity = new VerifyField();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "fieldName": entity.setFieldName(java_lang_String.demarshall(objVal, a1));
        break;
        case "expected": entity.setExpected(java_lang_String.demarshall(objVal, a1));
        break;
        case "actualResult": entity.setActualResult(java_lang_String.demarshall(objVal, a1));
        break;
        case "successResult": entity.setSuccessResult(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "explanation": entity.setExplanation(java_lang_String.demarshall(objVal, a1));
        break;
        case "operator": entity.setOperator(java_lang_String.demarshall(objVal, a1));
        break;
        case "nature": entity.setNature(java_lang_Long.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(VerifyField a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.models.testscenarios.shared.VerifyField") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "fieldName") + "\":") + java_lang_String.marshall(a0.getFieldName(), a1)) + ",\"") + "expected") + "\":") + java_lang_String.marshall(a0.getExpected(), a1)) + ",\"") + "actualResult") + "\":") + java_lang_String.marshall(a0.getActualResult(), a1)) + ",\"") + "successResult") + "\":") + java_lang_Boolean.marshall(a0.getSuccessResult(), a1)) + ",\"") + "explanation") + "\":") + java_lang_String.marshall(a0.getExplanation(), a1)) + ",\"") + "operator") + "\":") + java_lang_String.marshall(a0.getOperator(), a1)) + ",\"") + "nature") + "\":") + java_lang_Long.marshall(a0.getNature(), a1)) + "}");
  }

  private void lazyInit() {

  }
}