package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.screens.enums.model.EnumModel;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_e_m_EnumModel_1_Impl implements GeneratedMarshaller<EnumModel> {
  private EnumModel[] EMPTY_ARRAY = new EnumModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public EnumModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String EnumModel_String_enums(EnumModel instance) /*-{
    return instance.@org.drools.workbench.screens.enums.model.EnumModel::enums;
  }-*/;

  native static void EnumModel_String_enums(EnumModel instance, String value) /*-{
    instance.@org.drools.workbench.screens.enums.model.EnumModel::enums = value;
  }-*/;

  public EnumModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EnumModel.class, objId);
    }
    EnumModel entity = new EnumModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "enums": EnumModel_String_enums(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(EnumModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.screens.enums.model.EnumModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "enums") + "\":") + java_lang_String.marshall(EnumModel_String_enums(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}