package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.drools.workbench.screens.factmodel.model.AnnotationMetaModel;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_f_m_AnnotationMetaModel_1_Impl implements GeneratedMarshaller<AnnotationMetaModel> {
  private AnnotationMetaModel[] EMPTY_ARRAY = new AnnotationMetaModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public AnnotationMetaModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public AnnotationMetaModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AnnotationMetaModel.class, objId);
    }
    AnnotationMetaModel entity = new AnnotationMetaModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.name = java_lang_String.demarshall(objVal, a1);
        break;
        case "values": entity.values = java_util_Map.demarshall(objVal, a1);
        break;
      }
    }
    return entity;
  }

  public String marshall(AnnotationMetaModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.screens.factmodel.model.AnnotationMetaModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.name, a1)) + ",\"") + "values") + "\":") + java_util_Map.marshall(a0.values, a1)) + "}");
  }

  private void lazyInit() {

  }
}