package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.screens.factmodel.model.FactMetaModel;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_f_m_FactMetaModel_1_Impl implements GeneratedMarshaller<FactMetaModel> {
  private FactMetaModel[] EMPTY_ARRAY = new FactMetaModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public FactMetaModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public FactMetaModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactMetaModel.class, objId);
    }
    FactMetaModel entity = new FactMetaModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "superType": entity.setSuperType(java_lang_String.demarshall(objVal, a1));
        break;
        case "fields": a1.setAssumedElementType("org.drools.workbench.screens.factmodel.model.FieldMetaModel");
        entity.setFields(java_util_List.demarshall(objVal, a1));
        break;
        case "annotations": a1.setAssumedElementType("org.drools.workbench.screens.factmodel.model.AnnotationMetaModel");
        entity.setAnnotations(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactMetaModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.screens.factmodel.model.FactMetaModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "superType") + "\":") + java_lang_String.marshall(a0.getSuperType(), a1)) + ",\"") + "fields") + "\":") + java_util_List.marshall(a0.getFields(), a1)) + ",\"") + "annotations") + "\":") + java_util_List.marshall(a0.getAnnotations(), a1)) + "}");
  }

  private void lazyInit() {

  }
}