package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.screens.factmodel.model.FactMetaModel;
import org.drools.workbench.screens.factmodel.model.FactModels;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.soup.project.datamodel.imports.Imports;

public class Marshaller_o_d_w_s_f_m_FactModels_1_Impl implements GeneratedMarshaller<FactModels> {
  private FactModels[] EMPTY_ARRAY = new FactModels[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Imports> org_kie_soup_project_datamodel_imports_Imports = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public FactModels[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List FactModels_List_models(FactModels instance) /*-{
    return instance.@org.drools.workbench.screens.factmodel.model.FactModels::models;
  }-*/;

  native static void FactModels_List_models(FactModels instance, List<FactMetaModel> value) /*-{
    instance.@org.drools.workbench.screens.factmodel.model.FactModels::models = value;
  }-*/;

  public FactModels demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactModels.class, objId);
    }
    FactModels entity = new FactModels();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "packageName": entity.setPackageName(java_lang_String.demarshall(objVal, a1));
        break;
        case "imports": entity.setImports(org_kie_soup_project_datamodel_imports_Imports.demarshall(objVal, a1));
        break;
        case "models": a1.setAssumedElementType("org.drools.workbench.screens.factmodel.model.FactMetaModel");
        FactModels_List_models(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactModels a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.screens.factmodel.model.FactModels") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "packageName") + "\":") + java_lang_String.marshall(a0.getPackageName(), a1)) + ",\"") + "imports") + "\":") + org_kie_soup_project_datamodel_imports_Imports.marshall(a0.getImports(), a1)) + ",\"") + "models") + "\":") + java_util_List.marshall(a0.getModels(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_soup_project_datamodel_imports_Imports == null) {
      org_kie_soup_project_datamodel_imports_Imports = Marshalling.getMarshaller(Imports.class);
    }
  }
}