package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_s_m_t_FactModelTuple_1_Impl implements GeneratedMarshaller<FactModelTuple> {
  private FactModelTuple[] EMPTY_ARRAY = new FactModelTuple[0];
  private Marshaller<SortedMap> java_util_SortedMap = Marshalling.getMarshaller(SortedMap.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public FactModelTuple[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static SortedMap FactModelTuple_SortedMap_visibleFacts(FactModelTuple instance) /*-{
    return instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::visibleFacts;
  }-*/;

  native static void FactModelTuple_SortedMap_visibleFacts(FactModelTuple instance, SortedMap<String, FactModelTree> value) /*-{
    instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::visibleFacts = value;
  }-*/;

  native static SortedMap FactModelTuple_SortedMap_hiddenFacts(FactModelTuple instance) /*-{
    return instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::hiddenFacts;
  }-*/;

  native static void FactModelTuple_SortedMap_hiddenFacts(FactModelTuple instance, SortedMap<String, FactModelTree> value) /*-{
    instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::hiddenFacts = value;
  }-*/;

  native static List FactModelTuple_List_multipleNestedCollectionError(FactModelTuple instance) /*-{
    return instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::multipleNestedCollectionError;
  }-*/;

  native static void FactModelTuple_List_multipleNestedCollectionError(FactModelTuple instance, List<String> value) /*-{
    instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::multipleNestedCollectionError = value;
  }-*/;

  native static List FactModelTuple_List_multipleNestedObjectError(FactModelTuple instance) /*-{
    return instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::multipleNestedObjectError;
  }-*/;

  native static void FactModelTuple_List_multipleNestedObjectError(FactModelTuple instance, List<String> value) /*-{
    instance.@org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple::multipleNestedObjectError = value;
  }-*/;

  public FactModelTuple demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactModelTuple.class, objId);
    }
    FactModelTuple entity = new FactModelTuple();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "visibleFacts": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree");
        FactModelTuple_SortedMap_visibleFacts(entity, java_util_SortedMap.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "hiddenFacts": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree");
        FactModelTuple_SortedMap_hiddenFacts(entity, java_util_SortedMap.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "multipleNestedCollectionError": a1.setAssumedElementType("java.lang.String");
        FactModelTuple_List_multipleNestedCollectionError(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "multipleNestedObjectError": a1.setAssumedElementType("java.lang.String");
        FactModelTuple_List_multipleNestedObjectError(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(FactModelTuple a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "visibleFacts") + "\":") + java_util_SortedMap.marshall(a0.getVisibleFacts(), a1)) + ",\"") + "hiddenFacts") + "\":") + java_util_SortedMap.marshall(a0.getHiddenFacts(), a1)) + ",\"") + "multipleNestedCollectionError") + "\":") + java_util_List.marshall(a0.getMultipleNestedCollectionError(), a1)) + ",\"") + "multipleNestedObjectError") + "\":") + java_util_List.marshall(a0.getMultipleNestedObjectError(), a1)) + "}");
  }

  private void lazyInit() {

  }
}