package org.jboss.errai.marshalling.client.api;

import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_v_p_c_Coordinate_1_Impl implements GeneratedMarshaller<Coordinate> {
  private Coordinate[] EMPTY_ARRAY = new Coordinate[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public Coordinate[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Coordinate demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Coordinate.class, objId);
    }
    final Integer c1 = java_lang_Integer.demarshall(obj.get("col"), a1);
    final Integer c0 = java_lang_Integer.demarshall(obj.get("row"), a1);
    Coordinate entity = new Coordinate(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(Coordinate a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.services.verifier.plugin.client.Coordinate") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "col") + "\":") + java_lang_Integer.marshall(a0.getCol(), a1)) + ",\"") + "row") + "\":") + java_lang_Integer.marshall(a0.getRow(), a1)) + "}");
  }

  private void lazyInit() {

  }
}