package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.drools.workbench.services.verifier.plugin.client.api.FactTypes.FactType;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_v_p_c_a_FactTypes_erraiD_FactType_1_Impl implements GeneratedMarshaller<FactType> {
  private FactType[] EMPTY_ARRAY = new FactType[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public FactType[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public FactType demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(FactType.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    a1.setAssumedElementType("org.drools.workbench.services.verifier.plugin.client.api.FactTypes$Field");
    final Set c1 = java_util_Set.demarshall(obj.get("fields"), a1);
    FactType entity = new FactType(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(FactType a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.services.verifier.plugin.client.api.FactTypes$FactType") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "fields") + "\":") + java_util_Set.marshall(a0.getFields(), a1)) + "}");
  }

  private void lazyInit() {

  }
}