package org.jboss.errai.marshalling.client.api;

import org.drools.workbench.services.verifier.plugin.client.api.RemoveRule;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_v_p_c_a_RemoveRule_1_Impl implements GeneratedMarshaller<RemoveRule> {
  private RemoveRule[] EMPTY_ARRAY = new RemoveRule[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public RemoveRule[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RemoveRule demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RemoveRule.class, objId);
    }
    final Integer c0 = java_lang_Integer.demarshall(obj.get("deletedRow"), a1);
    RemoveRule entity = new RemoveRule(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(RemoveRule a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.services.verifier.plugin.client.api.RemoveRule") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "deletedRow") + "\":") + java_lang_Integer.marshall(a0.getDeletedRow(), a1)) + "}");
  }

  private void lazyInit() {

  }
}