package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.drools.workbench.screens.workitems.model.WorkItemsModelContent;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_d_w_s_w_m_WorkItemsModelContent_1_Impl implements GeneratedMarshaller<WorkItemsModelContent> {
  private WorkItemsModelContent[] EMPTY_ARRAY = new WorkItemsModelContent[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Overview> org_guvnor_common_services_shared_metadata_model_Overview = null;
  public WorkItemsModelContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String WorkItemsModelContent_String_definition(WorkItemsModelContent instance) /*-{
    return instance.@org.drools.workbench.screens.workitems.model.WorkItemsModelContent::definition;
  }-*/;

  native static void WorkItemsModelContent_String_definition(WorkItemsModelContent instance, String value) /*-{
    instance.@org.drools.workbench.screens.workitems.model.WorkItemsModelContent::definition = value;
  }-*/;

  native static List WorkItemsModelContent_List_workItemImages(WorkItemsModelContent instance) /*-{
    return instance.@org.drools.workbench.screens.workitems.model.WorkItemsModelContent::workItemImages;
  }-*/;

  native static void WorkItemsModelContent_List_workItemImages(WorkItemsModelContent instance, List<String> value) /*-{
    instance.@org.drools.workbench.screens.workitems.model.WorkItemsModelContent::workItemImages = value;
  }-*/;

  native static Overview WorkItemsModelContent_Overview_overview(WorkItemsModelContent instance) /*-{
    return instance.@org.drools.workbench.screens.workitems.model.WorkItemsModelContent::overview;
  }-*/;

  native static void WorkItemsModelContent_Overview_overview(WorkItemsModelContent instance, Overview value) /*-{
    instance.@org.drools.workbench.screens.workitems.model.WorkItemsModelContent::overview = value;
  }-*/;

  public WorkItemsModelContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(WorkItemsModelContent.class, objId);
    }
    WorkItemsModelContent entity = new WorkItemsModelContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "definition": WorkItemsModelContent_String_definition(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "workItemImages": a1.setAssumedElementType("java.lang.String");
        WorkItemsModelContent_List_workItemImages(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "overview": WorkItemsModelContent_Overview_overview(entity, org_guvnor_common_services_shared_metadata_model_Overview.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(WorkItemsModelContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.drools.workbench.screens.workitems.model.WorkItemsModelContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "definition") + "\":") + java_lang_String.marshall(a0.getDefinition(), a1)) + ",\"") + "workItemImages") + "\":") + java_util_List.marshall(a0.getWorkItemImages(), a1)) + ",\"") + "overview") + "\":") + org_guvnor_common_services_shared_metadata_model_Overview.marshall(a0.getOverview(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_shared_metadata_model_Overview == null) {
      org_guvnor_common_services_shared_metadata_model_Overview = Marshalling.getMarshaller(Overview.class);
    }
  }
}