package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.ala.ui.model.AbstractHasKeyObject;
import org.guvnor.ala.ui.model.Pipeline;
import org.guvnor.ala.ui.model.PipelineKey;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_m_Pipeline_1_Impl implements GeneratedMarshaller<Pipeline> {
  private Pipeline[] EMPTY_ARRAY = new Pipeline[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<PipelineKey> org_guvnor_ala_ui_model_PipelineKey = null;
  public Pipeline[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static PipelineKey AbstractHasKeyObject_PipelineKey_key(AbstractHasKeyObject instance) /*-{
    return instance.@org.guvnor.ala.ui.model.AbstractHasKeyObject::key;
  }-*/;

  native static void AbstractHasKeyObject_PipelineKey_key(AbstractHasKeyObject instance, PipelineKey value) /*-{
    instance.@org.guvnor.ala.ui.model.AbstractHasKeyObject::key = value;
  }-*/;

  public Pipeline demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Pipeline.class, objId);
    }
    a1.setAssumedElementType("org.guvnor.ala.ui.model.Stage");
    final List c1 = java_util_List.demarshall(obj.get("stages"), a1);
    final PipelineKey c0 = org_guvnor_ala_ui_model_PipelineKey.demarshall(obj.get("key"), a1);
    Pipeline entity = new Pipeline(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "key": AbstractHasKeyObject_PipelineKey_key(entity, org_guvnor_ala_ui_model_PipelineKey.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Pipeline a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.model.Pipeline") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "stages") + "\":") + java_util_List.marshall(a0.getStages(), a1)) + ",\"") + "key") + "\":") + org_guvnor_ala_ui_model_PipelineKey.marshall(a0.getKey(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_ala_ui_model_PipelineKey == null) {
      org_guvnor_ala_ui_model_PipelineKey = Marshalling.getMarshaller(PipelineKey.class);
    }
  }
}