package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_m_ProviderConfiguration_1_Impl implements GeneratedMarshaller<ProviderConfiguration> {
  private ProviderConfiguration[] EMPTY_ARRAY = new ProviderConfiguration[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public ProviderConfiguration[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProviderConfiguration demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProviderConfiguration.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("id"), a1);
    a1.setAssumedMapKeyType("java.lang.String");
    a1.setAssumedMapValueType("java.lang.Object");
    final Map c1 = java_util_Map.demarshall(obj.get("values"), a1);
    a1.resetAssumedTypes();
    ProviderConfiguration entity = new ProviderConfiguration(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(ProviderConfiguration a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.model.ProviderConfiguration") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + ",\"") + "values") + "\":") + java_util_Map.marshall(a0.getValues(), a1)) + "}");
  }

  private void lazyInit() {

  }
}