package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.ala.ui.model.AbstractHasKeyObject;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_m_Provider_1_Impl implements GeneratedMarshaller<Provider> {
  private Provider[] EMPTY_ARRAY = new Provider[0];
  private Marshaller<ProviderConfiguration> org_guvnor_ala_ui_model_ProviderConfiguration = null;
  private Marshaller<ProviderKey> org_guvnor_ala_ui_model_ProviderKey = null;
  public Provider[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static ProviderKey AbstractHasKeyObject_ProviderKey_key(AbstractHasKeyObject instance) /*-{
    return instance.@org.guvnor.ala.ui.model.AbstractHasKeyObject::key;
  }-*/;

  native static void AbstractHasKeyObject_ProviderKey_key(AbstractHasKeyObject instance, ProviderKey value) /*-{
    instance.@org.guvnor.ala.ui.model.AbstractHasKeyObject::key = value;
  }-*/;

  public Provider demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Provider.class, objId);
    }
    final ProviderConfiguration c1 = org_guvnor_ala_ui_model_ProviderConfiguration.demarshall(obj.get("configuration"), a1);
    final ProviderKey c0 = org_guvnor_ala_ui_model_ProviderKey.demarshall(obj.get("key"), a1);
    Provider entity = new Provider(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "key": AbstractHasKeyObject_ProviderKey_key(entity, org_guvnor_ala_ui_model_ProviderKey.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Provider a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.model.Provider") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "configuration") + "\":") + org_guvnor_ala_ui_model_ProviderConfiguration.marshall(a0.getConfiguration(), a1)) + ",\"") + "key") + "\":") + org_guvnor_ala_ui_model_ProviderKey.marshall(a0.getKey(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_ala_ui_model_ProviderConfiguration == null) {
      org_guvnor_ala_ui_model_ProviderConfiguration = Marshalling.getMarshaller(ProviderConfiguration.class);
    }
    if (org_guvnor_ala_ui_model_ProviderKey == null) {
      org_guvnor_ala_ui_model_ProviderKey = Marshalling.getMarshaller(ProviderKey.class);
    }
  }
}