package org.jboss.errai.marshalling.client.api;

import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_m_RuntimeListItem_1_Impl implements GeneratedMarshaller<RuntimeListItem> {
  private RuntimeListItem[] EMPTY_ARRAY = new RuntimeListItem[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Runtime> org_guvnor_ala_ui_model_Runtime = null;
  private Marshaller<PipelineExecutionTrace> org_guvnor_ala_ui_model_PipelineExecutionTrace = null;
  public RuntimeListItem[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RuntimeListItem demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RuntimeListItem.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("itemLabel"), a1);
    final Runtime c1 = org_guvnor_ala_ui_model_Runtime.demarshall(obj.get("runtime"), a1);
    final PipelineExecutionTrace c2 = org_guvnor_ala_ui_model_PipelineExecutionTrace.demarshall(obj.get("pipelineTrace"), a1);
    RuntimeListItem entity = new RuntimeListItem(c0, c1, c2);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(RuntimeListItem a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.model.RuntimeListItem") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "itemLabel") + "\":") + java_lang_String.marshall(a0.getItemLabel(), a1)) + ",\"") + "runtime") + "\":") + org_guvnor_ala_ui_model_Runtime.marshall(a0.getRuntime(), a1)) + ",\"") + "pipelineTrace") + "\":") + org_guvnor_ala_ui_model_PipelineExecutionTrace.marshall(a0.getPipelineTrace(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_ala_ui_model_Runtime == null) {
      org_guvnor_ala_ui_model_Runtime = Marshalling.getMarshaller(Runtime.class);
    }
    if (org_guvnor_ala_ui_model_PipelineExecutionTrace == null) {
      org_guvnor_ala_ui_model_PipelineExecutionTrace = Marshalling.getMarshaller(PipelineExecutionTrace.class);
    }
  }
}