package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.ala.ui.model.AbstractHasKeyObject;
import org.guvnor.ala.ui.model.PipelineExecutionTrace;
import org.guvnor.ala.ui.model.Runtime;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_m_Runtime_1_Impl implements GeneratedMarshaller<Runtime> {
  private Runtime[] EMPTY_ARRAY = new Runtime[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<PipelineExecutionTrace> org_guvnor_ala_ui_model_PipelineExecutionTrace = null;
  private Marshaller<RuntimeKey> org_guvnor_ala_ui_model_RuntimeKey = null;
  public Runtime[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static RuntimeKey AbstractHasKeyObject_RuntimeKey_key(AbstractHasKeyObject instance) /*-{
    return instance.@org.guvnor.ala.ui.model.AbstractHasKeyObject::key;
  }-*/;

  native static void AbstractHasKeyObject_RuntimeKey_key(AbstractHasKeyObject instance, RuntimeKey value) /*-{
    instance.@org.guvnor.ala.ui.model.AbstractHasKeyObject::key = value;
  }-*/;

  public Runtime demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Runtime.class, objId);
    }
    final String c1 = java_lang_String.demarshall(obj.get("name"), a1);
    final PipelineExecutionTrace c2 = org_guvnor_ala_ui_model_PipelineExecutionTrace.demarshall(obj.get("pipelineTrace"), a1);
    final String c3 = java_lang_String.demarshall(obj.get("status"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("endpoint"), a1);
    final String c5 = java_lang_String.demarshall(obj.get("createdDate"), a1);
    final RuntimeKey c0 = org_guvnor_ala_ui_model_RuntimeKey.demarshall(obj.get("key"), a1);
    Runtime entity = new Runtime(c0, c1, c2, c3, c4, c5);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "key": AbstractHasKeyObject_RuntimeKey_key(entity, org_guvnor_ala_ui_model_RuntimeKey.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Runtime a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.model.Runtime") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "pipelineTrace") + "\":") + org_guvnor_ala_ui_model_PipelineExecutionTrace.marshall(a0.getPipelineTrace(), a1)) + ",\"") + "status") + "\":") + java_lang_String.marshall(a0.getStatus(), a1)) + ",\"") + "endpoint") + "\":") + java_lang_String.marshall(a0.getEndpoint(), a1)) + ",\"") + "createdDate") + "\":") + java_lang_String.marshall(a0.getCreatedDate(), a1)) + ",\"") + "key") + "\":") + org_guvnor_ala_ui_model_RuntimeKey.marshall(a0.getKey(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_ala_ui_model_PipelineExecutionTrace == null) {
      org_guvnor_ala_ui_model_PipelineExecutionTrace = Marshalling.getMarshaller(PipelineExecutionTrace.class);
    }
    if (org_guvnor_ala_ui_model_RuntimeKey == null) {
      org_guvnor_ala_ui_model_RuntimeKey = Marshalling.getMarshaller(RuntimeKey.class);
    }
  }
}