package org.jboss.errai.marshalling.client.api;

import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Stage;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_m_Stage_1_Impl implements GeneratedMarshaller<Stage> {
  private Stage[] EMPTY_ARRAY = new Stage[0];
  private Marshaller<PipelineKey> org_guvnor_ala_ui_model_PipelineKey = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public Stage[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Stage demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Stage.class, objId);
    }
    final PipelineKey c0 = org_guvnor_ala_ui_model_PipelineKey.demarshall(obj.get("pipelineKey"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("name"), a1);
    Stage entity = new Stage(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(Stage a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.model.Stage") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "pipelineKey") + "\":") + org_guvnor_ala_ui_model_PipelineKey.marshall(a0.getPipelineKey(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_ala_ui_model_PipelineKey == null) {
      org_guvnor_ala_ui_model_PipelineKey = Marshalling.getMarshaller(PipelineKey.class);
    }
  }
}