package org.jboss.errai.marshalling.client.api;

import org.guvnor.ala.ui.openshift.model.TemplateParam;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_a_u_o_m_TemplateParam_1_Impl implements GeneratedMarshaller<TemplateParam> {
  private TemplateParam[] EMPTY_ARRAY = new TemplateParam[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public TemplateParam[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public TemplateParam demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TemplateParam.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("displayName"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("description"), a1);
    final Boolean c3 = java_lang_Boolean.demarshall(obj.get("required"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("value"), a1);
    TemplateParam entity = new TemplateParam(c0, c1, c2, c3, c4);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(TemplateParam a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.ala.ui.openshift.model.TemplateParam") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "displayName") + "\":") + java_lang_String.marshall(a0.getDisplayName(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "required") + "\":") + java_lang_Boolean.marshall(a0.isRequired(), a1)) + ",\"") + "value") + "\":") + java_lang_String.marshall(a0.getValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}