package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.events.ModuleUpdatedEvent;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_c_s_p_e_ModuleUpdatedEvent_1_Impl implements GeneratedMarshaller<ModuleUpdatedEvent> {
  private ModuleUpdatedEvent[] EMPTY_ARRAY = new ModuleUpdatedEvent[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ModuleUpdatedEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Module ModuleUpdatedEvent_Module_oldModule(ModuleUpdatedEvent instance) /*-{
    return instance.@org.guvnor.common.services.project.events.ModuleUpdatedEvent::oldModule;
  }-*/;

  native static void ModuleUpdatedEvent_Module_oldModule(ModuleUpdatedEvent instance, Module value) /*-{
    instance.@org.guvnor.common.services.project.events.ModuleUpdatedEvent::oldModule = value;
  }-*/;

  native static Module ModuleUpdatedEvent_Module_newModule(ModuleUpdatedEvent instance) /*-{
    return instance.@org.guvnor.common.services.project.events.ModuleUpdatedEvent::newModule;
  }-*/;

  native static void ModuleUpdatedEvent_Module_newModule(ModuleUpdatedEvent instance, Module value) /*-{
    instance.@org.guvnor.common.services.project.events.ModuleUpdatedEvent::newModule = value;
  }-*/;

  public ModuleUpdatedEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ModuleUpdatedEvent.class, objId);
    }
    ModuleUpdatedEvent entity = new ModuleUpdatedEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "oldModule": ModuleUpdatedEvent_Module_oldModule(entity, (Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
        case "newModule": ModuleUpdatedEvent_Module_newModule(entity, (Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ModuleUpdatedEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.events.ModuleUpdatedEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "oldModule") + "\":") + java_lang_Object.marshall(a0.getOldModule(), a1)) + ",\"") + "newModule") + "\":") + java_lang_Object.marshall(a0.getNewModule(), a1)) + "}");
  }

  private void lazyInit() {

  }
}