package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.events.NewModuleEvent;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_c_s_p_e_NewModuleEvent_1_Impl implements GeneratedMarshaller<NewModuleEvent> {
  private NewModuleEvent[] EMPTY_ARRAY = new NewModuleEvent[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public NewModuleEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Module NewModuleEvent_Module_module(NewModuleEvent instance) /*-{
    return instance.@org.guvnor.common.services.project.events.NewModuleEvent::module;
  }-*/;

  native static void NewModuleEvent_Module_module(NewModuleEvent instance, Module value) /*-{
    instance.@org.guvnor.common.services.project.events.NewModuleEvent::module = value;
  }-*/;

  native static String NewModuleEvent_String_sessionId(NewModuleEvent instance) /*-{
    return instance.@org.guvnor.common.services.project.events.NewModuleEvent::sessionId;
  }-*/;

  native static void NewModuleEvent_String_sessionId(NewModuleEvent instance, String value) /*-{
    instance.@org.guvnor.common.services.project.events.NewModuleEvent::sessionId = value;
  }-*/;

  native static String NewModuleEvent_String_identity(NewModuleEvent instance) /*-{
    return instance.@org.guvnor.common.services.project.events.NewModuleEvent::identity;
  }-*/;

  native static void NewModuleEvent_String_identity(NewModuleEvent instance, String value) /*-{
    instance.@org.guvnor.common.services.project.events.NewModuleEvent::identity = value;
  }-*/;

  public NewModuleEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NewModuleEvent.class, objId);
    }
    NewModuleEvent entity = new NewModuleEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "module": NewModuleEvent_Module_module(entity, (Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
        case "sessionId": NewModuleEvent_String_sessionId(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "identity": NewModuleEvent_String_identity(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(NewModuleEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.events.NewModuleEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "module") + "\":") + java_lang_Object.marshall(a0.getModule(), a1)) + ",\"") + "sessionId") + "\":") + java_lang_String.marshall(a0.getSessionId(), a1)) + ",\"") + "identity") + "\":") + java_lang_String.marshall(a0.getIdentity(), a1)) + "}");
  }

  private void lazyInit() {

  }
}