package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.Build;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_c_s_p_m_Build_1_Impl implements GeneratedMarshaller<Build> {
  private Build[] EMPTY_ARRAY = new Build[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public Build[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Build demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Build.class, objId);
    }
    Build entity = new Build();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "plugins": a1.setAssumedElementType("org.guvnor.common.services.project.model.Plugin");
        entity.setPlugins(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Build a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.model.Build") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "plugins") + "\":") + java_util_List.marshall(a0.getPlugins(), a1)) + "}");
  }

  private void lazyInit() {

  }
}