package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.GAV;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_o_g_c_s_p_m_GAV_1_Impl implements GeneratedMarshaller<GAV> {
  private GAV[] EMPTY_ARRAY = new GAV[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public GAV[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public GAV demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(GAV.class, objId);
    }
    GAV entity = new GAV();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "groupId": entity.setGroupId(java_lang_String.demarshall(objVal, a1));
        break;
        case "artifactId": entity.setArtifactId(java_lang_String.demarshall(objVal, a1));
        break;
        case "version": entity.setVersion(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(GAV a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.model.GAV") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "groupId") + "\":") + java_lang_String.marshall(a0.getGroupId(), a1)) + ",\"") + "artifactId") + "\":") + java_lang_String.marshall(a0.getArtifactId(), a1)) + ",\"") + "version") + "\":") + java_lang_String.marshall(a0.getVersion(), a1)) + "}");
  }

  private void lazyInit() {

  }
}