package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_g_c_s_p_m_Module_1_Impl implements GeneratedMarshaller<Module> {
  private Module[] EMPTY_ARRAY = new Module[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<POM> org_guvnor_common_services_project_model_POM = null;
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public Module[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Path Module_Path_rootPath(Module instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Module::rootPath;
  }-*/;

  native static void Module_Path_rootPath(Module instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Module::rootPath = value;
  }-*/;

  native static Path Module_Path_pomXMLPath(Module instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Module::pomXMLPath;
  }-*/;

  native static void Module_Path_pomXMLPath(Module instance, Path value) /*-{
    instance.@org.guvnor.common.services.project.model.Module::pomXMLPath = value;
  }-*/;

  native static Collection Module_Collection_modules(Module instance) /*-{
    return instance.@org.guvnor.common.services.project.model.Module::modules;
  }-*/;

  native static void Module_Collection_modules(Module instance, Collection<String> value) /*-{
    instance.@org.guvnor.common.services.project.model.Module::modules = value;
  }-*/;

  public Module demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Module.class, objId);
    }
    Module entity = new Module();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "rootPath": Module_Path_rootPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "pomXMLPath": Module_Path_pomXMLPath(entity, (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "modules": Module_Collection_modules(entity, (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, objVal, a1));
        break;
        case "pom": entity.setPom(org_guvnor_common_services_project_model_POM.demarshall(objVal, a1));
        break;
        case "numberOfAssets": entity.setNumberOfAssets(java_lang_Integer.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(Module a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.model.Module") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "rootPath") + "\":") + java_lang_Object.marshall(a0.getRootPath(), a1)) + ",\"") + "pomXMLPath") + "\":") + java_lang_Object.marshall(a0.getPomXMLPath(), a1)) + ",\"") + "modules") + "\":") + java_lang_Object.marshall(a0.getModules(), a1)) + ",\"") + "pom") + "\":") + org_guvnor_common_services_project_model_POM.marshall(a0.getPom(), a1)) + ",\"") + "numberOfAssets") + "\":") + java_lang_Integer.marshall(a0.getNumberOfAssets(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_project_model_POM == null) {
      org_guvnor_common_services_project_model_POM = Marshalling.getMarshaller(POM.class);
    }
  }
}