package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.Build;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepository;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;

public class Marshaller_o_g_c_s_p_m_POM_1_Impl implements GeneratedMarshaller<POM> {
  private POM[] EMPTY_ARRAY = new POM[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Build> org_guvnor_common_services_project_model_Build = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public POM[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static GAV POM_GAV_gav(POM instance) /*-{
    return instance.@org.guvnor.common.services.project.model.POM::gav;
  }-*/;

  native static void POM_GAV_gav(POM instance, GAV value) /*-{
    instance.@org.guvnor.common.services.project.model.POM::gav = value;
  }-*/;

  native static List POM_List_repositories(POM instance) /*-{
    return instance.@org.guvnor.common.services.project.model.POM::repositories;
  }-*/;

  native static void POM_List_repositories(POM instance, List<MavenRepository> value) /*-{
    instance.@org.guvnor.common.services.project.model.POM::repositories = value;
  }-*/;

  public POM demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(POM.class, objId);
    }
    POM entity = new POM();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "parent": entity.setParent((GAV) ((ObjectMarshaller) java_lang_Object).demarshall(GAV.class, objVal, a1));
        break;
        case "gav": POM_GAV_gav(entity, (GAV) ((ObjectMarshaller) java_lang_Object).demarshall(GAV.class, objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "url": entity.setUrl(java_lang_String.demarshall(objVal, a1));
        break;
        case "packaging": entity.setPackaging(java_lang_String.demarshall(objVal, a1));
        break;
        case "build": entity.setBuild(org_guvnor_common_services_project_model_Build.demarshall(objVal, a1));
        break;
        case "dependencies": a1.setAssumedElementType("org.guvnor.common.services.project.model.Dependency");
        entity.setDependencies(java_util_List.demarshall(objVal, a1));
        break;
        case "repositories": a1.setAssumedElementType("org.guvnor.common.services.project.model.MavenRepository");
        POM_List_repositories(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "modules": a1.setAssumedElementType("java.lang.String");
        entity.setModules(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static List POM_List_dependencies(POM instance) /*-{
    return instance.@org.guvnor.common.services.project.model.POM::dependencies;
  }-*/;

  native static void POM_List_dependencies(POM instance, List<Dependency> value) /*-{
    instance.@org.guvnor.common.services.project.model.POM::dependencies = value;
  }-*/;

  public String marshall(POM a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.guvnor.common.services.project.model.POM") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "parent") + "\":") + java_lang_Object.marshall(a0.getParent(), a1)) + ",\"") + "gav") + "\":") + java_lang_Object.marshall(a0.getGav(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "url") + "\":") + java_lang_String.marshall(a0.getUrl(), a1)) + ",\"") + "packaging") + "\":") + java_lang_String.marshall(a0.getPackaging(), a1)) + ",\"") + "build") + "\":") + org_guvnor_common_services_project_model_Build.marshall(a0.getBuild(), a1)) + ",\"") + "dependencies") + "\":") + java_util_List.marshall(POM_List_dependencies(a0), a1)) + ",\"") + "repositories") + "\":") + java_util_List.marshall(a0.getRepositories(), a1)) + ",\"") + "modules") + "\":") + java_util_List.marshall(a0.getModules(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_project_model_Build == null) {
      org_guvnor_common_services_project_model_Build = Marshalling.getMarshaller(Build.class);
    }
  }
}